/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQuery;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityBridgeDAO;
import org.alfresco.repo.security.authority.AuthorityBridgeLink;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.authority.AuthorityInfo;
import org.alfresco.repo.security.authority.GetAuthoritiesCannedQueryFactory;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.BridgeTable;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.SearchLanguageConversion;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorityDAOBridgeTableImpl
implements AuthorityDAO,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    private static Log logger = LogFactory.getLog(AuthorityDAOBridgeTableImpl.class);
    private static final String CANNED_QUERY_AUTHS_LIST = "authsGetAuthoritiesCannedQueryFactory";
    private static final String CANNED_QUERY_AUTH_BRIDGE_LINK_LIST = "authsGetAuthorityBridgeCannedQueryFactory";
    private StoreRef storeRef;
    private NodeService nodeService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private QName qnameAssocSystem;
    private QName qnameAssocAuthorities;
    private QName qnameAssocZones;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private PersonService personService;
    private TenantService tenantService;
    private SimpleCache<Pair<String, String>, NodeRef> authorityLookupCache;
    private static final NodeRef NULL_NODEREF = new NodeRef("null", "null", "null");
    private SimpleCache<String, Set<String>> userAuthorityCache;
    private SimpleCache<Pair<String, String>, List<ChildAssociationRef>> zoneAuthorityCache;
    private SimpleCache<NodeRef, List<ChildAssociationRef>> childAuthorityCache;
    private SimpleCache<String, BridgeTable<String>> authorityBridgeTableByTenantCache;
    private Map<String, NodeRef> systemContainerRefs = new ConcurrentHashMap<String, NodeRef>(4);
    private AclDAO aclDao;
    private PolicyComponent policyComponent;
    private int zoneAuthoritySampleSize = 10000;
    private NamedObjectRegistry<CannedQueryFactory> cannedQueryRegistry;
    private AuthorityBridgeDAO authorityBridgeDAO;
    private boolean useBridgeTable = true;
    private static final Collection<AuthorityType> SEARCHABLE_AUTHORITY_TYPES = new LinkedList<AuthorityType>();

    public void setZoneAuthoritySampleSize(int zoneAuthoritySampleSize) {
        this.zoneAuthoritySampleSize = zoneAuthoritySampleSize;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
        this.qnameAssocSystem = QName.createQName((String)"sys", (String)"system", (NamespacePrefixResolver)namespacePrefixResolver);
        this.qnameAssocAuthorities = QName.createQName((String)"sys", (String)"authorities", (NamespacePrefixResolver)namespacePrefixResolver);
        this.qnameAssocZones = QName.createQName((String)"sys", (String)"zones", (NamespacePrefixResolver)namespacePrefixResolver);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setAuthorityLookupCache(SimpleCache<Pair<String, String>, NodeRef> authorityLookupCache) {
        this.authorityLookupCache = authorityLookupCache;
    }

    public void setUserAuthorityCache(SimpleCache<String, Set<String>> userAuthorityCache) {
        this.userAuthorityCache = userAuthorityCache;
    }

    public void setZoneAuthorityCache(SimpleCache<Pair<String, String>, List<ChildAssociationRef>> zoneAuthorityCache) {
        this.zoneAuthorityCache = zoneAuthorityCache;
    }

    public void setChildAuthorityCache(SimpleCache<NodeRef, List<ChildAssociationRef>> childAuthorityCache) {
        this.childAuthorityCache = childAuthorityCache;
    }

    public void setAuthorityBridgeTableByTenantCache(SimpleCache<String, BridgeTable<String>> authorityBridgeTableByTenantCache) {
        this.authorityBridgeTableByTenantCache = authorityBridgeTableByTenantCache;
    }

    public void setUseBridgeTable(boolean useBridgeTable) {
        this.useBridgeTable = useBridgeTable;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setAclDAO(AclDAO aclDao) {
        this.aclDao = aclDao;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    public void setAuthorityBridgeDAO(AuthorityBridgeDAO authorityBridgeDAO) {
        this.authorityBridgeDAO = authorityBridgeDAO;
    }

    @Override
    public boolean authorityExists(String name) {
        NodeRef ref = this.getAuthorityOrNull(name);
        return ref != null;
    }

    @Override
    public void addAuthority(Collection<String> parentNames, String childName) {
        HashSet<NodeRef> parentRefs = new HashSet<NodeRef>(parentNames.size() * 2);
        AuthorityType authorityType = AuthorityType.getAuthorityType((String)childName);
        boolean isUser = authorityType.equals((Object)AuthorityType.USER);
        boolean notUserOrGroup = !isUser && !authorityType.equals((Object)AuthorityType.GROUP);
        for (String parentName : parentNames) {
            NodeRef parentRef = this.getAuthorityOrNull(parentName);
            if (parentRef == null) {
                throw new UnknownAuthorityException("An authority was not found for " + parentName);
            }
            if (!(!notUserOrGroup || authorityType.equals((Object)AuthorityType.ROLE) && AuthorityType.getAuthorityType((String)parentName).equals((Object)AuthorityType.ROLE))) {
                throw new AlfrescoRuntimeException("Authorities of the type " + authorityType + " may not be added to other authorities");
            }
            this.childAuthorityCache.remove((Serializable)parentRef);
            parentRefs.add(parentRef);
        }
        NodeRef childRef = this.getAuthorityOrNull(childName);
        if (childRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + childName);
        }
        if (isUser) {
            childName = (String)((Object)this.nodeService.getProperty(childRef, ContentModel.PROP_USERNAME));
        }
        this.nodeService.addChild(parentRefs, childRef, ContentModel.ASSOC_MEMBER, QName.createQName((String)"cm", (String)childName, (NamespacePrefixResolver)this.namespacePrefixResolver));
        if (isUser) {
            this.userAuthorityCache.remove((Serializable)((Object)childName));
        } else {
            this.userAuthorityCache.clear();
            this.authorityBridgeTableByTenantCache.clear();
        }
    }

    @Override
    public void createAuthority(String name, String authorityDisplayName, Set<String> authorityZones) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_AUTHORITY_NAME, name);
        props.put(ContentModel.PROP_AUTHORITY_DISPLAY_NAME, authorityDisplayName);
        NodeRef authorityContainerRef = this.getAuthorityContainer();
        NodeRef childRef = this.nodeService.createNode(authorityContainerRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)name, (NamespacePrefixResolver)this.namespacePrefixResolver), ContentModel.TYPE_AUTHORITY_CONTAINER, props).getChildRef();
        if (authorityZones != null) {
            HashSet<NodeRef> zoneRefs = new HashSet<NodeRef>(authorityZones.size() * 2);
            String currentUserDomain = this.tenantService.getCurrentUserDomain();
            for (String authorityZone : authorityZones) {
                zoneRefs.add(this.getOrCreateZone(authorityZone));
                this.zoneAuthorityCache.remove((Serializable)new Pair((Object)currentUserDomain, (Object)authorityZone));
            }
            this.zoneAuthorityCache.remove((Serializable)new Pair((Object)currentUserDomain, null));
            this.nodeService.addChild(zoneRefs, childRef, ContentModel.ASSOC_IN_ZONE, QName.createQName((String)"cm", (String)name, (NamespacePrefixResolver)this.namespacePrefixResolver));
        }
        this.authorityLookupCache.put(this.cacheKey(name), (Object)childRef);
    }

    private Pair<String, String> cacheKey(String authorityName) {
        String tenantDomain = AuthorityType.getAuthorityType((String)authorityName) == AuthorityType.USER ? this.tenantService.getDomain(authorityName) : this.tenantService.getCurrentUserDomain();
        return new Pair((Object)tenantDomain, (Object)authorityName);
    }

    @Override
    public void deleteAuthority(String name) {
        NodeRef nodeRef = this.getAuthorityOrNull(name);
        if (nodeRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + name);
        }
        String currentUserDomain = this.tenantService.getCurrentUserDomain();
        for (String authorityZone : this.getAuthorityZones(name)) {
            this.zoneAuthorityCache.remove((Serializable)new Pair((Object)currentUserDomain, (Object)authorityZone));
        }
        this.zoneAuthorityCache.remove((Serializable)new Pair((Object)currentUserDomain, null));
        this.removeParentsFromChildAuthorityCache(nodeRef);
        this.authorityLookupCache.remove(this.cacheKey(name));
        this.userAuthorityCache.clear();
        this.authorityBridgeTableByTenantCache.clear();
        this.nodeService.deleteNode(nodeRef);
    }

    @Override
    public PagingResults<String> getAuthorities(AuthorityType type, String zoneName, String displayNameFilter, boolean sortByDisplayName, boolean sortAscending, PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        if (type == null && zoneName == null) {
            throw new IllegalArgumentException("Type and/or zoneName required - both cannot be null");
        }
        if (zoneName == null && type.equals((Object)AuthorityType.USER)) {
            return this.getUserAuthoritiesImpl(displayNameFilter, sortByDisplayName, sortAscending, pagingRequest);
        }
        NodeRef containerRef = null;
        if (zoneName != null) {
            containerRef = this.getZone(zoneName);
            if (containerRef == null) {
                throw new UnknownAuthorityException("A zone was not found for " + zoneName);
            }
        } else {
            containerRef = this.getAuthorityContainer();
        }
        return this.getAuthoritiesImpl(type, containerRef, displayNameFilter, sortByDisplayName, sortAscending, pagingRequest);
    }

    private PagingResults<String> getAuthoritiesImpl(AuthorityType type, NodeRef containerRef, String displayNameFilter, boolean sortByDisplayName, boolean sortAscending, PagingRequest pagingRequest) {
        Long start;
        Long l = start = logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        if (type != null) {
            switch (type) {
                case GROUP: 
                case ROLE: 
                case USER: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected authority type: " + type);
                }
            }
        }
        GetAuthoritiesCannedQueryFactory getAuthoritiesCannedQueryFactory = (GetAuthoritiesCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_AUTHS_LIST));
        CannedQuery<AuthorityInfo> cq = getAuthoritiesCannedQueryFactory.getCannedQuery(type, containerRef, displayNameFilter, sortByDisplayName, sortAscending, pagingRequest);
        final CannedQueryResults results = cq.execute();
        PagingResults<String> finalResults = new PagingResults<String>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<String> getPage() {
                ArrayList<String> auths = new ArrayList<String>(results.getPageCount());
                for (AuthorityInfo authInfo : results.getPage()) {
                    auths.add(authInfo.getAuthorityName());
                }
                return auths;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return results.getTotalResultCount();
            }
        };
        if (start != null) {
            int cnt = finalResults.getPage().size();
            int skipCount = pagingRequest.getSkipCount();
            int maxItems = pagingRequest.getMaxItems();
            boolean hasMoreItems = finalResults.hasMoreItems();
            int pageNum = skipCount / maxItems + 1;
            logger.debug((Object)("getAuthoritiesByType: " + cnt + " items in " + (System.currentTimeMillis() - start) + " msecs [type=" + type + ",pageNum=" + pageNum + ",skip=" + skipCount + ",max=" + maxItems + ",hasMorePages=" + hasMoreItems + ",filter=" + displayNameFilter + "]"));
        }
        return finalResults;
    }

    private PagingResults<String> getUserAuthoritiesImpl(String displayNameFilter, boolean sortByDisplayName, boolean sortAscending, PagingRequest pagingRequest) {
        ArrayList<Pair<QName, String>> filter = null;
        if (displayNameFilter != null) {
            filter = new ArrayList<Pair<QName, String>>();
            filter.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)displayNameFilter));
        }
        ArrayList<Pair<QName, Boolean>> sort = null;
        if (sortByDisplayName) {
            sort = new ArrayList<Pair<QName, Boolean>>();
            sort.add((Pair<QName, Boolean>)new Pair((Object)ContentModel.PROP_USERNAME, (Object)sortAscending));
        }
        final PagingResults<PersonService.PersonInfo> ppr = this.personService.getPeople(filter, true, sort, pagingRequest);
        List result = ppr.getPage();
        final ArrayList<String> auths = new ArrayList<String>(result.size());
        for (PersonService.PersonInfo person : result) {
            auths.add(person.getUserName());
        }
        return new PagingResults<String>(){

            public String getQueryExecutionId() {
                return ppr.getQueryExecutionId();
            }

            public List<String> getPage() {
                return auths;
            }

            public boolean hasMoreItems() {
                return ppr.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return ppr.getTotalResultCount();
            }
        };
    }

    @Override
    public Set<String> getRootAuthorities(AuthorityType type, String zoneName) {
        NodeRef container;
        NodeRef nodeRef = container = zoneName == null ? this.getAuthorityContainer() : this.getZone(zoneName);
        if (container == null) {
            return Collections.emptySet();
        }
        return this.getRootAuthoritiesUnderContainer(container, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<String> findAuthorities(AuthorityType type, String parentAuthority, boolean immediate, String displayNamePattern, String zoneName) {
        Long start = logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        Pattern pattern = displayNamePattern == null ? null : Pattern.compile(SearchLanguageConversion.convert((SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_LUCENE, (SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_REGEX, (String)displayNamePattern), 2);
        Set<String> rootAuthorities = null;
        if (parentAuthority == null && immediate) {
            rootAuthorities = this.getRootAuthorities(type, zoneName);
            if (pattern == null) {
                if (start == null) return rootAuthorities;
                logger.debug((Object)("findAuthorities (rootAuthories): " + rootAuthorities.size() + " items in " + (System.currentTimeMillis() - start) + " msecs [type=" + type + ",zone=" + zoneName + "]"));
                return rootAuthorities;
            }
        }
        TreeSet<String> authorities = new TreeSet<String>();
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.storeRef);
        sp.setLanguage("lucene");
        StringBuilder query = new StringBuilder(500);
        if (type == null || type == AuthorityType.USER) {
            if (type == null) {
                query.append("((");
            }
            query.append("TYPE:\"").append(ContentModel.TYPE_PERSON).append("\"");
            if (displayNamePattern != null) {
                query.append(" AND @").append(AbstractLuceneQueryParser.escape((String)("{" + ContentModel.PROP_USERNAME.getNamespaceURI() + "}" + ISO9075.encode((String)ContentModel.PROP_USERNAME.getLocalName())))).append(":\"").append(AbstractLuceneQueryParser.escape((String)displayNamePattern)).append("\"");
            }
            if (type == null) {
                query.append(") OR (");
            }
        }
        if (type != AuthorityType.USER) {
            query.append("TYPE:\"").append(ContentModel.TYPE_AUTHORITY_CONTAINER).append("\"");
            if (displayNamePattern != null) {
                query.append(" AND (");
                if (!displayNamePattern.startsWith("*")) {
                    Collection<AuthorityType> authorityTypes = type == null ? SEARCHABLE_AUTHORITY_TYPES : Collections.singleton(type);
                    boolean first = true;
                    for (AuthorityType subType : authorityTypes) {
                        if (first) {
                            first = false;
                        } else {
                            query.append(" OR ");
                        }
                        query.append("@").append(AbstractLuceneQueryParser.escape((String)("{" + ContentModel.PROP_AUTHORITY_NAME.getNamespaceURI() + "}" + ISO9075.encode((String)ContentModel.PROP_AUTHORITY_NAME.getLocalName())))).append(":\"");
                        query.append(this.getName(subType, AbstractLuceneQueryParser.escape((String)displayNamePattern))).append("\"");
                    }
                } else {
                    query.append("@").append(AbstractLuceneQueryParser.escape((String)("{" + ContentModel.PROP_AUTHORITY_NAME.getNamespaceURI() + "}" + ISO9075.encode((String)ContentModel.PROP_AUTHORITY_NAME.getLocalName())))).append(":\"");
                    query.append(this.getName(type, AbstractLuceneQueryParser.escape((String)displayNamePattern))).append("\"");
                }
                query.append(" OR @").append(AbstractLuceneQueryParser.escape((String)("{" + ContentModel.PROP_AUTHORITY_DISPLAY_NAME.getNamespaceURI() + "}" + ISO9075.encode((String)ContentModel.PROP_AUTHORITY_DISPLAY_NAME.getLocalName())))).append(":\"").append(AbstractLuceneQueryParser.escape((String)displayNamePattern)).append("\")");
            }
            if (type == null) {
                query.append("))");
            }
        }
        if (parentAuthority != null) {
            if (immediate) {
                NodeRef parentAuthorityNodeRef = this.getAuthorityNodeRefOrNull(parentAuthority);
                if (parentAuthorityNodeRef == null) throw new UnknownAuthorityException("An authority was not found for " + parentAuthority);
                query.append(" AND PARENT:\"").append(AbstractLuceneQueryParser.escape((String)parentAuthorityNodeRef.toString())).append("\"");
            } else {
                query.append(" AND PATH:\"/sys:system/sys:authorities/cm:").append(ISO9075.encode((String)parentAuthority));
                query.append("//*\"");
            }
        }
        if (zoneName != null) {
            NodeRef zoneNodeRef = this.getZone(zoneName);
            if (zoneNodeRef == null) throw new UnknownAuthorityException("A zone was not found for " + zoneName);
            query.append(" AND PARENT:\"").append(AbstractLuceneQueryParser.escape((String)zoneNodeRef.toString())).append("\"");
        }
        sp.setQuery(query.toString());
        sp.setMaxItems(100);
        ResultSet rs = null;
        try {
            rs = this.searchService.query(sp);
            for (ResultSetRow row : rs) {
                NodeRef nodeRef = row.getNodeRef();
                QName idProp = this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_AUTHORITY_CONTAINER) ? ContentModel.PROP_AUTHORITY_NAME : ContentModel.PROP_USERNAME;
                this.addAuthorityNameIfMatches(authorities, (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, idProp)), type, pattern);
            }
            if (rootAuthorities != null) {
                authorities.retainAll(rootAuthorities);
            }
            if (start != null) {
                logger.debug((Object)("findAuthorities: " + authorities.size() + " items in " + (System.currentTimeMillis() - start) + " msecs [type=" + type + ",zone=" + zoneName + ",parent=" + parentAuthority + ",immediate=" + immediate + ",filter=" + displayNamePattern + "]"));
            }
            TreeSet<String> treeSet = authorities;
            return treeSet;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Override
    public Set<String> getContainedAuthorities(AuthorityType type, String parentName, boolean immediate) {
        AuthorityType parentAuthorityType = AuthorityType.getAuthorityType((String)parentName);
        if (parentAuthorityType == AuthorityType.USER) {
            return Collections.emptySet();
        }
        NodeRef nodeRef = this.getAuthorityOrNull(parentName);
        if (nodeRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + parentName);
        }
        TreeSet<String> authorities = new TreeSet<String>();
        this.listAuthorities(type, nodeRef, authorities, false, !immediate, false);
        return authorities;
    }

    @Override
    public void removeAuthority(String parentName, String childName) {
        NodeRef parentRef = this.getAuthorityOrNull(parentName);
        if (parentRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + parentName);
        }
        NodeRef childRef = this.getAuthorityOrNull(childName);
        if (childRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + childName);
        }
        this.nodeService.removeChild(parentRef, childRef);
        this.childAuthorityCache.remove((Serializable)parentRef);
        if (AuthorityType.getAuthorityType((String)childName) == AuthorityType.USER) {
            this.userAuthorityCache.remove((Serializable)((Object)childName));
        } else {
            this.userAuthorityCache.clear();
            this.authorityBridgeTableByTenantCache.clear();
        }
    }

    private BridgeTable<String> getBridgeTable() {
        String tenant = this.tenantService.getCurrentUserDomain();
        BridgeTable bridgeTable = (BridgeTable)this.authorityBridgeTableByTenantCache.get((Serializable)((Object)tenant));
        if (bridgeTable == null) {
            List<AuthorityBridgeLink> links = this.authorityBridgeDAO.getAuthorityBridgeLinks();
            bridgeTable = new BridgeTable();
            for (AuthorityBridgeLink link : links) {
                bridgeTable.addLink((Object)link.getParentName(), (Object)link.getChildName());
            }
            this.authorityBridgeTableByTenantCache.put((Serializable)((Object)tenant), (Object)bridgeTable);
        }
        return bridgeTable;
    }

    private void listAuthoritiesByBridgeTable(Set<String> authorities, String name) {
        BridgeTable<String> bridgeTable = this.getBridgeTable();
        AuthorityType type = AuthorityType.getAuthorityType((String)name);
        switch (type) {
            case USER: 
            case ADMIN: 
            case GUEST: 
            case EVERYONE: {
                NodeRef authRef = this.getAuthorityOrNull(name);
                List<AuthorityBridgeLink> parents = this.authorityBridgeDAO.getDirectAuthoritiesForUser(authRef);
                for (AuthorityBridgeLink parent : parents) {
                    authorities.add(parent.getParentName());
                    authorities.addAll(bridgeTable.getAncestors((Object)parent.getParentName()));
                }
                break;
            }
            case GROUP: 
            case ROLE: 
            case OWNER: {
                authorities.addAll(bridgeTable.getAncestors((Object)name));
            }
        }
    }

    @Override
    public Set<String> getContainingAuthorities(AuthorityType type, String name, boolean immediate) {
        if (!immediate && AuthorityType.getAuthorityType((String)name) == AuthorityType.USER) {
            TreeSet<String> authorities = (TreeSet<String>)this.userAuthorityCache.get((Serializable)((Object)name));
            if (authorities == null) {
                authorities = new TreeSet<String>();
                if (this.useBridgeTable) {
                    this.listAuthoritiesByBridgeTable(authorities, name);
                } else {
                    this.listAuthorities(null, name, authorities, true, true);
                }
                this.userAuthorityCache.put((Serializable)((Object)name), authorities);
            }
            if (type == null) {
                return authorities;
            }
            TreeSet<String> filteredAuthorities = new TreeSet<String>();
            for (String authority : authorities) {
                this.addAuthorityNameIfMatches(filteredAuthorities, authority, type);
            }
            return filteredAuthorities;
        }
        TreeSet<String> authorities = new TreeSet<String>();
        this.listAuthorities(type, name, authorities, true, !immediate);
        return authorities;
    }

    @Override
    public Set<String> getContainingAuthoritiesInZone(AuthorityType type, String authority, final String zoneName, AuthorityService.AuthorityFilter filter, int size) {
        String currentUserDomain = this.tenantService.getCurrentUserDomain();
        Pair cacheKey = new Pair((Object)currentUserDomain, (Object)zoneName);
        List zoneAuthorities = (List)this.zoneAuthorityCache.get((Serializable)cacheKey);
        final int maxToProcess = Math.max(size, this.zoneAuthoritySampleSize);
        if (zoneAuthorities == null) {
            zoneAuthorities = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<ChildAssociationRef>>(){

                public List<ChildAssociationRef> doWork() throws Exception {
                    NodeRef root;
                    NodeRef nodeRef = root = zoneName == null ? AuthorityDAOBridgeTableImpl.this.getAuthorityContainer() : AuthorityDAOBridgeTableImpl.this.getZone(zoneName);
                    if (root == null) {
                        return Collections.emptyList();
                    }
                    return AuthorityDAOBridgeTableImpl.this.nodeService.getChildAssocs(root, null, null, maxToProcess, false);
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), currentUserDomain));
            this.zoneAuthorityCache.put((Serializable)cacheKey, (Object)zoneAuthorities);
        }
        TreeSet<String> result = new TreeSet<String>();
        int maxResults = size > 0 ? size : Integer.MAX_VALUE;
        int hits = 0;
        int processed = 0;
        for (ChildAssociationRef groupAssoc : zoneAuthorities) {
            boolean filterZone;
            Set<String> unfilteredResult;
            String containing = groupAssoc.getQName().getLocalName();
            AuthorityType containingType = AuthorityType.getAuthorityType((String)containing);
            ++processed;
            switch (containingType) {
                case USER: 
                case ADMIN: 
                case GUEST: {
                    break;
                }
                default: {
                    Pair<String, String> containingKey = this.cacheKey(containing);
                    if (this.authorityLookupCache.contains(containingKey)) break;
                    this.authorityLookupCache.put(containingKey, (Object)groupAssoc.getChildRef());
                }
            }
            if (!(type != null && containingType != type || authority != null && !this.isAuthorityContained(groupAssoc.getChildRef(), authority) || filter != null && !filter.includeAuthority(containing))) {
                result.add(containing);
                if (++hits == maxResults) break;
            }
            if (processed < maxToProcess) continue;
            if (authority == null) {
                unfilteredResult = new HashSet<String>(this.getAuthorities(type, zoneName, null, false, true, new PagingRequest(0, filter == null ? maxResults : Integer.MAX_VALUE, null)).getPage());
                if (filter == null) {
                    return unfilteredResult;
                }
                filterZone = false;
            } else {
                unfilteredResult = this.getContainingAuthorities(type, authority, false);
                filterZone = zoneName != null;
            }
            TreeSet<String> newResult = new TreeSet<String>((Collection<String>)result);
            int i = newResult.size();
            for (String container : unfilteredResult) {
                if (result.contains(container) || filter != null && !filter.includeAuthority(container) || filterZone && !this.getAuthorityZones(container).contains(zoneName)) continue;
                newResult.add(container);
                if (++i < maxResults) continue;
                break;
            }
            result = newResult;
            break;
        }
        return result;
    }

    @Override
    public String getShortName(String name) {
        AuthorityType type = AuthorityType.getAuthorityType((String)name);
        if (type.isFixedString()) {
            return "";
        }
        if (type.isPrefixed()) {
            return name.substring(type.getPrefixString().length());
        }
        return name;
    }

    @Override
    public String getName(AuthorityType type, String shortName) {
        if (type.isFixedString()) {
            return type.getFixedString();
        }
        if (type.isPrefixed()) {
            return type.getPrefixString() + shortName;
        }
        return shortName;
    }

    private void addAuthorityNameIfMatches(Set<String> authorities, String authorityName, AuthorityType type) {
        if (type == null || AuthorityType.getAuthorityType((String)authorityName).equals((Object)type)) {
            authorities.add(authorityName);
        }
    }

    private void addAuthorityNameIfMatches(Set<String> authorities, String authorityName, AuthorityType type, Pattern pattern) {
        if (type == null || AuthorityType.getAuthorityType((String)authorityName).equals((Object)type)) {
            if (pattern == null) {
                authorities.add(authorityName);
            } else if (pattern.matcher(this.getShortName(authorityName)).matches()) {
                authorities.add(authorityName);
            } else {
                String displayName = this.getAuthorityDisplayName(authorityName);
                if (displayName != null && pattern.matcher(displayName).matches()) {
                    authorities.add(authorityName);
                }
            }
        }
    }

    private void listAuthorities(AuthorityType type, String name, Set<String> authorities, boolean parents, boolean recursive) {
        AuthorityType localType = AuthorityType.getAuthorityType((String)name);
        if (!localType.equals((Object)AuthorityType.GUEST)) {
            NodeRef ref = this.getAuthorityOrNull(name);
            if (ref != null) {
                this.listAuthorities(type, ref, authorities, parents, recursive, false);
            } else if (!localType.equals((Object)AuthorityType.USER)) {
                throw new UnknownAuthorityException("An authority was not found for " + name);
            }
        }
    }

    private void listAuthorities(AuthorityType type, NodeRef nodeRef, Set<String> authorities, boolean parents, boolean recursive, boolean includeNode) {
        block6: {
            List cars;
            if (includeNode) {
                String authorityName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_AUTHORITY_CONTAINER) ? ContentModel.PROP_AUTHORITY_NAME : ContentModel.PROP_USERNAME));
                this.addAuthorityNameIfMatches(authorities, authorityName, type);
            }
            if (includeNode && !recursive) break block6;
            if (parents) {
                cars = this.nodeService.getParentAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_MEMBER, RegexQNamePattern.MATCH_ALL);
                for (ChildAssociationRef car : cars) {
                    this.listAuthorities(type, car.getParentRef(), authorities, true, recursive, true);
                }
            } else {
                cars = (List)this.childAuthorityCache.get((Serializable)nodeRef);
                if (cars == null && !(cars = this.nodeService.getChildAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false)).isEmpty() && ((ChildAssociationRef)cars.get(0)).getTypeQName().equals((Object)ContentModel.ASSOC_MEMBER)) {
                    this.childAuthorityCache.put((Serializable)nodeRef, (Object)cars);
                }
                for (ChildAssociationRef car : cars) {
                    String childName = car.getQName().getLocalName();
                    AuthorityType childType = AuthorityType.getAuthorityType((String)childName);
                    this.addAuthorityNameIfMatches(authorities, childName, type);
                    if (!recursive || childType == AuthorityType.USER) continue;
                    this.listAuthorities(type, car.getChildRef(), authorities, false, true, false);
                }
            }
        }
    }

    @Override
    public boolean isAuthorityContained(NodeRef authorityNodeRef, String authorityToFind) {
        List cars = (List)this.childAuthorityCache.get((Serializable)authorityNodeRef);
        if (cars == null) {
            cars = this.nodeService.getChildAssocs(authorityNodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
            this.childAuthorityCache.put((Serializable)authorityNodeRef, (Object)cars);
        }
        for (ChildAssociationRef car : cars) {
            String authorityName = car.getQName().getLocalName();
            if (!authorityToFind.equals(authorityName) && (AuthorityType.getAuthorityType((String)authorityName) == AuthorityType.USER || !this.isAuthorityContained(car.getChildRef(), authorityToFind))) continue;
            return true;
        }
        return false;
    }

    private void removeParentsFromChildAuthorityCache(NodeRef nodeRef) {
        for (ChildAssociationRef car : this.nodeService.getParentAssocs(nodeRef)) {
            NodeRef parentRef = car.getParentRef();
            if (!this.dictionaryService.isSubClass(this.nodeService.getType(parentRef), ContentModel.TYPE_AUTHORITY_CONTAINER)) continue;
            this.childAuthorityCache.remove((Serializable)parentRef);
        }
    }

    private NodeRef getAuthorityOrNull(String name) {
        try {
            if (AuthorityType.getAuthorityType((String)name).equals((Object)AuthorityType.USER)) {
                return this.personService.getPerson(name, false);
            }
            if (AuthorityType.getAuthorityType((String)name).equals((Object)AuthorityType.GUEST)) {
                return this.personService.getPerson(name, false);
            }
            if (AuthorityType.getAuthorityType((String)name).equals((Object)AuthorityType.ADMIN)) {
                return this.personService.getPerson(name, false);
            }
            Pair<String, String> cacheKey = this.cacheKey(name);
            NodeRef result = (NodeRef)this.authorityLookupCache.get(cacheKey);
            if (result == null) {
                List results = this.nodeService.getChildAssocs(this.getAuthorityContainer(), (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)QName.createQName((String)"cm", (String)name, (NamespacePrefixResolver)this.namespacePrefixResolver), false);
                result = results.isEmpty() ? NULL_NODEREF : ((ChildAssociationRef)results.get(0)).getChildRef();
                this.authorityLookupCache.put(cacheKey, (Object)result);
            }
            return result == NULL_NODEREF ? null : result;
        }
        catch (NoSuchPersonException e) {
            return null;
        }
    }

    private NodeRef getAuthorityContainer() {
        return this.getSystemContainer(this.qnameAssocAuthorities);
    }

    private NodeRef getZoneContainer() {
        return this.getSystemContainer(this.qnameAssocZones);
    }

    private NodeRef getSystemContainer(QName assocQName) {
        String cacheKey = this.tenantService.getCurrentUserDomain() + assocQName.toString();
        NodeRef systemContainerRef = this.systemContainerRefs.get(cacheKey);
        if (systemContainerRef == null) {
            NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
            List results = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.qnameAssocSystem, false);
            if (results.size() == 0) {
                throw new AlfrescoRuntimeException("Required system path not found: " + this.qnameAssocSystem);
            }
            NodeRef sysNodeRef = ((ChildAssociationRef)results.get(0)).getChildRef();
            if ((results = this.nodeService.getChildAssocs(sysNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)assocQName, false)).size() == 0) {
                throw new AlfrescoRuntimeException("Required path not found: " + assocQName);
            }
            systemContainerRef = ((ChildAssociationRef)results.get(0)).getChildRef();
            this.systemContainerRefs.put(cacheKey, systemContainerRef);
        }
        return systemContainerRef;
    }

    @Override
    public NodeRef getAuthorityNodeRefOrNull(String name) {
        return this.getAuthorityOrNull(name);
    }

    @Override
    public String getAuthorityName(NodeRef authorityRef) {
        String name = null;
        if (this.nodeService.exists(authorityRef)) {
            QName type = this.nodeService.getType(authorityRef);
            if (this.dictionaryService.isSubClass(type, ContentModel.TYPE_AUTHORITY_CONTAINER)) {
                name = (String)((Object)this.nodeService.getProperty(authorityRef, ContentModel.PROP_AUTHORITY_NAME));
            } else if (this.dictionaryService.isSubClass(type, ContentModel.TYPE_PERSON)) {
                name = (String)((Object)this.nodeService.getProperty(authorityRef, ContentModel.PROP_USERNAME));
            }
        }
        return name;
    }

    @Override
    public String getAuthorityDisplayName(String authorityName) {
        NodeRef ref = this.getAuthorityOrNull(authorityName);
        if (ref == null) {
            return null;
        }
        Serializable value = this.nodeService.getProperty(ref, ContentModel.PROP_AUTHORITY_DISPLAY_NAME);
        if (value == null) {
            return null;
        }
        return (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
    }

    @Override
    public void setAuthorityDisplayName(String authorityName, String authorityDisplayName) {
        NodeRef ref = this.getAuthorityOrNull(authorityName);
        if (ref == null) {
            return;
        }
        this.nodeService.setProperty(ref, ContentModel.PROP_AUTHORITY_DISPLAY_NAME, (Serializable)((Object)authorityDisplayName));
    }

    @Override
    public NodeRef getOrCreateZone(String zoneName) {
        return this.getOrCreateZone(zoneName, true);
    }

    private NodeRef getOrCreateZone(String zoneName, boolean create) {
        QName zoneQName;
        NodeRef zoneContainerRef = this.getZoneContainer();
        List results = this.nodeService.getChildAssocs(zoneContainerRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)(zoneQName = QName.createQName((String)"cm", (String)zoneName, (NamespacePrefixResolver)this.namespacePrefixResolver)), false);
        if (results.isEmpty()) {
            if (create) {
                HashMap<QName, String> props = new HashMap<QName, String>();
                props.put(ContentModel.PROP_NAME, zoneName);
                return this.nodeService.createNode(zoneContainerRef, ContentModel.ASSOC_CHILDREN, zoneQName, ContentModel.TYPE_ZONE, props).getChildRef();
            }
            return null;
        }
        return ((ChildAssociationRef)results.get(0)).getChildRef();
    }

    @Override
    public NodeRef getZone(String zoneName) {
        return this.getOrCreateZone(zoneName, false);
    }

    @Override
    public Set<String> getAuthorityZones(String name) {
        TreeSet<String> zones = new TreeSet<String>();
        NodeRef childRef = this.getAuthorityOrNull(name);
        if (childRef == null) {
            return null;
        }
        List results = this.nodeService.getParentAssocs(childRef, (QNamePattern)ContentModel.ASSOC_IN_ZONE, RegexQNamePattern.MATCH_ALL);
        if (results.isEmpty()) {
            return zones;
        }
        for (ChildAssociationRef current : results) {
            NodeRef zoneRef = current.getParentRef();
            Serializable value = this.nodeService.getProperty(zoneRef, ContentModel.PROP_NAME);
            if (value == null) continue;
            String zone = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            zones.add(zone);
        }
        return zones;
    }

    @Override
    public Set<String> getAllAuthoritiesInZone(String zoneName, AuthorityType type) {
        NodeRef zoneRef = this.getZone(zoneName);
        if (zoneRef == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(this.getAuthoritiesImpl(type, zoneRef, null, false, false, new PagingRequest(0, Integer.MAX_VALUE, null)).getPage());
    }

    @Override
    public void addAuthorityToZones(String authorityName, Set<String> zones) {
        if (zones != null && zones.size() > 0) {
            HashSet<NodeRef> zoneRefs = new HashSet<NodeRef>(zones.size() * 2);
            for (String authorityZone : zones) {
                zoneRefs.add(this.getOrCreateZone(authorityZone));
            }
            NodeRef authRef = this.getAuthorityOrNull(authorityName);
            if (authRef != null) {
                if (AuthorityType.getAuthorityType((String)authorityName) == AuthorityType.USER) {
                    authorityName = (String)((Object)this.nodeService.getProperty(authRef, ContentModel.PROP_USERNAME));
                }
                this.nodeService.addChild(zoneRefs, authRef, ContentModel.ASSOC_IN_ZONE, QName.createQName((String)"cm", (String)authorityName, (NamespacePrefixResolver)this.namespacePrefixResolver));
            }
        }
    }

    @Override
    public void removeAuthorityFromZones(String authorityName, Set<String> zones) {
        if (zones != null && zones.size() > 0) {
            NodeRef authRef = this.getAuthorityOrNull(authorityName);
            List results = this.nodeService.getParentAssocs(authRef, (QNamePattern)ContentModel.ASSOC_IN_ZONE, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef current : results) {
                String testZone;
                NodeRef zoneRef = current.getParentRef();
                Serializable value = this.nodeService.getProperty(zoneRef, ContentModel.PROP_NAME);
                if (value == null || !zones.contains(testZone = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value))) continue;
                this.nodeService.removeChildAssociation(current);
            }
        }
    }

    private Set<String> getRootAuthoritiesUnderContainer(NodeRef container, AuthorityType type) {
        if (type != null && type.equals((Object)AuthorityType.USER)) {
            return Collections.emptySet();
        }
        Collection childRefs = this.nodeService.getChildAssocsWithoutParentAssocsOfType(container, ContentModel.ASSOC_MEMBER);
        TreeSet<String> authorities = new TreeSet<String>();
        for (ChildAssociationRef childRef : childRefs) {
            this.addAuthorityNameIfMatches(authorities, childRef.getQName().getLocalName(), type);
        }
        return authorities;
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.userAuthorityCache.remove((Serializable)((Object)this.getAuthorityName(nodeRef)));
        this.removeParentsFromChildAuthorityCache(nodeRef);
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        boolean isAuthority = this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_AUTHORITY_CONTAINER);
        QName idProp = isAuthority ? ContentModel.PROP_AUTHORITY_NAME : ContentModel.PROP_USERNAME;
        String authBefore = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)before.get(idProp));
        if (authBefore == null) {
            return;
        }
        String authAfter = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)after.get(idProp));
        if (!EqualsHelper.nullSafeEquals((Object)authBefore, (Object)authAfter)) {
            if (AlfrescoTransactionSupport.getResource("PersonServiceImpl.KEY_ALLOW_UID_UPDATE") != null || authBefore.equalsIgnoreCase(authAfter)) {
                if (isAuthority) {
                    if (authBefore != null) {
                        this.aclDao.renameAuthority(authBefore, authAfter);
                    }
                    QName newAssocQName = QName.createQName((String)"cm", (String)authAfter, (NamespacePrefixResolver)this.namespacePrefixResolver);
                    ChildAssociationRef assoc = this.nodeService.getPrimaryParent(nodeRef);
                    this.nodeService.moveNode(nodeRef, assoc.getParentRef(), assoc.getTypeQName(), newAssocQName);
                    QName oldAssocQName = QName.createQName((String)"cm", (String)authBefore, (NamespacePrefixResolver)this.namespacePrefixResolver);
                    newAssocQName = QName.createQName((String)"cm", (String)authAfter, (NamespacePrefixResolver)this.namespacePrefixResolver);
                    for (ChildAssociationRef parent : this.nodeService.getParentAssocs(nodeRef)) {
                        if (parent.isPrimary() || !parent.getQName().equals((Object)oldAssocQName)) continue;
                        this.nodeService.removeChildAssociation(parent);
                        this.nodeService.addChild(parent.getParentRef(), parent.getChildRef(), parent.getTypeQName(), newAssocQName);
                    }
                    this.authorityLookupCache.clear();
                    this.authorityBridgeTableByTenantCache.clear();
                    this.userAuthorityCache.clear();
                } else {
                    this.userAuthorityCache.remove((Serializable)((Object)authBefore));
                }
                this.removeParentsFromChildAuthorityCache(nodeRef);
            } else {
                throw new UnsupportedOperationException("The name of an authority can not be changed");
            }
        }
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.TYPE_AUTHORITY, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
    }

    static {
        SEARCHABLE_AUTHORITY_TYPES.add(AuthorityType.ROLE);
        SEARCHABLE_AUTHORITY_TYPES.add(AuthorityType.GROUP);
    }
}

