/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority.script;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public interface Authority {
    public ScriptAuthorityType getAuthorityType();

    public String getShortName();

    public String getFullName();

    public String getDisplayName();

    public static class AuthorityComparator
    implements Comparator<Authority> {
        private Map<Authority, String> nameCache;
        private String sortBy;

        public AuthorityComparator(String sortBy) {
            this.sortBy = sortBy;
            this.nameCache = new HashMap<Authority, String>();
        }

        @Override
        public int compare(Authority g1, Authority g2) {
            return this.get(g1).compareTo(this.get(g2));
        }

        private String get(Authority g) {
            String v = this.nameCache.get(g);
            if (v == null) {
                v = "displayName".equals(this.sortBy) ? g.getDisplayName() : ("shortName".equals(this.sortBy) ? g.getShortName() : g.getFullName());
                v = v.toLowerCase();
                this.nameCache.put(g, v);
            }
            return v;
        }
    }

    public static enum ScriptAuthorityType {
        GROUP,
        USER;

    }
}

