/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority.script;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authority.script.ScriptAuthorityService;
import org.alfresco.repo.security.authority.script.ScriptGroup;
import org.alfresco.repo.security.authority.script.ScriptUser;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.ScriptPagingDetails;
import org.springframework.context.ApplicationContext;

public class ScriptAuthorityServiceTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static final String GROUP_A = "testGroupA";
    private static final String GROUP_A_FULL = "GROUP_testGroupA";
    private static final String GROUP_B = "testGroupB";
    private static final String GROUP_B_FULL = "GROUP_testGroupB";
    private static final String GROUP_C = "testGroupC";
    private static final String GROUP_C_FULL = "GROUP_testGroupC";
    private static final String USER_A = "testUserA";
    private static final String USER_B = "testUserB";
    private static final String USER_C = "testUserC";
    private AuthenticationComponent authenticationComponentImpl;
    private MutableAuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    private AuthorityService authorityService;
    private AuthorityService pubAuthorityService;
    private PersonService personService;
    private UserTransaction tx;
    private AclDAO aclDaoComponent;
    private NodeService nodeService;
    private ScriptAuthorityService service;

    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        this.authenticationComponentImpl = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        this.authorityService = (AuthorityService)ctx.getBean("authorityService");
        this.pubAuthorityService = (AuthorityService)ctx.getBean("AuthorityService");
        this.personService = (PersonService)ctx.getBean("personService");
        this.authenticationDAO = (MutableAuthenticationDao)ctx.getBean("authenticationDao");
        this.aclDaoComponent = (AclDAO)ctx.getBean("aclDAO");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.service = (ScriptAuthorityService)ctx.getBean("authorityServiceScript");
        this.authenticationComponentImpl.setSystemUserAsCurrentUser();
        TransactionService transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.tx = transactionService.getUserTransaction();
        this.tx.begin();
        for (String user : new String[]{USER_A, USER_B, USER_C}) {
            if (this.personService.personExists(user)) {
                NodeRef person = this.personService.getPerson(user);
                NodeRef hf = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER));
                if (hf != null) {
                    this.nodeService.deleteNode(hf);
                }
                this.aclDaoComponent.deleteAccessControlEntries(user);
                this.personService.deletePerson(user);
            }
            if (!this.authenticationDAO.userExists(user)) continue;
            this.authenticationDAO.deleteUser(user);
        }
        if (this.authorityService.authorityExists(GROUP_A_FULL)) {
            this.authorityService.deleteAuthority(GROUP_A_FULL);
        }
        if (this.authorityService.authorityExists(GROUP_B_FULL)) {
            this.authorityService.deleteAuthority(GROUP_B_FULL);
        }
        if (this.authorityService.authorityExists(GROUP_C_FULL)) {
            this.authorityService.deleteAuthority(GROUP_C_FULL);
        }
        this.tx.commit();
        this.tx = transactionService.getUserTransaction();
        this.tx.begin();
        this.authorityService.createAuthority(AuthorityType.GROUP, GROUP_A);
        this.authorityService.createAuthority(AuthorityType.GROUP, GROUP_B);
        this.authorityService.createAuthority(AuthorityType.GROUP, GROUP_C);
        for (String user : new String[]{USER_A, USER_B, USER_C}) {
            if (!this.authenticationDAO.userExists(user)) {
                this.authenticationService.createAuthentication(user, user.toCharArray());
            }
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
            props.put(ContentModel.PROP_USERNAME, (Serializable)((Object)user));
            props.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)user));
            props.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)("Last_" + user)));
            this.personService.createPerson(props);
        }
    }

    protected void tearDown() throws Exception {
        if (this.tx.getStatus() == 0 || this.tx.getStatus() == 1) {
            this.tx.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testBasics() {
        int count = this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size();
        Object[] groups = this.service.getAllRootGroups();
        ScriptAuthorityServiceTest.assertEquals((int)count, (int)groups.length);
        ScriptGroup groupA = null;
        ScriptGroup groupB = null;
        ScriptGroup groupC = null;
        for (ScriptGroup scriptGroup : groups) {
            if (scriptGroup.getShortName().equals(GROUP_A)) {
                groupA = scriptGroup;
            }
            if (scriptGroup.getShortName().equals(GROUP_B)) {
                groupB = scriptGroup;
            }
            if (!scriptGroup.getShortName().equals(GROUP_C)) continue;
            groupC = scriptGroup;
        }
        ScriptAuthorityServiceTest.assertNotNull((String)("testGroupA not found in " + Arrays.toString(groups)), (Object)groupA);
        ScriptAuthorityServiceTest.assertNotNull((String)("testGroupB not found in " + Arrays.toString(groups)), (Object)groupB);
        ScriptAuthorityServiceTest.assertNotNull((String)("testGroupC not found in " + Arrays.toString(groups)), (Object)groupC);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_A, (String)groupA.getShortName());
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_A, (String)groupA.getDisplayName());
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_A_FULL, (String)groupA.getFullName());
        ScriptNode groupANode = groupA.getGroupNode();
        ScriptAuthorityServiceTest.assertEquals((Object)groupA.getDisplayName(), (Object)groupANode.getProperties().get("authorityDisplayName"));
        ScriptAuthorityServiceTest.assertEquals((Object)groupA.getFullName(), (Object)groupANode.getProperties().get("authorityName"));
    }

    public void testZones() {
    }

    public void testGetGroups() {
        ScriptGroup[] groups = this.service.getGroupsInZone("test", "APP.DEFAULT", new ScriptPagingDetails(10, 0), null);
        ScriptAuthorityServiceTest.assertEquals((int)3, (int)groups.length);
        groups = this.service.getGroupsInZone(GROUP_A, "APP.DEFAULT", new ScriptPagingDetails(10, 0), null);
        ScriptAuthorityServiceTest.assertEquals((int)1, (int)groups.length);
        groups = this.service.getGroupsInZone("*Group", "APP.DEFAULT", new ScriptPagingDetails(10, 0), null);
        ScriptAuthorityServiceTest.assertEquals((int)3, (int)groups.length);
        groups = this.service.getGroupsInZone("t?st", "APP.DEFAULT", new ScriptPagingDetails(10, 0), null);
        ScriptAuthorityServiceTest.assertEquals((int)3, (int)groups.length);
        groups = this.service.getGroupsInZone("*", "APP.DEFAULT", new ScriptPagingDetails(10, 0), null);
        ScriptAuthorityServiceTest.assertEquals((int)5, (int)groups.length);
        groups = this.service.getGroupsInZone("test", "APP.DEFAULT", new ScriptPagingDetails(2, 2), "displayName");
        ScriptAuthorityServiceTest.assertEquals((int)1, (int)groups.length);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_C, (String)groups[0].getShortName());
    }

    public void testFindGroups() {
        this.pubAuthorityService.addAuthority(GROUP_A_FULL, GROUP_B_FULL);
        ScriptGroup[] groups = this.service.searchGroups(GROUP_A, new ScriptPagingDetails(10, 0), "default");
        ScriptAuthorityServiceTest.assertEquals((int)1, (int)groups.length);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_A, (String)groups[0].getShortName());
        groups = this.service.searchGroups(GROUP_A.substring(0, GROUP_A.length() - 1), new ScriptPagingDetails(10, 0), "default");
        ScriptAuthorityServiceTest.assertEquals((int)3, (int)groups.length);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_A, (String)groups[0].getShortName());
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_B, (String)groups[1].getShortName());
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_C, (String)groups[2].getShortName());
        groups = this.service.searchGroups(GROUP_A.substring(0, GROUP_A.length() - 1), new ScriptPagingDetails(2, 0), "default");
        ScriptAuthorityServiceTest.assertEquals((int)2, (int)groups.length);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_A, (String)groups[0].getShortName());
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_B, (String)groups[1].getShortName());
        groups = this.service.searchGroups(GROUP_A.substring(0, GROUP_A.length() - 1), new ScriptPagingDetails(2, 2), "default");
        ScriptAuthorityServiceTest.assertEquals((int)1, (int)groups.length);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_C, (String)groups[0].getShortName());
        groups = this.service.searchRootGroups(GROUP_A, new ScriptPagingDetails(10, 0), "default");
        ScriptAuthorityServiceTest.assertEquals((int)1, (int)groups.length);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_A, (String)groups[0].getShortName());
        groups = this.service.searchRootGroups(GROUP_A.substring(0, GROUP_A.length() - 1) + "*", new ScriptPagingDetails(10, 0), "default");
        ScriptAuthorityServiceTest.assertEquals((int)2, (int)groups.length);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_A, (String)groups[0].getShortName());
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_C, (String)groups[1].getShortName());
        HashSet<String> zones = new HashSet<String>();
        zones.add("APP.SHARE");
        this.pubAuthorityService.addAuthorityToZones(GROUP_A_FULL, zones);
        zones.add("APP.WCM");
        this.pubAuthorityService.addAuthorityToZones(GROUP_B_FULL, zones);
        groups = this.service.searchGroupsInZone(GROUP_A.substring(0, GROUP_A.length() - 1), "APP.SHARE", new ScriptPagingDetails(10, 0), "default");
        ScriptAuthorityServiceTest.assertEquals((int)2, (int)groups.length);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_A, (String)groups[0].getShortName());
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_B, (String)groups[1].getShortName());
        groups = this.service.searchGroupsInZone(GROUP_A.substring(0, GROUP_A.length() - 1), "APP.WCM", new ScriptPagingDetails(10, 0), "default");
        ScriptAuthorityServiceTest.assertEquals((int)1, (int)groups.length);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_B, (String)groups[0].getShortName());
        groups = this.service.searchRootGroupsInZone(GROUP_A.substring(0, GROUP_A.length() - 1) + "*", "APP.SHARE", new ScriptPagingDetails(10, 0), "default");
        ScriptAuthorityServiceTest.assertEquals((int)1, (int)groups.length);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_A, (String)groups[0].getShortName());
        groups = this.service.searchRootGroupsInZone(GROUP_A.substring(0, GROUP_A.length() - 1) + "*", "APP.WCM", new ScriptPagingDetails(10, 0), "default");
        ScriptAuthorityServiceTest.assertEquals((int)1, (int)groups.length);
        ScriptAuthorityServiceTest.assertEquals((String)GROUP_B, (String)groups[0].getShortName());
    }

    public void testGroupUsers() {
        ScriptGroup groupA = this.service.getGroup(GROUP_A);
        ScriptAuthorityServiceTest.assertEquals((int)0, (int)groupA.getUserCount());
        ScriptUser[] users = groupA.getAllUsers();
        ScriptAuthorityServiceTest.assertEquals((int)0, (int)users.length);
        this.authorityService.addAuthority(GROUP_A_FULL, USER_A);
        this.authorityService.addAuthority(GROUP_A_FULL, USER_B);
        groupA = this.service.getGroup(GROUP_A);
        ScriptAuthorityServiceTest.assertEquals((int)2, (int)groupA.getUserCount());
        users = groupA.getAllUsers();
        ScriptAuthorityServiceTest.assertEquals((int)2, (int)users.length);
        ScriptUser userA = null;
        ScriptUser userB = null;
        for (ScriptUser user : users) {
            if (user.getUserName().equals(USER_A)) {
                userA = user;
            }
            if (!user.getUserName().equals(USER_B)) continue;
            userB = user;
        }
        ScriptAuthorityServiceTest.assertNotNull(userA);
        ScriptAuthorityServiceTest.assertNotNull(userB);
        ScriptAuthorityServiceTest.assertEquals((Object)USER_A, (Object)userA.getPerson().getProperties().get("userName"));
        ScriptAuthorityServiceTest.assertEquals((Object)USER_B, (Object)userB.getPerson().getProperties().get("userName"));
    }

    public void testUsers() {
        ScriptUser userA = this.service.getUser(USER_A);
        ScriptUser userB = this.service.getUser(USER_B);
        ScriptUser userC = this.service.getUser(USER_C);
        ScriptUser userNA = this.service.getUser("DOESnotEXISTinTHEsystem");
        ScriptAuthorityServiceTest.assertNotNull((Object)userA);
        ScriptAuthorityServiceTest.assertNotNull((Object)userB);
        ScriptAuthorityServiceTest.assertNotNull((Object)userC);
        ScriptAuthorityServiceTest.assertNull((Object)userNA);
        ScriptAuthorityServiceTest.assertEquals((String)USER_A, (String)userA.getShortName());
        String fullDisplayName = "testUserA Last_testUserA";
        ScriptAuthorityServiceTest.assertEquals((String)fullDisplayName, (String)userA.getFullName());
        ScriptAuthorityServiceTest.assertEquals((String)fullDisplayName, (String)userA.getDisplayName());
        NodeRef nodeA = this.personService.getPerson(USER_A, false);
        ScriptAuthorityServiceTest.assertNotNull((Object)nodeA);
        ScriptAuthorityServiceTest.assertEquals((Object)nodeA, (Object)userA.getPersonNodeRef());
        ScriptAuthorityServiceTest.assertEquals((Object)nodeA, (Object)userA.getPerson().getNodeRef());
        ScriptAuthorityServiceTest.assertEquals((Object)USER_A, (Object)userA.getPerson().getProperties().get("userName"));
        ScriptAuthorityServiceTest.assertEquals((Object)USER_A, (Object)userA.getPerson().getProperties().get("firstName"));
    }

    public void testFindUsers() {
        Object[] users = this.service.searchUsers(AuthenticationUtil.getAdminUserName(), new ScriptPagingDetails(10, 0), "userName");
        ScriptAuthorityServiceTest.assertTrue((String)"Admin not found", (users.length > 0 ? 1 : 0) != 0);
        users = this.service.searchUsers(USER_A.substring(0, USER_A.length() - 1), new ScriptPagingDetails(10, 0), "userName");
        ScriptAuthorityServiceTest.assertEquals((String)("Users count wrong " + users), (int)3, (int)users.length);
        ScriptAuthorityServiceTest.assertEquals((Object)USER_A, (Object)users[0].getPerson().getProperties().get("userName"));
        ScriptAuthorityServiceTest.assertEquals((Object)USER_B, (Object)users[1].getPerson().getProperties().get("userName"));
        ScriptAuthorityServiceTest.assertEquals((Object)USER_C, (Object)users[2].getPerson().getProperties().get("userName"));
        ScriptUser userA = users[0];
        ScriptUser userB = users[1];
        ScriptUser userC = users[2];
        this.nodeService.setProperty(userB.getPersonNodeRef(), ContentModel.PROP_FIRSTNAME, (Serializable)((Object)"bbbbFIRST"));
        this.nodeService.setProperty(userC.getPersonNodeRef(), ContentModel.PROP_LASTNAME, (Serializable)((Object)"ccccLAST"));
        users = this.service.searchUsers(USER_A.substring(0, USER_A.length() - 1), new ScriptPagingDetails(10, 0), "userName");
        ScriptAuthorityServiceTest.assertEquals((String)("Users count wrong " + Arrays.toString(users)), (int)3, (int)users.length);
        ScriptAuthorityServiceTest.assertEquals((Object)USER_A, (Object)((ScriptUser)users[0]).getPerson().getProperties().get("userName"));
        ScriptAuthorityServiceTest.assertEquals((Object)USER_B, (Object)((ScriptUser)users[1]).getPerson().getProperties().get("userName"));
        ScriptAuthorityServiceTest.assertEquals((Object)USER_C, (Object)((ScriptUser)users[2]).getPerson().getProperties().get("userName"));
        users = this.service.searchUsers(USER_A.substring(0, USER_A.length() - 1), new ScriptPagingDetails(10, 0), "firstName");
        ScriptAuthorityServiceTest.assertEquals((String)("Users count wrong " + Arrays.toString(users)), (int)3, (int)users.length);
        ScriptAuthorityServiceTest.assertEquals((Object)USER_B, (Object)((ScriptUser)users[0]).getPerson().getProperties().get("userName"));
        ScriptAuthorityServiceTest.assertEquals((Object)USER_A, (Object)((ScriptUser)users[1]).getPerson().getProperties().get("userName"));
        ScriptAuthorityServiceTest.assertEquals((Object)USER_C, (Object)((ScriptUser)users[2]).getPerson().getProperties().get("userName"));
        users = this.service.searchUsers(USER_A.substring(0, USER_A.length() - 1), new ScriptPagingDetails(10, 0), "lastName");
        ScriptAuthorityServiceTest.assertEquals((String)("Users count wrong " + Arrays.toString(users)), (int)3, (int)users.length);
        ScriptAuthorityServiceTest.assertEquals((Object)USER_C, (Object)((ScriptUser)users[0]).getPerson().getProperties().get("userName"));
        ScriptAuthorityServiceTest.assertEquals((Object)USER_A, (Object)((ScriptUser)users[1]).getPerson().getProperties().get("userName"));
        ScriptAuthorityServiceTest.assertEquals((Object)USER_B, (Object)((ScriptUser)users[2]).getPerson().getProperties().get("userName"));
    }
}

