/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionReference;
import org.alfresco.service.namespace.QName;

public class PermissionReferenceImpl
extends AbstractPermissionReference {
    private static ReadWriteLock lock = new ReentrantReadWriteLock();
    private static HashMap<QName, HashMap<String, PermissionReferenceImpl>> instances = new HashMap();
    private static final long serialVersionUID = -8639601925783501443L;
    private QName qName;
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PermissionReferenceImpl getPermissionReference(QName qName, String name) {
        PermissionReferenceImpl instance;
        HashMap<String, PermissionReferenceImpl> typed;
        lock.readLock().lock();
        try {
            typed = instances.get(qName);
            if (typed != null && (instance = typed.get(name)) != null) {
                PermissionReferenceImpl permissionReferenceImpl = instance;
                return permissionReferenceImpl;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        lock.writeLock().lock();
        try {
            typed = instances.get(qName);
            if (typed == null) {
                typed = new HashMap();
                instances.put(qName, typed);
            }
            if ((instance = typed.get(name)) == null) {
                instance = new PermissionReferenceImpl(qName, name);
                typed.put(name, instance);
            }
            PermissionReferenceImpl permissionReferenceImpl = instance;
            return permissionReferenceImpl;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    protected PermissionReferenceImpl(QName qName, String name) {
        this.qName = qName;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public QName getQName() {
        return this.qName;
    }
}

