/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.providers.dao.User;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMRepository;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityServiceImpl;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.AccessControlEntry;
import org.alfresco.repo.security.permissions.AccessControlList;
import org.alfresco.repo.security.permissions.AccessControlListProperties;
import org.alfresco.repo.security.permissions.DynamicAuthority;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.permissions.impl.AccessPermissionImpl;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.security.permissions.impl.PermissionsDaoComponent;
import org.alfresco.repo.security.permissions.impl.RequiredPermission;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionContext;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class PermissionServiceImpl
extends AbstractLifecycleBean
implements PermissionServiceSPI {
    static SimplePermissionReference OLD_ALL_PERMISSIONS_REFERENCE = new SimplePermissionReference(QName.createQName((String)"", (String)"All"), "All");
    private static Log log = LogFactory.getLog(PermissionServiceImpl.class);
    protected SimpleCache<Serializable, AccessStatus> accessCache;
    protected SimpleCache<Serializable, Set<String>> readersCache;
    protected SimpleCache<Serializable, Set<String>> readersDeniedCache;
    protected ModelDAO modelDAO;
    protected PermissionsDaoComponent permissionsDaoComponent;
    protected NodeService nodeService;
    protected TenantService tenantService;
    protected DictionaryService dictionaryService;
    protected OwnableService ownableService;
    protected AuthorityService authorityService;
    protected List<DynamicAuthority> dynamicAuthorities;
    protected PolicyComponent policyComponent;
    protected AclDAO aclDaoComponent;
    protected PermissionReference allPermissionReference;
    protected boolean anyDenyDenies = false;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setAnyDenyDenies(boolean anyDenyDenies) {
        this.anyDenyDenies = anyDenyDenies;
        this.accessCache.clear();
        this.readersCache.clear();
        this.readersDeniedCache.clear();
    }

    public boolean getAnyDenyDenies() {
        return this.anyDenyDenies;
    }

    public void setModelDAO(ModelDAO modelDAO) {
        this.modelDAO = modelDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setPermissionsDaoComponent(PermissionsDaoComponent permissionsDaoComponent) {
        this.permissionsDaoComponent = permissionsDaoComponent;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setDynamicAuthorities(List<DynamicAuthority> dynamicAuthorities) {
        this.dynamicAuthorities = dynamicAuthorities;
    }

    public void setAclDAO(AclDAO aclDaoComponent) {
        this.aclDaoComponent = aclDaoComponent;
    }

    public void setAccessCache(SimpleCache<Serializable, AccessStatus> accessCache) {
        this.accessCache = accessCache;
    }

    public void setReadersCache(SimpleCache<Serializable, Set<String>> readersCache) {
        this.readersCache = readersCache;
    }

    public void setReadersDeniedCache(SimpleCache<Serializable, Set<String>> readersDeniedCache) {
        this.readersDeniedCache = readersDeniedCache;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        this.accessCache.clear();
    }

    public void onCreateChildAssociation(ChildAssociationRef childAssocRef) {
        this.accessCache.clear();
    }

    public void beforeDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        this.accessCache.clear();
    }

    protected void onBootstrap(ApplicationEvent event) {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"modelDAO", (Object)this.modelDAO);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"ownableService", (Object)this.ownableService);
        PropertyCheck.mandatory((Object)this, (String)"permissionsDaoComponent", (Object)this.permissionsDaoComponent);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"accessCache", this.accessCache);
        PropertyCheck.mandatory((Object)this, (String)"readersCache", this.readersCache);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"aclDaoComponent", (Object)this.aclDaoComponent);
        this.allPermissionReference = this.getPermissionReference("All");
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onMoveNode"), ContentModel.TYPE_BASE, (Behaviour)new JavaBehaviour(this, "onMoveNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateChildAssociation"), ContentModel.TYPE_AUTHORITY_CONTAINER, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteChildAssociation"), ContentModel.TYPE_AUTHORITY_CONTAINER, (Behaviour)new JavaBehaviour(this, "beforeDeleteChildAssociation"));
    }

    public String getOwnerAuthority() {
        return "ROLE_OWNER";
    }

    public String getAllAuthorities() {
        return "GROUP_EVERYONE";
    }

    public String getAllPermission() {
        return "All";
    }

    public Set<AccessPermission> getPermissions(NodeRef nodeRef) {
        return this.getAllPermissionsImpl(nodeRef, true, true);
    }

    public Set<AccessPermission> getAllSetPermissions(NodeRef nodeRef) {
        HashSet<AccessPermission> accessPermissions = new HashSet<AccessPermission>();
        NodePermissionEntry nodePremissionEntry = this.getSetPermissions(nodeRef);
        for (PermissionEntry permissionEntry : nodePremissionEntry.getPermissionEntries()) {
            accessPermissions.add(new AccessPermissionImpl(this.getPermission(permissionEntry.getPermissionReference()), permissionEntry.getAccessStatus(), permissionEntry.getAuthority(), permissionEntry.getPosition()));
        }
        return accessPermissions;
    }

    public Set<AccessPermission> getAllSetPermissions(StoreRef storeRef) {
        HashSet<AccessPermission> accessPermissions = new HashSet<AccessPermission>();
        NodePermissionEntry nodePremissionEntry = this.getSetPermissions(storeRef);
        for (PermissionEntry permissionEntry : nodePremissionEntry.getPermissionEntries()) {
            accessPermissions.add(new AccessPermissionImpl(this.getPermission(permissionEntry.getPermissionReference()), permissionEntry.getAccessStatus(), permissionEntry.getAuthority(), permissionEntry.getPosition()));
        }
        return accessPermissions;
    }

    protected Set<AccessPermission> getAllPermissionsImpl(NodeRef nodeRef, boolean includeTrue, boolean includeFalse) {
        String userName = AuthenticationUtil.getRunAsUser();
        HashSet<AccessPermission> accessPermissions = new HashSet<AccessPermission>();
        for (PermissionReference pr : this.getSettablePermissionReferences(nodeRef)) {
            if (this.hasPermission(nodeRef, pr) == AccessStatus.ALLOWED) {
                accessPermissions.add(new AccessPermissionImpl(this.getPermission(pr), AccessStatus.ALLOWED, userName, -1));
                continue;
            }
            if (!includeFalse) continue;
            accessPermissions.add(new AccessPermissionImpl(this.getPermission(pr), AccessStatus.DENIED, userName, -1));
        }
        return accessPermissions;
    }

    public Set<String> getSettablePermissions(NodeRef nodeRef) {
        Set<PermissionReference> settable = this.getSettablePermissionReferences(nodeRef);
        HashSet<String> strings = new HashSet<String>(settable.size());
        for (PermissionReference pr : settable) {
            strings.add(this.getPermission(pr));
        }
        return strings;
    }

    public Set<String> getSettablePermissions(QName type) {
        Set<PermissionReference> settable = this.getSettablePermissionReferences(type);
        LinkedHashSet<String> strings = new LinkedHashSet<String>(settable.size());
        for (PermissionReference pr : settable) {
            strings.add(this.getPermission(pr));
        }
        return strings;
    }

    @Override
    public NodePermissionEntry getSetPermissions(NodeRef nodeRef) {
        return this.permissionsDaoComponent.getPermissions(this.tenantService.getName(nodeRef));
    }

    @Override
    public NodePermissionEntry getSetPermissions(StoreRef storeRef) {
        return this.permissionsDaoComponent.getPermissions(storeRef);
    }

    @Override
    public AccessStatus hasPermission(NodeRef passedNodeRef, PermissionReference permIn) {
        if (passedNodeRef == null) {
            return AccessStatus.ALLOWED;
        }
        if (permIn == null) {
            return AccessStatus.DENIED;
        }
        if (passedNodeRef.getStoreRef().getProtocol().equals("avm")) {
            return this.doAvmCan(passedNodeRef, permIn);
        }
        if (this.isVersionNodeRef(passedNodeRef)) {
            passedNodeRef = this.convertVersionNodeRefToVersionedNodeRef(VersionUtil.convertNodeRef(passedNodeRef));
        }
        if (!this.nodeService.exists(passedNodeRef)) {
            return AccessStatus.ALLOWED;
        }
        final NodeRef nodeRef = this.tenantService.getName(passedNodeRef);
        final PermissionReference perm = permIn.equals(OLD_ALL_PERMISSIONS_REFERENCE) ? this.getAllPermissionReference() : permIn;
        if (AuthenticationUtil.getRunAsUser() == null) {
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return AccessStatus.ALLOWED;
        }
        AccessControlListProperties properties = this.permissionsDaoComponent.getAccessControlListProperties(nodeRef);
        if (properties != null && properties.getAclType() != null && properties.getAclType() != ACLType.OLD) {
            QName typeQname = this.nodeService.getType(nodeRef);
            Set aspectQNames = this.nodeService.getAspects(nodeRef);
            PermissionContext context = new PermissionContext(typeQname);
            context.getAspects().addAll(aspectQNames);
            Authentication auth = AuthenticationUtil.getRunAsAuthentication();
            if (auth != null) {
                String user = AuthenticationUtil.getRunAsUser();
                for (String dynamicAuthority : this.getDynamicAuthorities(auth, nodeRef, perm)) {
                    context.addDynamicAuthorityAssignment(user, dynamicAuthority);
                }
            }
            return this.hasPermission(properties.getId(), context, perm);
        }
        Authentication auth = AuthenticationUtil.getRunAsAuthentication();
        final Set<String> authorisations = this.getAuthorisations(auth, nodeRef, perm);
        Set available = (Set)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<PermissionReference>>(){

            public Set<PermissionReference> doWork() throws Exception {
                return PermissionServiceImpl.this.modelDAO.getAllPermissions(nodeRef);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        available.add(this.getAllPermissionReference());
        available.add(OLD_ALL_PERMISSIONS_REFERENCE);
        final Serializable key = this.generateKey(authorisations, nodeRef, perm, CacheType.HAS_PERMISSION);
        if (!available.contains(perm)) {
            this.accessCache.put(key, (Object)AccessStatus.DENIED);
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return AccessStatus.ALLOWED;
        }
        return (AccessStatus)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<AccessStatus>(){

            public AccessStatus doWork() throws Exception {
                AccessStatus status = (AccessStatus)PermissionServiceImpl.this.accessCache.get(key);
                if (status != null) {
                    return status;
                }
                QName typeQname = PermissionServiceImpl.this.nodeService.getType(nodeRef);
                Set aspectQNames = PermissionServiceImpl.this.nodeService.getAspects(nodeRef);
                NodeTest nt = new NodeTest(perm, typeQname, aspectQNames);
                boolean result = nt.evaluate(authorisations, nodeRef);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Permission <" + perm + "> is " + (result ? "allowed" : "denied") + " for " + AuthenticationUtil.getRunAsUser() + " on node " + PermissionServiceImpl.this.nodeService.getPath(nodeRef)));
                }
                status = result ? AccessStatus.ALLOWED : AccessStatus.DENIED;
                PermissionServiceImpl.this.accessCache.put(key, (Object)status);
                return status;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private AccessStatus doAvmCan(NodeRef nodeRef, PermissionReference permission) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        String path = (String)avmVersionPath.getSecond();
        boolean result = AVMRepository.GetInstance().can(nodeRef.getStoreRef().getIdentifier(), version, path, permission.getName());
        AccessStatus status = result ? AccessStatus.ALLOWED : AccessStatus.DENIED;
        return status;
    }

    public AccessStatus hasPermission(Long aclID, PermissionContext context, String permission) {
        return this.hasPermission(aclID, context, this.getPermissionReference(permission));
    }

    protected AccessStatus hasPermission(Long aclId, PermissionContext context, PermissionReference permission) {
        boolean result;
        if (aclId == null) {
            HashSet aspectQNames;
            if (context.getStoreAcl() == null) {
                return AccessStatus.ALLOWED;
            }
            if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
                return AccessStatus.ALLOWED;
            }
            Authentication auth = AuthenticationUtil.getRunAsAuthentication();
            if (auth == null) {
                throw new IllegalStateException("Unauthenticated");
            }
            Set<String> storeAuthorisations = this.getAuthorisations(auth, null);
            QName typeQname = context.getType();
            AclTest aclTest = new AclTest(permission, typeQname, aspectQNames = context.getAspects());
            boolean result2 = aclTest.evaluate(storeAuthorisations, context.getStoreAcl(), context);
            AccessStatus status = result2 ? AccessStatus.ALLOWED : AccessStatus.DENIED;
            return status;
        }
        if (permission == null) {
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.getRunAsUser() == null) {
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.getRunAsUser().equals(AuthenticationUtil.getSystemUserName())) {
            return AccessStatus.ALLOWED;
        }
        Authentication auth = AuthenticationUtil.getRunAsAuthentication();
        if (auth == null) {
            throw new IllegalStateException("Unauthenticated");
        }
        Set<String> authorisations = this.getAuthorisations(auth, context);
        final QName typeQname = context.getType();
        final HashSet aspectQNames = context.getAspects();
        Set available = (Set)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<PermissionReference>>(){

            public Set<PermissionReference> doWork() throws Exception {
                return PermissionServiceImpl.this.modelDAO.getAllPermissions(typeQname, aspectQNames);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        available.add(this.getAllPermissionReference());
        available.add(OLD_ALL_PERMISSIONS_REFERENCE);
        if (!available.contains(permission)) {
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return AccessStatus.ALLOWED;
        }
        if (permission.equals(OLD_ALL_PERMISSIONS_REFERENCE)) {
            permission = this.getAllPermissionReference();
        }
        if (context.getStoreAcl() == null) {
            AclTest aclTest = new AclTest(permission, typeQname, aspectQNames);
            result = aclTest.evaluate(authorisations, aclId, context);
        } else {
            Set<String> storeAuthorisations = this.getAuthorisations(auth, null);
            AclTest aclTest = new AclTest(permission, typeQname, aspectQNames);
            result = aclTest.evaluate(authorisations, aclId, context) && aclTest.evaluate(storeAuthorisations, context.getStoreAcl(), context);
        }
        AccessStatus status = result ? AccessStatus.ALLOWED : AccessStatus.DENIED;
        return status;
    }

    Serializable generateKey(Set<String> auths, NodeRef nodeRef, PermissionReference perm, CacheType type) {
        LinkedHashSet<Object> key = new LinkedHashSet<Object>();
        key.add(perm.toString());
        if (auths instanceof AuthorityServiceImpl.UserAuthoritySet) {
            key.add((Serializable)((Object)Collections.singleton(((AuthorityServiceImpl.UserAuthoritySet)auths).getUsername())));
        } else {
            key.addAll(auths);
        }
        key.add(nodeRef);
        NodeRef.Status nodeStatus = this.nodeService.getNodeStatus(nodeRef);
        key.add(nodeStatus == null ? "null" : nodeStatus.getChangeTxnId());
        key.add((Object)type);
        return key;
    }

    protected Set<String> getCoreAuthorisations(Authentication auth) {
        if (auth == null) {
            return Collections.emptySet();
        }
        User user = (User)auth.getPrincipal();
        String username = user.getUsername();
        Set<String> auths = this.authorityService.getAuthoritiesForUser(username);
        auths.add(username);
        for (GrantedAuthority grantedAuthority : auth.getAuthorities()) {
            auths.add(grantedAuthority.getAuthority());
        }
        return auths;
    }

    protected Set<String> getAuthorisations(Authentication auth, NodeRef nodeRef, PermissionReference required) {
        Set<String> auths = this.getCoreAuthorisations(auth);
        if (auth != null) {
            auths.addAll(this.getDynamicAuthorities(auth, nodeRef, required));
        }
        return auths;
    }

    protected Set<String> getDynamicAuthorities(Authentication auth, NodeRef nodeRef, PermissionReference required) {
        HashSet<String> dynAuths = new HashSet<String>(64);
        User user = (User)auth.getPrincipal();
        String username = user.getUsername();
        if ((nodeRef = this.tenantService.getName(nodeRef)) != null && this.dynamicAuthorities != null) {
            for (DynamicAuthority da : this.dynamicAuthorities) {
                Set<PermissionReference> requiredFor = da.requiredFor();
                if (requiredFor != null && !requiredFor.contains(required) || !da.hasAuthority(nodeRef, username)) continue;
                dynAuths.add(da.getAuthority());
            }
        }
        return dynAuths;
    }

    protected Set<String> getAuthorisations(Authentication auth, PermissionContext context) {
        Set<String> auths = this.getCoreAuthorisations(auth);
        if (auth != null && context != null) {
            auths.addAll(this.getDynamicAuthorities(auth, context, auths));
        }
        return auths;
    }

    protected Set<String> getDynamicAuthorities(Authentication auth, PermissionContext context, Set<String> auths) {
        HashSet<String> dynAuths = new HashSet<String>();
        Map dynamicAuthorityAssignments = context.getDynamicAuthorityAssignment();
        for (String dynKey : dynamicAuthorityAssignments.keySet()) {
            Set dynos;
            if (!auths.contains(dynKey) || (dynos = (Set)dynamicAuthorityAssignments.get(dynKey)) == null) continue;
            dynAuths.addAll(dynos);
        }
        return dynAuths;
    }

    @Override
    public NodePermissionEntry explainPermission(NodeRef nodeRef, PermissionReference perm) {
        return null;
    }

    public void clearPermission(StoreRef storeRef, String authority) {
        this.permissionsDaoComponent.deletePermissions(storeRef, authority);
        this.accessCache.clear();
    }

    public void deletePermission(StoreRef storeRef, String authority, String perm) {
        this.deletePermission(storeRef, authority, this.getPermissionReference(perm));
    }

    protected void deletePermission(StoreRef storeRef, String authority, PermissionReference perm) {
        this.permissionsDaoComponent.deletePermission(storeRef, authority, perm);
        this.accessCache.clear();
    }

    public void deletePermissions(StoreRef storeRef) {
        this.permissionsDaoComponent.deletePermissions(storeRef);
        this.accessCache.clear();
    }

    public void setPermission(StoreRef storeRef, String authority, String perm, boolean allow) {
        this.setPermission(storeRef, authority, this.getPermissionReference(perm), allow);
    }

    protected void setPermission(StoreRef storeRef, String authority, PermissionReference permission, boolean allow) {
        this.permissionsDaoComponent.setPermission(storeRef, authority, permission, allow);
        this.accessCache.clear();
    }

    public void deletePermissions(NodeRef nodeRef) {
        this.permissionsDaoComponent.deletePermissions(this.tenantService.getName(nodeRef));
        this.accessCache.clear();
    }

    @Override
    public void deletePermissions(NodePermissionEntry nodePermissionEntry) {
        this.permissionsDaoComponent.deletePermissions(this.tenantService.getName(nodePermissionEntry.getNodeRef()));
        this.accessCache.clear();
    }

    @Override
    public void deletePermission(PermissionEntry permissionEntry) {
        NodeRef nodeRef = permissionEntry.getNodeRef();
        String authority = permissionEntry.getAuthority();
        PermissionReference permission = permissionEntry.getPermissionReference();
        this.deletePermission(nodeRef, authority, permission);
    }

    protected void deletePermission(NodeRef nodeRef, String authority, PermissionReference perm) {
        this.permissionsDaoComponent.deletePermission(this.tenantService.getName(nodeRef), authority, perm);
        this.accessCache.clear();
    }

    public void clearPermission(NodeRef nodeRef, String authority) {
        this.permissionsDaoComponent.deletePermissions(this.tenantService.getName(nodeRef), authority);
        this.accessCache.clear();
    }

    protected void setPermission(NodeRef nodeRef, String authority, PermissionReference perm, boolean allow) {
        this.permissionsDaoComponent.setPermission(this.tenantService.getName(nodeRef), authority, perm, allow);
        this.accessCache.clear();
    }

    @Override
    public void setPermission(PermissionEntry permissionEntry) {
        this.permissionsDaoComponent.setPermission(permissionEntry);
        this.accessCache.clear();
    }

    @Override
    public void setPermission(NodePermissionEntry nodePermissionEntry) {
        this.permissionsDaoComponent.setPermission(nodePermissionEntry);
        this.accessCache.clear();
    }

    public void setInheritParentPermissions(NodeRef nodeRef, boolean inheritParentPermissions) {
        NodeRef actualRef = this.tenantService.getName(nodeRef);
        this.permissionsDaoComponent.setInheritParentPermissions(actualRef, inheritParentPermissions);
        this.accessCache.clear();
    }

    public boolean getInheritParentPermissions(NodeRef nodeRef) {
        return this.permissionsDaoComponent.getInheritParentPermissions(this.tenantService.getName(nodeRef));
    }

    @Override
    public PermissionReference getPermissionReference(QName qname, String permissionName) {
        return this.modelDAO.getPermissionReference(qname, permissionName);
    }

    @Override
    public PermissionReference getAllPermissionReference() {
        return this.allPermissionReference;
    }

    @Override
    public String getPermission(PermissionReference permissionReference) {
        if (this.modelDAO.isUnique(permissionReference)) {
            return permissionReference.getName();
        }
        return permissionReference.toString();
    }

    @Override
    public PermissionReference getPermissionReference(String permissionName) {
        return this.modelDAO.getPermissionReference(null, permissionName);
    }

    @Override
    public Set<PermissionReference> getSettablePermissionReferences(QName type) {
        return this.modelDAO.getExposedPermissions(type);
    }

    @Override
    public Set<PermissionReference> getSettablePermissionReferences(NodeRef nodeRef) {
        return this.modelDAO.getExposedPermissions(this.tenantService.getName(nodeRef));
    }

    public void deletePermission(NodeRef nodeRef, String authority, String perm) {
        this.deletePermission(nodeRef, authority, this.getPermissionReference(perm));
    }

    public AccessStatus hasPermission(NodeRef nodeRef, String perm) {
        return this.hasPermission(nodeRef, this.getPermissionReference(perm));
    }

    public void setPermission(NodeRef nodeRef, String authority, String perm, boolean allow) {
        this.setPermission(nodeRef, authority, this.getPermissionReference(perm), allow);
    }

    @Override
    public void deletePermissions(String recipient) {
        this.permissionsDaoComponent.deletePermissions(recipient);
        this.accessCache.clear();
    }

    public AccessStatus hasReadPermission(NodeRef nodeRef) {
        AccessStatus status = AccessStatus.DENIED;
        if (nodeRef == null) {
            return AccessStatus.ALLOWED;
        }
        if (!this.nodeService.exists(nodeRef)) {
            return AccessStatus.ALLOWED;
        }
        String runAsUser = AuthenticationUtil.getRunAsUser();
        if (runAsUser == null) {
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return AccessStatus.ALLOWED;
        }
        Boolean forceHasPermission = (Boolean)AlfrescoTransactionSupport.getResource("forceHasPermission");
        if (forceHasPermission == null) {
            for (DynamicAuthority dynamicAuthority : this.dynamicAuthorities) {
                String authority = dynamicAuthority.getAuthority();
                Set<PermissionReference> requiredFor = dynamicAuthority.requiredFor();
                if (authority == "ROLE_OWNER" || authority == "ROLE_ADMINISTRATOR" || authority == "ROLE_LOCK_OWNER" || requiredFor != null && !requiredFor.contains(this.modelDAO.getPermissionReference(null, "FullControl")) && !requiredFor.contains(this.modelDAO.getPermissionReference(null, "Read"))) continue;
                forceHasPermission = Boolean.TRUE;
                break;
            }
            AlfrescoTransactionSupport.bindResource("forceHasPermission", forceHasPermission);
        }
        if (forceHasPermission == Boolean.TRUE) {
            return this.hasPermission(nodeRef, "Read");
        }
        Long aclID = this.nodeService.getNodeAclId(nodeRef);
        status = aclID == null ? this.hasPermission(nodeRef, this.getPermissionReference(null, "Read")) : (this.canRead(aclID) == AccessStatus.ALLOWED || this.adminRead() == AccessStatus.ALLOWED || this.ownerRead(runAsUser, nodeRef) == AccessStatus.ALLOWED ? AccessStatus.ALLOWED : AccessStatus.DENIED);
        return status;
    }

    protected AccessStatus adminRead() {
        AccessStatus result = AccessStatus.DENIED;
        Set<String> authorisations = this.getAuthorisations();
        if (authorisations.contains(AuthenticationUtil.getAdminRoleName())) {
            result = AccessStatus.ALLOWED;
        }
        return result;
    }

    protected AccessStatus ownerRead(String username, NodeRef nodeRef) {
        AccessStatus result = AccessStatus.DENIED;
        String owner = this.ownableService.getOwner(nodeRef);
        if (owner == null) {
            result = AccessStatus.DENIED;
        }
        if (EqualsHelper.nullSafeEquals((Object)username, (Object)owner)) {
            return AccessStatus.ALLOWED;
        }
        return result;
    }

    public Set<String> getReaders(Long aclId) {
        AccessControlList acl = this.aclDaoComponent.getAccessControlList(aclId);
        if (acl == null) {
            return Collections.emptySet();
        }
        Set<String> aclReaders = (Set<String>)this.readersCache.get((Serializable)((Object)acl.getProperties()));
        if (aclReaders != null) {
            return aclReaders;
        }
        HashSet<String> assigned = new HashSet<String>();
        HashSet<String> readers = new HashSet<String>();
        for (AccessControlEntry ace : acl.getEntries()) {
            assigned.add(ace.getAuthority());
        }
        for (String authority : assigned) {
            UnconditionalAclTest test = new UnconditionalAclTest(this.getPermissionReference("Read"));
            if (!test.evaluate(authority, aclId)) continue;
            readers.add(authority);
        }
        aclReaders = Collections.unmodifiableSet(readers);
        this.readersCache.put((Serializable)((Object)acl.getProperties()), aclReaders);
        return aclReaders;
    }

    private Set<String> getReadersDenied(Long aclId) {
        AccessControlList acl = this.aclDaoComponent.getAccessControlList(aclId);
        if (acl == null) {
            return Collections.emptySet();
        }
        HashSet<String> denied = (HashSet<String>)this.readersDeniedCache.get((Serializable)aclId);
        if (denied != null) {
            return denied;
        }
        denied = new HashSet<String>();
        HashSet<String> assigned = new HashSet<String>();
        for (AccessControlEntry ace : acl.getEntries()) {
            assigned.add(ace.getAuthority());
        }
        for (String authority : assigned) {
            UnconditionalDeniedAclTest test = new UnconditionalDeniedAclTest(this.getPermissionReference("Read"));
            if (!test.evaluate(authority, aclId)) continue;
            denied.add(authority);
        }
        this.readersDeniedCache.put((Serializable)((Object)acl.getProperties()), denied);
        return denied;
    }

    protected AccessStatus canRead(Long aclId) {
        Set<String> authorities = this.getAuthorisations();
        if (this.anyDenyDenies) {
            Set<String> aclReadersDenied = this.getReadersDenied(aclId);
            for (String auth : aclReadersDenied) {
                if (!authorities.contains(auth)) continue;
                return AccessStatus.DENIED;
            }
        }
        Set<String> aclReaders = this.getReaders(aclId);
        for (String auth : aclReaders) {
            if (!authorities.contains(auth)) continue;
            return AccessStatus.ALLOWED;
        }
        return AccessStatus.DENIED;
    }

    protected boolean isVersionNodeRef(NodeRef nodeRef) {
        return nodeRef.getStoreRef().getProtocol().equals("versionStore");
    }

    protected NodeRef convertVersionNodeRefToVersionedNodeRef(NodeRef versionNodeRef) {
        Map properties = this.nodeService.getProperties(versionNodeRef);
        NodeRef nodeRef = null;
        if (versionNodeRef.getStoreRef().getIdentifier().equals("version2Store")) {
            nodeRef = (NodeRef)properties.get(Version2Model.PROP_QNAME_FROZEN_NODE_REF);
        } else if (versionNodeRef.getStoreRef().getIdentifier().equals("lightWeightVersionStore")) {
            nodeRef = new NodeRef((String)properties.get(VersionModel.PROP_QNAME_FROZEN_NODE_STORE_PROTOCOL), (String)properties.get(VersionModel.PROP_QNAME_FROZEN_NODE_STORE_ID), (String)properties.get(VersionModel.PROP_QNAME_FROZEN_NODE_ID));
        }
        return nodeRef;
    }

    public Set<String> getAuthorisations() {
        Set<String> auths = (Set<String>)AlfrescoTransactionSupport.getResource("MyAuthCache");
        Authentication auth = AuthenticationUtil.getRunAsAuthentication();
        if (!(auths == null || auth != null && auths.contains(((User)auth.getPrincipal()).getUsername()))) {
            auths = null;
        }
        if (auths == null) {
            auths = this.getCoreAuthorisations(auth);
            AlfrescoTransactionSupport.bindResource("MyAuthCache", auths);
        }
        return Collections.unmodifiableSet(auths);
    }

    protected static class MutableBoolean {
        private boolean value;

        MutableBoolean(boolean value) {
            this.value = value;
        }

        void setValue(boolean value) {
            this.value = value;
        }

        boolean getValue() {
            return this.value;
        }
    }

    protected class UnconditionalDeniedAclTest {
        PermissionReference required;
        Set<PermissionReference> granters;
        Set<PermissionReference> nodeRequirements = new HashSet<PermissionReference>();

        UnconditionalDeniedAclTest(PermissionReference required) {
            this.required = required;
            this.nodeRequirements = required.equals(PermissionServiceImpl.this.getPermissionReference("All")) ? PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(PermissionServiceImpl.this.getPermissionReference("FullControl"), RequiredPermission.On.NODE) : PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.NODE);
            if (PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.PARENT).size() > 0) {
                throw new IllegalStateException("Parent permissions can not be checked for an acl");
            }
            if (PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.CHILDREN).size() > 0) {
                throw new IllegalStateException("Child permissions can not be checked for an acl");
            }
            this.granters = new LinkedHashSet<PermissionReference>(128, 1.0f);
            this.granters.addAll(PermissionServiceImpl.this.modelDAO.getGrantingPermissions(required));
            this.granters.add(PermissionServiceImpl.this.getAllPermissionReference());
            this.granters.add(OLD_ALL_PERMISSIONS_REFERENCE);
        }

        boolean evaluate(String authority, Long aclId) {
            boolean success = true;
            if (!(success &= this.hasSinglePermission(authority, aclId))) {
                return false;
            }
            for (PermissionReference pr : this.nodeRequirements) {
                UnconditionalDeniedAclTest nt = new UnconditionalDeniedAclTest(pr);
                if (success &= nt.evaluate(authority, aclId)) continue;
                return false;
            }
            return success;
        }

        boolean hasSinglePermission(String authority, Long aclId) {
            if (this.checkGlobalPermissions(authority)) {
                return true;
            }
            if (aclId == null) {
                return false;
            }
            return this.checkRequired(authority, aclId);
        }

        private boolean checkGlobalPermissions(String authority) {
            for (PermissionEntry permissionEntry : PermissionServiceImpl.this.modelDAO.getGlobalPermissionEntries()) {
                if (!this.isDenied(permissionEntry, authority)) continue;
                return true;
            }
            return false;
        }

        boolean checkRequired(String authority, Long aclId) {
            AccessControlList acl = PermissionServiceImpl.this.aclDaoComponent.getAccessControlList(aclId);
            if (acl == null) {
                return false;
            }
            HashSet<Pair<String, PermissionReference>> allowed = new HashSet<Pair<String, PermissionReference>>();
            for (AccessControlEntry ace : acl.getEntries()) {
                if (!this.isDenied(ace, authority, allowed)) continue;
                return true;
            }
            return false;
        }

        private boolean isDenied(AccessControlEntry ace, String authority, Set<Pair<String, PermissionReference>> allowed) {
            Pair specific;
            if (ace.getAccessStatus() == AccessStatus.ALLOWED) {
                allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)ace.getPermission()));
                Set<PermissionReference> granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(ace.getPermission());
                for (PermissionReference granter : granters) {
                    allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)granter));
                }
                Set<PermissionReference> grantees = PermissionServiceImpl.this.modelDAO.getGranteePermissions(ace.getPermission());
                for (PermissionReference grantee : grantees) {
                    allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)grantee));
                }
                if (ace.getPermission().equals(PermissionServiceImpl.this.getAllPermissionReference()) || ace.getPermission().equals(OLD_ALL_PERMISSIONS_REFERENCE)) {
                    for (PermissionReference deny : PermissionServiceImpl.this.modelDAO.getAllPermissions()) {
                        allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)deny));
                    }
                }
                return false;
            }
            if (allowed != null && allowed.contains(specific = new Pair((Object)ace.getAuthority(), (Object)this.required))) {
                return false;
            }
            return authority.equals(ace.getAuthority()) && this.granters.contains(ace.getPermission());
        }

        private boolean isDenied(PermissionEntry pe, String authority) {
            if (pe.isAllowed()) {
                return false;
            }
            return this.granters.contains(pe.getPermissionReference()) && authority.equals(pe.getAuthority());
        }
    }

    protected class UnconditionalAclTest {
        PermissionReference required;
        Set<PermissionReference> granters;
        Set<PermissionReference> nodeRequirements = new HashSet<PermissionReference>();

        UnconditionalAclTest(PermissionReference required) {
            this.required = required;
            this.nodeRequirements = required.equals(PermissionServiceImpl.this.getPermissionReference("All")) ? PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(PermissionServiceImpl.this.getPermissionReference("FullControl"), RequiredPermission.On.NODE) : PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.NODE);
            if (PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.PARENT).size() > 0) {
                throw new IllegalStateException("Parent permissions can not be checked for an acl");
            }
            if (PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.CHILDREN).size() > 0) {
                throw new IllegalStateException("Child permissions can not be checked for an acl");
            }
            this.granters = new LinkedHashSet<PermissionReference>(128, 1.0f);
            this.granters.addAll(PermissionServiceImpl.this.modelDAO.getGrantingPermissions(required));
            this.granters.add(PermissionServiceImpl.this.getAllPermissionReference());
            this.granters.add(OLD_ALL_PERMISSIONS_REFERENCE);
        }

        boolean evaluate(String authority, Long aclId) {
            boolean success = true;
            if (!(success &= this.hasSinglePermission(authority, aclId))) {
                return false;
            }
            for (PermissionReference pr : this.nodeRequirements) {
                UnconditionalAclTest nt = new UnconditionalAclTest(pr);
                if (success &= nt.evaluate(authority, aclId)) continue;
                return false;
            }
            return success;
        }

        boolean hasSinglePermission(String authority, Long aclId) {
            if (this.checkGlobalPermissions(authority)) {
                return true;
            }
            if (aclId == null) {
                return false;
            }
            return this.checkRequired(authority, aclId);
        }

        private boolean checkGlobalPermissions(String authority) {
            for (PermissionEntry permissionEntry : PermissionServiceImpl.this.modelDAO.getGlobalPermissionEntries()) {
                if (!this.isGranted(permissionEntry, authority)) continue;
                return true;
            }
            return false;
        }

        boolean checkRequired(String authority, Long aclId) {
            AccessControlList acl = PermissionServiceImpl.this.aclDaoComponent.getAccessControlList(aclId);
            if (acl == null) {
                return false;
            }
            HashSet<Pair<String, PermissionReference>> denied = new HashSet<Pair<String, PermissionReference>>();
            for (AccessControlEntry ace : acl.getEntries()) {
                if (!this.isGranted(ace, authority, denied)) continue;
                return true;
            }
            return false;
        }

        private boolean isGranted(AccessControlEntry ace, String authority, Set<Pair<String, PermissionReference>> denied) {
            Pair specific;
            if (ace.getAccessStatus() == AccessStatus.DENIED) {
                denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)ace.getPermission()));
                Set<PermissionReference> granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(ace.getPermission());
                for (PermissionReference granter : granters) {
                    denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)granter));
                }
                Set<PermissionReference> grantees = PermissionServiceImpl.this.modelDAO.getGranteePermissions(ace.getPermission());
                for (PermissionReference grantee : grantees) {
                    denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)grantee));
                }
                if (ace.getPermission().equals(PermissionServiceImpl.this.getAllPermissionReference()) || ace.getPermission().equals(OLD_ALL_PERMISSIONS_REFERENCE)) {
                    for (PermissionReference deny : PermissionServiceImpl.this.modelDAO.getAllPermissions()) {
                        denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)deny));
                    }
                }
                return false;
            }
            if (denied != null && denied.contains(specific = new Pair((Object)ace.getAuthority(), (Object)this.required))) {
                return false;
            }
            return authority.equals(ace.getAuthority()) && this.granters.contains(ace.getPermission());
        }

        private boolean isGranted(PermissionEntry pe, String authority) {
            if (pe.isDenied()) {
                return false;
            }
            return this.granters.contains(pe.getPermissionReference()) && authority.equals(pe.getAuthority());
        }
    }

    protected class AclTest {
        PermissionReference required;
        Set<PermissionReference> granters;
        Set<PermissionReference> nodeRequirements = new HashSet<PermissionReference>();
        QName typeQName;
        Set<QName> aspectQNames;

        AclTest(PermissionReference required, QName typeQName, Set<QName> aspectQNames) {
            this.required = required;
            this.typeQName = typeQName;
            this.aspectQNames = aspectQNames;
            this.nodeRequirements = required.equals(PermissionServiceImpl.this.getPermissionReference("All")) ? PermissionServiceImpl.this.modelDAO.getRequiredPermissions(PermissionServiceImpl.this.getPermissionReference("FullControl"), typeQName, aspectQNames, RequiredPermission.On.NODE) : PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.NODE);
            if (PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.PARENT).size() > 0) {
                throw new IllegalStateException("Parent permissions can not be checked for an acl");
            }
            if (PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.CHILDREN).size() > 0) {
                throw new IllegalStateException("Child permissions can not be checked for an acl");
            }
            this.granters = new LinkedHashSet<PermissionReference>(128, 1.0f);
            this.granters.addAll(PermissionServiceImpl.this.modelDAO.getGrantingPermissions(required));
            this.granters.add(PermissionServiceImpl.this.getAllPermissionReference());
            this.granters.add(OLD_ALL_PERMISSIONS_REFERENCE);
        }

        boolean evaluate(Set<String> authorisations, Long aclId, PermissionContext context) {
            boolean success = true;
            if (PermissionServiceImpl.this.modelDAO.checkPermission(this.required) && !(success &= this.hasSinglePermission(authorisations, aclId, context))) {
                return false;
            }
            for (PermissionReference pr : this.nodeRequirements) {
                AclTest nt = new AclTest(pr, this.typeQName, this.aspectQNames);
                if (success &= nt.evaluate(authorisations, aclId, context)) continue;
                return false;
            }
            return success;
        }

        boolean hasSinglePermission(Set<String> authorisations, Long aclId, PermissionContext context) {
            if (this.checkGlobalPermissions(authorisations)) {
                return true;
            }
            return this.checkRequired(authorisations, aclId, context);
        }

        private boolean checkGlobalPermissions(Set<String> authorisations) {
            for (PermissionEntry permissionEntry : PermissionServiceImpl.this.modelDAO.getGlobalPermissionEntries()) {
                if (!this.isGranted(permissionEntry, authorisations)) continue;
                return true;
            }
            return false;
        }

        boolean checkRequired(Set<String> authorisations, Long aclId, PermissionContext context) {
            AccessControlList acl = PermissionServiceImpl.this.aclDaoComponent.getAccessControlList(aclId);
            if (acl == null) {
                return false;
            }
            if (PermissionServiceImpl.this.anyDenyDenies) {
                HashSet<Pair<String, PermissionReference>> allowed = new HashSet<Pair<String, PermissionReference>>();
                for (AccessControlEntry ace : acl.getEntries()) {
                    if (!this.isDenied(ace, authorisations, allowed, context)) continue;
                    return false;
                }
            }
            HashSet<Pair<String, PermissionReference>> denied = new HashSet<Pair<String, PermissionReference>>();
            for (AccessControlEntry ace : acl.getEntries()) {
                if (!this.isGranted(ace, authorisations, denied, context)) continue;
                return true;
            }
            return false;
        }

        private boolean isGranted(AccessControlEntry ace, Set<String> authorisations, Set<Pair<String, PermissionReference>> denied, PermissionContext context) {
            Pair specific;
            if (ace.getAccessStatus() == AccessStatus.DENIED) {
                denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)ace.getPermission()));
                Set<PermissionReference> granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(ace.getPermission());
                for (PermissionReference granter : granters) {
                    denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)granter));
                }
                Set<PermissionReference> grantees = PermissionServiceImpl.this.modelDAO.getGranteePermissions(ace.getPermission());
                for (PermissionReference grantee : grantees) {
                    denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)grantee));
                }
                if (ace.getPermission().equals(PermissionServiceImpl.this.getAllPermissionReference()) || ace.getPermission().equals(OLD_ALL_PERMISSIONS_REFERENCE)) {
                    for (PermissionReference deny : PermissionServiceImpl.this.modelDAO.getAllPermissions(context.getType(), context.getAspects())) {
                        denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)deny));
                    }
                }
                return false;
            }
            if (denied != null && denied.contains(specific = new Pair((Object)ace.getAuthority(), (Object)this.required))) {
                return false;
            }
            return authorisations.contains(ace.getAuthority()) && this.granters.contains(ace.getPermission());
        }

        private boolean isDenied(AccessControlEntry ace, Set<String> authorisations, Set<Pair<String, PermissionReference>> allowed, PermissionContext context) {
            Pair specific;
            if (ace.getAccessStatus() == AccessStatus.ALLOWED) {
                allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)ace.getPermission()));
                Set<PermissionReference> granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(ace.getPermission());
                for (PermissionReference granter : granters) {
                    allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)granter));
                }
                Set<PermissionReference> grantees = PermissionServiceImpl.this.modelDAO.getGranteePermissions(ace.getPermission());
                for (PermissionReference grantee : grantees) {
                    allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)grantee));
                }
                if (ace.getPermission().equals(PermissionServiceImpl.this.getAllPermissionReference()) || ace.getPermission().equals(OLD_ALL_PERMISSIONS_REFERENCE)) {
                    for (PermissionReference deny : PermissionServiceImpl.this.modelDAO.getAllPermissions(context.getType(), context.getAspects())) {
                        allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)deny));
                    }
                }
                return false;
            }
            if (allowed != null && allowed.contains(specific = new Pair((Object)ace.getAuthority(), (Object)this.required))) {
                return false;
            }
            return authorisations.contains(ace.getAuthority()) && this.granters.contains(ace.getPermission());
        }

        private boolean isGranted(PermissionEntry pe, Set<String> authorisations) {
            if (pe.isDenied()) {
                return false;
            }
            return this.granters.contains(pe.getPermissionReference()) && authorisations.contains(pe.getAuthority());
        }
    }

    protected class NodeTest {
        PermissionReference required;
        Set<PermissionReference> granters;
        Set<PermissionReference> nodeRequirements = new HashSet<PermissionReference>();
        Set<PermissionReference> parentRequirements = new HashSet<PermissionReference>();
        Set<PermissionReference> childrenRequirements = new HashSet<PermissionReference>();
        QName typeQName;
        Set<QName> aspectQNames;

        NodeTest(PermissionReference required, QName typeQName, Set<QName> aspectQNames) {
            this.required = required;
            this.typeQName = typeQName;
            this.aspectQNames = aspectQNames;
            this.nodeRequirements = required.equals(PermissionServiceImpl.this.getPermissionReference("All")) ? PermissionServiceImpl.this.modelDAO.getRequiredPermissions(PermissionServiceImpl.this.getPermissionReference("FullControl"), typeQName, aspectQNames, RequiredPermission.On.NODE) : PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.NODE);
            this.parentRequirements = PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.PARENT);
            this.childrenRequirements = PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.CHILDREN);
            this.granters = new LinkedHashSet<PermissionReference>(128, 1.0f);
            this.granters.addAll(PermissionServiceImpl.this.modelDAO.getGrantingPermissions(required));
            this.granters.add(PermissionServiceImpl.this.getAllPermissionReference());
            this.granters.add(OLD_ALL_PERMISSIONS_REFERENCE);
        }

        boolean evaluate(Set<String> authorisations, NodeRef nodeRef) {
            HashSet<Pair<String, PermissionReference>> denied = new HashSet<Pair<String, PermissionReference>>();
            return this.evaluate(authorisations, nodeRef, denied, null);
        }

        boolean evaluate(Set<String> authorisations, NodeRef nodeRef, Set<Pair<String, PermissionReference>> denied, MutableBoolean recursiveIn) {
            NodePermissionEntry nodePermissions;
            ChildAssociationRef car;
            MutableBoolean recursiveOut = null;
            HashSet<Pair<String, PermissionReference>> locallyDenied = new HashSet<Pair<String, PermissionReference>>();
            locallyDenied.addAll(denied);
            locallyDenied.addAll(this.getDenied(nodeRef));
            boolean success = true;
            if (PermissionServiceImpl.this.modelDAO.checkPermission(this.required)) {
                if (this.parentRequirements.contains(this.required)) {
                    if (this.checkGlobalPermissions(authorisations) || this.checkRequired(authorisations, nodeRef, locallyDenied)) {
                        if (recursiveIn != null) {
                            recursiveIn.setValue(true);
                        }
                    } else {
                        recursiveOut = new MutableBoolean(false);
                    }
                } else {
                    success &= this.hasSinglePermission(authorisations, nodeRef);
                }
                if (!success) {
                    return false;
                }
            }
            for (PermissionReference pr : this.nodeRequirements) {
                NodeTest nt = new NodeTest(pr, this.typeQName, this.aspectQNames);
                if (success &= nt.evaluate(authorisations, nodeRef, locallyDenied, null)) continue;
                return false;
            }
            if (success && (car = PermissionServiceImpl.this.nodeService.getPrimaryParent(nodeRef)).getParentRef() != null && ((nodePermissions = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(car.getChildRef())) == null || nodePermissions.inheritPermissions())) {
                locallyDenied.addAll(this.getDenied(car.getParentRef()));
                for (PermissionReference pr : this.parentRequirements) {
                    if (pr.equals(this.required)) {
                        success &= this.evaluate(authorisations, car.getParentRef(), locallyDenied, recursiveOut);
                        if (recursiveOut != null && recursiveOut.getValue() && recursiveIn != null) {
                            recursiveIn.setValue(true);
                        }
                    } else {
                        NodeTest nt = new NodeTest(pr, this.typeQName, this.aspectQNames);
                        success &= nt.evaluate(authorisations, car.getParentRef(), locallyDenied, null);
                    }
                    if (success) continue;
                    return false;
                }
            }
            if (recursiveOut != null && !recursiveOut.getValue()) {
                return false;
            }
            if (this.childrenRequirements.size() > 0) {
                List childAssocRefs = PermissionServiceImpl.this.nodeService.getChildAssocs(nodeRef);
                for (PermissionReference pr : this.childrenRequirements) {
                    for (ChildAssociationRef child : childAssocRefs) {
                        if (success &= PermissionServiceImpl.this.hasPermission(child.getChildRef(), pr) == AccessStatus.ALLOWED) continue;
                        return false;
                    }
                }
            }
            return success;
        }

        boolean hasSinglePermission(Set<String> authorisations, NodeRef nodeRef) {
            Serializable key = PermissionServiceImpl.this.generateKey(authorisations, nodeRef = PermissionServiceImpl.this.tenantService.getName(nodeRef), this.required, CacheType.SINGLE_PERMISSION_GLOBAL);
            AccessStatus status = (AccessStatus)PermissionServiceImpl.this.accessCache.get(key);
            if (status != null) {
                return status == AccessStatus.ALLOWED;
            }
            if (this.checkGlobalPermissions(authorisations)) {
                PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.ALLOWED);
                return true;
            }
            HashSet<Pair<String, PermissionReference>> denied = new HashSet<Pair<String, PermissionReference>>();
            return this.hasSinglePermission(authorisations, nodeRef, denied);
        }

        boolean hasSinglePermission(Set<String> authorisations, NodeRef nodeRef, Set<Pair<String, PermissionReference>> denied) {
            AccessStatus status;
            nodeRef = PermissionServiceImpl.this.tenantService.getName(nodeRef);
            denied.addAll(this.getDenied(nodeRef));
            Serializable key = null;
            if (denied.size() == 0) {
                key = PermissionServiceImpl.this.generateKey(authorisations, nodeRef, this.required, CacheType.SINGLE_PERMISSION);
            }
            if (key != null && (status = (AccessStatus)PermissionServiceImpl.this.accessCache.get(key)) != null) {
                return status == AccessStatus.ALLOWED;
            }
            if (this.checkRequired(authorisations, nodeRef, denied)) {
                if (key != null) {
                    PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.ALLOWED);
                }
                return true;
            }
            ChildAssociationRef car = PermissionServiceImpl.this.nodeService.getPrimaryParent(nodeRef);
            if (car.getParentRef() != null) {
                NodePermissionEntry nodePermissions = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(nodeRef);
                if (nodePermissions == null || nodePermissions.inheritPermissions()) {
                    if (this.hasSinglePermission(authorisations, car.getParentRef(), denied)) {
                        if (key != null) {
                            PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.ALLOWED);
                        }
                        return true;
                    }
                    if (key != null) {
                        PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.DENIED);
                    }
                    return false;
                }
                if (key != null) {
                    PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.DENIED);
                }
                return false;
            }
            if (key != null) {
                PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.DENIED);
            }
            return false;
        }

        private boolean checkGlobalPermissions(Set<String> authorisations) {
            for (PermissionEntry permissionEntry : PermissionServiceImpl.this.modelDAO.getGlobalPermissionEntries()) {
                if (!this.isGranted(permissionEntry, authorisations, null)) continue;
                return true;
            }
            return false;
        }

        Set<Pair<String, PermissionReference>> getDenied(NodeRef nodeRef) {
            HashSet<Pair<String, PermissionReference>> deniedSet = new HashSet<Pair<String, PermissionReference>>();
            NodePermissionEntry nodeEntry = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(nodeRef);
            if (nodeEntry != null) {
                for (PermissionEntry permissionEntry : nodeEntry.getPermissionEntries()) {
                    if (!permissionEntry.isDenied()) continue;
                    Set<PermissionReference> granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(permissionEntry.getPermissionReference());
                    for (PermissionReference granter : granters) {
                        deniedSet.add((Pair<String, PermissionReference>)new Pair((Object)permissionEntry.getAuthority(), (Object)granter));
                    }
                    Set<PermissionReference> grantees = PermissionServiceImpl.this.modelDAO.getGranteePermissions(permissionEntry.getPermissionReference());
                    for (PermissionReference grantee : grantees) {
                        deniedSet.add((Pair<String, PermissionReference>)new Pair((Object)permissionEntry.getAuthority(), (Object)grantee));
                    }
                    if (!permissionEntry.getPermissionReference().equals(PermissionServiceImpl.this.getAllPermissionReference()) && !permissionEntry.getPermissionReference().equals(OLD_ALL_PERMISSIONS_REFERENCE)) continue;
                    for (PermissionReference deny : PermissionServiceImpl.this.modelDAO.getAllPermissions(nodeRef)) {
                        deniedSet.add((Pair<String, PermissionReference>)new Pair((Object)permissionEntry.getAuthority(), (Object)deny));
                    }
                }
            }
            return deniedSet;
        }

        boolean checkRequired(Set<String> authorisations, NodeRef nodeRef, Set<Pair<String, PermissionReference>> denied) {
            NodePermissionEntry nodeEntry = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(nodeRef);
            if (nodeEntry == null) {
                return false;
            }
            for (PermissionEntry permissionEntry : nodeEntry.getPermissionEntries()) {
                if (!this.isGranted(permissionEntry, authorisations, denied)) continue;
                return true;
            }
            return false;
        }

        private boolean isGranted(PermissionEntry pe, Set<String> authorisations, Set<Pair<String, PermissionReference>> denied) {
            Pair specific;
            if (pe.isDenied()) {
                return false;
            }
            if (denied != null && denied.contains(specific = new Pair((Object)pe.getAuthority(), (Object)this.required))) {
                return false;
            }
            if (PermissionServiceImpl.this.anyDenyDenies && denied != null) {
                for (String auth : authorisations) {
                    Pair specific2 = new Pair((Object)auth, (Object)this.required);
                    if (denied.contains(specific2)) {
                        return false;
                    }
                    for (PermissionReference perm : this.granters) {
                        specific2 = new Pair((Object)auth, (Object)perm);
                        if (!denied.contains(specific2)) continue;
                        return false;
                    }
                }
            }
            return authorisations.contains(pe.getAuthority()) && this.granters.contains(pe.getPermissionReference());
        }
    }

    static enum CacheType {
        HAS_PERMISSION,
        SINGLE_PERMISSION,
        SINGLE_PERMISSION_GLOBAL;

    }
}

