/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.AccessControlEntry;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionTest;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl;
import org.alfresco.repo.security.permissions.impl.SimpleNodePermissionEntry;
import org.alfresco.repo.security.permissions.impl.SimplePermissionEntry;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class PermissionServiceTest
extends AbstractPermissionTest {
    private SimplePermissionEntry denyAndyAll;
    private SimplePermissionEntry allowAndyAll;
    private SimplePermissionEntry denyAndyRead;
    private SimplePermissionEntry allowAndyRead;
    private SimplePermissionEntry denyAndyReadProperties;
    private SimplePermissionEntry allowAndyReadProperties;
    private SimplePermissionEntry allowAndyReadChildren;

    public void testPublicAccessService() {
        this.runAs("admin");
        PermissionServiceTest.assertTrue((this.publicServiceAccessService.hasAccess("PermissionService", "getAllSetPermissions", this.rootNodeRef) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.publicServiceAccessService.hasAccess("SiteService", "createSite", "", "", "", "", true) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnyDenyDeniesAndRead() {
        this.personService.getPerson("andy");
        this.runAs("admin");
        this.authorityService.createAuthority(AuthorityType.GROUP, "ONE");
        this.authorityService.addAuthority("GROUP_ONE", "andy");
        this.authorityService.createAuthority(AuthorityType.GROUP, "TWO");
        this.authorityService.addAuthority("GROUP_TWO", "andy");
        this.authorityService.createAuthority(AuthorityType.GROUP, "THREE");
        this.authorityService.addAuthority("GROUP_THREE", "andy");
        this.authorityService.createAuthority(AuthorityType.GROUP, "GEN");
        this.authorityService.addAuthority("GROUP_GEN", "andy");
        NodeRef one = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(one, "andy", "Read", true);
        this.permissionService.setPermission(one, "GROUP_ONE", "Read", true);
        NodeRef two = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(two, "andy", "Read", true);
        this.permissionService.setPermission(two, "GROUP_TWO", "Read", true);
        NodeRef three = this.nodeService.createNode(one, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}three"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(three, "andy", "Read", true);
        this.permissionService.setPermission(three, "GROUP_THREE", "Read", true);
        NodeRef four = this.nodeService.createNode(three, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}four"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionServiceImpl.setAnyDenyDenies(false);
        try {
            this.runAs("andy");
            PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.runAs("admin");
            this.permissionService.setPermission(one, "GROUP_ONE", "Read", false);
            this.runAs("andy");
            PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        }
        finally {
            this.permissionServiceImpl.setAnyDenyDenies(true);
        }
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.deletePermission(one, "GROUP_ONE", "Read");
        this.permissionService.setPermission(one, "GROUP_ONE", "Read", true);
        this.runAs("admin");
        this.permissionService.setPermission(one, "andy", "Read", false);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.deletePermission(one, "andy", "Read");
        this.permissionService.setPermission(one, "andy", "Read", true);
        this.runAs("admin");
        this.permissionService.setPermission(one, "andy", "All", false);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.deletePermission(one, "andy", "All");
        this.runAs("admin");
        this.permissionService.setPermission(one, "GROUP_GEN", "All", false);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setInheritParentPermissions(three, false);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setInheritParentPermissions(three, true);
        this.permissionService.deletePermission(one, "GROUP_GEN", "All");
        this.runAs("admin");
        this.permissionService.setPermission(three, "andy", "Read", false);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.deletePermission(three, "andy", "Read");
        this.permissionService.setPermission(three, "andy", "Read", true);
        this.permissionService.setPermission(one, "GROUP_ONE", "Read", false);
        this.permissionService.setPermission(two, "GROUP_TWO", "Read", false);
        this.permissionService.setPermission(three, "GROUP_THREE", "Read", false);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs("admin");
        this.authorityService.removeAuthority("GROUP_ONE", "andy");
        AlfrescoTransactionSupport.bindResource("MyAuthCache", null);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs("admin");
        this.authorityService.removeAuthority("GROUP_TWO", "andy");
        AlfrescoTransactionSupport.bindResource("MyAuthCache", null);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs("admin");
        this.authorityService.removeAuthority("GROUP_THREE", "andy");
        AlfrescoTransactionSupport.bindResource("MyAuthCache", null);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setPermission(one, "GROUP_EVERYONE", "Read", false);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setPermission(this.rootNodeRef, "GROUP_EVERYONE", "Read", false);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(two, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(three, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(four, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(one) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(two) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(three) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasReadPermission(four) == AccessStatus.DENIED ? 1 : 0) != 0);
    }

    public void testCurrentUserAuthority() {
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        Set authorisations = this.permissionService.getAuthorisations();
        PermissionServiceTest.assertTrue((String)"", (boolean)authorisations.contains("andy"));
    }

    public void testMove() {
        this.runAs("admin");
        NodeRef one = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(one, "andy", "Read", true);
        NodeRef two = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(two, "andy", "Write", true);
        NodeRef three = this.nodeService.createNode(one, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef test = this.nodeService.createNode(one, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, two, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)two, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, three, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)three, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, two, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)two, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, one, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)one, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setPermission(test, "andy", "ChangePermissions", true);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, two, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)two, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, three, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)three, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, two, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)two, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, one, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)one, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setInheritParentPermissions(test, true);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setInheritParentPermissions(test, false);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setInheritParentPermissions(test, true);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, two, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)two, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setInheritParentPermissions(test, true);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setInheritParentPermissions(test, false);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setInheritParentPermissions(test, true);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, three, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)three, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setInheritParentPermissions(test, true);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.permissionService.setInheritParentPermissions(test, false);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, two, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)two, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.nodeService.moveNode(test, three, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        PermissionServiceTest.assertEquals((Object)three, (Object)this.nodeService.getPrimaryParent(test).getParentRef());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Read") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(test, "ChangePermissions") == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testChangePersonUid() {
        this.runAs("admin");
        NodeRef one = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(one, "andy", "All", true);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "ExecuteContent") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        boolean found = false;
        Set set = this.permissionService.getAllSetPermissions(one);
        for (AccessPermission ap : set) {
            if (!ap.getAuthority().equals("Andy")) continue;
            found = true;
        }
        PermissionServiceTest.assertFalse((boolean)found);
        NodeRef andy = this.personService.getPerson("andy");
        this.nodeService.setProperty(andy, ContentModel.PROP_USERNAME, (Serializable)((Object)"Andy"));
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"Andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "ExecuteContent") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        found = false;
        set = this.permissionService.getAllSetPermissions(one);
        for (AccessPermission ap : set) {
            if (!ap.getAuthority().equals("Andy")) continue;
            found = true;
        }
        PermissionServiceTest.assertTrue((boolean)found);
        try {
            this.nodeService.setProperty(andy, ContentModel.PROP_USERNAME, (Serializable)((Object)"Bob"));
            PermissionServiceTest.fail((String)"Chainging uid Andy -> Bob should fail");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    public void testChangeGroupUid() {
        this.runAs("admin");
        this.personService.getPerson("andy");
        NodeRef one = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.authorityService.createAuthority(AuthorityType.GROUP, "ONE");
        this.authorityService.addAuthority("GROUP_ONE", "andy");
        this.permissionService.setPermission(one, "GROUP_ONE", "All", true);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((String)"andy", (String)this.authenticationComponent.getCurrentUserName());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "ExecuteContent") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        boolean found = false;
        Set set = this.permissionService.getAllSetPermissions(one);
        for (AccessPermission ap : set) {
            if (!ap.getAuthority().equals("GROUP_One")) continue;
            found = true;
        }
        PermissionServiceTest.assertFalse((boolean)found);
        NodeRef gONE = this.authorityDAO.getAuthorityNodeRefOrNull("GROUP_ONE");
        this.nodeService.setProperty(gONE, ContentModel.PROP_AUTHORITY_NAME, (Serializable)((Object)"GROUP_One"));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(one, "ExecuteContent") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        found = false;
        set = this.permissionService.getAllSetPermissions(one);
        for (AccessPermission ap : set) {
            if (!ap.getAuthority().equals("GROUP_One")) continue;
            found = true;
        }
        PermissionServiceTest.assertTrue((boolean)found);
        try {
            this.nodeService.setProperty(gONE, ContentModel.PROP_AUTHORITY_NAME, (Serializable)((Object)"GROUP_TWO"));
            PermissionServiceTest.fail((String)"Chainging gid GROUP_One -> GROUP_TWO should fail");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    public void testAuthenticatedRoleIsPresent() {
        this.runAs("andy");
        Authentication auth = this.authenticationComponent.getCurrentAuthentication();
        for (GrantedAuthority authority : auth.getAuthorities()) {
            if (!authority.getAuthority().equals("ROLE_AUTHENTICATED")) continue;
            return;
        }
        PermissionServiceTest.fail((String)"Missing role ROLE_AUTHENTICATED ");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.denyAndyAll = new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), "andy", AccessStatus.DENIED);
        this.allowAndyAll = new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), "andy", AccessStatus.ALLOWED);
        this.denyAndyRead = new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.DENIED);
        this.allowAndyRead = new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED);
        this.denyAndyReadProperties = new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.DENIED);
        this.allowAndyReadProperties = new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED);
        this.allowAndyReadChildren = new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED);
    }

    public void testDelete() {
        if (this.aclDaoComponent.getDefaultProperties().getAclType() == ACLType.DEFINING) {
            this.runAs(AuthenticationUtil.getAdminUserName());
            NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
            NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
            PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.deletePermissions(n1);
            this.permissionService.deletePermissions(n2);
            this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.deletePermissions(n2);
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("Write"), "andy", AccessStatus.ALLOWED));
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.deletePermissions(n2);
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("Write"), "andy", AccessStatus.ALLOWED));
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.deletePermissions(n1);
            PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n2).size());
        } else {
            this.runAs(AuthenticationUtil.getAdminUserName());
            NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
            NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
            PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.deletePermissions(n1);
            this.permissionService.deletePermissions(n2);
            this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.deletePermissions(n2);
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("Write"), "andy", AccessStatus.ALLOWED));
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.deletePermissions(n2);
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("Write"), "andy", AccessStatus.ALLOWED));
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n2).size());
            this.permissionService.deletePermissions(n1);
            PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(n1).size());
            PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(n2).size());
        }
    }

    public void testPositionInformation() {
        if (this.aclDaoComponent.getDefaultProperties().getAclType() == ACLType.DEFINING) {
            this.runAs(AuthenticationUtil.getAdminUserName());
            NodeRef one = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
            NodeRef two = this.nodeService.createNode(one, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
            NodeRef three = this.nodeService.createNode(two, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}three"), ContentModel.TYPE_FOLDER).getChildRef();
            NodeRef four = this.nodeService.createNode(three, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}three"), ContentModel.TYPE_FOLDER).getChildRef();
            this.permissionService.setPermission(one, "andy", "All", true);
            this.permissionService.setPermission(two, "bob", "All", true);
            this.permissionService.setPermission(three, "carol", "All", true);
            Set set = this.permissionService.getAllSetPermissions(one);
            PermissionServiceTest.assertEquals((int)1, (int)set.size());
            for (AccessPermission ap : set) {
                if (!ap.getAuthority().equals("andy")) continue;
                PermissionServiceTest.assertFalse((boolean)ap.isInherited());
                PermissionServiceTest.assertEquals((int)0, (int)ap.getPosition());
            }
            set = this.permissionService.getAllSetPermissions(two);
            PermissionServiceTest.assertEquals((int)2, (int)set.size());
            for (AccessPermission ap : set) {
                if (ap.getAuthority().equals("andy")) {
                    PermissionServiceTest.assertTrue((boolean)ap.isInherited());
                    PermissionServiceTest.assertEquals((int)2, (int)ap.getPosition());
                }
                if (!ap.getAuthority().equals("bob")) continue;
                PermissionServiceTest.assertFalse((boolean)ap.isInherited());
                PermissionServiceTest.assertEquals((int)0, (int)ap.getPosition());
            }
            set = this.permissionService.getAllSetPermissions(three);
            PermissionServiceTest.assertEquals((int)3, (int)set.size());
            for (AccessPermission ap : set) {
                if (ap.getAuthority().equals("andy")) {
                    PermissionServiceTest.assertTrue((boolean)ap.isInherited());
                    PermissionServiceTest.assertEquals((int)4, (int)ap.getPosition());
                }
                if (ap.getAuthority().equals("bob")) {
                    PermissionServiceTest.assertTrue((boolean)ap.isInherited());
                    PermissionServiceTest.assertEquals((int)2, (int)ap.getPosition());
                }
                if (!ap.getAuthority().equals("carol")) continue;
                PermissionServiceTest.assertFalse((boolean)ap.isInherited());
                PermissionServiceTest.assertEquals((int)0, (int)ap.getPosition());
            }
            set = this.permissionService.getAllSetPermissions(four);
            PermissionServiceTest.assertEquals((int)3, (int)set.size());
            for (AccessPermission ap : set) {
                if (ap.getAuthority().equals("andy")) {
                    PermissionServiceTest.assertTrue((boolean)ap.isInherited());
                    PermissionServiceTest.assertEquals((int)5, (int)ap.getPosition());
                }
                if (ap.getAuthority().equals("bob")) {
                    PermissionServiceTest.assertTrue((boolean)ap.isInherited());
                    PermissionServiceTest.assertEquals((int)3, (int)ap.getPosition());
                }
                if (!ap.getAuthority().equals("carol")) continue;
                PermissionServiceTest.assertTrue((boolean)ap.isInherited());
                PermissionServiceTest.assertEquals((int)1, (int)ap.getPosition());
            }
        } else {
            this.runAs(AuthenticationUtil.getAdminUserName());
            NodeRef one = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
            NodeRef two = this.nodeService.createNode(one, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
            NodeRef three = this.nodeService.createNode(two, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}three"), ContentModel.TYPE_FOLDER).getChildRef();
            NodeRef four = this.nodeService.createNode(three, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}three"), ContentModel.TYPE_FOLDER).getChildRef();
            this.permissionService.setPermission(one, "andy", "All", true);
            this.permissionService.setPermission(two, "bob", "All", true);
            this.permissionService.setPermission(three, "carol", "All", true);
            Set set = this.permissionService.getAllSetPermissions(one);
            PermissionServiceTest.assertEquals((int)1, (int)set.size());
            for (AccessPermission ap : set) {
                if (!ap.getAuthority().equals("andy")) continue;
                PermissionServiceTest.assertFalse((boolean)ap.isInherited());
                PermissionServiceTest.assertEquals((int)0, (int)ap.getPosition());
            }
            set = this.permissionService.getAllSetPermissions(two);
            PermissionServiceTest.assertEquals((int)1, (int)set.size());
            for (AccessPermission ap : set) {
                if (!ap.getAuthority().equals("bob")) continue;
                PermissionServiceTest.assertFalse((boolean)ap.isInherited());
                PermissionServiceTest.assertEquals((int)0, (int)ap.getPosition());
            }
            set = this.permissionService.getAllSetPermissions(three);
            PermissionServiceTest.assertEquals((int)1, (int)set.size());
            for (AccessPermission ap : set) {
                if (!ap.getAuthority().equals("carol")) continue;
                PermissionServiceTest.assertFalse((boolean)ap.isInherited());
                PermissionServiceTest.assertEquals((int)0, (int)ap.getPosition());
            }
            set = this.permissionService.getAllSetPermissions(four);
            PermissionServiceTest.assertEquals((int)0, (int)set.size());
        }
    }

    public void test_AR_2055() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        ArrayList<String> pathElements = new ArrayList<String>();
        pathElements.add("monkey");
        try {
            FileFolderServiceImpl.makeFolders(this.serviceRegistry.getFileFolderService(), folder, pathElements, ContentModel.TYPE_FOLDER);
            PermissionServiceTest.fail();
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        this.runAs(AuthenticationUtil.getAdminUserName());
        this.permissionService.setPermission(folder, "andy", "All", true);
        FileFolderServiceImpl.makeFolders(this.serviceRegistry.getFileFolderService(), folder, pathElements, ContentModel.TYPE_FOLDER);
    }

    public void testRunAsRealAndEffectiveUsersWithPriorAuthentication() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        final NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Contributor")) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        PermissionServiceTest.assertEquals((String)"andy", (String)AuthenticationUtil.getRunAsUser());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
                Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.DENIED ? 1 : 0) != 0);
                        Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                        Assert.assertEquals((String)"lemur", (String)AuthenticationUtil.getRunAsUser());
                        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                            public Object doWork() throws Exception {
                                Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
                                Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                                    public Object doWork() throws Exception {
                                        Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.DENIED ? 1 : 0) != 0);
                                        Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                                        Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getRunAsUser());
                                        return null;
                                    }
                                }, (String)"andy");
                                Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                                return null;
                            }
                        }, (String)AuthenticationUtil.getAdminUserName());
                        Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                        Assert.assertEquals((String)"lemur", (String)AuthenticationUtil.getRunAsUser());
                        return null;
                    }
                }, (String)"lemur");
                Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        PermissionServiceTest.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        PermissionServiceTest.assertEquals((String)"andy", (String)AuthenticationUtil.getRunAsUser());
    }

    public void testNestedRunAsRealAndEffectiveUsersWithPriorAuthentication() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        final NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Contributor")) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        PermissionServiceTest.assertEquals((String)"andy", (String)AuthenticationUtil.getRunAsUser());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
                Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.DENIED ? 1 : 0) != 0);
                        Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                        Assert.assertEquals((String)"lemur", (String)AuthenticationUtil.getRunAsUser());
                        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                            public Object doWork() throws Exception {
                                Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
                                Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                                    public Object doWork() throws Exception {
                                        Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.DENIED ? 1 : 0) != 0);
                                        Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                                        Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getRunAsUser());
                                        return null;
                                    }
                                }, (String)"andy");
                                Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                                return null;
                            }
                        }, (String)AuthenticationUtil.getAdminUserName());
                        Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                        Assert.assertEquals((String)"lemur", (String)AuthenticationUtil.getRunAsUser());
                        return null;
                    }
                }, (String)"lemur");
                Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        PermissionServiceTest.assertEquals((String)"andy", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        PermissionServiceTest.assertEquals((String)"andy", (String)AuthenticationUtil.getRunAsUser());
    }

    public void testRunAsRealAndEffectiveUsersWithNoPriorAuthentication() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        final NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        AuthenticationUtil.clearCurrentSecurityContext();
        PermissionServiceTest.assertNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        PermissionServiceTest.assertNull((Object)AuthenticationUtil.getRunAsUser());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getFullyAuthenticatedUser());
                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        PermissionServiceTest.assertNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        PermissionServiceTest.assertNull((Object)AuthenticationUtil.getRunAsUser());
    }

    public void testNestedRunAsRealAndEffectiveUsersWithNoPriorAuthentication() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        final NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        AuthenticationUtil.clearCurrentSecurityContext();
        PermissionServiceTest.assertNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        PermissionServiceTest.assertNull((Object)AuthenticationUtil.getRunAsUser());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getFullyAuthenticatedUser());
                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.DENIED ? 1 : 0) != 0);
                        Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getFullyAuthenticatedUser());
                        Assert.assertEquals((String)"lemur", (String)AuthenticationUtil.getRunAsUser());
                        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                            public Object doWork() throws Exception {
                                Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
                                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getFullyAuthenticatedUser());
                                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                                    public Object doWork() throws Exception {
                                        Assert.assertTrue((PermissionServiceTest.this.permissionService.hasPermission(n1, PermissionServiceTest.this.getPermission("Contributor")) == AccessStatus.DENIED ? 1 : 0) != 0);
                                        Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getFullyAuthenticatedUser());
                                        Assert.assertEquals((String)"andy", (String)AuthenticationUtil.getRunAsUser());
                                        return null;
                                    }
                                }, (String)"andy");
                                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getFullyAuthenticatedUser());
                                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                                return null;
                            }
                        }, (String)AuthenticationUtil.getAdminUserName());
                        Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getFullyAuthenticatedUser());
                        Assert.assertEquals((String)"lemur", (String)AuthenticationUtil.getRunAsUser());
                        return null;
                    }
                }, (String)"lemur");
                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getFullyAuthenticatedUser());
                Assert.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)AuthenticationUtil.getRunAsUser());
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        PermissionServiceTest.assertNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        PermissionServiceTest.assertNull((Object)AuthenticationUtil.getRunAsUser());
    }

    public void testDefaultModelPermissions() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Contributor")) == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs(AuthenticationUtil.getAdminUserName());
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Contributor"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Contributor")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSystemUserPermissions() {
        AuthenticationUtil.setRunAsUserSystem();
        try {
            PermissionServiceTest.assertTrue((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "Consumer") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "Delete") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "AddChildren") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "CancelCheckOut") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "CheckOut") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "Coordinator") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        }
        finally {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminUserPermissions() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        try {
            PermissionServiceTest.assertFalse((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "Consumer") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "Delete") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "AddChildren") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertFalse((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "CancelCheckOut") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "CheckOut") == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertFalse((this.serviceRegistry.getPermissionService().hasPermission(this.rootNodeRef, "Coordinator") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        }
        finally {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }

    public void testWeSetConsumerOnRootIsNotSupportedByHasPermisssionAsItIsTheWrongType() {
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Consumer"), "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        PermissionServiceTest.assertEquals((Object)this.permissionService.hasPermission(this.rootNodeRef, "Consumer"), (Object)AccessStatus.DENIED);
    }

    public void testEqualBarCaseAuthorities() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "Andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "ANDY", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "woof/adobe", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "woof/Adobe", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "woof/ADOBE", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "Woof/Adobe", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "WOOF/ADOBE", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)8, (int)this.permissionService.getAllSetPermissions(n1).size());
    }

    public void testGetAllSetPermissions() {
        this.runAs("andy");
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Delete"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Delete"), "GROUP_GREEN", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "GROUP_RED", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.systemNodeRef, this.getPermission("Delete"), "andy", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.systemNodeRef, this.getPermission("Delete"), "GROUP_GREEN", AccessStatus.DENIED));
        NodeRef current = this.systemNodeRef;
        HashSet<AccessPermission> setPermissions = new HashSet<AccessPermission>();
        while (current != null) {
            Set morePermissions = this.permissionService.getAllSetPermissions(current);
            for (AccessPermission toTest : morePermissions) {
                if (toTest.getAuthorityType() != AuthorityType.GROUP) continue;
                boolean add = true;
                for (AccessPermission existing : setPermissions) {
                    if (!add || !existing.getAuthority().equals(toTest.getAuthority()) || !existing.getPermission().equals(toTest.getPermission())) continue;
                    add = false;
                }
                if (!add) continue;
                setPermissions.add(toTest);
            }
            if (this.permissionService.getInheritParentPermissions(current)) {
                current = this.nodeService.getPrimaryParent(current).getParentRef();
                continue;
            }
            current = null;
        }
        PermissionServiceTest.assertEquals((int)2, (int)setPermissions.size());
    }

    public void testPermissionCacheOnMove() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs(AuthenticationUtil.getAdminUserName());
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs(AuthenticationUtil.getAdminUserName());
        this.nodeService.moveNode(n2, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}oneMoved"));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.DENIED ? 1 : 0) != 0);
    }

    public void testSetInheritFalse() {
        this.runAs("andy");
        this.permissionService.setInheritParentPermissions(this.rootNodeRef, false);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertFalse((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
    }

    public void testSetInheritTrue() {
        this.runAs("andy");
        this.permissionService.setInheritParentPermissions(this.rootNodeRef, true);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermissions(this.permissionService.getSetPermissions(this.rootNodeRef));
    }

    public void testAlterInherit() {
        this.runAs("andy");
        this.testSetInheritFalse();
        this.testSetInheritTrue();
        this.testSetInheritFalse();
        this.testSetInheritTrue();
        this.permissionService.deletePermissions(this.rootNodeRef);
    }

    private void printPermissions(NodeRef nodeRef, String path) {
        Long id = (Long)this.nodeDAO.getNodePair(nodeRef).getFirst();
        System.out.println(path + " has " + id);
        for (AccessControlEntry entry : this.aclDaoComponent.getAccessControlList(id).getEntries()) {
            System.out.println("\t\t " + id + "  " + entry);
        }
        List children = this.nodeService.getChildAssocs(nodeRef);
        for (ChildAssociationRef child : children) {
            String newPath = path + "/" + child.getQName();
            this.printPermissions(child.getChildRef(), newPath);
        }
    }

    public void testSetNodePermissionEntry() {
        this.runAs("andy");
        ArrayList<SimplePermissionEntry> entries = new ArrayList<SimplePermissionEntry>();
        entries.add(new SimplePermissionEntry(this.rootNodeRef, new SimplePermissionReference(QName.createQName((String)"A", (String)"B"), "C"), "user-one", AccessStatus.ALLOWED));
        entries.add(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), "user-two", AccessStatus.ALLOWED));
        entries.add(new SimplePermissionEntry(this.rootNodeRef, new SimplePermissionReference(QName.createQName((String)"D", (String)"E"), "F"), this.permissionService.getAllAuthorities(), AccessStatus.ALLOWED));
        entries.add(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), this.permissionService.getAllAuthorities(), AccessStatus.DENIED));
        SimpleNodePermissionEntry entry = new SimpleNodePermissionEntry(this.rootNodeRef, false, entries);
        this.permissionService.setPermission(entry);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertFalse((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)4, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
    }

    public void testSetNodePermissionEntry2() {
        ArrayList<SimplePermissionEntry> entries = new ArrayList<SimplePermissionEntry>();
        entries.add(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), this.permissionService.getAllAuthorities(), AccessStatus.ALLOWED));
        SimpleNodePermissionEntry entry = new SimpleNodePermissionEntry(this.rootNodeRef, false, entries);
        this.permissionService.setPermission(entry);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertFalse((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
    }

    public void testAlterNodePermissions() {
        this.testSetNodePermissionEntry();
        this.testSetNodePermissionEntry2();
        this.testSetNodePermissionEntry();
        this.testSetNodePermissionEntry2();
    }

    public void testDoubleSetAllowDeny() {
        List<? extends PermissionEntry> permissionEntries = null;
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), true);
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), false);
        this.permissionService.deletePermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission());
        permissionEntries = this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries();
        PermissionServiceTest.assertEquals((int)0, (int)permissionEntries.size());
        this.permissionService.setPermission(this.rootNodeRef, "andy", "Read", true);
        this.permissionService.setPermission(this.rootNodeRef, "andy", "Read", false);
        this.permissionService.deletePermission(this.rootNodeRef, "andy", "Read");
        permissionEntries = this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries();
        PermissionServiceTest.assertEquals((int)0, (int)permissionEntries.size());
    }

    public void testSetPermissionEntryElements() {
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), true);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        for (PermissionEntry permissionEntry : this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries()) {
            PermissionServiceTest.assertEquals((String)"andy", (String)permissionEntry.getAuthority());
            PermissionServiceTest.assertTrue((boolean)permissionEntry.isAllowed());
            PermissionServiceTest.assertTrue((boolean)permissionEntry.getPermissionReference().getQName().equals((Object)this.permissionService.getAllPermissionReference().getQName()));
            PermissionServiceTest.assertTrue((boolean)permissionEntry.getPermissionReference().getName().equals(this.permissionService.getAllPermissionReference().getName()));
            PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)permissionEntry.getNodeRef());
        }
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), true);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(this.rootNodeRef, "other", this.permissionService.getAllPermission(), true);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), false);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(this.rootNodeRef, "andy", "Read", false);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)3, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(this.rootNodeRef, "andy", "Read");
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission());
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(this.rootNodeRef, "other", this.permissionService.getAllPermission());
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
    }

    public void testSetPermissionEntry() {
        this.permissionService.setPermission(this.allowAndyAll);
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), true);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        for (PermissionEntry permissionEntry : this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries()) {
            PermissionServiceTest.assertEquals((String)"andy", (String)permissionEntry.getAuthority());
            PermissionServiceTest.assertTrue((boolean)permissionEntry.isAllowed());
            PermissionServiceTest.assertTrue((boolean)permissionEntry.getPermissionReference().getQName().equals((Object)this.permissionService.getAllPermissionReference().getQName()));
            PermissionServiceTest.assertTrue((boolean)permissionEntry.getPermissionReference().getName().equals(this.permissionService.getAllPermissionReference().getName()));
            PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)permissionEntry.getNodeRef());
        }
        this.permissionService.setPermission(this.allowAndyAll);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), "other", AccessStatus.ALLOWED));
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(this.denyAndyAll);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, new SimplePermissionReference(QName.createQName((String)"A", (String)"B"), "C"), "andy", AccessStatus.DENIED));
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)3, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, new SimplePermissionReference(QName.createQName((String)"A", (String)"B"), "C"), "andy", AccessStatus.DENIED));
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(this.denyAndyAll);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), "other", AccessStatus.ALLOWED));
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(this.allowAndyAll);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
    }

    public void testGetSettablePermissionsForType() {
        Set answer = this.permissionService.getSettablePermissions(QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver));
        PermissionServiceTest.assertEquals((int)38, (int)answer.size());
        answer = this.permissionService.getSettablePermissions(QName.createQName((String)"cm", (String)"ownable", (NamespacePrefixResolver)this.namespacePrefixResolver));
        PermissionServiceTest.assertEquals((int)0, (int)answer.size());
        answer = this.permissionService.getSettablePermissions(QName.createQName((String)"cm", (String)"content", (NamespacePrefixResolver)this.namespacePrefixResolver));
        PermissionServiceTest.assertEquals((int)5, (int)answer.size());
        answer = this.permissionService.getSettablePermissions(QName.createQName((String)"cm", (String)"folder", (NamespacePrefixResolver)this.namespacePrefixResolver));
        PermissionServiceTest.assertEquals((int)5, (int)answer.size());
        answer = this.permissionService.getSettablePermissions(QName.createQName((String)"cm", (String)"monkey", (NamespacePrefixResolver)this.namespacePrefixResolver));
        PermissionServiceTest.assertEquals((int)0, (int)answer.size());
    }

    public void testGetSettablePermissionsForNode() {
        QName ownable = QName.createQName((String)"cm", (String)"ownable", (NamespacePrefixResolver)this.namespacePrefixResolver);
        Set answer = this.permissionService.getSettablePermissions(this.rootNodeRef);
        PermissionServiceTest.assertEquals((int)38, (int)answer.size());
        this.nodeService.addAspect(this.rootNodeRef, ownable, null);
        answer = this.permissionService.getSettablePermissions(this.rootNodeRef);
        PermissionServiceTest.assertEquals((int)38, (int)answer.size());
        this.nodeService.removeAspect(this.rootNodeRef, ownable);
        answer = this.permissionService.getSettablePermissions(this.rootNodeRef);
        PermissionServiceTest.assertEquals((int)38, (int)answer.size());
    }

    public void testSimplePermissionOnRoot() {
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)38, (int)this.permissionService.getPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertEquals((int)0, (int)this.countGranted(this.permissionService.getPermissions(this.rootNodeRef)));
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)38, (int)this.permissionService.getPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertEquals((int)2, (int)this.countGranted(this.permissionService.getPermissions(this.rootNodeRef)));
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.DENIED));
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.DENIED));
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    private int countGranted(Set<AccessPermission> permissions) {
        int count = 0;
        for (AccessPermission ap : permissions) {
            if (ap.getAccessStatus() != AccessStatus.ALLOWED) continue;
            ++count;
        }
        return count;
    }

    public void testGlobalPermissionsForAdmin() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_CONTENT).getChildRef();
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), AuthenticationUtil.getAdminUserName(), AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), AuthenticationUtil.getAdminUserName(), AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadContent"), AuthenticationUtil.getAdminUserName(), AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("All"), AuthenticationUtil.getAdminUserName(), AccessStatus.DENIED));
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testPermissionGroupOnRoot() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)38, (int)this.permissionService.getPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertEquals((int)7, (int)this.countGranted(this.permissionService.getPermissions(this.rootNodeRef)));
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("andy");
    }

    public void testSimplePermissionSimpleInheritance() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(this.allowAndyReadProperties);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyReadChildren);
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyReadProperties);
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyReadChildren);
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyReadProperties);
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testPermissionGroupSimpleInheritance() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testDenySimplePermisionOnRootNode() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyReadProperties);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyReadProperties);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyReadProperties);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testDenyPermissionOnRootNOde() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testComplexDenyOnRootNode() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyReadProperties);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyReadChildren);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testPerformance() throws Exception {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n3 = this.nodeService.createNode(n2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}three"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n4 = this.nodeService.createNode(n3, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}four"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n5 = this.nodeService.createNode(n4, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}five"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n6 = this.nodeService.createNode(n5, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}six"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n7 = this.nodeService.createNode(n6, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}seven"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n8 = this.nodeService.createNode(n7, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}eight"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n9 = this.nodeService.createNode(n8, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}nine"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n10 = this.nodeService.createNode(n9, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}ten"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        this.permissionService.hasPermission(n5, "Read");
        long start = System.nanoTime();
        for (int i = 0; i < 10000; ++i) {
            this.permissionService.hasPermission(n5, "Read");
        }
        long end = System.nanoTime();
        System.out.println("Can in " + (float)(end - start) / 1.0E9f / 10000.0f);
        System.out.println("Can per second " + 1.0f / ((float)(end - start) / 1.0E9f / 10000.0f));
    }

    public void testPerf() throws Exception {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n3 = this.nodeService.createNode(n2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}three"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n4 = this.nodeService.createNode(n3, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}four"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n5 = this.nodeService.createNode(n4, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}five"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n6 = this.nodeService.createNode(n5, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}six"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n7 = this.nodeService.createNode(n6, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}seven"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n8 = this.nodeService.createNode(n7, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}eight"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n9 = this.nodeService.createNode(n8, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}nine"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n10 = this.nodeService.createNode(n9, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}ten"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        long time = 0L;
        time = 0L;
        for (int i = 0; i < 1000; ++i) {
            long start = System.nanoTime();
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n10, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            long end = System.nanoTime();
            time += end - start;
        }
        System.out.println("Time is " + (double)time / 1.0E9);
    }

    public void testAllPermissions() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(this.allowAndyAll);
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyAll);
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testOldAllPermissions() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE, "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyAll);
        PermissionServiceTest.assertEquals((int)3, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testAuthenticatedAuthority() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "ROLE_AUTHENTICATED", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "ROLE_AUTHENTICATED", AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "ROLE_AUTHENTICATED", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testAllAuthorities() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), this.permissionService.getAllAuthorities(), AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), this.permissionService.getAllAuthorities(), AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), this.permissionService.getAllAuthorities(), AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testAllPermissionsAllAuthorities() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), this.permissionService.getAllAuthorities(), AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), this.permissionService.getAllAuthorities(), AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), this.permissionService.getAllAuthorities(), AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testGroupAndUserInteraction() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "ROLE_AUTHENTICATED", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.DENIED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.DENIED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupAndUserInteractionAnyAllowAllows() {
        this.permissionServiceImpl.setAnyDenyDenies(false);
        try {
            this.runAs("andy");
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.runAs("lemur");
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
            this.runAs("andy");
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.runAs("lemur");
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "ROLE_AUTHENTICATED", AccessStatus.ALLOWED));
            this.runAs("andy");
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.runAs("lemur");
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.DENIED));
            this.runAs("andy");
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.runAs("lemur");
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
            this.runAs("andy");
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.runAs("lemur");
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.DENIED));
            this.runAs("andy");
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            this.runAs("lemur");
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        }
        finally {
            this.permissionServiceImpl.setAnyDenyDenies(true);
        }
    }

    public void testInheritPermissions() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setInheritParentPermissions(n2, false);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setInheritParentPermissions(n2, true);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testAncestorRequirementAndInheritance() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadContent"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("ReadChildren"), "andy", AccessStatus.DENIED));
        this.permissionService.setInheritParentPermissions(n2, false);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setInheritParentPermissions(n2, true);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testPermissionCase() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "Andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "ANDY", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadContent"), "AnDy", AccessStatus.ALLOWED));
        this.permissionService.getAllSetPermissions(this.rootNodeRef);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testEffectiveComposite() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadContent"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testContentPermissions() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_CONTENT).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadContent"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(n2, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.deletePermission(new SimplePermissionEntry(n2, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        this.permissionService.deletePermission(new SimplePermissionEntry(n2, this.getPermission("ReadContent"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testAllPermissionSet() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("FullControl"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("FullControl"), "andy", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("FullControl"), "andy", AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testChildrenRequirements() {
        if (!this.personService.createMissingPeople()) {
            PermissionServiceTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.rootNodeRef).size());
        }
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Delete"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.systemNodeRef, this.getPermission("Delete"), "andy", AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testClearPermission() {
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "lemur", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "lemur", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)4, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.clearPermission(this.rootNodeRef, "andy");
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.clearPermission(this.rootNodeRef, "lemur");
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
    }

    public void xtestAclInsertionPerformanceShared() {
        NodeRef parent = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        for (int i = 0; i < 10000; ++i) {
            this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}child" + i)), ContentModel.TYPE_FOLDER).getChildRef();
        }
        long start = System.nanoTime();
        this.permissionService.setPermission(new SimplePermissionEntry(parent, this.getPermission("Consumer"), "andy", AccessStatus.ALLOWED));
        long end = System.nanoTime();
        PermissionServiceTest.assertTrue((String)("Time was " + (float)(end - start) / 1.0E9f), (end == start ? 1 : 0) != 0);
    }

    public void xtestAclInsertionPerformanceDefining() {
        NodeRef parent = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        for (int i = 0; i < 10000; ++i) {
            NodeRef created = this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}child" + i)), ContentModel.TYPE_FOLDER).getChildRef();
            this.permissionService.setPermission(new SimplePermissionEntry(created, this.getPermission("Consumer"), "bob", AccessStatus.ALLOWED));
        }
        long start = System.nanoTime();
        this.permissionService.setPermission(new SimplePermissionEntry(parent, this.getPermission("Consumer"), "andy", AccessStatus.ALLOWED));
        long end = System.nanoTime();
        PermissionServiceTest.assertTrue((String)("Time was " + (float)(end - start) / 1.0E9f), (end == start ? 1 : 0) != 0);
    }

    public void xtestAclInsertionPerformanceMixed() {
        NodeRef parent = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        for (int i = 0; i < 10000; ++i) {
            NodeRef created = this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}child" + i)), ContentModel.TYPE_FOLDER).getChildRef();
            if (i % 2 != 0) continue;
            this.permissionService.setPermission(new SimplePermissionEntry(created, this.getPermission("Consumer"), "bob", AccessStatus.ALLOWED));
        }
        long start = System.nanoTime();
        this.permissionService.setPermission(new SimplePermissionEntry(parent, this.getPermission("Consumer"), "andy", AccessStatus.ALLOWED));
        long end = System.nanoTime();
        PermissionServiceTest.assertTrue((String)("Time was " + (float)(end - start) / 1.0E9f), (end == start ? 1 : 0) != 0);
    }

    public void testClearPermissionNullAuthority() {
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "lemur", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "lemur", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)4, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.clearPermission(this.rootNodeRef, null);
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
    }

    public void testGetAllSetPermissionsFromAllNodes() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}three"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n4 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}four"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n5 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}five"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n6 = this.nodeService.createNode(n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}six"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n7 = this.nodeService.createNode(n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}seven"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n8 = this.nodeService.createNode(n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}eight"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n9 = this.nodeService.createNode(n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}nine"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n10 = this.nodeService.createNode(n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}ten"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("ReadContent"), AuthenticationUtil.getAdminUserName(), AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n3, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n4, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n5, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n6, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n7, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n8, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n9, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n10, this.getPermission("ReadChildren"), AuthenticationUtil.getAdminUserName(), AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n10, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
    }

    public void test_DefiningShared_AclUpdatePerformance() {
        this.runAs("admin");
        NodeRef one = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(one, "andy", "Read", true);
        NodeRef two = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(two, "andy", "Write", true);
        NodeRef test = this.nodeService.createNode(one, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"), ContentModel.TYPE_FOLDER).getChildRef();
        long start = System.nanoTime();
        for (int i = 0; i < 1000; ++i) {
            this.nodeService.moveNode(test, two, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
            this.nodeService.moveNode(test, one, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        }
        long end = System.nanoTime();
    }

    public void test_DefiningDefining_AclUpdatePerformance() {
        this.runAs("admin");
        NodeRef one = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(one, "andy", "Read", true);
        this.permissionService.setPermission(one, "bob", "Read", true);
        this.permissionService.setPermission(one, "cat", "Read", true);
        this.permissionService.setPermission(one, "dog", "Read", true);
        this.permissionService.setPermission(one, "emu", "Read", true);
        this.permissionService.setPermission(one, "fox", "Read", true);
        NodeRef two = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(two, "andy", "Write", true);
        NodeRef test = this.nodeService.createNode(one, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(test, "andy", "ChangePermissions", true);
        long start = System.nanoTime();
        for (int i = 0; i < 1000; ++i) {
            this.nodeService.moveNode(test, two, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
            this.nodeService.moveNode(test, one, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"));
        }
        long end = System.nanoTime();
    }

    public void testAclInsertionPerformanceShared() {
        NodeRef parent = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        for (int i = 0; i < 1000; ++i) {
            this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}child" + i)), ContentModel.TYPE_FOLDER).getChildRef();
        }
        long start = System.nanoTime();
        this.permissionService.setPermission(new SimplePermissionEntry(parent, this.getPermission("Consumer"), "andy", AccessStatus.ALLOWED));
        long end = System.nanoTime();
    }

    public void testAclInsertionPerformanceDefining() {
        NodeRef parent = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        for (int i = 0; i < 1000; ++i) {
            NodeRef created = this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}child" + i)), ContentModel.TYPE_FOLDER).getChildRef();
            this.permissionService.setPermission(new SimplePermissionEntry(created, this.getPermission("Consumer"), "bob", AccessStatus.ALLOWED));
        }
        long start = System.nanoTime();
        this.permissionService.setPermission(new SimplePermissionEntry(parent, this.getPermission("Consumer"), "andy", AccessStatus.ALLOWED));
        long end = System.nanoTime();
    }

    public void testAclInsertionPerformanceMixed() {
        NodeRef parent = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        for (int i = 0; i < 1000; ++i) {
            NodeRef created = this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}child" + i)), ContentModel.TYPE_FOLDER).getChildRef();
            if (i % 2 != 0) continue;
            this.permissionService.setPermission(new SimplePermissionEntry(created, this.getPermission("Consumer"), "bob", AccessStatus.ALLOWED));
        }
        long start = System.nanoTime();
        this.permissionService.setPermission(new SimplePermissionEntry(parent, this.getPermission("Consumer"), "andy", AccessStatus.ALLOWED));
        long end = System.nanoTime();
    }

    public void xtestFindNodesByPermission() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}three"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n4 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}four"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n5 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}five"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n6 = this.nodeService.createNode(n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}six"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n7 = this.nodeService.createNode(n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}seven"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n8 = this.nodeService.createNode(n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}eight"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n9 = this.nodeService.createNode(n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}nine"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n10 = this.nodeService.createNode(n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}ten"), ContentModel.TYPE_FOLDER).getChildRef();
        this.personService.getPerson("andy");
        String groupAuth = this.authorityService.createAuthority(AuthorityType.GROUP, "G");
        this.authorityService.addAuthority(groupAuth, "andy");
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Consumer"), AuthenticationUtil.getAdminUserName(), AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Consumer"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n6, this.getPermission("Consumer"), "andy", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n7, this.getPermission("Consumer"), "andy", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n8, this.getPermission("Consumer"), "andy", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n9, this.getPermission("Consumer"), "andy", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n9, this.getPermission("Consumer"), groupAuth, AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n10, this.getPermission("Consumer"), groupAuth, AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n10, this.getPermission("Consumer"), "andy", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("Contributor"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n3, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n3, this.getPermission("ReadContent"), groupAuth, AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n4, this.getPermission("ReadChildren"), groupAuth, AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n5, this.getPermission("ReadContent"), groupAuth, AccessStatus.ALLOWED));
    }
}

