/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionReference;
import org.alfresco.service.namespace.QName;

public final class SimplePermissionReference
extends AbstractPermissionReference {
    private static final long serialVersionUID = 637302438293417818L;
    private static ReadWriteLock lock = new ReentrantReadWriteLock();
    private static HashMap<QName, HashMap<String, SimplePermissionReference>> instances = new HashMap();
    private QName qName;
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimplePermissionReference getPermissionReference(QName qName, String name) {
        SimplePermissionReference instance;
        HashMap<String, SimplePermissionReference> typed;
        lock.readLock().lock();
        try {
            typed = instances.get(qName);
            if (typed != null && (instance = typed.get(name)) != null) {
                SimplePermissionReference simplePermissionReference = instance;
                return simplePermissionReference;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        lock.writeLock().lock();
        try {
            typed = instances.get(qName);
            if (typed == null) {
                typed = new HashMap();
                instances.put(qName, typed);
            }
            if ((instance = typed.get(name)) == null) {
                instance = new SimplePermissionReference(qName, name);
                typed.put(name, instance);
            }
            SimplePermissionReference simplePermissionReference = instance;
            return simplePermissionReference;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    protected SimplePermissionReference(QName qName, String name) {
        this.qName = qName;
        this.name = name;
    }

    @Override
    public QName getQName() {
        return this.qName;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

