/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.HomeFolderProvider2;
import org.alfresco.repo.security.person.PersonException;
import org.alfresco.repo.security.person.PortableHomeFolderManager;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class HomeFolderProviderSynchronizer
extends AbstractLifecycleBean {
    private static final Log logger = LogFactory.getLog(HomeFolderProviderSynchronizer.class);
    private static final Log batchLogger = LogFactory.getLog((String)(HomeFolderProviderSynchronizer.class + ".batch"));
    private static final String GUEST_HOME_FOLDER_PROVIDER = "guestHomeFolderProvider";
    private static final String BOOTSTRAP_HOME_FOLDER_PROVIDER = "bootstrapHomeFolderProvider";
    private final TransactionService transactionService;
    private final AuthorityService authorityService;
    private final PersonService personService;
    private final FileFolderService fileFolderService;
    private final NodeService nodeService;
    private final PortableHomeFolderManager homeFolderManager;
    private final TenantAdminService tenantAdminService;
    private boolean enabled;
    private String overrideHomeFolderProviderName;
    private boolean keepEmptyParents;

    public HomeFolderProviderSynchronizer(TransactionService transactionService, AuthorityService authorityService, PersonService personService, FileFolderService fileFolderService, NodeService nodeService, PortableHomeFolderManager homeFolderManager, TenantAdminService tenantAdminService) {
        this.transactionService = transactionService;
        this.authorityService = authorityService;
        this.personService = personService;
        this.fileFolderService = fileFolderService;
        this.nodeService = nodeService;
        this.homeFolderManager = homeFolderManager;
        this.tenantAdminService = tenantAdminService;
    }

    public void setEnabled(String enabled) {
        this.enabled = "true".equalsIgnoreCase(enabled);
    }

    private boolean enabled() {
        return this.enabled;
    }

    public void setOverrideHomeFolderProviderName(String overrideHomeFolderProviderName) {
        this.overrideHomeFolderProviderName = overrideHomeFolderProviderName;
    }

    private String getOverrideHomeFolderProviderName() {
        return this.overrideHomeFolderProviderName;
    }

    public void setKeepEmptyParents(String keepEmptyParents) {
        this.keepEmptyParents = "true".equalsIgnoreCase(keepEmptyParents);
    }

    private boolean keepEmptyParents() {
        return this.keepEmptyParents;
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    protected void onBootstrap(ApplicationEvent event) {
        if (this.enabled()) {
            String overrideProviderName = this.getOverrideHomeFolderProviderName();
            String systemUserName = AuthenticationUtil.getSystemUserName();
            this.scanPeople(systemUserName, "", overrideProviderName);
            if (this.tenantAdminService.isEnabled()) {
                List<Tenant> tenants = this.tenantAdminService.getAllTenants();
                for (Tenant tenant : tenants) {
                    if (!tenant.isEnabled()) continue;
                    systemUserName = this.tenantAdminService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenant.getTenantDomain());
                    this.scanPeople(systemUserName, tenant.getTenantDomain(), overrideProviderName);
                }
            }
        }
    }

    private void scanPeople(String systemUserName, String tenantDomain, final String overrideProvider) {
        RunAsWorker[] workers;
        Set<String> authorities = this.getAllAuthoritiesInTxn(systemUserName);
        final ParentFolderStructure parentFolderStructure = new ParentFolderStructure();
        final HashMap tmpFolders = new HashMap();
        String createParentFoldersPhaseName = "createParentFolders";
        for (RunAsWorker worker : workers = new RunAsWorker[]{new RunAsWorker(systemUserName, "calculateParentFolderStructure"){

            @Override
            public void doWork(NodeRef person) throws Exception {
                HomeFolderProviderSynchronizer.this.calculateParentFolderStructure(parentFolderStructure, person, overrideProvider);
            }
        }, new RunAsWorker(systemUserName, "moveHomeFolderThatClashesWithParentFolderStructure"){

            @Override
            public void doWork(NodeRef person) throws Exception {
                HomeFolderProviderSynchronizer.this.moveHomeFolderThatClashesWithParentFolderStructure(parentFolderStructure, tmpFolders, person, overrideProvider);
            }
        }, new RunAsWorker(systemUserName, "createParentFolders"){

            @Override
            public void doWork(NodeRef person) throws Exception {
                HomeFolderProviderSynchronizer.this.createParentFolders(person, overrideProvider);
            }
        }, new RunAsWorker(systemUserName, "moveHomeFolderIfRequired"){

            @Override
            public void doWork(NodeRef person) throws Exception {
                HomeFolderProviderSynchronizer.this.moveHomeFolderIfRequired(person, overrideProvider);
            }
        }}) {
            String name = worker.getName();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("  -- " + ("".equals(tenantDomain) ? "" : tenantDomain + " ") + name + " --"));
            }
            int threadCount = name.equals("createParentFolders") ? 1 : 2;
            int peoplePerTransaction = 20;
            BatchProcessor<NodeRef> processor = new BatchProcessor<NodeRef>("HomeFolderProviderSynchronizer", this.transactionService.getRetryingTransactionHelper(), new WorkProvider(authorities), threadCount, peoplePerTransaction, null, batchLogger, 100);
            processor.process(worker, true);
            if (processor.getTotalErrors() <= 0) continue;
            logger.info((Object)"  -- Give up after error --");
            break;
        }
    }

    private Set<String> getAllAuthoritiesInTxn(String systemUserName) {
        return (Set)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<String>>(){

            public Set<String> doWork() throws Exception {
                RetryingTransactionHelper txnHelper = HomeFolderProviderSynchronizer.this.transactionService.getRetryingTransactionHelper();
                RetryingTransactionHelper.RetryingTransactionCallback<Set<String>> restoreCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Set<String>>(){

                    @Override
                    public Set<String> execute() throws Exception {
                        TreeSet<String> result = new TreeSet<String>();
                        result.addAll(HomeFolderProviderSynchronizer.this.authorityService.getAllAuthorities(AuthorityType.USER));
                        return result;
                    }
                };
                return txnHelper.doInTransaction(restoreCallback, false, true);
            }
        }, (String)systemUserName);
    }

    private ParentFolderStructure calculateParentFolderStructure(final ParentFolderStructure parentFolderStructure, NodeRef person, String overrideProviderName) {
        new HomeFolderHandler(person, overrideProviderName){

            @Override
            protected void handleNotInPreferredLocation() {
                this.recordParentFolder();
            }

            @Override
            protected void handleInPreferredLocation() {
                this.recordParentFolder();
            }

            private void recordParentFolder() {
                parentFolderStructure.recordParentFolder(this.root, this.preferredPath);
            }
        }.doWork();
        return parentFolderStructure;
    }

    private void moveHomeFolderThatClashesWithParentFolderStructure(final ParentFolderStructure parentFolderStructure, final Map<NodeRef, String> tmpFolders, NodeRef person, String overrideProviderName) {
        new HomeFolderHandler(person, overrideProviderName){

            @Override
            protected void handleNotInPreferredLocation() {
                this.moveToTmpIfClash();
            }

            @Override
            protected void handleInPreferredLocation() {
                this.moveToTmpIfClash();
            }

            private void moveToTmpIfClash() {
                if (parentFolderStructure.clash(this.root, this.actualPath)) {
                    String tmpFolder = this.getTmpFolderName(this.root);
                    this.preferredPath = new ArrayList();
                    this.preferredPath.add(tmpFolder);
                    this.preferredPath.addAll(this.actualPath);
                    HomeFolderProviderSynchronizer.this.moveHomeFolder(this.person, this.homeFolder, this.root, this.preferredPath, this.originalRoot, null, this.originalProviderName, this.actualPath);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String getTmpFolderName(NodeRef root) {
                Map map = tmpFolders;
                synchronized (map) {
                    String tmpFolder = (String)tmpFolders.get(root);
                    if (tmpFolder == null) {
                        tmpFolder = this.createTmpFolderName(root);
                        tmpFolders.put(root, tmpFolder);
                    }
                    return tmpFolder;
                }
            }

            private String createTmpFolderName(NodeRef root) {
                String temporary = "Temporary-";
                int from = 1;
                int to = 100;
                for (int i = from; i <= to; ++i) {
                    String tmpFolderName = temporary + i;
                    if (HomeFolderProviderSynchronizer.this.fileFolderService.searchSimple(root, tmpFolderName) != null) continue;
                    HomeFolderProviderSynchronizer.this.fileFolderService.create(root, tmpFolderName, ContentModel.TYPE_FOLDER);
                    return tmpFolderName;
                }
                String msg = "Unable to create a temporary folder into which home folders will be moved. Tried creating " + temporary + from + " .. " + temporary + to + ". Remove these folders and try again.";
                logger.error((Object)("     # " + msg));
                throw new PersonException(msg);
            }
        }.doWork();
    }

    private void createParentFolders(NodeRef person, String overrideProviderName) {
        new HomeFolderHandler(person, overrideProviderName){

            @Override
            protected void handleNotInPreferredLocation() {
                HomeFolderProviderSynchronizer.this.createNewParentIfRequired(this.root, this.preferredPath);
            }

            @Override
            protected void handleInPreferredLocation() {
            }
        }.doWork();
    }

    private void moveHomeFolderIfRequired(NodeRef person, String overrideProviderName) {
        new HomeFolderHandler(person, overrideProviderName){

            @Override
            protected void handleNotInPreferredLocation() {
                HomeFolderProviderSynchronizer.this.moveHomeFolder(this.person, this.homeFolder, this.root, this.preferredPath, this.originalRoot, this.providerName, this.originalProviderName, this.actualPath);
            }

            @Override
            protected void handleInPreferredLocation() {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("     # " + HomeFolderProviderSynchronizer.this.toPath(this.actualPath) + " is already in preferred location."));
                }
            }

            @Override
            protected void handleSharedHomeProvider() {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("     # " + this.userName + " " + this.providerName + " creates shared home folders - These are not moved."));
                }
            }

            @Override
            protected void handleOriginalSharedHomeProvider() {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("     # " + this.userName + " Original " + this.originalProviderName + " creates shared home folders - These are not moved."));
                }
            }

            @Override
            protected void handleRootOrAbove() {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("     # " + this.userName + " has a home folder that is the provider's root directory (or is above it). " + "This is normally for users that origanally had an internal provider or a provider that uses " + "shared home folders - These are not moved."));
                }
            }

            @Override
            protected void handleNotAHomeFolderProvider2() {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("     # " + this.userName + " " + this.providerName + " for is not a HomeFolderProvider2."));
                }
            }

            @Override
            protected void handleSpecialHomeFolderProvider() {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("     # " + this.userName + " Original " + this.originalProviderName + " is an internal type - These are not moved."));
                }
            }

            @Override
            protected void handleHomeFolderNotSet() {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("     # " + this.userName + " Home folder is not set - ignored"));
                }
            }
        }.doWork();
    }

    private String toPath(List<String> folders) {
        return this.toPath(folders, folders == null ? 0 : folders.size() - 1);
    }

    private String toPath(List<String> folders, int depth) {
        StringBuilder sb = new StringBuilder("");
        if (folders != null) {
            if (folders.isEmpty()) {
                sb.append('.');
            } else {
                for (String folder : folders) {
                    if (sb.length() > 0) {
                        sb.append('/');
                    }
                    sb.append(folder);
                    if (depth-- > 0) continue;
                    break;
                }
            }
        } else {
            sb.append("<notUnderSameRoot>");
        }
        return sb.toString();
    }

    private String toPath(NodeRef root, NodeRef leaf) {
        StringBuilder sb = new StringBuilder("");
        List<String> path = this.getRelativePath(root, leaf);
        if (path != null) {
            if (path.isEmpty()) {
                sb.append('.');
            } else {
                for (String folder : path) {
                    if (sb.length() > 0) {
                        sb.append('/');
                    }
                    sb.append(folder);
                }
            }
        } else {
            sb.append("<notUnderSameRoot>");
        }
        return sb.toString();
    }

    private List<String> getRelativePath(NodeRef root, NodeRef homeFolder) {
        int homeFolderSize;
        if (root == null || homeFolder == null) {
            return null;
        }
        if (root.equals((Object)homeFolder)) {
            return Collections.emptyList();
        }
        Path rootPath = this.nodeService.getPath(root);
        Path homeFolderPath = this.nodeService.getPath(homeFolder);
        int rootSize = rootPath.size();
        if (rootSize >= (homeFolderSize = homeFolderPath.size())) {
            return Collections.emptyList();
        }
        for (int i = 0; i < rootSize; ++i) {
            if (rootPath.get(i).equals(homeFolderPath.get(i))) continue;
            return null;
        }
        ArrayList<String> path = new ArrayList<String>();
        for (int i = rootSize; i < homeFolderSize; ++i) {
            Path.Element element = homeFolderPath.get(i);
            if (!(element instanceof Path.ChildAssocElement)) {
                return null;
            }
            QName folderQName = ((Path.ChildAssocElement)element).getRef().getQName();
            path.add(folderQName.getLocalName());
        }
        return path;
    }

    private void moveHomeFolder(NodeRef person, NodeRef homeFolder, NodeRef root, List<String> preferredPath, NodeRef oldRoot, String providerName, String originalProviderName, List<String> actualPath) {
        try {
            NodeRef newParent = this.createNewParentIfRequired(root, preferredPath);
            this.homeFolderManager.modifyHomeFolderNameIfItExists(root, preferredPath);
            String homeFolderName = preferredPath.get(preferredPath.size() - 1);
            NodeRef oldParent = this.nodeService.getPrimaryParent(homeFolder).getParentRef();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("     mv " + this.toPath(actualPath) + " " + this.toPath(preferredPath) + (providerName != null && !providerName.equals(originalProviderName) ? "    # AND reset provider to " + providerName : "")));
            }
            homeFolder = this.fileFolderService.move(homeFolder, newParent, homeFolderName).getNodeRef();
            this.nodeService.setProperty(person, ContentModel.PROP_HOMEFOLDER, (Serializable)homeFolder);
            if (providerName != null && !providerName.equals(originalProviderName)) {
                this.nodeService.setProperty(person, ContentModel.PROP_HOME_FOLDER_PROVIDER, (Serializable)((Object)providerName));
            }
            this.removeEmptyParentFolders(oldParent, oldRoot);
        }
        catch (FileExistsException e) {
            String message = "mv " + this.toPath(actualPath) + " " + this.toPath(preferredPath) + " failed as the target already existed.";
            logger.error((Object)("     # " + message));
            throw new PersonException(message);
        }
        catch (FileNotFoundException e) {
            String message = "mv " + this.toPath(actualPath) + " " + this.toPath(preferredPath) + " failed as source did not exist.";
            logger.error((Object)("  " + message));
            throw new PersonException(message);
        }
    }

    private NodeRef createNewParentIfRequired(NodeRef root, List<String> homeFolderPath) {
        NodeRef parent = root;
        int len = homeFolderPath.size() - 1;
        for (int i = 0; i < len; ++i) {
            String pathElement = homeFolderPath.get(i);
            NodeRef nodeRef = this.nodeService.getChildByName(parent, ContentModel.ASSOC_CONTAINS, pathElement);
            String path = this.toPath(homeFolderPath, i);
            if (nodeRef == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("     mkdir " + path));
                }
                parent = this.fileFolderService.create(parent, pathElement, ContentModel.TYPE_FOLDER).getNodeRef();
                continue;
            }
            if (!this.fileFolderService.getFileInfo(nodeRef).isFolder()) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("     # cannot create folder " + path + " as content with the same name exists. " + "Move the content and try again."));
                }
                throw new FileExistsException(parent, path);
            }
            parent = nodeRef;
        }
        return parent;
    }

    private void removeEmptyParentFolders(NodeRef parent, NodeRef root) {
        if (root != null && !this.keepEmptyParents() && this.nodeService.getProperty(parent, ContentModel.PROP_OWNER) == null) {
            NodeRef nodeRef = parent;
            while (!root.equals((Object)nodeRef)) {
                if (nodeRef == null) {
                    return;
                }
                nodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
            }
            while (!root.equals((Object)parent)) {
                nodeRef = parent;
                parent = this.nodeService.getPrimaryParent(parent).getParentRef();
                if (!this.nodeService.getChildAssocs(nodeRef).isEmpty()) {
                    return;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("       rm " + this.toPath(root, nodeRef)));
                }
                this.nodeService.deleteNode(nodeRef);
            }
        }
    }

    private class ParentFolderStructure {
        private Map<NodeRef, RootFolder> folders = new HashMap<NodeRef, RootFolder>();

        private ParentFolderStructure() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recordParentFolder(NodeRef root, List<String> path) {
            RootFolder rootsFolders;
            RootFolder rootFolder = rootsFolders = this.getFolders(root);
            synchronized (rootFolder) {
                rootsFolders.add(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean clash(NodeRef root, List<String> path) {
            RootFolder rootsFolders;
            if (path == null || path.isEmpty()) {
                return false;
            }
            RootFolder rootFolder = rootsFolders = this.getFolders(root);
            synchronized (rootFolder) {
                return rootsFolders.clash(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RootFolder getFolders(NodeRef root) {
            Map<NodeRef, RootFolder> map = this.folders;
            synchronized (map) {
                RootFolder rootsFolders = this.folders.get(root);
                if (rootsFolders == null) {
                    rootsFolders = new RootFolder();
                    this.folders.put(root, rootsFolders);
                }
                return rootsFolders;
            }
        }

        private class Folder {
            String name;
            boolean duplicateWithDifferentCase;
            List<Folder> children;

            public Folder(String name) {
                this.name = name;
            }

            protected void add(List<String> path, int depth) {
                int parentSize = path.size() - 1;
                String name = path.get(depth);
                Folder child = this.getChild(name);
                if (child == null) {
                    child = new Folder(name);
                    if (this.children == null) {
                        this.children = new LinkedList<Folder>();
                    }
                    this.children.add(child);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("     " + HomeFolderProviderSynchronizer.this.toPath(path, depth)));
                    }
                } else if (!child.name.equals(name)) {
                    child.duplicateWithDifferentCase = true;
                }
                if (++depth < parentSize) {
                    this.add(path, depth);
                }
            }

            protected boolean clash(List<String> path, int depth) {
                String name = path.get(depth);
                Folder child = this.getChild(name);
                if (child == null) {
                    return false;
                }
                if (child.duplicateWithDifferentCase) {
                    return true;
                }
                if (!child.name.equals(name)) {
                    child.duplicateWithDifferentCase = true;
                    return true;
                }
                if (++depth == path.size()) {
                    return true;
                }
                return this.clash(path, depth);
            }

            private Folder getChild(String name) {
                if (this.children != null) {
                    for (Folder child : this.children) {
                        if (!name.equalsIgnoreCase(child.name)) continue;
                        return child;
                    }
                }
                return null;
            }
        }

        private class RootFolder
        extends Folder {
            private boolean includesRoot;

            public RootFolder() {
                super(null);
            }

            public void add(List<String> path) {
                if (!this.includesRoot) {
                    int parentSize = path.size() - 1;
                    if (parentSize == 0) {
                        this.includesRoot = true;
                        this.children = null;
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)"   # Recorded root as parent - no need to record other parents as all home folders will clash");
                        }
                    } else {
                        this.add(path, 0);
                    }
                }
            }

            public boolean clash(List<String> path) {
                return this.includesRoot ? false : this.clash(path, 0);
            }
        }
    }

    private abstract class HomeFolderHandler {
        protected final NodeRef person;
        protected final String overrideProviderName;
        protected NodeRef homeFolder;
        protected String userName;
        protected String originalProviderName;
        protected String providerName;
        protected HomeFolderProvider2 provider;
        protected NodeRef root;
        protected List<String> preferredPath;
        protected List<String> actualPath;
        protected NodeRef originalRoot;

        public HomeFolderHandler(NodeRef person, String overrideProviderName) {
            this.person = person;
            this.overrideProviderName = overrideProviderName == null || overrideProviderName.trim().isEmpty() ? null : overrideProviderName;
        }

        public void doWork() {
            this.homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)HomeFolderProviderSynchronizer.this.nodeService.getProperty(this.person, ContentModel.PROP_HOMEFOLDER));
            this.userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)HomeFolderProviderSynchronizer.this.nodeService.getProperty(this.person, ContentModel.PROP_USERNAME));
            if (this.homeFolder != null) {
                this.originalProviderName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)HomeFolderProviderSynchronizer.this.nodeService.getProperty(this.person, ContentModel.PROP_HOME_FOLDER_PROVIDER));
                if (!HomeFolderProviderSynchronizer.BOOTSTRAP_HOME_FOLDER_PROVIDER.equals(this.originalProviderName) && !HomeFolderProviderSynchronizer.GUEST_HOME_FOLDER_PROVIDER.equals(this.originalProviderName)) {
                    this.providerName = this.overrideProviderName != null ? this.overrideProviderName : this.originalProviderName;
                    this.provider = HomeFolderProviderSynchronizer.this.homeFolderManager.getHomeFolderProvider2(this.providerName);
                    if (this.provider != null) {
                        this.root = HomeFolderProviderSynchronizer.this.homeFolderManager.getRootPathNodeRef(this.provider);
                        this.preferredPath = this.provider.getHomeFolderPath(this.person);
                        if (this.preferredPath == null || this.preferredPath.isEmpty()) {
                            this.handleSharedHomeProvider();
                        } else {
                            this.originalRoot = null;
                            HomeFolderProvider2 originalProvider = HomeFolderProviderSynchronizer.this.homeFolderManager.getHomeFolderProvider2(this.originalProviderName);
                            List<String> originalPreferredPath = null;
                            if (originalProvider != null) {
                                this.originalRoot = HomeFolderProviderSynchronizer.this.homeFolderManager.getRootPathNodeRef(originalProvider);
                                originalPreferredPath = originalProvider.getHomeFolderPath(this.person);
                            }
                            if (originalProvider != null && (originalPreferredPath == null || originalPreferredPath.isEmpty())) {
                                this.handleOriginalSharedHomeProvider();
                            } else {
                                this.actualPath = HomeFolderProviderSynchronizer.this.getRelativePath(this.root, this.homeFolder);
                                if (this.actualPath != null && this.actualPath.isEmpty()) {
                                    this.handleRootOrAbove();
                                } else if (this.preferredPath.equals(this.actualPath)) {
                                    this.handleInPreferredLocation();
                                } else {
                                    this.handleNotInPreferredLocation();
                                }
                            }
                        }
                    } else {
                        this.handleNotAHomeFolderProvider2();
                    }
                } else {
                    this.handleSpecialHomeFolderProvider();
                }
            } else {
                this.handleHomeFolderNotSet();
            }
        }

        protected abstract void handleInPreferredLocation();

        protected abstract void handleNotInPreferredLocation();

        protected void handleSharedHomeProvider() {
        }

        protected void handleOriginalSharedHomeProvider() {
        }

        protected void handleRootOrAbove() {
        }

        protected void handleNotAHomeFolderProvider2() {
        }

        protected void handleSpecialHomeFolderProvider() {
        }

        protected void handleHomeFolderNotSet() {
        }
    }

    private abstract class RunAsWorker
    extends BatchProcessor.BatchProcessWorkerAdaptor<NodeRef> {
        final String userName;
        final String name;

        @Override
        public void beforeProcess() throws Throwable {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)this.userName);
        }

        @Override
        public void afterProcess() throws Throwable {
            AuthenticationUtil.popAuthentication();
        }

        public RunAsWorker(String userName, String name) {
            this.userName = userName;
            this.name = name;
        }

        @Override
        public void process(final NodeRef person) throws Throwable {
            AuthenticationUtil.RunAsWork<Object> runAsWork = new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    RunAsWorker.this.doWork(person);
                    return null;
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsWork, (String)this.userName);
        }

        public abstract void doWork(NodeRef var1) throws Exception;

        public String getName() {
            return this.name;
        }
    }

    private class WorkProvider
    implements BatchProcessWorkProvider<NodeRef> {
        private static final int BATCH_SIZE = 100;
        private final VmShutdownListener vmShutdownLister = new VmShutdownListener("getHomeFolderProviderSynchronizerWorkProvider");
        private final Iterator<String> iterator;
        private final int size;

        public WorkProvider(Set<String> authorities) {
            this.iterator = authorities.iterator();
            this.size = authorities.size();
        }

        @Override
        public synchronized int getTotalEstimatedWorkSize() {
            return this.size;
        }

        @Override
        public synchronized Collection<NodeRef> getNextWork() {
            if (this.vmShutdownLister.isVmShuttingDown()) {
                return Collections.emptyList();
            }
            RetryingTransactionHelper txnHelper = HomeFolderProviderSynchronizer.this.transactionService.getRetryingTransactionHelper();
            RetryingTransactionHelper.RetryingTransactionCallback<Collection<NodeRef>> restoreCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Collection<NodeRef>>(){

                @Override
                public Collection<NodeRef> execute() throws Exception {
                    ArrayList<NodeRef> results = new ArrayList<NodeRef>(100);
                    while (results.size() < 100 && WorkProvider.this.iterator.hasNext()) {
                        String userName = (String)WorkProvider.this.iterator.next();
                        try {
                            NodeRef person = HomeFolderProviderSynchronizer.this.personService.getPerson(userName, false);
                            results.add(person);
                        }
                        catch (NoSuchPersonException e) {
                            if (!logger.isTraceEnabled()) continue;
                            logger.trace((Object)("The user " + userName + " no longer exists - ignored."));
                        }
                    }
                    return results;
                }
            };
            return txnHelper.doInTransaction(restoreCallback, false, true);
        }
    }
}

