/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site.script;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.invitation.InvitationSearchCriteriaImpl;
import org.alfresco.repo.invitation.script.ScriptInvitation;
import org.alfresco.repo.invitation.script.ScriptInvitationFactory;
import org.alfresco.repo.jscript.ContentAwareScriptableQNameMap;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ScriptableHashMap;
import org.alfresco.repo.jscript.ScriptableQNameMap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationException;
import org.alfresco.service.cmr.invitation.InvitationSearchCriteria;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.invitation.ModeratedInvitation;
import org.alfresco.service.cmr.invitation.NominatedInvitation;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteMemberInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.springframework.extensions.surf.util.ParameterCheck;

public class Site
implements Serializable {
    private static final long serialVersionUID = 8013569574120957923L;
    private SiteInfo siteInfo;
    private String siteGroup;
    private ScriptableHashMap<String, String> siteRoleGroups;
    private ScriptableQNameMap<String, CustomProperty> customProperties = null;
    private ServiceRegistry serviceRegistry;
    private SiteService siteService;
    private Scriptable scope;
    private boolean isDirty = false;
    private final ScriptInvitationFactory scriptInvitationFactory;
    private final InvitationService invitationService;

    Site(SiteInfo siteInfo, ServiceRegistry serviceRegistry, SiteService siteService, Scriptable scope) {
        this.serviceRegistry = serviceRegistry;
        this.siteService = siteService;
        this.siteInfo = siteInfo;
        this.scope = scope;
        this.invitationService = serviceRegistry.getInvitationService();
        NodeService nodeService = serviceRegistry.getNodeService();
        PersonService personService = serviceRegistry.getPersonService();
        this.scriptInvitationFactory = new ScriptInvitationFactory(this.invitationService, nodeService, personService);
    }

    public String getSitePreset() {
        return this.siteInfo.getSitePreset();
    }

    public String getShortName() {
        return this.siteInfo.getShortName();
    }

    public String getTitle() {
        return this.siteInfo.getTitle();
    }

    public void setTitle(String title) {
        this.isDirty = true;
        this.siteInfo.setTitle(title);
    }

    public String getDescription() {
        return this.siteInfo.getDescription();
    }

    public void setDescription(String description) {
        this.isDirty = true;
        this.siteInfo.setDescription(description);
    }

    public boolean getIsPublic() {
        return this.siteInfo.getIsPublic();
    }

    public void setIsPublic(boolean isPublic) {
        this.isDirty = true;
        this.siteInfo.setIsPublic(isPublic);
    }

    public String getVisibility() {
        return this.siteInfo.getVisibility().toString();
    }

    public void setVisibility(String visibility) {
        ParameterCheck.mandatoryString((String)"visibility", (String)visibility);
        SiteVisibility siteVisibility = SiteVisibility.valueOf(visibility);
        this.siteInfo.setVisibility(siteVisibility);
        this.isDirty = true;
    }

    public ScriptNode getNode() {
        ScriptNode node = null;
        if (this.siteInfo.getNodeRef() != null) {
            node = new ScriptNode(this.siteInfo.getNodeRef(), this.serviceRegistry, this.scope);
        }
        return node;
    }

    public String getSiteGroup() {
        if (this.siteGroup == null) {
            this.siteGroup = this.siteService.getSiteGroup(this.siteInfo.getShortName());
        }
        return this.siteGroup;
    }

    public ScriptableHashMap<String, String> getSitePermissionGroups() {
        if (this.siteRoleGroups == null) {
            List<String> roles = this.siteService.getSiteRoles(this.siteInfo.getShortName());
            this.siteRoleGroups = new ScriptableHashMap();
            for (String role : roles) {
                this.siteRoleGroups.put(role, this.siteService.getSiteRoleGroup(this.siteInfo.getShortName(), role));
            }
        }
        return this.siteRoleGroups;
    }

    public void save() {
        if (this.isDirty) {
            this.siteService.updateSite(this.siteInfo);
            this.isDirty = false;
        }
    }

    public void deleteSite() {
        this.siteService.deleteSite(this.siteInfo.getShortName());
    }

    public ScriptableHashMap<String, String> listMembers(String nameFilter, String roleFilter) {
        return this.listMembers(nameFilter, roleFilter, 0);
    }

    public ScriptableHashMap<String, String> listMembers(String nameFilter, String roleFilter, int size) {
        return this.listMembers(nameFilter, roleFilter, size, false);
    }

    public ScriptableHashMap<String, String> listMembers(String nameFilter, String roleFilter, int size, boolean collapseGroups) {
        Map<String, String> members = this.siteService.listMembers(this.getShortName(), nameFilter, roleFilter, size, collapseGroups);
        ScriptableHashMap<String, String> result = new ScriptableHashMap<String, String>();
        result.putAll(members);
        return result;
    }

    public String getMembersRole(String authorityName) {
        return this.siteService.getMembersRole(this.getShortName(), authorityName);
    }

    public SiteMemberInfo getMembersRoleInfo(String authorityName) {
        return this.siteService.getMembersRoleInfo(this.getShortName(), authorityName);
    }

    public boolean isMember(String authorityName) {
        return this.siteService.isMember(this.getShortName(), authorityName);
    }

    public void setMembership(String authorityName, String role) {
        this.siteService.setMembership(this.getShortName(), authorityName, role);
    }

    public void removeMembership(String authorityName) {
        this.siteService.removeMembership(this.getShortName(), authorityName);
    }

    public ScriptNode getContainer(String componentId) {
        ScriptNode container = null;
        try {
            NodeRef containerNodeRef = this.siteService.getContainer(this.getShortName(), componentId);
            if (containerNodeRef != null) {
                container = new ScriptNode(containerNodeRef, this.serviceRegistry, this.scope);
            }
        }
        catch (AccessDeniedException ade) {
            return null;
        }
        return container;
    }

    public ScriptNode createContainer(String componentId) {
        return this.createContainer(componentId, null, null);
    }

    public ScriptNode createContainer(String componentId, String folderType) {
        return this.createContainer(componentId, folderType, null);
    }

    public ScriptNode createContainer(final String componentId, final String folderType, final Object permissions) {
        NodeRef containerNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                QName folderQName = folderType == null ? null : QName.createQName((String)folderType, (NamespacePrefixResolver)Site.this.serviceRegistry.getNamespaceService());
                NodeRef containerNode = Site.this.siteService.createContainer(Site.this.getShortName(), componentId, folderQName, null);
                if (permissions != null && permissions instanceof ScriptableObject) {
                    ScriptableObject scriptable = (ScriptableObject)permissions;
                    Object[] propIds = scriptable.getIds();
                    for (int i = 0; i < propIds.length; ++i) {
                        String key;
                        Object value;
                        Object propId = propIds[i];
                        if (!(propId instanceof String) || !((value = scriptable.get(key = (String)propId, (Scriptable)scriptable)) instanceof String)) continue;
                        Site.this.serviceRegistry.getPermissionService().setPermission(containerNode, key, (String)value, true);
                    }
                }
                Site.this.serviceRegistry.getOwnableService().setOwner(containerNode, AuthenticationUtil.getAdminUserName());
                return containerNode;
            }
        }, (String)"System");
        if (this.serviceRegistry.getPermissionService().hasPermission(containerNodeRef, "ReadProperties") == AccessStatus.ALLOWED) {
            return this.getContainer(componentId);
        }
        return null;
    }

    public ScriptNode createAndSaveContainer(String containerId, String containerType, final String description) {
        final ScriptNode result = this.createContainer(containerId, containerType);
        if (result == null) {
            return null;
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Site.this.serviceRegistry.getNodeService().setProperty(result.getNodeRef(), ContentModel.PROP_DESCRIPTION, (Serializable)((Object)description));
                result.save();
                return null;
            }
        }, (String)"System");
        return result;
    }

    public boolean hasContainer(String componentId) {
        return this.siteService.hasContainer(this.getShortName(), componentId);
    }

    public void setPermissions(ScriptNode node, Object permissions) {
        NodeRef nodeRef = node.getNodeRef();
        if (permissions != null && permissions instanceof ScriptableObject) {
            PermissionService permissionService = this.serviceRegistry.getPermissionService();
            if (!permissionService.getInheritParentPermissions(nodeRef)) {
                permissionService.deletePermissions(nodeRef);
            }
            ScriptableObject scriptable = (ScriptableObject)permissions;
            Object[] propIds = scriptable.getIds();
            for (int i = 0; i < propIds.length; ++i) {
                String key;
                Object value;
                Object propId = propIds[i];
                if (!(propId instanceof String) || !((value = scriptable.get(key = (String)propId, (Scriptable)scriptable)) instanceof String)) continue;
                permissionService.setPermission(nodeRef, key, (String)value, true);
            }
            String managers = this.siteService.getSiteRoleGroup(this.getShortName(), "SiteManager");
            permissionService.setPermission(nodeRef, managers, "SiteManager", true);
            permissionService.setInheritParentPermissions(nodeRef, false);
        } else {
            this.resetAllPermissions(node);
        }
    }

    public void resetAllPermissions(ScriptNode node) {
        NodeRef nodeRef = node.getNodeRef();
        PermissionService permissionService = this.serviceRegistry.getPermissionService();
        try {
            if (!permissionService.getInheritParentPermissions(nodeRef)) {
                permissionService.deletePermissions(nodeRef);
                permissionService.setInheritParentPermissions(nodeRef, true);
            }
        }
        catch (AccessDeniedException e) {
            throw new AlfrescoRuntimeException("You do not have the authority to update permissions on this node.", (Throwable)((Object)e));
        }
    }

    public CustomProperty getCustomProperty(String name) {
        return (CustomProperty)this.getCustomProperties().get(name);
    }

    public ScriptableQNameMap<String, CustomProperty> getCustomProperties() {
        if (this.customProperties == null) {
            ScriptNode siteNode = new ScriptNode(this.siteInfo.getNodeRef(), this.serviceRegistry);
            siteNode.setScope(this.scope);
            this.customProperties = new ContentAwareScriptableQNameMap<String, CustomProperty>(siteNode, this.serviceRegistry);
            Map<QName, Serializable> props = this.siteInfo.getCustomProperties();
            for (QName qname : props.keySet()) {
                Serializable propValue = props.get(qname);
                ScriptNode.NodeValueConverter valueConverter = siteNode.new ScriptNode.NodeValueConverter();
                Serializable value = valueConverter.convertValueForScript(qname, propValue);
                String title = null;
                String type = null;
                PropertyDefinition propDef = this.serviceRegistry.getDictionaryService().getProperty(qname);
                if (propDef != null) {
                    type = propDef.getDataType().getName().toString();
                    title = propDef.getTitle();
                }
                CustomProperty customProp = new CustomProperty(qname.toString(), value, type, title);
                this.customProperties.put(qname.toString(), customProp);
            }
        }
        return this.customProperties;
    }

    public ScriptInvitation<?> inviteModerated(String inviteeComments, String inviteeUserName, String inviteeRole) {
        ModeratedInvitation invitation = this.invitationService.inviteModerated(inviteeComments, inviteeUserName, Invitation.ResourceType.WEB_SITE, this.getShortName(), inviteeRole);
        return this.scriptInvitationFactory.toScriptInvitation(invitation);
    }

    public ScriptInvitation<?> inviteNominated(String inviteeFirstName, String inviteeLastName, String inviteeEmail, String inviteeRole, String acceptUrl, String rejectUrl) {
        NominatedInvitation invitation = this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, Invitation.ResourceType.WEB_SITE, this.getShortName(), inviteeRole, acceptUrl, rejectUrl);
        return this.scriptInvitationFactory.toScriptInvitation(invitation);
    }

    public ScriptInvitation<?> inviteNominated(String inviteeUserName, String inviteeRole, String acceptUrl, String rejectUrl) {
        NominatedInvitation invitation = this.invitationService.inviteNominated(inviteeUserName, Invitation.ResourceType.WEB_SITE, this.getShortName(), inviteeRole, acceptUrl, rejectUrl);
        return this.scriptInvitationFactory.toScriptInvitation(invitation);
    }

    public ScriptInvitation<?> getInvitation(String invitationId) {
        try {
            Invitation invitation = this.invitationService.getInvitation(invitationId);
            return this.scriptInvitationFactory.toScriptInvitation(invitation);
        }
        catch (InvitationException e) {
            return null;
        }
    }

    public ScriptInvitation<?>[] listInvitations() {
        List<Invitation> invitations = this.invitationService.listPendingInvitationsForResource(Invitation.ResourceType.WEB_SITE, this.getShortName());
        ScriptInvitation[] ret = new ScriptInvitation[invitations.size()];
        int i = 0;
        for (Invitation item : invitations) {
            ret[i++] = this.scriptInvitationFactory.toScriptInvitation(item);
        }
        return ret;
    }

    public ScriptInvitation<?>[] listInvitations(Scriptable props) {
        InvitationSearchCriteriaImpl crit = new InvitationSearchCriteriaImpl();
        crit.setResourceName(this.getShortName());
        crit.setResourceType(Invitation.ResourceType.WEB_SITE);
        if (props.has("inviteeUserName", props)) {
            crit.setInvitee((String)props.get("inviteeUserName", props));
        }
        if (props.has("invitationType", props)) {
            String invitationType = (String)props.get("invitationType", props);
            crit.setInvitationType(InvitationSearchCriteria.InvitationType.valueOf(invitationType));
        }
        List<Invitation> invitations = this.invitationService.searchInvitation(crit);
        ScriptInvitation[] ret = new ScriptInvitation[invitations.size()];
        int i = 0;
        for (Invitation item : invitations) {
            ret[i++] = this.scriptInvitationFactory.toScriptInvitation(item);
        }
        return ret;
    }

    public class CustomProperty {
        private String name;
        private Serializable value;
        private String type;
        private String title;

        public CustomProperty(String name, Serializable value, String type, String title) {
            this.name = name;
            this.value = value;
            this.type = type;
            this.title = title;
        }

        public String getName() {
            return this.name;
        }

        public Serializable getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

