/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.subscriptions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.feed.local.LocalFeedTaskProcessor;
import org.alfresco.repo.activities.post.lookup.PostLookup;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.subscriptions.SubscriptionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.quartz.Scheduler;
import org.springframework.context.ApplicationContext;

public class SubscriptionServiceActivitiesTest
extends TestCase {
    protected static final String TEST_TEMPLATES_LOCATION = "activities";
    protected ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    protected SubscriptionService subscriptionService;
    protected PersonService personService;
    protected SiteService siteService;
    protected ActivityService activityService;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected PostLookup postLookup;
    protected FeedGenerator feedGenerator;

    public void setUp() throws Exception {
        Scheduler scheduler = (Scheduler)this.ctx.getBean("schedulerFactory");
        scheduler.shutdown();
        this.subscriptionService = (SubscriptionService)this.ctx.getBean("SubscriptionService");
        this.personService = (PersonService)this.ctx.getBean("PersonService");
        this.siteService = (SiteService)this.ctx.getBean("SiteService");
        this.activityService = (ActivityService)this.ctx.getBean("activityService");
        this.nodeService = (NodeService)this.ctx.getBean("NodeService");
        this.contentService = (ContentService)this.ctx.getBean("ContentService");
        ChildApplicationContextFactory activitiesFeed = (ChildApplicationContextFactory)this.ctx.getBean("ActivitiesFeed");
        ApplicationContext activitiesFeedCtx = activitiesFeed.getApplicationContext();
        this.postLookup = (PostLookup)activitiesFeedCtx.getBean("postLookup");
        this.feedGenerator = (FeedGenerator)activitiesFeedCtx.getBean("feedGenerator");
        LocalFeedTaskProcessor feedProcessor = (LocalFeedTaskProcessor)activitiesFeedCtx.getBean("feedTaskProcessor");
        ArrayList<String> templateSearchPaths = new ArrayList<String>(1);
        templateSearchPaths.add(TEST_TEMPLATES_LOCATION);
        feedProcessor.setTemplateSearchPaths(templateSearchPaths);
        feedProcessor.setUseRemoteCallbacks(false);
    }

    protected void deletePerson(String userId) {
        this.personService.deletePerson(userId);
    }

    protected NodeRef createPerson(String userId) {
        this.deletePerson(userId);
        PropertyMap properties = new PropertyMap(5);
        properties.put(ContentModel.PROP_USERNAME, userId);
        properties.put(ContentModel.PROP_FIRSTNAME, userId);
        properties.put(ContentModel.PROP_LASTNAME, "Test");
        properties.put(ContentModel.PROP_EMAIL, userId + "@email.com");
        return this.personService.createPerson(properties);
    }

    protected void deleteSite(String siteId) {
        if (this.siteService.getSite(siteId) != null) {
            this.siteService.deleteSite(siteId);
        }
    }

    protected SiteInfo createSite(String siteId, SiteVisibility visibility) {
        this.deleteSite(siteId);
        return this.siteService.createSite("sitePreset", siteId, null, null, visibility);
    }

    protected NodeRef addTextContent(String siteId, String name) {
        String textData = name;
        String mimeType = "text/plain";
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, name);
        NodeRef parentRef = this.siteService.getContainer(siteId, "documentLibrary");
        if (parentRef == null) {
            parentRef = this.siteService.createContainer(siteId, "documentLibrary", ContentModel.TYPE_FOLDER, null);
        }
        ChildAssociationRef association = this.nodeService.createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, name);
        titledProps.put(ContentModel.PROP_DESCRIPTION, name);
        this.nodeService.addAspect(content, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimeType);
        writer.setEncoding("UTF-8");
        writer.putContent(textData);
        this.activityService.postActivity("org.alfresco.documentlibrary.file-added", siteId, "documentlibrary", content, name, ContentModel.PROP_CONTENT, parentRef);
        return content;
    }

    protected void generateFeed() throws Exception {
        this.postLookup.execute();
        this.feedGenerator.execute();
    }

    public void testFollowingActivity() throws Exception {
        String userId1 = "bob";
        String userId2 = "tom";
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceActivitiesTest.this.createPerson("bob");
                SubscriptionServiceActivitiesTest.this.createPerson("tom");
                SubscriptionServiceActivitiesTest.this.createSite("bobpub", SiteVisibility.PUBLIC);
                SubscriptionServiceActivitiesTest.this.siteService.setMembership("bobpub", "bob", "SiteManager");
                SubscriptionServiceActivitiesTest.this.createSite("bobpriv1", SiteVisibility.PRIVATE);
                SubscriptionServiceActivitiesTest.this.siteService.setMembership("bobpriv1", "bob", "SiteManager");
                SubscriptionServiceActivitiesTest.this.createSite("bobpriv2", SiteVisibility.PRIVATE);
                SubscriptionServiceActivitiesTest.this.siteService.setMembership("bobpriv2", "bob", "SiteManager");
                SubscriptionServiceActivitiesTest.this.createSite("bobmod1", SiteVisibility.MODERATED);
                SubscriptionServiceActivitiesTest.this.siteService.setMembership("bobmod1", "bob", "SiteManager");
                SubscriptionServiceActivitiesTest.this.createSite("bobmod2", SiteVisibility.MODERATED);
                SubscriptionServiceActivitiesTest.this.siteService.setMembership("bobmod2", "bob", "SiteManager");
                List<String> feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("bob", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)0, (int)feed.size());
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("tom", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)0, (int)feed.size());
                SubscriptionServiceActivitiesTest.this.generateFeed();
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("bob", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)5, (int)feed.size());
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("tom", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)0, (int)feed.size());
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceActivitiesTest.this.subscriptionService.follow("bob", "tom");
                return null;
            }
        }, (String)"bob");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceActivitiesTest.this.subscriptionService.follow("tom", "bob");
                return null;
            }
        }, (String)"tom");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceActivitiesTest.this.generateFeed();
                List<String> feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("bob", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)7, (int)feed.size());
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("tom", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)2, (int)feed.size());
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceActivitiesTest.this.addTextContent("bobpub", "bobpub-a");
                SubscriptionServiceActivitiesTest.this.addTextContent("bobpriv1", "bobpriv1-a");
                SubscriptionServiceActivitiesTest.this.addTextContent("bobpriv2", "bobpriv2-a");
                SubscriptionServiceActivitiesTest.this.addTextContent("bobmod1", "bobmod1-a");
                SubscriptionServiceActivitiesTest.this.addTextContent("bobmod2", "bobmod2-a");
                return null;
            }
        }, (String)"bob");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceActivitiesTest.this.generateFeed();
                List<String> feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("bob", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)12, (int)feed.size());
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("tom", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)3, (int)feed.size());
                SubscriptionServiceActivitiesTest.this.siteService.setMembership("bobpriv2", "tom", "SiteConsumer");
                SubscriptionServiceActivitiesTest.this.siteService.setMembership("bobmod2", "tom", "SiteManager");
                SubscriptionServiceActivitiesTest.this.generateFeed();
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("bob", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)14, (int)feed.size());
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("tom", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)5, (int)feed.size());
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceActivitiesTest.this.addTextContent("bobpub", "bobpub-b");
                SubscriptionServiceActivitiesTest.this.addTextContent("bobpriv1", "bobpriv1-b");
                SubscriptionServiceActivitiesTest.this.addTextContent("bobpriv2", "bobpriv2-b");
                SubscriptionServiceActivitiesTest.this.addTextContent("bobmod1", "bobmod1-b");
                SubscriptionServiceActivitiesTest.this.addTextContent("bobmod2", "bobmod2-b");
                return null;
            }
        }, (String)"bob");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceActivitiesTest.this.generateFeed();
                List<String> feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("bob", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)19, (int)feed.size());
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("tom", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)8, (int)feed.size());
                SubscriptionServiceActivitiesTest.this.deleteSite("bobpub");
                SubscriptionServiceActivitiesTest.this.deleteSite("bobpriv1");
                SubscriptionServiceActivitiesTest.this.deleteSite("bobpriv2");
                SubscriptionServiceActivitiesTest.this.deleteSite("bobmod1");
                SubscriptionServiceActivitiesTest.this.deleteSite("bobmod2");
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("bob", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)2, (int)feed.size());
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("tom", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)2, (int)feed.size());
                SubscriptionServiceActivitiesTest.this.deletePerson("bob");
                SubscriptionServiceActivitiesTest.this.deletePerson("tom");
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("bob", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)0, (int)feed.size());
                feed = SubscriptionServiceActivitiesTest.this.activityService.getUserFeedEntries("tom", "json", null, false, false, null, null);
                Assert.assertEquals((String)feed.toString(), (int)0, (int)feed.size());
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }
}

