/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.template.AVMTemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class AVMTemplateNodeTest
extends TestCase {
    private static final String TEST_WCM_NAMESPACE = "http://www.alfresco.org/model/testwcmmodel/1.0";
    private static final QName ASPECT_AUTHORED = QName.createQName((String)"http://www.alfresco.org/model/testwcmmodel/1.0", (String)"authored");
    private static final QName PROP_AUTHORED_DATE = QName.createQName((String)"http://www.alfresco.org/model/testwcmmodel/1.0", (String)"dateAuthored");
    private static final ApplicationContext APPLICATION_CONTEXT = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/application-context.xml", "classpath:test/alfresco/wcm-template-node-test-context.xml"});
    private static final ServiceRegistry SERVICE_REGISTRY = (ServiceRegistry)APPLICATION_CONTEXT.getBean("ServiceRegistry");
    private AVMService avmService = SERVICE_REGISTRY.getAVMService();

    protected void setUp() throws Exception {
        this.avmService.createStore("main");
        this.avmService.createDirectory("main:/", "root");
        this.avmService.createFile("main:/root", "testfile.txt");
    }

    protected void tearDown() throws Exception {
        this.avmService.purgeStore("main");
    }

    public void testDatePropertiesConversion() throws Exception {
        AVMTemplateNodeTest.assertNotNull((String)"Aspect 'twcm:authored' is not in the set of compiled dictionary models", (Object)SERVICE_REGISTRY.getDictionaryService().getAspect(ASPECT_AUTHORED));
        LinkedList<Date> values = new LinkedList<Date>();
        for (int i = 0; i < 5; ++i) {
            values.add(new Date());
        }
        PropertyValue value = new PropertyValue(DataTypeDefinition.TEXT, values);
        this.avmService.addAspect("main:/root/testfile.txt", ASPECT_AUTHORED);
        this.avmService.setNodeProperty("main:/root/testfile.txt", PROP_AUTHORED_DATE, value);
        NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, "main:/root/testfile.txt");
        AVMTemplateNode templateNode = new AVMTemplateNode(nodeRef, SERVICE_REGISTRY, null);
        Map<String, Serializable> properties = templateNode.getProperties();
        AVMTemplateNodeTest.assertNotNull(properties);
        AVMTemplateNodeTest.assertFalse((boolean)properties.isEmpty());
        AVMTemplateNodeTest.assertTrue((boolean)properties.containsKey(PROP_AUTHORED_DATE));
        Collection authoredDates = (Collection)((Object)properties.get(PROP_AUTHORED_DATE));
        AVMTemplateNodeTest.assertNotNull((Object)authoredDates);
        AVMTemplateNodeTest.assertFalse((boolean)authoredDates.isEmpty());
        for (Serializable date : authoredDates) {
            AVMTemplateNodeTest.assertFalse((String)("Unexpected data type of 'twcm:authored' property values: " + (null != date ? date.getClass().getName() : "null")), (boolean)(date instanceof String));
        }
    }
}

