/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.template.BaseContentNode;
import org.alfresco.repo.template.TemplatePermissions;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;

public abstract class BasePermissionsNode
extends BaseContentNode
implements TemplatePermissions {
    private List<String> permissions = null;
    private List<String> directPermissions = null;
    private List<String> fullPermissions = null;

    @Override
    public List<String> getPermissions() {
        if (this.permissions == null) {
            this.permissions = this.retrieveAllSetPermissions(false, false);
        }
        return this.permissions;
    }

    public List<String> getDirectPermissions() {
        if (this.directPermissions == null) {
            this.directPermissions = this.retrieveAllSetPermissions(true, false);
        }
        return this.directPermissions;
    }

    public List<String> getFullPermissions() {
        if (this.fullPermissions == null) {
            this.fullPermissions = this.retrieveAllSetPermissions(false, true);
        }
        return this.fullPermissions;
    }

    private List<String> retrieveAllSetPermissions(boolean direct, boolean full) {
        String userName = this.services.getAuthenticationService().getCurrentUserName();
        ArrayList<String> permissions = new ArrayList<String>(4);
        if (this.hasPermission("ReadPermissions")) {
            Set acls = this.services.getPermissionService().getAllSetPermissions(this.getNodeRef());
            for (AccessPermission permission : acls) {
                if (direct && !permission.isSetDirectly()) continue;
                StringBuilder buf = new StringBuilder(64);
                buf.append(permission.getAccessStatus()).append(';').append(permission.getAuthority()).append(';').append(permission.getPermission());
                if (full) {
                    buf.append(';').append(permission.isSetDirectly() ? "DIRECT" : "INHERITED");
                }
                permissions.add(buf.toString());
            }
        }
        return permissions;
    }

    @Override
    public boolean getInheritsPermissions() {
        return this.services.getPermissionService().getInheritParentPermissions(this.getNodeRef());
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.services.getPermissionService().hasPermission(this.getNodeRef(), permission) == AccessStatus.ALLOWED;
    }
}

