/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.Map;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNameMap;

public class QNameAwareObjectWrapper
implements ObjectWrapper {
    private final ThreadLocal<ObjectWrapper> threadDelegates = new ThreadLocal<ObjectWrapper>(){

        @Override
        protected ObjectWrapper initialValue() {
            return new DefaultObjectWrapper(){

                public TemplateModel wrap(Object obj) throws TemplateModelException {
                    if (obj instanceof QNameMap) {
                        return new QNameHash((QNameMap)obj, (ObjectWrapper)this);
                    }
                    return super.wrap(obj);
                }
            };
        }
    };

    public QNameAwareObjectWrapper() {
        this.threadDelegates.get();
        try {
            Introspector.getBeanInfo(TemplateNode.class);
            Introspector.getBeanInfo(QName.class);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public TemplateModel wrap(Object obj) throws TemplateModelException {
        return this.threadDelegates.get().wrap(obj);
    }

    class QNameHash
    extends SimpleHash {
        public QNameHash(QNameMap map, ObjectWrapper wrapper) {
            super((Map)map, wrapper);
        }

        protected Map copyMap(Map map) {
            if (map instanceof QNameMap) {
                return (Map)((QNameMap)map).clone();
            }
            return super.copyMap(map);
        }
    }
}

