/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.transaction.UserTransaction;
import net.sf.acegisecurity.providers.encoding.PasswordEncoder;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.RepoModelDefinition;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.domain.tenant.TenantAdminDAO;
import org.alfresco.repo.domain.tenant.TenantEntity;
import org.alfresco.repo.domain.tenant.TenantUpdateEntity;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.node.db.DbNodeServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.AbstractTenantRoutingContentStore;
import org.alfresco.repo.tenant.MultiTServiceImpl;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.repo.usage.UserUsageTrackingComponent;
import org.alfresco.repo.workflow.WorkflowDeployer;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.RepositoryExporterService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

public class MultiTAdminServiceImpl
implements TenantAdminService,
ApplicationContextAware,
InitializingBean {
    private static Log logger = LogFactory.getLog(MultiTAdminServiceImpl.class);
    private ApplicationContext ctx;
    private NodeService nodeService;
    private RepoAdminService repoAdminService;
    private AuthenticationContext authenticationContext;
    private MultiTServiceImpl tenantService;
    protected TransactionService transactionService;
    protected DictionaryComponent dictionaryComponent;
    protected TenantAdminDAO tenantAdminDAO;
    protected PasswordEncoder passwordEncoder;
    protected ContentStore tenantFileContentStore;
    private ThumbnailRegistry thumbnailRegistry;
    private WorkflowService workflowService;
    private RepositoryExporterService repositoryExporterService;
    private ModuleService moduleService;
    private List<WorkflowDeployer> workflowDeployers = new ArrayList<WorkflowDeployer>();
    private String baseAdminUsername = null;
    protected static final String REGEX_VALID_DNS_LABEL = "^[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9]$";
    protected static final String REGEX_CONTAINS_ALPHA = "^(.*)[a-zA-Z](.*)$";
    protected static final int MAX_LEN = 75;
    public static final String PROTOCOL_STORE_USER = "user";
    public static final String PROTOCOL_STORE_WORKSPACE = "workspace";
    public static final String PROTOCOL_STORE_SYSTEM = "system";
    public static final String PROTOCOL_STORE_ARCHIVE = "archive";
    public static final String STORE_BASE_ID_USER = "alfrescoUserStore";
    public static final String STORE_BASE_ID_SYSTEM = "system";
    public static final String STORE_BASE_ID_VERSION1 = "lightWeightVersionStore";
    public static final String STORE_BASE_ID_VERSION2 = "version2Store";
    public static final String STORE_BASE_ID_SPACES = "SpacesStore";
    public static final String TENANTS_ATTRIBUTE_PATH = "alfresco-tenants";
    public static final String TENANT_ATTRIBUTE_ENABLED = "enabled";
    public static final String TENANT_ATTRIBUTE_ROOT_CONTENT_STORE_DIR = "rootContentStoreDir";
    private List<TenantDeployer> tenantDeployers = new ArrayList<TenantDeployer>();
    private static final String WARN_MSG = "system.mt.warn.upgrade_mt_admin_context";

    public void setNodeService(DbNodeServiceImpl dbNodeService) {
        this.nodeService = dbNodeService;
    }

    public void setDictionaryComponent(DictionaryComponent dictionaryComponent) {
        this.dictionaryComponent = dictionaryComponent;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setTenantService(MultiTServiceImpl tenantService) {
        this.tenantService = tenantService;
    }

    public void setTenantAdminDAO(TenantAdminDAO tenantAdminDAO) {
        this.tenantAdminDAO = tenantAdminDAO;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setTenantFileContentStore(ContentStore tenantFileContentStore) {
        this.tenantFileContentStore = tenantFileContentStore;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setRepositoryExporterService(RepositoryExporterService repositoryExporterService) {
        this.repositoryExporterService = repositoryExporterService;
    }

    public void setWorkflowDeployer(WorkflowDeployer workflowDeployer) {
        logger.warn((Object)WARN_MSG);
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public void setThumbnailRegistry(ThumbnailRegistry thumbnailRegistry) {
        this.thumbnailRegistry = thumbnailRegistry;
    }

    public void setBaseAdminUsername(String baseAdminUsername) {
        this.baseAdminUsername = baseAdminUsername;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.baseAdminUsername == null) {
            logger.warn((Object)I18NUtil.getMessage((String)WARN_MSG));
        }
        PropertyCheck.mandatory((Object)this, (String)"NodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"DictionaryComponent", (Object)this.dictionaryComponent);
        PropertyCheck.mandatory((Object)this, (String)"RepoAdminService", (Object)this.repoAdminService);
        PropertyCheck.mandatory((Object)this, (String)"TransactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"TenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"TenantAdminDAO", (Object)this.tenantAdminDAO);
        PropertyCheck.mandatory((Object)this, (String)"PasswordEncoder", (Object)this.passwordEncoder);
        PropertyCheck.mandatory((Object)this, (String)"TenantFileContentStore", (Object)this.tenantFileContentStore);
        PropertyCheck.mandatory((Object)this, (String)"WorkflowService", (Object)this.workflowService);
        PropertyCheck.mandatory((Object)this, (String)"RepositoryExporterService", (Object)this.repositoryExporterService);
        PropertyCheck.mandatory((Object)this, (String)"moduleService", (Object)this.moduleService);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }

    @Override
    public void startTenants() {
        AuthenticationUtil.setMtEnabled((boolean)true);
        this.register((TenantDeployer)this.dictionaryComponent);
        if (this.tenantFileContentStore instanceof TenantDeployer) {
            this.register((TenantDeployer)this.tenantFileContentStore, 0);
        }
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        try {
            this.authenticationContext.setSystemUserAsCurrentUser();
            userTransaction.begin();
            List<Tenant> tenants = this.getAllTenants();
            int enabledCount = 0;
            int disabledCount = 0;
            for (Tenant tenant : tenants) {
                if (!(this.tenantFileContentStore instanceof AbstractTenantRoutingContentStore) && !this.tenantFileContentStore.getRootLocation().equals(tenant.getRootContentStoreDir())) {
                    throw new AlfrescoRuntimeException("MT: cannot start tenants - TenantRoutingContentStore is not configured AND not all tenants use co-mingled content store");
                }
                if (tenant.isEnabled()) {
                    this.enableTenant(tenant.getTenantDomain(), true);
                    ++enabledCount;
                    continue;
                }
                this.disableTenant(tenant.getTenantDomain(), false);
                ++disabledCount;
            }
            userTransaction.commit();
            if (enabledCount + disabledCount == 0) {
                AuthenticationUtil.setMtEnabled((boolean)false);
            }
            if (logger.isInfoEnabled() && enabledCount + disabledCount > 0) {
                logger.info((Object)String.format("Alfresco Multi-Tenant startup - %d enabled tenants, %d disabled tenants", enabledCount, disabledCount));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Alfresco Multi-Tenant startup - %d enabled tenants, %d disabled tenants", enabledCount, disabledCount));
            }
        }
        catch (Throwable e) {
            try {
                if (userTransaction != null) {
                    userTransaction.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AlfrescoRuntimeException("Failed to bootstrap tenants", e);
        }
        finally {
            this.authenticationContext.clearCurrentSecurityContext();
        }
    }

    @Override
    public void stopTenants() {
        this.tenantDeployers.clear();
        this.tenantDeployers = null;
        AuthenticationUtil.setMtEnabled((boolean)false);
    }

    @Override
    public void createTenant(String tenantDomain, char[] tenantAdminRawPassword) {
        this.createTenant(tenantDomain, tenantAdminRawPassword, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTenant(String tenantDomainIn, char[] tenantAdminRawPassword, String rootContentStoreDir) {
        ParameterCheck.mandatory((String)"tenantAdminRawPassword", (Object)tenantAdminRawPassword);
        String tenantDomain = this.getTenantDomain(tenantDomainIn);
        AuthenticationUtil.setMtEnabled((boolean)true);
        long start = System.currentTimeMillis();
        this.initTenant(tenantDomain, rootContentStoreDir);
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)this.getSystemUser(tenantDomain));
            this.dictionaryComponent.init();
            if (this.tenantFileContentStore instanceof TenantDeployer) {
                ((TenantDeployer)this.tenantFileContentStore).init();
            }
            ImporterBootstrap userImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("userBootstrap-mt"));
            this.bootstrapUserTenantStore(userImporterBootstrap, tenantDomain, tenantAdminRawPassword);
            ImporterBootstrap systemImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("systemBootstrap-mt"));
            this.bootstrapSystemTenantStore(systemImporterBootstrap, tenantDomain);
            ImporterBootstrap versionImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("versionBootstrap-mt"));
            this.bootstrapVersionTenantStore(versionImporterBootstrap, tenantDomain);
            ImporterBootstrap version2ImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("version2Bootstrap-mt"));
            this.bootstrapVersionTenantStore(version2ImporterBootstrap, tenantDomain);
            ImporterBootstrap spacesArchiveImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("spacesArchiveBootstrap-mt"));
            this.bootstrapSpacesArchiveTenantStore(spacesArchiveImporterBootstrap, tenantDomain);
            ImporterBootstrap spacesImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("spacesBootstrap-mt"));
            this.bootstrapSpacesTenantStore(spacesImporterBootstrap, tenantDomain);
            this.thumbnailRegistry.initThumbnailDefinitions();
            for (TenantDeployer tenantDeployer : this.tenantDeployers) {
                tenantDeployer.onEnableTenant();
            }
            for (WorkflowDeployer workflowDeployer : this.workflowDeployers) {
                workflowDeployer.init();
            }
            this.moduleService.startModules();
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Tenant created: " + tenantDomain + " in " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    @Override
    public void exportTenant(String tenantDomain, final File directoryDestination) {
        final String lowerTenantDomain = this.getTenantDomain(tenantDomain);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                MultiTAdminServiceImpl.this.repositoryExporterService.export(directoryDestination, lowerTenantDomain);
                return null;
            }
        }, (String)this.getSystemUser(tenantDomain));
        logger.info((Object)("Tenant exported: " + tenantDomain));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importTenant(String tenantDomainIn, File directorySource, String contentRoot) {
        String tenantDomain = this.getTenantDomain(tenantDomainIn);
        AuthenticationUtil.setMtEnabled((boolean)true);
        this.initTenant(tenantDomain, contentRoot);
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)this.getSystemUser(tenantDomain));
            this.dictionaryComponent.init();
            if (this.tenantFileContentStore instanceof TenantDeployer) {
                ((TenantDeployer)this.tenantFileContentStore).init();
            }
            this.importBootstrapUserTenantStore(tenantDomain, directorySource);
            this.importBootstrapSystemTenantStore(tenantDomain, directorySource);
            this.importBootstrapVersionTenantStore(tenantDomain, directorySource);
            this.importBootstrapSpacesArchiveTenantStore(tenantDomain, directorySource);
            this.importBootstrapSpacesModelsTenantStore(tenantDomain, directorySource);
            this.importBootstrapSpacesTenantStore(tenantDomain, directorySource);
            this.thumbnailRegistry.initThumbnailDefinitions();
            for (TenantDeployer tenantDeployer : this.tenantDeployers) {
                tenantDeployer.onEnableTenant();
            }
            for (WorkflowDeployer workflowDeployer : this.workflowDeployers) {
                workflowDeployer.init();
            }
            this.moduleService.startModules();
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        logger.info((Object)("Tenant imported: " + tenantDomain));
    }

    @Override
    public boolean existsTenant(String tenantDomain) {
        ParameterCheck.mandatory((String)"tenantDomain", (Object)tenantDomain);
        tenantDomain = this.getTenantDomain(tenantDomain);
        return this.getTenantAttributes(tenantDomain) != null;
    }

    private Tenant getTenantAttributes(String tenantDomain) {
        TenantEntity tenantEntity = this.tenantAdminDAO.getTenant(tenantDomain);
        if (tenantEntity == null) {
            return null;
        }
        Tenant tenant = new Tenant(tenantEntity.getTenantDomain(), tenantEntity.getEnabled().booleanValue(), tenantEntity.getContentRoot());
        return tenant;
    }

    @Override
    public void enableTenant(String tenantDomain) {
        if (!this.existsTenant(tenantDomain = this.getTenantDomain(tenantDomain))) {
            throw new AuthenticationException("Tenant does not exist: " + tenantDomain);
        }
        if (this.isEnabledTenant(tenantDomain)) {
            logger.warn((Object)("Tenant already enabled: " + tenantDomain));
        }
        this.enableTenant(tenantDomain, true);
    }

    private void enableTenant(String tenantDomain, boolean notifyTenantDeployers) {
        ParameterCheck.mandatory((String)"tenantDomain", (Object)tenantDomain);
        TenantUpdateEntity tenantUpdateEntity = this.tenantAdminDAO.getTenantForUpdate(tenantDomain);
        tenantUpdateEntity.setEnabled(true);
        this.tenantAdminDAO.updateTenant(tenantUpdateEntity);
        if (notifyTenantDeployers) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() {
                    for (TenantDeployer tenantDeployer : MultiTAdminServiceImpl.this.tenantDeployers) {
                        tenantDeployer.onEnableTenant();
                    }
                    return null;
                }
            }, (String)this.getSystemUser(tenantDomain));
        }
        logger.info((Object)("Tenant enabled: " + tenantDomain));
    }

    @Override
    public void disableTenant(String tenantDomain) {
        if (!this.existsTenant(tenantDomain = this.getTenantDomain(tenantDomain))) {
            throw new AuthenticationException("Tenant does not exist: " + tenantDomain);
        }
        if (!this.isEnabledTenant(tenantDomain)) {
            logger.warn((Object)("Tenant already disabled: " + tenantDomain));
        }
        this.disableTenant(tenantDomain, true);
    }

    public void disableTenant(String tenantDomain, boolean notifyTenantDeployers) {
        tenantDomain = this.getTenantDomain(tenantDomain);
        if (notifyTenantDeployers) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() {
                    for (TenantDeployer tenantDeployer : MultiTAdminServiceImpl.this.tenantDeployers) {
                        tenantDeployer.onDisableTenant();
                    }
                    return null;
                }
            }, (String)this.getSystemUser(tenantDomain));
        }
        TenantUpdateEntity tenantUpdateEntity = this.tenantAdminDAO.getTenantForUpdate(tenantDomain);
        tenantUpdateEntity.setEnabled(false);
        this.tenantAdminDAO.updateTenant(tenantUpdateEntity);
        logger.info((Object)("Tenant disabled: " + tenantDomain));
    }

    @Override
    public boolean isEnabledTenant(String tenantDomain) {
        ParameterCheck.mandatory((String)"tenantDomain", (Object)tenantDomain);
        tenantDomain = this.getTenantDomain(tenantDomain);
        Tenant tenant = this.getTenantAttributes(tenantDomain);
        if (tenant != null) {
            return tenant.isEnabled();
        }
        return false;
    }

    protected String getRootContentStoreDir(String tenantDomain) {
        ParameterCheck.mandatory((String)"tenantDomain", (Object)tenantDomain);
        Tenant tenant = this.getTenantAttributes(tenantDomain);
        if (tenant != null) {
            return tenant.getRootContentStoreDir();
        }
        return null;
    }

    @Override
    public Tenant getTenant(String tenantDomain) {
        if (!this.existsTenant(tenantDomain = this.getTenantDomain(tenantDomain))) {
            throw new AuthenticationException("Tenant does not exist: " + tenantDomain);
        }
        return new Tenant(tenantDomain, this.isEnabledTenant(tenantDomain), this.getRootContentStoreDir(tenantDomain));
    }

    @Override
    public void deleteTenant(String tenantDomain) {
        if (!this.existsTenant(tenantDomain = this.getTenantDomain(tenantDomain))) {
            throw new AuthenticationException("Tenant does not exist: " + tenantDomain);
        }
        try {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() {
                    List<RepoModelDefinition> models;
                    List<String> messageResourceBundles;
                    List<WorkflowDefinition> workflowDefs = MultiTAdminServiceImpl.this.workflowService.getDefinitions();
                    if (workflowDefs != null) {
                        for (WorkflowDefinition workflowDef : workflowDefs) {
                            MultiTAdminServiceImpl.this.workflowService.undeployDefinition(workflowDef.getId());
                        }
                    }
                    if ((messageResourceBundles = MultiTAdminServiceImpl.this.repoAdminService.getMessageBundles()) != null) {
                        for (String messageResourceBundle : messageResourceBundles) {
                            MultiTAdminServiceImpl.this.repoAdminService.undeployMessageBundle(messageResourceBundle);
                        }
                    }
                    if ((models = MultiTAdminServiceImpl.this.repoAdminService.getModels()) != null) {
                        for (RepoModelDefinition model : models) {
                            MultiTAdminServiceImpl.this.repoAdminService.undeployModel(model.getRepoName());
                        }
                    }
                    return null;
                }
            }, (String)this.getSystemUser(tenantDomain));
            String tenantAdminUser = this.getTenantAdminUser(tenantDomain);
            this.nodeService.deleteStore(this.tenantService.getName(tenantAdminUser, new StoreRef(PROTOCOL_STORE_WORKSPACE, STORE_BASE_ID_SPACES)));
            this.nodeService.deleteStore(this.tenantService.getName(tenantAdminUser, new StoreRef(PROTOCOL_STORE_ARCHIVE, STORE_BASE_ID_SPACES)));
            this.nodeService.deleteStore(this.tenantService.getName(tenantAdminUser, new StoreRef(PROTOCOL_STORE_WORKSPACE, STORE_BASE_ID_VERSION1)));
            this.nodeService.deleteStore(this.tenantService.getName(tenantAdminUser, new StoreRef(PROTOCOL_STORE_WORKSPACE, STORE_BASE_ID_VERSION2)));
            this.nodeService.deleteStore(this.tenantService.getName(tenantAdminUser, new StoreRef("system", "system")));
            this.nodeService.deleteStore(this.tenantService.getName(tenantAdminUser, new StoreRef(PROTOCOL_STORE_USER, STORE_BASE_ID_USER)));
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() {
                    for (TenantDeployer tenantDeployer : MultiTAdminServiceImpl.this.tenantDeployers) {
                        tenantDeployer.onDisableTenant();
                    }
                    return null;
                }
            }, (String)this.getSystemUser(tenantDomain));
            this.tenantAdminDAO.deleteTenant(tenantDomain);
        }
        catch (Throwable t) {
            throw new AlfrescoRuntimeException("Failed to delete tenant: " + tenantDomain, t);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Tenant deleted: " + tenantDomain));
        }
    }

    @Override
    public List<Tenant> getAllTenants() {
        List<TenantEntity> tenantEntities = this.tenantAdminDAO.listTenants();
        ArrayList<Tenant> tenants = new ArrayList<Tenant>(tenantEntities.size());
        for (TenantEntity tenantEntity : tenantEntities) {
            tenants.add(new Tenant(tenantEntity.getTenantDomain(), tenantEntity.getEnabled().booleanValue(), tenantEntity.getContentRoot()));
        }
        return tenants;
    }

    private void importBootstrapSystemTenantStore(String tenantDomain, File directorySource) {
        Properties bootstrapView = new Properties();
        bootstrapView.put("path", "/");
        bootstrapView.put("location", directorySource.getPath() + "/" + tenantDomain + "_system.acp");
        ArrayList<Properties> bootstrapViews = new ArrayList<Properties>(1);
        bootstrapViews.add(bootstrapView);
        ImporterBootstrap systemImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("systemBootstrap"));
        systemImporterBootstrap.setBootstrapViews(bootstrapViews);
        this.bootstrapSystemTenantStore(systemImporterBootstrap, tenantDomain);
    }

    private void bootstrapSystemTenantStore(ImporterBootstrap systemImporterBootstrap, String tenantDomain) {
        StoreRef bootstrapStoreRef = systemImporterBootstrap.getStoreRef();
        StoreRef tenantBootstrapStoreRef = new StoreRef(bootstrapStoreRef.getProtocol(), this.tenantService.getName(bootstrapStoreRef.getIdentifier(), tenantDomain));
        systemImporterBootstrap.setStoreUrl(tenantBootstrapStoreRef.toString());
        ArrayList<String> mustNotExistStoreUrls = new ArrayList<String>();
        mustNotExistStoreUrls.add(new StoreRef(PROTOCOL_STORE_WORKSPACE, this.tenantService.getName(STORE_BASE_ID_USER, tenantDomain)).toString());
        systemImporterBootstrap.setMustNotExistStoreUrls(mustNotExistStoreUrls);
        systemImporterBootstrap.bootstrap();
        systemImporterBootstrap.setStoreUrl(bootstrapStoreRef.toString());
        logger.debug((Object)("Bootstrapped store: " + this.tenantService.getBaseName(tenantBootstrapStoreRef)));
    }

    private void importBootstrapUserTenantStore(String tenantDomain, File directorySource) {
        Properties bootstrapView = new Properties();
        bootstrapView.put("path", "/");
        bootstrapView.put("location", directorySource.getPath() + "/" + tenantDomain + "_users.acp");
        ArrayList<Properties> bootstrapViews = new ArrayList<Properties>(1);
        bootstrapViews.add(bootstrapView);
        ImporterBootstrap userImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("userBootstrap"));
        userImporterBootstrap.setBootstrapViews(bootstrapViews);
        this.bootstrapUserTenantStore(userImporterBootstrap, tenantDomain, null);
    }

    private void bootstrapUserTenantStore(ImporterBootstrap userImporterBootstrap, String tenantDomain, char[] tenantAdminRawPassword) {
        StoreRef bootstrapStoreRef = userImporterBootstrap.getStoreRef();
        bootstrapStoreRef = new StoreRef(bootstrapStoreRef.getProtocol(), this.tenantService.getName(bootstrapStoreRef.getIdentifier(), tenantDomain));
        userImporterBootstrap.setStoreUrl(bootstrapStoreRef.toString());
        Properties props = userImporterBootstrap.getConfiguration();
        props.put("alfresco_user_store.adminusername", this.getTenantAdminUser(tenantDomain));
        if (tenantAdminRawPassword != null) {
            Object salt = null;
            props.put("alfresco_user_store.adminpassword", this.passwordEncoder.encodePassword(new String(tenantAdminRawPassword), salt));
        }
        userImporterBootstrap.bootstrap();
        logger.debug((Object)("Bootstrapped store: " + this.tenantService.getBaseName(bootstrapStoreRef)));
    }

    private void importBootstrapVersionTenantStore(String tenantDomain, File directorySource) {
        Properties bootstrapView = new Properties();
        bootstrapView.put("path", "/");
        bootstrapView.put("location", directorySource.getPath() + "/" + tenantDomain + "_versions2.acp");
        ArrayList<Properties> bootstrapViews = new ArrayList<Properties>(1);
        bootstrapViews.add(bootstrapView);
        ImporterBootstrap versionImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("versionBootstrap"));
        versionImporterBootstrap.setBootstrapViews(bootstrapViews);
        this.bootstrapVersionTenantStore(versionImporterBootstrap, tenantDomain);
    }

    private void bootstrapVersionTenantStore(ImporterBootstrap versionImporterBootstrap, String tenantDomain) {
        StoreRef bootstrapStoreRef = versionImporterBootstrap.getStoreRef();
        bootstrapStoreRef = new StoreRef(bootstrapStoreRef.getProtocol(), this.tenantService.getName(bootstrapStoreRef.getIdentifier(), tenantDomain));
        versionImporterBootstrap.setStoreUrl(bootstrapStoreRef.toString());
        versionImporterBootstrap.bootstrap();
        logger.debug((Object)("Bootstrapped store: " + this.tenantService.getBaseName(bootstrapStoreRef)));
    }

    private void importBootstrapSpacesArchiveTenantStore(String tenantDomain, File directorySource) {
        Properties bootstrapView = new Properties();
        bootstrapView.put("path", "/");
        bootstrapView.put("location", directorySource.getPath() + "/" + tenantDomain + "_spaces_archive.acp");
        ArrayList<Properties> bootstrapViews = new ArrayList<Properties>(1);
        bootstrapViews.add(bootstrapView);
        ImporterBootstrap spacesArchiveImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("spacesArchiveBootstrap"));
        spacesArchiveImporterBootstrap.setBootstrapViews(bootstrapViews);
        this.bootstrapSpacesArchiveTenantStore(spacesArchiveImporterBootstrap, tenantDomain);
    }

    private void bootstrapSpacesArchiveTenantStore(ImporterBootstrap spacesArchiveImporterBootstrap, String tenantDomain) {
        StoreRef bootstrapStoreRef = spacesArchiveImporterBootstrap.getStoreRef();
        bootstrapStoreRef = new StoreRef(bootstrapStoreRef.getProtocol(), this.tenantService.getName(bootstrapStoreRef.getIdentifier(), tenantDomain));
        spacesArchiveImporterBootstrap.setStoreUrl(bootstrapStoreRef.toString());
        ArrayList<String> mustNotExistStoreUrls = new ArrayList<String>();
        mustNotExistStoreUrls.add(bootstrapStoreRef.toString());
        spacesArchiveImporterBootstrap.setMustNotExistStoreUrls(mustNotExistStoreUrls);
        spacesArchiveImporterBootstrap.bootstrap();
        logger.debug((Object)("Bootstrapped store: " + this.tenantService.getBaseName(bootstrapStoreRef)));
    }

    private void importBootstrapSpacesModelsTenantStore(String tenantDomain, File directorySource) {
        Properties bootstrapView = new Properties();
        bootstrapView.put("path", "/");
        bootstrapView.put("location", directorySource.getPath() + "/" + tenantDomain + "_models.acp");
        ArrayList<Properties> bootstrapViews = new ArrayList<Properties>(1);
        bootstrapViews.add(bootstrapView);
        ImporterBootstrap spacesImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("spacesBootstrap"));
        spacesImporterBootstrap.setBootstrapViews(bootstrapViews);
        this.bootstrapSpacesTenantStore(spacesImporterBootstrap, tenantDomain);
    }

    private void importBootstrapSpacesTenantStore(String tenantDomain, File directorySource) {
        Properties bootstrapView = new Properties();
        bootstrapView.put("path", "/");
        bootstrapView.put("location", directorySource.getPath() + "/" + tenantDomain + "_spaces.acp");
        bootstrapView.put("uuidBinding", "UPDATE_EXISTING");
        ArrayList<Properties> bootstrapViews = new ArrayList<Properties>(1);
        bootstrapViews.add(bootstrapView);
        ImporterBootstrap spacesImporterBootstrap = (ImporterBootstrap)((Object)this.ctx.getBean("spacesBootstrap"));
        spacesImporterBootstrap.setBootstrapViews(bootstrapViews);
        spacesImporterBootstrap.setUseExistingStore(true);
        this.bootstrapSpacesTenantStore(spacesImporterBootstrap, tenantDomain);
    }

    private void bootstrapSpacesTenantStore(ImporterBootstrap spacesImporterBootstrap, String tenantDomain) {
        StoreRef bootstrapStoreRef = spacesImporterBootstrap.getStoreRef();
        bootstrapStoreRef = new StoreRef(bootstrapStoreRef.getProtocol(), this.tenantService.getName(bootstrapStoreRef.getIdentifier(), tenantDomain));
        spacesImporterBootstrap.setStoreUrl(bootstrapStoreRef.toString());
        Properties props = spacesImporterBootstrap.getConfiguration();
        props.put("alfresco_user_store.adminusername", this.getTenantAdminUser(tenantDomain));
        props.put("alfresco_user_store.guestusername", this.getTenantGuestUser(tenantDomain));
        spacesImporterBootstrap.bootstrap();
        UserUsageTrackingComponent userUsageTrackingComponent = (UserUsageTrackingComponent)this.ctx.getBean("userUsageTrackingComponent");
        userUsageTrackingComponent.bootstrapInternal();
        logger.debug((Object)("Bootstrapped store: " + this.tenantService.getBaseName(bootstrapStoreRef)));
    }

    @Override
    public void deployTenants(final TenantDeployer deployer, Log logger) {
        if (deployer == null) {
            throw new AlfrescoRuntimeException("Deployer must be provided");
        }
        if (logger == null) {
            throw new AlfrescoRuntimeException("Logger must be provided");
        }
        if (this.tenantService.isEnabled()) {
            UserTransaction userTransaction = this.transactionService.getUserTransaction();
            this.authenticationContext.setSystemUserAsCurrentUser();
            List<Tenant> tenants = null;
            try {
                userTransaction.begin();
                tenants = this.getAllTenants();
                userTransaction.commit();
            }
            catch (Throwable e) {
                try {
                    if (userTransaction != null) {
                        userTransaction.rollback();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new AlfrescoRuntimeException("Failed to get tenants", e);
            }
            finally {
                this.authenticationContext.clearCurrentSecurityContext();
            }
            for (Tenant tenant : tenants) {
                if (!tenant.isEnabled()) continue;
                try {
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                        public Object doWork() {
                            deployer.init();
                            return null;
                        }
                    }, (String)this.getSystemUser(tenant.getTenantDomain()));
                }
                catch (Throwable e) {
                    logger.error((Object)("Deployment failed" + e));
                    StringWriter stringWriter = new StringWriter();
                    e.printStackTrace(new PrintWriter(stringWriter));
                    logger.error((Object)stringWriter.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeployTenants(final TenantDeployer deployer, Log logger) {
        if (deployer == null) {
            throw new AlfrescoRuntimeException("Deployer must be provided");
        }
        if (logger == null) {
            throw new AlfrescoRuntimeException("Logger must be provided");
        }
        if (this.tenantService.isEnabled()) {
            UserTransaction userTransaction = this.transactionService.getUserTransaction();
            this.authenticationContext.setSystemUserAsCurrentUser();
            List<Tenant> tenants = null;
            try {
                userTransaction.begin();
                tenants = this.getAllTenants();
                userTransaction.commit();
            }
            catch (Throwable e) {
                try {
                    if (userTransaction != null) {
                        userTransaction.rollback();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    this.authenticationContext.clearCurrentSecurityContext();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new AlfrescoRuntimeException("Failed to get tenants", e);
            }
            try {
                AuthenticationUtil.pushAuthentication();
                for (Tenant tenant : tenants) {
                    if (!tenant.isEnabled()) continue;
                    try {
                        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                            public Object doWork() {
                                deployer.destroy();
                                return null;
                            }
                        }, (String)this.getSystemUser(tenant.getTenantDomain()));
                    }
                    catch (Throwable e) {
                        logger.error((Object)("Undeployment failed" + e));
                        StringWriter stringWriter = new StringWriter();
                        e.printStackTrace(new PrintWriter(stringWriter));
                        logger.error((Object)stringWriter.toString());
                    }
                }
            }
            finally {
                AuthenticationUtil.popAuthentication();
            }
        }
    }

    @Override
    public void register(TenantDeployer deployer) {
        this.register(deployer, -1);
    }

    protected void register(TenantDeployer deployer, int position) {
        if (deployer == null) {
            throw new AlfrescoRuntimeException("Deployer must be provided");
        }
        if (!this.tenantDeployers.contains(deployer)) {
            if (position == -1) {
                this.tenantDeployers.add(deployer);
            } else {
                this.tenantDeployers.add(position, deployer);
            }
        }
    }

    @Override
    public void unregister(TenantDeployer deployer) {
        if (deployer == null) {
            throw new AlfrescoRuntimeException("TenantDeployer must be provided");
        }
        if (this.tenantDeployers != null) {
            this.tenantDeployers.remove(deployer);
        }
    }

    @Override
    public void register(WorkflowDeployer workflowDeployer) {
        if (workflowDeployer == null) {
            throw new AlfrescoRuntimeException("WorkflowDeployer must be provided");
        }
        if (!this.workflowDeployers.contains((Object)workflowDeployer)) {
            this.workflowDeployers.add(workflowDeployer);
        }
    }

    public void resetCache(String tenantDomain) {
        if (this.existsTenant(tenantDomain)) {
            if (this.isEnabledTenant(tenantDomain)) {
                this.enableTenant(tenantDomain);
            } else {
                this.disableTenant(tenantDomain);
            }
        } else {
            throw new AuthenticationException("No such tenant " + tenantDomain);
        }
    }

    private void initTenant(String tenantDomain, String rootContentStoreDir) {
        this.validateTenantName(tenantDomain);
        if (this.existsTenant(tenantDomain)) {
            throw new AlfrescoRuntimeException("Tenant already exists: " + tenantDomain);
        }
        if (rootContentStoreDir != null) {
            if (!(this.tenantFileContentStore instanceof AbstractTenantRoutingContentStore)) {
                throw new AlfrescoRuntimeException("MT: cannot initialse tenant - TenantRoutingContentStore is not configured AND tenant is not using co-mingled content store (ie. default root location)");
            }
            File tenantRootDir = new File(rootContentStoreDir);
            if (tenantRootDir.exists() && tenantRootDir.list().length != 0) {
                logger.warn((Object)("Tenant root directory is not empty: " + rootContentStoreDir));
            }
        }
        if (rootContentStoreDir == null) {
            rootContentStoreDir = this.tenantFileContentStore.getRootLocation();
        }
        TenantEntity tenantEntity = new TenantEntity(tenantDomain);
        tenantEntity.setEnabled(true);
        tenantEntity.setContentRoot(rootContentStoreDir);
        this.tenantAdminDAO.createTenant(tenantEntity);
    }

    private void validateTenantName(String tenantDomain) {
        ParameterCheck.mandatory((String)"tenantDomain", (Object)tenantDomain);
        if (tenantDomain.length() > 75) {
            throw new IllegalArgumentException(tenantDomain + " is not a valid tenant name (must be less than " + 75 + " characters)");
        }
        if (!Pattern.matches(REGEX_CONTAINS_ALPHA, tenantDomain)) {
            throw new IllegalArgumentException(tenantDomain + " is not a valid tenant name (must contain at least one alpha character)");
        }
        String[] dnsLabels = tenantDomain.split("\\.");
        if (dnsLabels.length != 0) {
            for (int i = 0; i < dnsLabels.length; ++i) {
                if (Pattern.matches(REGEX_VALID_DNS_LABEL, dnsLabels[i])) continue;
                throw new IllegalArgumentException(dnsLabels[i] + " is not a valid DNS label (must match " + REGEX_VALID_DNS_LABEL + ")");
            }
        } else if (!Pattern.matches(REGEX_VALID_DNS_LABEL, tenantDomain)) {
            throw new IllegalArgumentException(tenantDomain + " is not a valid DNS label (must match " + REGEX_VALID_DNS_LABEL + ")");
        }
    }

    public boolean isEnabled() {
        return this.tenantService.isEnabled();
    }

    public String getCurrentUserDomain() {
        return this.tenantService.getCurrentUserDomain();
    }

    public String getUserDomain(String username) {
        return this.tenantService.getUserDomain(username);
    }

    public String getBaseNameUser(String username) {
        return this.tenantService.getBaseNameUser(username);
    }

    public String getDomainUser(String baseUsername, String tenantDomain) {
        tenantDomain = this.getTenantDomain(tenantDomain);
        return this.tenantService.getDomainUser(baseUsername, tenantDomain);
    }

    public String getDomain(String name) {
        name = this.getTenantDomain(name);
        return this.tenantService.getDomain(name);
    }

    public String getBaseAdminUser() {
        if (this.baseAdminUsername != null) {
            return this.baseAdminUsername;
        }
        return this.getBaseNameUser(AuthenticationUtil.getAdminUserName());
    }

    private String getSystemUser(String tenantDomain) {
        return this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain);
    }

    private String getTenantAdminUser(String tenantDomain) {
        return this.tenantService.getDomainUser(this.getBaseAdminUser(), tenantDomain);
    }

    private String getTenantGuestUser(String tenantDomain) {
        return this.authenticationContext.getGuestUserName(tenantDomain);
    }

    protected String getTenantDomain(String tenantDomain) {
        ParameterCheck.mandatory((String)"tenantDomain", (Object)tenantDomain);
        return tenantDomain.toLowerCase(I18NUtil.getLocale());
    }
}

