/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import junit.framework.TestCase;
import org.alfresco.repo.tenant.MultiTNodeServiceInterceptor;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.springframework.context.ApplicationContext;

public class MultiTNodeServiceInterceptorTest
extends TestCase {
    public static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private String tenant1 = "tenant-" + GUID.generate();
    private String tenant1Pwd = "pwd1";
    private boolean enableTest = true;
    private TransactionService transactionService;
    private TenantAdminService tenantAdminService;
    private TenantService tenantService;
    private MultiTNodeServiceInterceptor interceptor;

    public void setUp() throws Exception {
        this.transactionService = (TransactionService)ctx.getBean("TransactionService");
        this.tenantAdminService = (TenantAdminService)ctx.getBean("tenantAdminService");
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        this.interceptor = (MultiTNodeServiceInterceptor)((Object)ctx.getBean("multiTNodeServiceInterceptor"));
        if (!this.tenantAdminService.isEnabled()) {
            this.enableTest = false;
            return;
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Object> createTenantCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                MultiTNodeServiceInterceptorTest.this.tenantAdminService.createTenant(MultiTNodeServiceInterceptorTest.this.tenant1, MultiTNodeServiceInterceptorTest.this.tenant1Pwd.toCharArray());
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(createTenantCallback, false, true);
    }

    public void tearDown() throws Exception {
        if (!this.tenantAdminService.isEnabled()) {
            return;
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Object> createTenantCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                MultiTNodeServiceInterceptorTest.this.tenantAdminService.deleteTenant(MultiTNodeServiceInterceptorTest.this.tenant1);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(createTenantCallback, false, true);
    }

    public void testSetUp() {
    }
}

