/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import org.alfresco.repo.security.authentication.AuthenticationUtil;

public class TenantUtil {
    public static <R> R runAsPrimaryTenant(final TenantRunAsWork<R> runAsWork, String user) {
        String runAsUser = AuthenticationUtil.getRunAsUser();
        if (runAsUser == null || runAsUser.equals(user)) {
            return TenantUtil.runAsWork(runAsWork);
        }
        return (R)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<R>(){

            public R doWork() {
                return TenantUtil.runAsWork(runAsWork);
            }
        }, (String)user);
    }

    public static <R> R runAsUserTenant(final TenantRunAsWork<R> runAsWork, String uid, final String tenantDomain) {
        return (R)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<R>(){

            public R doWork() {
                return TenantUtil.runAsTenant(runAsWork, tenantDomain);
            }
        }, (String)uid);
    }

    public static <R> R runAsTenant(final TenantRunAsWork<R> runAsWork, String tenantDomain) {
        if (TenantUtil.getCurrentDomain().equals(tenantDomain)) {
            return TenantUtil.runAsWork(runAsWork);
        }
        return (R)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<R>(){

            public R doWork() {
                return TenantUtil.runAsWork(runAsWork);
            }
        }, (String)(AuthenticationUtil.getRunAsUser() + "@" + tenantDomain));
    }

    public static <R> R runAsDefaultTenant(final TenantRunAsWork<R> runAsWork) {
        if (TenantUtil.getCurrentDomain().equals("")) {
            return TenantUtil.runAsWork(runAsWork);
        }
        return (R)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<R>(){

            public R doWork() {
                return TenantUtil.runAsWork(runAsWork);
            }
        }, (String)(AuthenticationUtil.getSystemUserName() + "@"));
    }

    public static <R> R runAsSystemTenant(final TenantRunAsWork<R> runAsWork, String tenantDomain) {
        StringBuffer systemUser = new StringBuffer().append(AuthenticationUtil.getSystemUserName());
        if (AuthenticationUtil.isMtEnabled()) {
            systemUser.append("@").append(tenantDomain);
        }
        return (R)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<R>(){

            public R doWork() {
                return TenantUtil.runAsWork(runAsWork);
            }
        }, (String)systemUser.toString());
    }

    private static <R> R runAsWork(TenantRunAsWork<R> runAsWork) {
        try {
            return runAsWork.doWork();
        }
        catch (Throwable exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException("Error during run as.", exception);
        }
    }

    public static String getCurrentDomain() {
        int idx;
        String runAsUser;
        if (AuthenticationUtil.isMtEnabled() && (runAsUser = AuthenticationUtil.getRunAsUser()) != null && (idx = runAsUser.lastIndexOf("@")) > 0 && idx < runAsUser.length() - 1) {
            return runAsUser.substring(idx + 1);
        }
        return "";
    }

    public static interface TenantRunAsWork<Result> {
        public Result doWork() throws Exception;
    }
}

