/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.util.GUID;

public class TransactionAwareSingleton<T>
extends TransactionListenerAdapter {
    private final String txnKey = GUID.generate();
    private final ReentrantReadWriteLock.ReadLock singletonReadLock;
    private final ReentrantReadWriteLock.WriteLock singletonWriteLock;
    private Object singletonValue;

    public TransactionAwareSingleton() {
        ReentrantReadWriteLock serverReadWriteLock = new ReentrantReadWriteLock();
        this.singletonReadLock = serverReadWriteLock.readLock();
        this.singletonWriteLock = serverReadWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue(Object value) {
        this.singletonWriteLock.lock();
        try {
            this.singletonValue = value;
        }
        finally {
            this.singletonWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValue() {
        this.singletonReadLock.lock();
        try {
            Object object = this.singletonValue;
            return object;
        }
        finally {
            this.singletonReadLock.unlock();
        }
    }

    public T get() {
        TransactionStorage storage = (TransactionStorage)AlfrescoTransactionSupport.getResource(this.txnKey);
        if (storage != null) {
            return (T)storage.newValue;
        }
        return (T)this.getValue();
    }

    public void put(T value) {
        TransactionStorage storage = (TransactionStorage)AlfrescoTransactionSupport.getResource(this.txnKey);
        if (storage == null) {
            storage = new TransactionStorage();
            AlfrescoTransactionSupport.bindResource(this.txnKey, storage);
            AlfrescoTransactionSupport.bindListener(this);
        }
        storage.newValue = value;
    }

    @Override
    public void afterCommit() {
        TransactionStorage storage = (TransactionStorage)AlfrescoTransactionSupport.getResource(this.txnKey);
        if (storage != null) {
            this.setValue(storage.newValue);
        }
    }

    private static class TransactionStorage {
        public Object newValue;

        private TransactionStorage() {
        }
    }
}

