/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.util.Random;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionAwareSingleton;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class TransactionAwareSingletonTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static Random rand = new Random();
    private TransactionAwareSingleton<Integer> singleton = new TransactionAwareSingleton();
    private static final Integer INTEGER_ONE = new Integer(1);
    private static final Integer INTEGER_TWO = new Integer(2);
    private TransactionService transactionService;
    private static final int THREAD_COUNT = 20;

    public void setUp() throws Exception {
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
    }

    public void testCommit() throws Throwable {
        UserTransaction txn = this.transactionService.getUserTransaction();
        try {
            txn.begin();
            this.singleton.put(INTEGER_ONE);
            this.check(INTEGER_ONE, true);
            this.check(null, false);
            txn.commit();
        }
        catch (Throwable e) {
            try {
                txn.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        this.check(INTEGER_ONE, true);
        this.check(INTEGER_ONE, false);
    }

    public void testRollback() throws Throwable {
        UserTransaction txn = this.transactionService.getUserTransaction();
        try {
            txn.begin();
            this.singleton.put(INTEGER_TWO);
            this.check(INTEGER_TWO, true);
            this.check(null, false);
            txn.rollback();
        }
        catch (Throwable e) {
            try {
                txn.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        this.check(null, true);
        this.check(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testThreadsCommit() throws Throwable {
        int i;
        TestThread[] threads = new TestThread[20];
        for (i = 0; i < 20; ++i) {
            TestThread thread = new TestThread(true);
            thread.start();
            threads[i] = thread;
        }
        for (i = 0; i < 20; ++i) {
            while (!threads[i].finished) {
                TransactionAwareSingletonTest transactionAwareSingletonTest = this;
                synchronized (transactionAwareSingletonTest) {
                    try {
                        ((Object)((Object)this)).wait(20L);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            if (threads[i].error == null) continue;
            throw threads[i].error;
        }
    }

    public void testThreadsRollback() throws Throwable {
        TestThread[] threads = new TestThread[20];
        for (int i = 0; i < 20; ++i) {
            TestThread thread = new TestThread(false);
            thread.start();
            threads[i] = thread;
        }
    }

    private void check(final Integer expected, boolean inTransaction) {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> checkWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                Integer actual = (Integer)TransactionAwareSingletonTest.this.singleton.get();
                if (expected == null) {
                    Assert.assertNull((String)("Expected null but got " + actual), (Object)actual);
                } else {
                    Assert.assertTrue((String)("Values don't match: " + expected + " != " + actual), (boolean)actual.equals(expected));
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(checkWork, false, !inTransaction);
    }

    private class TestThread
    extends Thread {
        private boolean finished = false;
        private Throwable error;
        private boolean commit;
        private Integer value = new Integer((int)System.nanoTime());

        public TestThread(boolean commit) {
            this.commit = commit;
        }

        @Override
        public synchronized void run() {
            UserTransaction txn = TransactionAwareSingletonTest.this.transactionService.getUserTransaction();
            try {
                txn.begin();
                TransactionAwareSingletonTest.this.singleton.put(this.value);
                try {
                    this.wait((long)(rand.nextDouble() * 1000.0) + 1L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                TransactionAwareSingletonTest.this.check(this.value, true);
                if (this.commit) {
                    txn.commit();
                } else {
                    txn.rollback();
                }
            }
            catch (Throwable e) {
                try {
                    txn.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.error = e;
            }
            if (!this.commit) {
                try {
                    TransactionAwareSingletonTest.this.check(null, false);
                }
                catch (Throwable e) {
                    this.error = e;
                }
            }
            this.finished = true;
        }
    }
}

