/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.apache.commons.lang.mutable.MutableInt;

public abstract class TransactionalResourceHelper {
    public static final int getCount(Object resourceKey) {
        MutableInt counter = (MutableInt)AlfrescoTransactionSupport.getResource(resourceKey);
        return counter == null ? 0 : counter.intValue();
    }

    public static final void resetCount(Object resourceKey) {
        AlfrescoTransactionSupport.unbindResource(resourceKey);
    }

    public static final int incrementCount(Object resourceKey) {
        MutableInt counter = (MutableInt)AlfrescoTransactionSupport.getResource(resourceKey);
        if (counter == null) {
            counter = new MutableInt(0);
            AlfrescoTransactionSupport.bindResource(resourceKey, counter);
        }
        counter.increment();
        return counter.intValue();
    }

    public static final int decrementCount(Object resourceKey, boolean allowNegative) {
        MutableInt counter = (MutableInt)AlfrescoTransactionSupport.getResource(resourceKey);
        if (counter == null) {
            counter = new MutableInt(0);
            AlfrescoTransactionSupport.bindResource(resourceKey, counter);
        }
        if (counter.intValue() > 0 || allowNegative) {
            counter.decrement();
        }
        return counter.intValue();
    }

    public static final boolean isResourcePresent(Object resourceKey) {
        Object resource = AlfrescoTransactionSupport.getResource(resourceKey);
        return resource != null;
    }

    public static final <K, V> Map<K, V> getMap(Object resourceKey) {
        HashMap map = (HashMap)AlfrescoTransactionSupport.getResource(resourceKey);
        if (map == null) {
            map = new HashMap(29);
            AlfrescoTransactionSupport.bindResource(resourceKey, map);
        }
        return map;
    }

    public static final <V> Set<V> getSet(Object resourceKey) {
        HashSet set = (HashSet)AlfrescoTransactionSupport.getResource(resourceKey);
        if (set == null) {
            set = new HashSet(29);
            AlfrescoTransactionSupport.bindResource(resourceKey, set);
        }
        return set;
    }

    public static final <V> TreeSet<V> getTreeSet(Object resourceKey) {
        TreeSet set = (TreeSet)AlfrescoTransactionSupport.getResource(resourceKey);
        if (set == null) {
            set = new TreeSet();
            AlfrescoTransactionSupport.bindResource(resourceKey, set);
        }
        return set;
    }

    public static final <V> List<V> getList(Object resourceKey) {
        ArrayList list = (ArrayList)AlfrescoTransactionSupport.getResource(resourceKey);
        if (list == null) {
            list = new ArrayList(29);
            AlfrescoTransactionSupport.bindResource(resourceKey, list);
        }
        return list;
    }
}

