/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.commons.httpclient.util.EncodingUtil;

public class ContentDataPart
extends PartBase {
    protected static final String FILE_NAME = "; filename=";
    private static final byte[] FILE_NAME_BYTES = EncodingUtil.getAsciiBytes((String)"; filename=");
    private ContentService contentService;
    private ContentData data;
    private String filename;

    public ContentDataPart(ContentService contentService, String partName, ContentData data) {
        super(partName, data.getMimetype(), data.getEncoding(), null);
        this.contentService = contentService;
        this.data = data;
        this.filename = partName;
    }

    protected void sendDispositionHeader(OutputStream out) throws IOException {
        super.sendDispositionHeader(out);
        if (this.filename != null) {
            out.write(FILE_NAME_BYTES);
            out.write(QUOTE_BYTES);
            out.write(EncodingUtil.getAsciiBytes((String)this.filename));
            out.write(QUOTE_BYTES);
        }
    }

    protected long lengthOfData() throws IOException {
        return this.data.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendData(OutputStream out) throws IOException {
        InputStream is = this.contentService.getRawReader(this.data.getContentUrl()).getContentInputStream();
        try {
            int len;
            byte[] tmp = new byte[4096];
            while ((len = is.read(tmp)) >= 0) {
                out.write(tmp, 0, len);
            }
        }
        finally {
            is.close();
        }
    }
}

