/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.AlienProcessor;
import org.alfresco.repo.transfer.ChangeCapturingProgressMonitor;
import org.alfresco.repo.transfer.ManifestProcessorFactory;
import org.alfresco.repo.transfer.TransferCommitTransactionListener;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferProgressMonitor;
import org.alfresco.repo.transfer.TransferVersionChecker;
import org.alfresco.repo.transfer.TransferVersionImpl;
import org.alfresco.repo.transfer.manifest.TransferManifestProcessor;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestReader;
import org.alfresco.repo.transfer.requisite.XMLTransferRequsiteWriter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.cmr.transfer.TransferServicePolicies;
import org.alfresco.service.cmr.transfer.TransferVersion;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.FileCopyUtils;
import org.xml.sax.helpers.DefaultHandler;

public class RepoTransferReceiverImpl
implements TransferReceiver,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnRestoreNodePolicy,
NodeServicePolicies.OnMoveNodePolicy,
ContentServicePolicies.OnContentUpdatePolicy {
    private static final Log log = LogFactory.getLog(RepoTransferReceiverImpl.class);
    private static final String MSG_FAILED_TO_CREATE_STAGING_FOLDER = "transfer_service.receiver.failed_to_create_staging_folder";
    private static final String MSG_ERROR_WHILE_STARTING = "transfer_service.receiver.error_start";
    private static final String MSG_TRANSFER_TEMP_FOLDER_NOT_FOUND = "transfer_service.receiver.temp_folder_not_found";
    private static final String MSG_TRANSFER_LOCK_UNAVAILABLE = "transfer_service.receiver.lock_unavailable";
    private static final String MSG_INBOUND_TRANSFER_FOLDER_NOT_FOUND = "transfer_service.receiver.record_folder_not_found";
    private static final String MSG_ERROR_WHILE_ENDING_TRANSFER = "transfer_service.receiver.error_ending_transfer";
    private static final String MSG_ERROR_WHILE_STAGING_SNAPSHOT = "transfer_service.receiver.error_staging_snapshot";
    private static final String MSG_ERROR_WHILE_STAGING_CONTENT = "transfer_service.receiver.error_staging_content";
    private static final String MSG_NO_SNAPSHOT_RECEIVED = "transfer_service.receiver.no_snapshot_received";
    private static final String MSG_ERROR_WHILE_COMMITTING_TRANSFER = "transfer_service.receiver.error_committing_transfer";
    private static final String MSG_ERROR_WHILE_GENERATING_REQUISITE = "transfer_service.receiver.error_generating_requisite";
    private static final String MSG_LOCK_TIMED_OUT = "transfer_service.receiver.lock_timed_out";
    private static final String MSG_LOCK_NOT_FOUND = "transfer_service.receiver.lock_not_found";
    private static final String MSG_TRANSFER_TO_SELF = "transfer_service.receiver.error.transfer_to_self";
    private static final String MSG_INCOMPATIBLE_VERSIONS = "transfer_service.incompatible_versions";
    private static final String SNAPSHOT_FILE_NAME = "snapshot.xml";
    private NodeService nodeService;
    private SearchService searchService;
    private TransactionService transactionService;
    private String transferLockFolderPath;
    private String inboundTransferRecordsPath;
    private String rootStagingDirectory;
    private String transferTempFolderPath;
    private ManifestProcessorFactory manifestProcessorFactory;
    private BehaviourFilter behaviourFilter;
    private ChangeCapturingProgressMonitor progressMonitor;
    private ActionService actionService;
    private TenantService tenantService;
    private RuleService ruleService;
    private PolicyComponent policyComponent;
    private DescriptorService descriptorService;
    private AlienProcessor alienProcessor;
    private JobLockService jobLockService;
    private TransferVersionChecker transferVersionChecker;
    private SimpleCache<String, NodeRef> singletonCache;
    private final String KEY_TRANSFER_TEMP_NODEREF = "key.transferTempFolder.noderef";
    private final String KEY_INBOUND_TRANSFER_RECORDS_NODEREF = "key.inboundTransferRecordsFolder.noderef";
    private ClassPolicyDelegate<TransferServicePolicies.BeforeStartInboundTransferPolicy> beforeStartInboundTransferDelegate;
    private ClassPolicyDelegate<TransferServicePolicies.OnStartInboundTransferPolicy> onStartInboundTransferDelegate;
    private ClassPolicyDelegate<TransferServicePolicies.OnEndInboundTransferPolicy> onEndInboundTransferDelegate;
    private Map<String, Lock> locks = new ConcurrentHashMap<String, Lock>();
    private long lockRefreshTime = 60000L;
    private int lockRetryCount = 2;
    private long lockRetryWait = 100L;
    private long lockTimeOut = 3600000L;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"ruleService", (Object)this.ruleService);
        PropertyCheck.mandatory((Object)this, (String)"actionService", (Object)this.actionService);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"tennantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"transferLockFolderPath", (Object)this.transferLockFolderPath);
        PropertyCheck.mandatory((Object)this, (String)"inboundTransferRecordsPath", (Object)this.inboundTransferRecordsPath);
        PropertyCheck.mandatory((Object)this, (String)"rootStagingDirectory", (Object)this.rootStagingDirectory);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"descriptorService", (Object)this.descriptorService);
        PropertyCheck.mandatory((Object)this, (String)"alienProcessor", (Object)this.alienProcessor);
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.getJobLockService());
        PropertyCheck.mandatory((Object)this, (String)"transferVersionChecker", (Object)this.getTransferVersionChecker());
        this.beforeStartInboundTransferDelegate = this.policyComponent.registerClassPolicy(TransferServicePolicies.BeforeStartInboundTransferPolicy.class);
        this.onStartInboundTransferDelegate = this.policyComponent.registerClassPolicy(TransferServicePolicies.OnStartInboundTransferPolicy.class);
        this.onEndInboundTransferDelegate = this.policyComponent.registerClassPolicy(TransferServicePolicies.OnEndInboundTransferPolicy.class);
        this.getPolicyComponent().bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, TransferModel.ASPECT_TRANSFERRED, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, TransferModel.ASPECT_TRANSFERRED, (Behaviour)new JavaBehaviour(this, "onContentUpdate", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, TransferModel.ASPECT_TRANSFERRED, (Behaviour)new JavaBehaviour(this, "onCopyTransferred", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, TransferModel.ASPECT_ALIEN, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, TransferModel.ASPECT_ALIEN, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.OnRestoreNodePolicy.QNAME, TransferModel.ASPECT_ALIEN, (Behaviour)new JavaBehaviour(this, "onRestoreNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, TransferModel.ASPECT_ALIEN, (Behaviour)new JavaBehaviour(this, "onMoveNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, TransferModel.ASPECT_ALIEN, (Behaviour)new JavaBehaviour(this, "onCopyAlien", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    @Override
    public File getStagingFolder(String transferId) {
        if (transferId == null) {
            throw new IllegalArgumentException("transferId = " + transferId);
        }
        NodeRef transferNodeRef = new NodeRef(transferId);
        String tempFolderPath = this.rootStagingDirectory + "/" + transferNodeRef.getId();
        File tempFolder = new File(tempFolderPath);
        if (!tempFolder.exists() && !tempFolder.mkdirs()) {
            tempFolder = null;
            throw new TransferException(MSG_FAILED_TO_CREATE_STAGING_FOLDER, new Object[]{transferId});
        }
        return tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef getTempFolder(String transferId) {
        NodeRef transferTempFolder;
        block8: {
            transferTempFolder = (NodeRef)this.singletonCache.get((Serializable)((Object)"key.transferTempFolder.noderef"));
            if (transferTempFolder == null) {
                ResultSet rs = null;
                try {
                    rs = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", this.transferTempFolderPath);
                    if (rs.length() > 0) {
                        transferTempFolder = rs.getNodeRef(0);
                        this.singletonCache.put((Serializable)((Object)"key.transferTempFolder.noderef"), (Object)transferTempFolder);
                        break block8;
                    }
                    throw new TransferException(MSG_TRANSFER_TEMP_FOLDER_NOT_FOUND, new Object[]{transferId, this.transferTempFolderPath});
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
        NodeRef transferNodeRef = new NodeRef(transferId);
        String tempTransferFolderName = transferNodeRef.getId();
        NodeRef tempFolderNode = null;
        QName folderName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)tempTransferFolderName);
        List tempChildren = this.nodeService.getChildAssocs(transferTempFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)folderName);
        if (tempChildren.isEmpty()) {
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_NAME, tempTransferFolderName);
            tempFolderNode = this.nodeService.createNode(transferTempFolder, ContentModel.ASSOC_CONTAINS, folderName, TransferModel.TYPE_TEMP_TRANSFER_STORE, props).getChildRef();
        } else {
            tempFolderNode = ((ChildAssociationRef)tempChildren.get(0)).getChildRef();
        }
        return tempFolderNode;
    }

    @Override
    public String start(String fromRepositoryId, boolean transferToSelf, TransferVersion fromVersion) {
        log.debug((Object)"Start transfer");
        this.checkTransfer(fromRepositoryId, transferToSelf);
        TransferVersion toVersion = this.getVersion();
        if (!this.getTransferVersionChecker().checkTransferVersions(fromVersion, toVersion)) {
            throw new TransferException(MSG_INCOMPATIBLE_VERSIONS, new Object[]{"None", fromVersion, toVersion});
        }
        String tenantDomain = this.tenantService.getUserDomain(AuthenticationUtil.getRunAsUser());
        String lockStr = tenantDomain.isEmpty() ? "transfer.server.default" : "transfer.server.tenant." + tenantDomain;
        QName lockQName = QName.createQName((String)"http://www.alfresco.org/model/transfer/1.0", (String)lockStr);
        Lock lock = new Lock(lockQName);
        try {
            TransferServicePolicies.BeforeStartInboundTransferPolicy beforeStartPolicy = this.beforeStartInboundTransferDelegate.get(TransferModel.TYPE_TRANSFER_RECORD);
            beforeStartPolicy.beforeStartInboundTransfer();
            lock.makeLock();
            String transferId = null;
            try {
                RetryingTransactionHelper txHelper = this.transactionService.getRetryingTransactionHelper();
                transferId = txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                    @Override
                    public String execute() throws Throwable {
                        NodeRef relatedTransferRecord = RepoTransferReceiverImpl.this.createTransferRecord();
                        String transferId = relatedTransferRecord.toString();
                        RepoTransferReceiverImpl.this.getTempFolder(transferId);
                        RepoTransferReceiverImpl.this.getStagingFolder(transferId);
                        TransferServicePolicies.OnStartInboundTransferPolicy onStartPolicy = (TransferServicePolicies.OnStartInboundTransferPolicy)RepoTransferReceiverImpl.this.onStartInboundTransferDelegate.get(TransferModel.TYPE_TRANSFER_RECORD);
                        onStartPolicy.onStartInboundTransfer(transferId);
                        return transferId;
                    }
                }, false, true);
            }
            catch (Exception e) {
                log.debug((Object)"Exception while staring transfer", (Throwable)e);
                log.debug((Object)"releasing lock - we never created the transfer id");
                lock.releaseLock();
                throw new TransferException(MSG_ERROR_WHILE_STARTING, e);
            }
            lock.transferId = transferId;
            this.locks.put(transferId, lock);
            log.info((Object)("transfer started:" + transferId));
            lock.enableLockTimeout();
            return transferId;
        }
        catch (LockAcquisitionException lae) {
            log.debug((Object)"transfer lock is already taken", (Throwable)((Object)lae));
            throw new TransferException(MSG_TRANSFER_LOCK_UNAVAILABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeRef createTransferRecord() {
        NodeRef inboundTransferRecordsFolder;
        block6: {
            log.debug((Object)"Receiver createTransferRecord");
            inboundTransferRecordsFolder = (NodeRef)this.singletonCache.get((Serializable)((Object)"key.inboundTransferRecordsFolder.noderef"));
            if (inboundTransferRecordsFolder == null) {
                log.debug((Object)("Trying to find transfer records folder: " + this.inboundTransferRecordsPath));
                ResultSet rs = null;
                try {
                    rs = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", this.inboundTransferRecordsPath);
                    if (rs.length() > 0) {
                        inboundTransferRecordsFolder = rs.getNodeRef(0);
                        this.singletonCache.put((Serializable)((Object)"key.inboundTransferRecordsFolder.noderef"), (Object)inboundTransferRecordsFolder);
                        log.debug((Object)("Found inbound transfer records folder: " + inboundTransferRecordsFolder));
                        break block6;
                    }
                    throw new TransferException(MSG_INBOUND_TRANSFER_FOLDER_NOT_FOUND, new Object[]{this.inboundTransferRecordsPath});
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSSZ");
        String timeNow = format.format(new Date());
        String name = timeNow + ".xml";
        QName recordName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)name);
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(ContentModel.PROP_NAME, name);
        props.put(TransferModel.PROP_PROGRESS_POSITION, 0);
        props.put(TransferModel.PROP_PROGRESS_ENDPOINT, 1);
        props.put(TransferModel.PROP_TRANSFER_STATUS, TransferProgress.Status.PRE_COMMIT.toString());
        log.debug((Object)("Creating transfer record with name: " + name));
        ChildAssociationRef assoc = this.nodeService.createNode(inboundTransferRecordsFolder, ContentModel.ASSOC_CONTAINS, recordName, TransferModel.TYPE_TRANSFER_RECORD, props);
        log.debug((Object)("<-createTransferRecord: " + assoc.getChildRef()));
        return assoc.getChildRef();
    }

    private void timeout(final String transferId) {
        log.info((Object)("Inbound Transfer has timed out transferId:" + transferId));
        final RetryingTransactionHelper.RetryingTransactionCallback<Void> timeoutCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TransferProgress progress = RepoTransferReceiverImpl.this.getProgressMonitor().getProgress(transferId);
                if (progress.getStatus().equals((Object)TransferProgress.Status.PRE_COMMIT)) {
                    log.warn((Object)("Inbound Transfer Lock Timeout - transferId:" + transferId));
                    RepoTransferReceiverImpl.this.locks.remove(transferId);
                    RepoTransferReceiverImpl.this.removeTempFolders(transferId);
                    Object[] msgParams = new Object[]{transferId};
                    RepoTransferReceiverImpl.this.getProgressMonitor().logException(transferId, "transfer timeout", (Throwable)((Object)new TransferException(RepoTransferReceiverImpl.MSG_LOCK_TIMED_OUT, msgParams)));
                    RepoTransferReceiverImpl.this.getProgressMonitor().updateStatus(transferId, TransferProgress.Status.ERROR);
                } else {
                    log.warn((Object)("Inbound Transfer Lock Timeout - already past PRE-COMMIT - do no cleanup transferId:" + transferId));
                }
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                RepoTransferReceiverImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction(timeoutCB, false, true);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public void end(String transferId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request to end transfer " + transferId));
        }
        if (transferId == null) {
            throw new IllegalArgumentException("transferId = null");
        }
        try {
            Lock lock = this.locks.get(transferId);
            if (lock != null) {
                log.debug((Object)("releasing lock:" + lock.lockToken));
                lock.releaseLock();
                this.locks.remove(transferId);
            }
            this.removeTempFolders(transferId);
            Set<NodeRef> createdNodes = Collections.emptySet();
            Set<NodeRef> updatedNodes = Collections.emptySet();
            Set<NodeRef> deletedNodes = Collections.emptySet();
            ChangeCapturingProgressMonitor.TransferChangesRecord changesRecord = this.progressMonitor.removeChangeRecord(transferId);
            if (changesRecord != null) {
                createdNodes = new HashSet<NodeRef>(changesRecord.getCreatedNodes());
                updatedNodes = new HashSet<NodeRef>(changesRecord.getUpdatedNodes());
                deletedNodes = new HashSet<NodeRef>(changesRecord.getDeletedNodes());
            }
            TransferServicePolicies.OnEndInboundTransferPolicy onEndPolicy = this.onEndInboundTransferDelegate.get(TransferModel.TYPE_TRANSFER_RECORD);
            onEndPolicy.onEndInboundTransfer(transferId, createdNodes, updatedNodes, deletedNodes);
        }
        catch (TransferException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransferException(MSG_ERROR_WHILE_ENDING_TRANSFER, new Object[]{transferId}, ex);
        }
    }

    private void removeTempFolders(String transferId) {
        NodeRef tempStoreNode = null;
        try {
            log.debug((Object)"Deleting temporary store node...");
            tempStoreNode = this.getTempFolder(transferId);
            this.nodeService.deleteNode(tempStoreNode);
            log.debug((Object)"Deleted temporary store node.");
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to delete temp store node for transfer id " + transferId + "\nTemp store noderef = " + tempStoreNode));
        }
        File stagingFolder = null;
        try {
            log.debug((Object)("delete staging folder " + transferId));
            stagingFolder = this.getStagingFolder(transferId);
            this.deleteFile(stagingFolder);
            log.debug((Object)"Staging folder deleted");
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to delete staging folder for transfer id " + transferId + "\nStaging folder = " + stagingFolder.toString()));
        }
    }

    @Override
    public void cancel(String transferId) throws TransferException {
        TransferProgress progress = this.getProgressMonitor().getProgress(transferId);
        this.getProgressMonitor().updateStatus(transferId, TransferProgress.Status.CANCELLED);
        if (progress.getStatus().equals((Object)TransferProgress.Status.PRE_COMMIT)) {
            this.end(transferId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String transferId) throws TransferException {
        Lock lock = this.checkLock(transferId);
        lock.enableLockTimeout();
    }

    private void deleteFile(File file) {
        File[] fileList;
        if (file.isDirectory() && (fileList = file.listFiles()) != null) {
            for (File currentFile : fileList) {
                this.deleteFile(currentFile);
            }
        }
        file.delete();
    }

    public Lock checkLock(String transferId) throws TransferException {
        if (transferId == null) {
            throw new IllegalArgumentException("nudgeLock: transferId = null");
        }
        Lock lock = this.locks.get(transferId);
        if (lock != null) {
            if (lock.isActive()) {
                lock.suspendLockTimeout();
                return lock;
            }
            log.debug((Object)"lock not active");
            throw new TransferException(MSG_LOCK_TIMED_OUT, new Object[]{transferId});
        }
        log.debug((Object)"lock not found");
        throw new TransferException(MSG_LOCK_NOT_FOUND, new Object[]{transferId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSnapshot(String transferId, InputStream openStream) throws TransferException {
        Lock lock = this.checkLock(transferId);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving snapshot for transferId =" + transferId));
            }
            File snapshotFile = new File(this.getStagingFolder(transferId), SNAPSHOT_FILE_NAME);
            try {
                if (snapshotFile.createNewFile()) {
                    FileCopyUtils.copy((InputStream)openStream, (OutputStream)new BufferedOutputStream(new FileOutputStream(snapshotFile)));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saved snapshot for transferId =" + transferId));
                }
            }
            catch (Exception ex) {
                throw new TransferException(MSG_ERROR_WHILE_STAGING_SNAPSHOT, new Object[]{transferId}, ex);
            }
        }
        finally {
            lock.enableLockTimeout();
        }
    }

    @Override
    public void saveContent(String transferId, String contentFileId, InputStream contentStream) throws TransferException {
        Lock lock = this.checkLock(transferId);
        try {
            File stagedFile = new File(this.getStagingFolder(transferId), contentFileId);
            if (stagedFile.createNewFile()) {
                FileCopyUtils.copy((InputStream)contentStream, (OutputStream)new BufferedOutputStream(new FileOutputStream(stagedFile)));
            }
        }
        catch (Exception ex) {
            throw new TransferException(MSG_ERROR_WHILE_STAGING_CONTENT, new Object[]{transferId, contentFileId}, ex);
        }
        finally {
            lock.enableLockTimeout();
        }
    }

    @Override
    public void commitAsync(String transferId) {
        Lock lock = this.checkLock(transferId);
        try {
            this.progressMonitor.updateStatus(transferId, TransferProgress.Status.COMMIT_REQUESTED);
            Action commitAction = this.actionService.createAction("commit-transfer");
            commitAction.setParameterValue("transfer-id", (Serializable)((Object)transferId));
            commitAction.setExecuteAsynchronously(true);
            this.actionService.executeAction(commitAction, new NodeRef(transferId));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registered transfer commit for asynchronous execution: " + transferId));
            }
        }
        catch (Exception error) {
            lock.enableLockTimeout();
            throw new TransferException(MSG_ERROR_WHILE_COMMITTING_TRANSFER, new Object[]{transferId}, error);
        }
    }

    @Override
    public void commit(final String transferId) throws TransferException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Committing transferId=" + transferId));
        }
        this.checkLock(transferId);
        boolean rulesEnabled = this.ruleService.isEnabled();
        this.ruleService.disableRules();
        try {
            this.checkLock(transferId);
            this.progressMonitor.updateStatus(transferId, TransferProgress.Status.COMMITTING);
            RetryingTransactionHelper.RetryingTransactionCallback<Object> commitWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute() throws Throwable {
                    AlfrescoTransactionSupport.bindListener(new TransferCommitTransactionListener(transferId, RepoTransferReceiverImpl.this));
                    List<TransferManifestProcessor> commitProcessors = RepoTransferReceiverImpl.this.manifestProcessorFactory.getCommitProcessors(RepoTransferReceiverImpl.this, transferId);
                    SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                    SAXParser parser = saxParserFactory.newSAXParser();
                    File snapshotFile = RepoTransferReceiverImpl.this.getSnapshotFile(transferId);
                    if (snapshotFile.exists()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Processing manifest file:" + snapshotFile.getAbsolutePath()));
                        }
                        for (TransferManifestProcessor processor : commitProcessors) {
                            XMLTransferManifestReader reader = new XMLTransferManifestReader(processor);
                            RepoTransferReceiverImpl.this.behaviourFilter.disableBehaviour();
                            try {
                                parser.parse(snapshotFile, (DefaultHandler)reader);
                            }
                            finally {
                                RepoTransferReceiverImpl.this.behaviourFilter.enableBehaviour();
                            }
                            parser.reset();
                        }
                    } else {
                        RepoTransferReceiverImpl.this.progressMonitor.logException(transferId, "Unable to start commit. No snapshot file received", (Throwable)((Object)new TransferException(RepoTransferReceiverImpl.MSG_NO_SNAPSHOT_RECEIVED, new Object[]{transferId})));
                    }
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction(commitWork, false, true);
            Throwable error = this.progressMonitor.getProgress(transferId).getError();
            if (error != null) {
                if (TransferException.class.isAssignableFrom(error.getClass())) {
                    throw (TransferException)((Object)error);
                }
                throw new TransferException(MSG_ERROR_WHILE_COMMITTING_TRANSFER, new Object[]{transferId}, error);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Commit success transferId=" + transferId));
            }
        }
        catch (Exception ex) {
            if (TransferException.class.isAssignableFrom(ex.getClass())) {
                throw (TransferException)((Object)ex);
            }
            throw new TransferException(MSG_ERROR_WHILE_COMMITTING_TRANSFER, ex);
        }
        finally {
            if (rulesEnabled) {
                this.ruleService.enableRules();
            }
            try {
                this.end(transferId);
            }
            catch (Exception ex) {
                log.error((Object)("Failed to clean up transfer. Lock may still be in place: " + transferId), (Throwable)ex);
            }
        }
    }

    @Override
    public TransferProgress getStatus(String transferId) throws TransferException {
        return this.getProgressMonitor().getProgress(transferId);
    }

    private File getSnapshotFile(String transferId) {
        return new File(this.getStagingFolder(transferId), SNAPSHOT_FILE_NAME);
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setSingletonCache(SimpleCache<String, NodeRef> singletonCache) {
        this.singletonCache = singletonCache;
    }

    public void setTransferLockFolderPath(String transferLockFolderPath) {
        this.transferLockFolderPath = transferLockFolderPath;
    }

    public void setTransferTempFolderPath(String transferTempFolderPath) {
        this.transferTempFolderPath = transferTempFolderPath;
    }

    public void setRootStagingDirectory(String rootStagingDirectory) {
        this.rootStagingDirectory = rootStagingDirectory;
    }

    public void setInboundTransferRecordsPath(String inboundTransferRecordsPath) {
        this.inboundTransferRecordsPath = inboundTransferRecordsPath;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setManifestProcessorFactory(ManifestProcessorFactory manifestProcessorFactory) {
        this.manifestProcessorFactory = manifestProcessorFactory;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    @Override
    public TransferProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(TransferProgressMonitor progressMonitor) {
        this.progressMonitor = new ChangeCapturingProgressMonitor(progressMonitor);
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public RuleService getRuleService() {
        return this.ruleService;
    }

    @Override
    public void generateRequsite(String transferId, OutputStream out) throws TransferException {
        log.debug((Object)("Generate Requsite for transfer:" + transferId));
        try {
            File snapshotFile = this.getSnapshotFile(transferId);
            if (snapshotFile.exists()) {
                log.debug((Object)"snapshot does exist");
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                SAXParser parser = saxParserFactory.newSAXParser();
                OutputStreamWriter dest = new OutputStreamWriter(out, "UTF-8");
                XMLTransferRequsiteWriter writer = new XMLTransferRequsiteWriter(dest);
                TransferManifestProcessor processor = this.manifestProcessorFactory.getRequsiteProcessor(this, transferId, writer);
                XMLTransferManifestReader reader = new XMLTransferManifestReader(processor);
                parser.parse(snapshotFile, (DefaultHandler)reader);
                dest.flush();
            }
            log.debug((Object)("Generate Requsite done transfer:" + transferId));
        }
        catch (Exception ex) {
            if (TransferException.class.isAssignableFrom(ex.getClass())) {
                throw (TransferException)((Object)ex);
            }
            throw new TransferException(MSG_ERROR_WHILE_GENERATING_REQUISITE, ex);
        }
    }

    @Override
    public InputStream getTransferReport(String transferId) {
        return this.progressMonitor.getLogInputStream(transferId);
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public PolicyComponent getPolicyComponent() {
        return this.policyComponent;
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        log.debug((Object)"on create child association to transferred node");
        String localRepositoryId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        this.alienProcessor.onCreateChild(childAssocRef, localRepositoryId, isNewNode);
    }

    @Override
    public void beforeDeleteNode(NodeRef deletedNodeRef) {
        log.debug((Object)"on delete node - need to check for transferred node");
        this.alienProcessor.beforeDeleteAlien(deletedNodeRef, null);
    }

    @Override
    public void onRestoreNode(ChildAssociationRef childAssocRef) {
        log.debug((Object)"on restore node");
        log.debug((Object)("restoredAssocRef:" + childAssocRef));
        this.alienProcessor.afterMoveAlien(childAssocRef);
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        log.debug((Object)"onMoveNode");
        log.debug((Object)("oldChildAssocRef:" + oldChildAssocRef));
        log.debug((Object)("newChildAssocRef:" + newChildAssocRef));
        NodeRef oldParentRef = oldChildAssocRef.getParentRef();
        NodeRef newParentRef = newChildAssocRef.getParentRef();
        if (newParentRef.equals((Object)oldParentRef)) {
            log.debug((Object)"old parent and new parent are the same - this is a rename, do nothing");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("moving node from oldParentRef:" + oldParentRef + " to:" + newParentRef));
            }
            this.alienProcessor.beforeDeleteAlien(newChildAssocRef.getChildRef(), oldChildAssocRef);
            this.alienProcessor.afterMoveAlien(newChildAssocRef);
        }
    }

    public CopyBehaviourCallback onCopyTransferred(QName classRef, CopyDetails copyDetails) {
        return TransferredAspectCopyBehaviourCallback.INSTANCE;
    }

    public CopyBehaviourCallback onCopyAlien(QName classRef, CopyDetails copyDetails) {
        return AlienAspectCopyBehaviourCallback.INSTANCE;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public DescriptorService getDescriptorService() {
        return this.descriptorService;
    }

    public void setAlienProcessor(AlienProcessor alienProcessor) {
        this.alienProcessor = alienProcessor;
    }

    public AlienProcessor getAlienProcessor() {
        return this.alienProcessor;
    }

    @Override
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        log.debug((Object)("on content update called:" + nodeRef));
        if (newContent) {
            log.debug((Object)("new content remove PROP_FROM_CONTENT from node:" + nodeRef));
            this.nodeService.setProperty(nodeRef, TransferModel.PROP_FROM_CONTENT, null);
        }
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public JobLockService getJobLockService() {
        return this.jobLockService;
    }

    public void setLockRetryCount(int lockRetryCount) {
        this.lockRetryCount = lockRetryCount;
    }

    public int getLockRetryCount() {
        return this.lockRetryCount;
    }

    public void setLockRetryWait(long lockRetryWait) {
        this.lockRetryWait = lockRetryWait;
    }

    public long getLockRetryWait() {
        return this.lockRetryWait;
    }

    public void setLockTimeOut(long lockTimeOut) {
        this.lockTimeOut = lockTimeOut;
    }

    public long getLockTimeOut() {
        return this.lockTimeOut;
    }

    public void setLockRefreshTime(long lockRefreshTime) {
        this.lockRefreshTime = lockRefreshTime;
    }

    public long getLockRefreshTime() {
        return this.lockRefreshTime;
    }

    private void checkTransfer(String fromRepository, boolean transferToSelf) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("checkTransfer fromRepository:" + fromRepository + ", transferToSelf:" + transferToSelf));
        }
        String localRepositoryId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        if (!transferToSelf) {
            if (fromRepository != null) {
                if (fromRepository.equalsIgnoreCase(localRepositoryId)) {
                    throw new TransferException(MSG_TRANSFER_TO_SELF);
                }
            } else {
                throw new TransferException("from repository id is missing");
            }
        }
    }

    public void setTransferVersionChecker(TransferVersionChecker transferVersionChecker) {
        this.transferVersionChecker = transferVersionChecker;
    }

    public TransferVersionChecker getTransferVersionChecker() {
        return this.transferVersionChecker;
    }

    @Override
    public TransferVersion getVersion() {
        Descriptor d = this.descriptorService.getServerDescriptor();
        return new TransferVersionImpl(d);
    }

    @Override
    public void setTransferRootNode(String rootFileSystem) {
    }

    private class Lock
    implements JobLockService.JobLockRefreshCallback {
        QName lockQName;
        String lockToken;
        String transferId;
        private boolean active = false;
        private boolean processing = false;
        long lastActive = System.currentTimeMillis();

        public Lock(QName lockQName) {
            this.lockQName = lockQName;
        }

        public synchronized void makeLock() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("makeLock" + this.lockQName));
            }
            this.lockToken = RepoTransferReceiverImpl.this.getJobLockService().getLock(this.lockQName, RepoTransferReceiverImpl.this.getLockRefreshTime(), RepoTransferReceiverImpl.this.getLockRetryWait(), RepoTransferReceiverImpl.this.getLockRetryCount());
            this.active = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("lock taken: name" + this.lockQName + " token:" + this.lockToken));
                log.debug((Object)("register lock callback, target lock refresh time :" + RepoTransferReceiverImpl.this.getLockRefreshTime()));
            }
            RepoTransferReceiverImpl.this.getJobLockService().refreshLock(this.lockToken, this.lockQName, RepoTransferReceiverImpl.this.getLockRefreshTime(), this);
            if (log.isDebugEnabled()) {
                log.debug((Object)"refreshLock callback registered");
            }
        }

        public synchronized void suspendLockTimeout() {
            log.debug((Object)"suspend lock called");
            if (!this.active) {
                log.debug((Object)"lock not active, throw timed out exception");
                throw new TransferException(RepoTransferReceiverImpl.MSG_LOCK_TIMED_OUT);
            }
            this.processing = true;
        }

        public synchronized void enableLockTimeout() {
            long now = System.currentTimeMillis();
            if (now > this.lastActive + 1000L) {
                this.lastActive = now;
                log.debug((Object)("start waiting : lastActive:" + this.lastActive));
            }
            this.processing = false;
        }

        public synchronized void releaseLock() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("transfer service about to releaseLock : " + this.lockQName));
            }
            if (this.active) {
                this.active = false;
                RepoTransferReceiverImpl.this.getJobLockService().releaseLock(this.lockToken, this.lockQName);
            }
        }

        @Override
        public synchronized boolean isActive() {
            long now = System.currentTimeMillis();
            if (this.active && !this.processing && now > this.lastActive + RepoTransferReceiverImpl.this.getLockTimeOut()) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("transfer service callback isActive: " + this.active));
            }
            return this.active;
        }

        @Override
        public synchronized void lockReleased() {
            if (this.active) {
                this.active = false;
                log.info((Object)("transfer service: lock has timed out, timeout :" + this.lockQName));
                RepoTransferReceiverImpl.this.timeout(this.transferId);
            }
        }
    }

    private static class AlienAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new AlienAspectCopyBehaviourCallback();

        private AlienAspectCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            return Collections.emptyMap();
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            return !classQName.equals((Object)TransferModel.ASPECT_ALIEN);
        }
    }

    private static class TransferredAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new TransferredAspectCopyBehaviourCallback();

        private TransferredAspectCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            return Collections.emptyMap();
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            return !classQName.equals((Object)TransferModel.ASPECT_TRANSFERRED);
        }
    }

    public class AsyncCommitCommand
    implements Runnable {
        private String transferId;
        private String runAsUser;

        public AsyncCommitCommand(String transferId) {
            this.transferId = transferId;
            this.runAsUser = AuthenticationUtil.getFullyAuthenticatedUser();
        }

        @Override
        public void run() {
            AuthenticationUtil.RunAsWork<Object> actionRunAs = new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    return RepoTransferReceiverImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() {
                            RepoTransferReceiverImpl.this.commit(AsyncCommitCommand.this.transferId);
                            return null;
                        }
                    }, false, true);
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)actionRunAs, (String)this.runAsUser);
        }
    }
}

