/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.RepoTransferReceiverImpl;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferProgressMonitor;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestWriter;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferServicePolicies;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.filters.StringInputStream;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class RepoTransferReceiverImplTest
extends BaseAlfrescoSpringTest {
    private static int fileCount = 0;
    private static final Log log = LogFactory.getLog(RepoTransferReceiverImplTest.class);
    private RepoTransferReceiverImpl receiver;
    private SearchService searchService;
    private String dummyContent;
    private byte[] dummyContentBytes;
    private NodeRef guestHome;
    private PolicyComponent policyComponent;

    public void runBare() throws Throwable {
        this.preventTransaction();
        super.runBare();
    }

    protected void onSetUp() throws Exception {
        super.onSetUp();
        System.out.println("java.io.tmpdir == " + System.getProperty("java.io.tmpdir"));
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.receiver = (RepoTransferReceiverImpl)this.getApplicationContext().getBean("transferReceiver");
        this.policyComponent = (PolicyComponent)this.getApplicationContext().getBean("policyComponent");
        this.searchService = (SearchService)this.getApplicationContext().getBean("searchService");
        this.dummyContent = "This is some dummy content.";
        this.dummyContentBytes = this.dummyContent.getBytes("UTF-8");
        this.setTransactionDefinition((TransactionDefinition)new DefaultTransactionDefinition(3));
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.startNewTransaction();
        String guestHomeQuery = "/app:company_home/app:guest_home";
        ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
        RepoTransferReceiverImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
        this.guestHome = guestHomeResult.getNodeRef(0);
        this.endTransaction();
    }

    public void testDelete() {
        log.debug((Object)"start testDelete");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        final String uuid = GUID.generate();
        class TestContext {
            ChildAssociationRef childAssoc;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            @Override
            public TestContext execute() throws Throwable {
                TestContext tc = new TestContext();
                ResultSet rs = RepoTransferReceiverImplTest.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", "/app:company_home");
                Assert.assertEquals((int)1, (int)rs.length());
                NodeRef companyHome = rs.getNodeRef(0);
                HashMap<QName, String> props = new HashMap<QName, String>();
                props.put(ContentModel.PROP_NAME, uuid);
                tc.childAssoc = RepoTransferReceiverImplTest.this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)uuid), ContentModel.TYPE_CONTENT, props);
                return tc;
            }
        };
        final TestContext tc = tran.doInTransaction(setupCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.nodeService.deleteNode(tc.childAssoc.getChildRef());
                return null;
            }
        };
        tran.doInTransaction(deleteCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                log.debug((Object)"Test that original node no longer exists...");
                Assert.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.childAssoc.getChildRef()));
                log.debug((Object)"PASS - Original node no longer exists.");
                NodeRef archiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, tc.childAssoc.getChildRef().getId());
                log.debug((Object)"Test that archive node exists...");
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(archiveNodeRef));
                log.debug((Object)"PASS - Archive node exists.");
                return null;
            }
        };
        tran.doInTransaction(validateCB, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_testStartAndEnd() throws Exception {
        log.debug((Object)"start testStartAndEnd");
        RetryingTransactionHelper trx = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute() throws Throwable {
                log.debug((Object)"about to call start");
                String transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                File stagingFolder = null;
                try {
                    System.out.println("TransferId == " + transferId);
                    stagingFolder = RepoTransferReceiverImplTest.this.receiver.getStagingFolder(transferId);
                    Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.receiver.getStagingFolder(transferId).exists());
                    NodeRef tempFolder = RepoTransferReceiverImplTest.this.receiver.getTempFolder(transferId);
                    Assert.assertNotNull((String)"tempFolder is null", (Object)tempFolder);
                    Thread.sleep(1000L);
                    try {
                        RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                        Assert.fail((String)"Successfully started twice!");
                    }
                    catch (TransferException ex) {
                        // empty catch block
                    }
                    Thread.sleep(300L);
                    try {
                        RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                        Assert.fail((String)"Successfully started twice!");
                    }
                    catch (TransferException ex) {
                        // empty catch block
                    }
                    try {
                        RepoTransferReceiverImplTest.this.receiver.end(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate()).toString());
                    }
                    catch (TransferException ex) {
                        // empty catch block
                    }
                }
                finally {
                    log.debug((Object)"about to call end");
                    RepoTransferReceiverImplTest.this.receiver.end(transferId);
                    if (stagingFolder != null) {
                        Assert.assertFalse((boolean)stagingFolder.exists());
                    }
                }
                return null;
            }
        };
        long oldRefreshTime = this.receiver.getLockRefreshTime();
        try {
            this.receiver.setLockRefreshTime(500L);
            for (int i = 0; i < 5; ++i) {
                log.info((Object)("test iteration:" + i));
                trx.doInTransaction(cb, false, true);
            }
        }
        finally {
            this.receiver.setLockRefreshTime(oldRefreshTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_testLockTimeout() throws Exception {
        log.info((Object)"start testLockTimeout");
        RetryingTransactionHelper trx = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> startWithoutAnythingElse = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                log.debug((Object)"about to call start");
                String transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> slowTransfer = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                log.debug((Object)"about to call start");
                String transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                Thread.sleep(1000L);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(transferId, null);
                Assert.fail((String)"did not timeout");
                return null;
            }
        };
        long lockRefreshTime = this.receiver.getLockRefreshTime();
        long lockTimeOut = this.receiver.getLockTimeOut();
        try {
            this.receiver.setLockRefreshTime(500L);
            this.receiver.setLockTimeOut(200L);
            for (int i = 0; i < 3; ++i) {
                log.info((Object)("test iteration:" + i));
                trx.doInTransaction(startWithoutAnythingElse, false, true);
                Thread.sleep(1000L);
            }
            try {
                trx.doInTransaction(slowTransfer, false, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            this.receiver.setLockRefreshTime(lockRefreshTime);
            this.receiver.setLockTimeOut(lockTimeOut);
        }
        log.info((Object)"end testLockTimeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveContent() throws Exception {
        log.info((Object)"start testSaveContent");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        this.startNewTransaction();
        try {
            String transferId = this.receiver.start("1234", true, this.receiver.getVersion());
            try {
                String contentId = "mytestcontent";
                this.receiver.saveContent(transferId, contentId, new ByteArrayInputStream(this.dummyContentBytes));
                File contentFile = new File(this.receiver.getStagingFolder(transferId), contentId);
                RepoTransferReceiverImplTest.assertTrue((boolean)contentFile.exists());
                RepoTransferReceiverImplTest.assertEquals((long)this.dummyContentBytes.length, (long)contentFile.length());
            }
            finally {
                this.receiver.end(transferId);
            }
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveSnapshot() throws Exception {
        log.info((Object)"start testSaveSnapshot");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        this.startNewTransaction();
        try {
            String transferId = this.receiver.start("1234", true, this.receiver.getVersion());
            File snapshotFile = null;
            try {
                TransferManifestNormalNode node = this.createContentNode();
                ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
                nodes.add(node);
                String snapshot = this.createSnapshot(nodes);
                this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                File stagingFolder = this.receiver.getStagingFolder(transferId);
                snapshotFile = new File(stagingFolder, "snapshot.xml");
                RepoTransferReceiverImplTest.assertTrue((boolean)snapshotFile.exists());
                RepoTransferReceiverImplTest.assertEquals((long)snapshot.getBytes("UTF-8").length, (long)snapshotFile.length());
            }
            finally {
                this.receiver.end(transferId);
                if (snapshotFile != null) {
                    RepoTransferReceiverImplTest.assertFalse((boolean)snapshotFile.exists());
                }
            }
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicCommit() throws Exception {
        log.info((Object)"start testBasicCommit");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            TransferManifestNode node = null;
            String transferId = null;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            @Override
            public TestContext execute() throws Throwable {
                TestContext tc = new TestContext();
                tc.node = RepoTransferReceiverImplTest.this.createContentNode();
                return tc;
            }
        };
        final TestContext tc = tran.doInTransaction(setupCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doPrepareCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
                nodes.add(tc.node);
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(nodes);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, tc.node.getUuid(), new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doCommitCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doEndCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.end(tc.transferId);
                return null;
            }
        };
        try {
            tran.doInTransaction(doPrepareCB, false, true);
            tran.doInTransaction(doCommitCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction(doEndCB, false, true);
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doValidateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.node.getNodeRef()));
                RepoTransferReceiverImplTest.this.nodeService.deleteNode(tc.node.getNodeRef());
                return null;
            }
        };
        tran.doInTransaction(doValidateCB, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoreComplexCommit() throws Exception {
        log.info((Object)"start testMoreComplexCommit");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            List<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
            TransferManifestNormalNode node1 = null;
            TransferManifestNormalNode node2 = null;
            TransferManifestNode node3 = null;
            TransferManifestNode node4 = null;
            TransferManifestNode node5 = null;
            TransferManifestNode node6 = null;
            TransferManifestNode node7 = null;
            TransferManifestNode node8 = null;
            TransferManifestNode node9 = null;
            TransferManifestNode node10 = null;
            TransferManifestNormalNode node11 = null;
            TransferManifestNode node12 = null;
            String transferId = null;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            @Override
            public TestContext execute() throws Throwable {
                TestContext tc = new TestContext();
                tc.node1 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node1);
                tc.node2 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node2);
                tc.node3 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node3);
                tc.node4 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node4);
                tc.node5 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node5);
                tc.node6 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node6);
                tc.node7 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node7);
                tc.node8 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node8);
                tc.node9 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node9);
                tc.node10 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node10);
                tc.node11 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node11);
                tc.node12 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node12);
                RepoTransferReceiverImplTest.this.associatePeers(tc.node1, tc.node2);
                RepoTransferReceiverImplTest.this.moveNode(tc.node2, tc.node11);
                return tc;
            }
        };
        final TestContext tc = tran.doInTransaction(setupCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doPrepareCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(tc.nodes);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                for (TransferManifestNode node : tc.nodes) {
                    RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, node.getUuid(), new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                }
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doCommitCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                log.info((Object)"testMoreComplexCommit - commit");
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                log.info((Object)"testMoreComplexCommit - commited");
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doEndCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.end(tc.transferId);
                return null;
            }
        };
        try {
            tran.doInTransaction(doPrepareCB, false, true);
            tran.doInTransaction(doCommitCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction(doEndCB, false, true);
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                log.info((Object)"testMoreComplexCommit - validate nodes");
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.getAspects(tc.node1.getNodeRef()).contains(ContentModel.ASPECT_ATTACHABLE));
                Assert.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.getSourceAssocs(tc.node2.getNodeRef(), (QNamePattern)ContentModel.ASSOC_ATTACHMENTS).isEmpty());
                for (TransferManifestNode node : tc.nodes) {
                    Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(node.getNodeRef()));
                }
                return null;
            }
        };
        tran.doInTransaction(validateCB, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeDeleteAndRestore() throws Exception {
        log.info((Object)"start testNodeDeleteAndRestore");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        final TransferServicePolicies.OnEndInboundTransferPolicy mockedPolicyHandler = (TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.mock(TransferServicePolicies.OnEndInboundTransferPolicy.class);
        this.policyComponent.bindClassBehaviour(TransferServicePolicies.OnEndInboundTransferPolicy.QNAME, TransferModel.TYPE_TRANSFER_RECORD, (Behaviour)new JavaBehaviour(mockedPolicyHandler, "onEndInboundTransfer", Behaviour.NotificationFrequency.EVERY_EVENT));
        class TestContext {
            String transferId;
            TransferManifestNormalNode node1;
            TransferManifestNormalNode node2;
            TransferManifestNode node3;
            TransferManifestNode node4;
            TransferManifestNode node5;
            TransferManifestNode node6;
            TransferManifestNode node7;
            TransferManifestNode node8;
            TransferManifestNode node9;
            TransferManifestNode node10;
            TransferManifestNormalNode node11;
            TransferManifestNode node12;
            TransferManifestDeletedNode deletedNode8;
            TransferManifestDeletedNode deletedNode2;
            TransferManifestDeletedNode deletedNode11;
            List<TransferManifestNode> nodes;
            String errorMsgId;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            @Override
            public TestContext execute() throws Throwable {
                TestContext tc = new TestContext();
                tc.nodes = new ArrayList<TransferManifestNode>();
                tc.node1 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node1);
                tc.node2 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node2);
                tc.node3 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node3);
                tc.node4 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node4);
                tc.node5 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node5);
                tc.node6 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node6);
                tc.node7 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node7);
                tc.node8 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node8);
                tc.node9 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node9);
                tc.node10 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node10);
                tc.node11 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node11);
                tc.node12 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node12);
                RepoTransferReceiverImplTest.this.associatePeers(tc.node1, tc.node2);
                RepoTransferReceiverImplTest.this.moveNode(tc.node2, tc.node11);
                tc.deletedNode8 = RepoTransferReceiverImplTest.this.createDeletedNode(tc.node8);
                tc.deletedNode2 = RepoTransferReceiverImplTest.this.createDeletedNode(tc.node2);
                tc.deletedNode11 = RepoTransferReceiverImplTest.this.createDeletedNode(tc.node11);
                return tc;
            }
        };
        final TestContext tc = tran.doInTransaction(setupCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doFirstPrepareCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(tc.nodes);
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                for (TransferManifestNode node : tc.nodes) {
                    RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, node.getUuid(), new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                }
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doCommitCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doEndCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.end(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateFirstCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.getAspects(tc.node1.getNodeRef()).contains(ContentModel.ASPECT_ATTACHABLE));
                Assert.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.getSourceAssocs(tc.node2.getNodeRef(), (QNamePattern)ContentModel.ASSOC_ATTACHMENTS).isEmpty());
                ArgumentCaptor transferIdCaptor = ArgumentCaptor.forClass(String.class);
                ArgumentCaptor createdNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ArgumentCaptor updatedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ArgumentCaptor deletedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ((TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.verify((Object)mockedPolicyHandler, (VerificationMode)Mockito.times((int)1))).onEndInboundTransfer((String)transferIdCaptor.capture(), (Set)createdNodesCaptor.capture(), (Set)updatedNodesCaptor.capture(), (Set)deletedNodesCaptor.capture());
                Assert.assertEquals((String)tc.transferId, (String)((String)transferIdCaptor.getValue()));
                Set capturedCreatedNodes = (Set)createdNodesCaptor.getValue();
                Assert.assertEquals((int)tc.nodes.size(), (int)capturedCreatedNodes.size());
                for (TransferManifestNode node : tc.nodes) {
                    Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(node.getNodeRef()));
                    Assert.assertTrue((boolean)capturedCreatedNodes.contains(node.getNodeRef()));
                }
                return null;
            }
        };
        Mockito.reset((Object[])new TransferServicePolicies.OnEndInboundTransferPolicy[]{mockedPolicyHandler});
        try {
            tran.doInTransaction(doFirstPrepareCB, false, true);
            tran.doInTransaction(doCommitCB, false, true);
            tran.doInTransaction(validateFirstCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction(doEndCB, false, true);
            }
        }
        Mockito.reset((Object[])new TransferServicePolicies.OnEndInboundTransferPolicy[]{mockedPolicyHandler});
        this.logger.debug((Object)"part 2 - transfer some deleted nodes");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doSecondPrepareCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(Arrays.asList(tc.deletedNode8, tc.deletedNode2, tc.deletedNode11));
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateSecondCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                ArgumentCaptor transferIdCaptor = ArgumentCaptor.forClass(String.class);
                ArgumentCaptor createdNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ArgumentCaptor updatedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ArgumentCaptor deletedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ((TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.verify((Object)mockedPolicyHandler, (VerificationMode)Mockito.times((int)1))).onEndInboundTransfer((String)transferIdCaptor.capture(), (Set)createdNodesCaptor.capture(), (Set)updatedNodesCaptor.capture(), (Set)deletedNodesCaptor.capture());
                Assert.assertEquals((String)tc.transferId, (String)((String)transferIdCaptor.getValue()));
                Set capturedDeletedNodes = (Set)deletedNodesCaptor.getValue();
                Assert.assertEquals((int)3, (int)capturedDeletedNodes.size());
                Assert.assertTrue((boolean)capturedDeletedNodes.contains(tc.deletedNode8.getNodeRef()));
                Assert.assertTrue((boolean)capturedDeletedNodes.contains(tc.deletedNode2.getNodeRef()));
                Assert.assertTrue((boolean)capturedDeletedNodes.contains(tc.deletedNode11.getNodeRef()));
                log.debug((Object)"Test success of transfer...");
                TransferProgress progress = RepoTransferReceiverImplTest.this.receiver.getProgressMonitor().getProgress(tc.transferId);
                Assert.assertEquals((Object)((Object)TransferProgress.Status.COMPLETE), (Object)((Object)progress.getStatus()));
                NodeRef archiveNode8 = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, tc.node8.getNodeRef().getId());
                NodeRef archiveNode2 = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, tc.node2.getNodeRef().getId());
                NodeRef archiveNode11 = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, tc.node11.getNodeRef().getId());
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(archiveNode8));
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.hasAspect(archiveNode8, ContentModel.ASPECT_ARCHIVED));
                log.debug((Object)("Successfully tested existence of archive node: " + archiveNode8));
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(archiveNode2));
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.hasAspect(archiveNode2, ContentModel.ASPECT_ARCHIVED));
                log.debug((Object)("Successfully tested existence of archive node: " + archiveNode2));
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(archiveNode11));
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.hasAspect(archiveNode11, ContentModel.ASPECT_ARCHIVED));
                log.debug((Object)("Successfully tested existence of archive node: " + archiveNode11));
                log.debug((Object)"Successfully tested existence of all archive nodes");
                log.debug((Object)("Testing existence of original node: " + tc.node8.getNodeRef()));
                Assert.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.node8.getNodeRef()));
                log.debug((Object)("Testing existence of original node: " + tc.node2.getNodeRef()));
                Assert.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.node2.getNodeRef()));
                log.debug((Object)("Testing existence of original node: " + tc.node11.getNodeRef()));
                Assert.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.node11.getNodeRef()));
                log.debug((Object)"Successfully tested non-existence of all original nodes");
                log.debug((Object)("Progress indication: " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
                return null;
            }
        };
        try {
            tran.doInTransaction(doSecondPrepareCB, false, true);
            tran.doInTransaction(doCommitCB, false, true);
            tran.doInTransaction(validateSecondCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction(doEndCB, false, true);
            }
        }
        this.logger.debug((Object)"part 3 - restore orphan node which should fail");
        System.out.println("Now try to restore orphan node 2.");
        Mockito.reset((Object[])new TransferServicePolicies.OnEndInboundTransferPolicy[]{mockedPolicyHandler});
        Object errorMsgId = null;
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doThirdPrepareCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(Arrays.asList(tc.node2));
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, tc.node2.getUuid(), new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doCommitExpectingFailCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                try {
                    RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                    Assert.fail((String)"Expected an exception");
                }
                catch (TransferException ex) {
                    tc.errorMsgId = ex.getMsgId();
                    ArgumentCaptor transferIdCaptor = ArgumentCaptor.forClass(String.class);
                    ArgumentCaptor createdNodesCaptor = ArgumentCaptor.forClass(Set.class);
                    ArgumentCaptor updatedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                    ArgumentCaptor deletedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                    ((TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.verify((Object)mockedPolicyHandler, (VerificationMode)Mockito.times((int)1))).onEndInboundTransfer((String)transferIdCaptor.capture(), (Set)createdNodesCaptor.capture(), (Set)updatedNodesCaptor.capture(), (Set)deletedNodesCaptor.capture());
                    Assert.assertEquals((String)tc.transferId, (String)((String)transferIdCaptor.getValue()));
                    Assert.assertTrue((boolean)((Set)createdNodesCaptor.getValue()).isEmpty());
                    Assert.assertTrue((boolean)((Set)updatedNodesCaptor.getValue()).isEmpty());
                    Assert.assertTrue((boolean)((Set)deletedNodesCaptor.getValue()).isEmpty());
                }
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateThirdCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                TransferProgress progress = RepoTransferReceiverImplTest.this.receiver.getProgressMonitor().getProgress(tc.transferId);
                Assert.assertEquals((Object)((Object)TransferProgress.Status.ERROR), (Object)((Object)progress.getStatus()));
                log.debug((Object)("Progress indication: " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
                Assert.assertNotNull((String)"Progress error", (Object)progress.getError());
                Assert.assertTrue((boolean)(progress.getError() instanceof Exception));
                Assert.assertTrue((String)tc.errorMsgId, (boolean)tc.errorMsgId.contains("orphan"));
                return null;
            }
        };
        try {
            tran.doInTransaction(doThirdPrepareCB, false, true);
            tran.doInTransaction(doCommitExpectingFailCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction(doEndCB, false, true);
            }
        }
        tran.doInTransaction(validateThirdCB, false, true);
        log.debug((Object)"start testNodeDeleteAndRestore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJira_ALF_2772() throws Exception {
        log.debug((Object)"start testJira_ALF_2772");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            TransferManifestNormalNode node1 = null;
            TransferManifestNormalNode node2 = null;
            TransferManifestNormalNode node11 = null;
            TransferManifestDeletedNode deletedNode11 = null;
            String transferId = null;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            @Override
            public TestContext execute() throws Throwable {
                TestContext tc = new TestContext();
                tc.node1 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.node2 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.node11 = RepoTransferReceiverImplTest.this.createFolderNode();
                RepoTransferReceiverImplTest.this.associatePeers(tc.node1, tc.node2);
                RepoTransferReceiverImplTest.this.moveNode(tc.node2, tc.node11);
                tc.deletedNode11 = RepoTransferReceiverImplTest.this.createDeletedNode(tc.node11);
                return tc;
            }
        };
        final TestContext tc = tran.doInTransaction(setupCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doEndCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.end(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doFirstCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                ArrayList<TransferManifestNormalNode> nodes = new ArrayList<TransferManifestNormalNode>();
                nodes.add(tc.node11);
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(nodes);
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                for (TransferManifestNode transferManifestNode : nodes) {
                    RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, transferManifestNode.getUuid(), new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                }
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                for (TransferManifestNode transferManifestNode : nodes) {
                    Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(transferManifestNode.getNodeRef()));
                }
                return null;
            }
        };
        try {
            tran.doInTransaction(doFirstCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction(doEndCB, false, true);
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doSecondCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(Arrays.asList(tc.deletedNode11));
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doValidateSecondCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                TransferProgress progress = RepoTransferReceiverImplTest.this.receiver.getProgressMonitor().getProgress(tc.transferId);
                Assert.assertEquals((Object)((Object)TransferProgress.Status.COMPLETE), (Object)((Object)progress.getStatus()));
                NodeRef archivedNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, tc.deletedNode11.getNodeRef().getId());
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(archivedNodeRef));
                Assert.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.hasAspect(archivedNodeRef, ContentModel.ASPECT_ARCHIVED));
                log.debug((Object)("Successfully tested existence of archive node: " + tc.deletedNode11.getNodeRef()));
                log.debug((Object)"Successfully tested existence of all archive nodes");
                log.debug((Object)("Testing existence of original node: " + tc.node11.getNodeRef()));
                Assert.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.node11.getNodeRef()));
                log.debug((Object)"Successfully tested non-existence of all original nodes");
                log.debug((Object)("Progress indication: " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
                return null;
            }
        };
        try {
            tran.doInTransaction(doSecondCB, false, true);
            tran.doInTransaction(doValidateSecondCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction(doEndCB, false, true);
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doThirdCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(Arrays.asList(tc.node2, tc.node11));
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, tc.node2.getUuid(), new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doValidateThirdCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                return null;
            }
        };
        try {
            tran.doInTransaction(doThirdCB, false, true);
            tran.doInTransaction(doValidateThirdCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction(doEndCB, false, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncCommit() throws Exception {
        log.info((Object)"start testAsyncCommit");
        this.setDefaultRollback(false);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        this.startNewTransaction();
        String transferId = this.receiver.start("1234", true, this.receiver.getVersion());
        this.endTransaction();
        this.startNewTransaction();
        ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
        TransferManifestNormalNode node1 = this.createContentNode();
        nodes.add(node1);
        TransferManifestNormalNode node2 = this.createContentNode();
        nodes.add(node2);
        TransferManifestNormalNode node3 = this.createContentNode();
        nodes.add(node3);
        TransferManifestNormalNode node4 = this.createContentNode();
        nodes.add(node4);
        TransferManifestNormalNode node5 = this.createContentNode();
        nodes.add(node5);
        TransferManifestNormalNode node6 = this.createContentNode();
        nodes.add(node6);
        TransferManifestNormalNode node7 = this.createContentNode();
        nodes.add(node7);
        TransferManifestNormalNode node8 = this.createFolderNode();
        nodes.add(node8);
        TransferManifestNormalNode node9 = this.createFolderNode();
        nodes.add(node9);
        TransferManifestNormalNode node10 = this.createFolderNode();
        nodes.add(node10);
        TransferManifestNormalNode node11 = this.createFolderNode();
        nodes.add(node11);
        TransferManifestNormalNode node12 = this.createFolderNode();
        nodes.add(node12);
        this.associatePeers(node1, node2);
        this.moveNode(node2, node11);
        this.endTransaction();
        String snapshot = this.createSnapshot(nodes);
        this.startNewTransaction();
        this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
        this.endTransaction();
        for (TransferManifestNode node : nodes) {
            this.startNewTransaction();
            this.receiver.saveContent(transferId, node.getUuid(), new ByteArrayInputStream(this.dummyContentBytes));
            this.endTransaction();
        }
        this.startNewTransaction();
        this.receiver.commitAsync(transferId);
        this.endTransaction();
        log.debug((Object)"Posted request for commit");
        TransferProgressMonitor progressMonitor = this.receiver.getProgressMonitor();
        TransferProgress progress = null;
        while (progress == null || !TransferProgress.getTerminalStatuses().contains((Object)progress.getStatus())) {
            Thread.sleep(500L);
            this.startNewTransaction();
            progress = progressMonitor.getProgress(transferId);
            this.endTransaction();
            log.debug((Object)("Progress indication: " + (Object)((Object)progress.getStatus()) + ": " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
        }
        RepoTransferReceiverImplTest.assertEquals((Object)((Object)TransferProgress.Status.COMPLETE), (Object)((Object)progress.getStatus()));
        this.startNewTransaction();
        try {
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.getAspects(node1.getNodeRef()).contains(ContentModel.ASPECT_ATTACHABLE));
            RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.getSourceAssocs(node2.getNodeRef(), (QNamePattern)ContentModel.ASSOC_ATTACHMENTS).isEmpty());
            for (TransferManifestNode node : nodes) {
                RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(node.getNodeRef()));
            }
        }
        finally {
            this.endTransaction();
        }
    }

    private TransferManifestDeletedNode createDeletedNode(TransferManifestNode nodeToDelete) {
        TransferManifestDeletedNode deletedNode = new TransferManifestDeletedNode();
        deletedNode.setNodeRef(nodeToDelete.getNodeRef());
        deletedNode.setParentPath(nodeToDelete.getParentPath());
        deletedNode.setPrimaryParentAssoc(nodeToDelete.getPrimaryParentAssoc());
        deletedNode.setUuid(nodeToDelete.getUuid());
        return deletedNode;
    }

    private void moveNode(TransferManifestNormalNode childNode, TransferManifestNormalNode newParent) {
        List<ChildAssociationRef> currentParents = childNode.getParentAssocs();
        ArrayList<ChildAssociationRef> newParents = new ArrayList<ChildAssociationRef>();
        for (ChildAssociationRef parent : currentParents) {
            if (!parent.isPrimary()) {
                newParents.add(parent);
                continue;
            }
            ChildAssociationRef newPrimaryAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, newParent.getNodeRef(), parent.getQName(), parent.getChildRef(), true, -1);
            newParents.add(newPrimaryAssoc);
            childNode.setPrimaryParentAssoc(newPrimaryAssoc);
            Path newParentPath = new Path();
            newParentPath.append(newParent.getParentPath());
            newParentPath.append((Path.Element)new Path.ChildAssocElement(newParent.getPrimaryParentAssoc()));
            childNode.setParentPath(newParentPath);
        }
        childNode.setParentAssocs(newParents);
    }

    private void associatePeers(TransferManifestNormalNode source, TransferManifestNormalNode target) {
        Set<QName> aspects;
        List<AssociationRef> currentRefereePeers;
        List<AssociationRef> currentReferencedPeers = source.getTargetAssocs();
        if (currentReferencedPeers == null) {
            currentReferencedPeers = new ArrayList<AssociationRef>();
            source.setTargetAssocs(currentReferencedPeers);
        }
        if ((currentRefereePeers = target.getSourceAssocs()) == null) {
            currentRefereePeers = new ArrayList<AssociationRef>();
            target.setSourceAssocs(currentRefereePeers);
        }
        if ((aspects = source.getAspects()) == null) {
            aspects = new HashSet<QName>();
            source.setAspects(aspects);
        }
        aspects.add(ContentModel.ASPECT_ATTACHABLE);
        AssociationRef newAssoc = new AssociationRef(null, source.getNodeRef(), ContentModel.ASSOC_ATTACHMENTS, target.getNodeRef());
        currentRefereePeers.add(newAssoc);
        currentReferencedPeers.add(newAssoc);
    }

    private String createSnapshot(List<TransferManifestNode> nodes) throws Exception {
        XMLTransferManifestWriter manifestWriter = new XMLTransferManifestWriter();
        StringWriter output = new StringWriter();
        manifestWriter.startTransferManifest(output);
        TransferManifestHeader header = new TransferManifestHeader();
        header.setCreatedDate(new Date());
        header.setNodeCount(nodes.size());
        header.setRepositoryId("repo 1");
        manifestWriter.writeTransferManifestHeader(header);
        for (TransferManifestNode node : nodes) {
            manifestWriter.writeTransferManifestNode(node);
        }
        manifestWriter.endTransferManifest();
        return output.toString();
    }

    private TransferManifestNormalNode createContentNode() throws Exception {
        TransferManifestNormalNode node = new TransferManifestNormalNode();
        String uuid = GUID.generate();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, uuid);
        node.setNodeRef(nodeRef);
        node.setUuid(uuid);
        byte[] dummyContent = "This is some dummy content.".getBytes("UTF-8");
        node.setType(ContentModel.TYPE_CONTENT);
        NodeRef parentFolder = this.guestHome;
        String nodeName = uuid + ".testnode" + this.getNameSuffix();
        ArrayList<ChildAssociationRef> parents = new ArrayList<ChildAssociationRef>();
        ChildAssociationRef primaryAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parentFolder, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName), node.getNodeRef(), true, -1);
        parents.add(primaryAssoc);
        node.setParentAssocs(parents);
        node.setParentPath(this.nodeService.getPath(parentFolder));
        node.setPrimaryParentAssoc(primaryAssoc);
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)uuid));
        props.put(ContentModel.PROP_NAME, (Serializable)((Object)nodeName));
        ContentData contentData = new ContentData("/" + uuid, "text/plain", (long)dummyContent.length, "UTF-8");
        props.put(ContentModel.PROP_CONTENT, (Serializable)contentData);
        node.setProperties(props);
        return node;
    }

    private TransferManifestNormalNode createFolderNode() throws Exception {
        NodeRef guestHome;
        TransferManifestNormalNode node = new TransferManifestNormalNode();
        String uuid = GUID.generate();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, uuid);
        node.setNodeRef(nodeRef);
        node.setUuid(uuid);
        node.setType(ContentModel.TYPE_FOLDER);
        String guestHomeQuery = "/app:company_home/app:guest_home";
        ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
        RepoTransferReceiverImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
        NodeRef parentFolder = guestHome = guestHomeResult.getNodeRef(0);
        String nodeName = uuid + ".folder" + this.getNameSuffix();
        ArrayList<ChildAssociationRef> parents = new ArrayList<ChildAssociationRef>();
        ChildAssociationRef primaryAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parentFolder, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName), node.getNodeRef(), true, -1);
        parents.add(primaryAssoc);
        node.setParentAssocs(parents);
        node.setParentPath(this.nodeService.getPath(parentFolder));
        node.setPrimaryParentAssoc(primaryAssoc);
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)uuid));
        props.put(ContentModel.PROP_NAME, (Serializable)((Object)nodeName));
        node.setProperties(props);
        return node;
    }

    private String getNameSuffix() {
        return "" + fileCount++;
    }
}

