/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.transfer.AbstractNodeFilter;
import org.alfresco.repo.transfer.AbstractNodeFinder;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.NodeCrawler;
import org.alfresco.service.cmr.transfer.NodeFilter;
import org.alfresco.service.cmr.transfer.NodeFinder;

public class StandardNodeCrawlerImpl
implements NodeCrawler {
    private ServiceRegistry serviceRegistry;
    private List<NodeFinder> nodeFinders = new ArrayList<NodeFinder>();
    private List<NodeFilter> nodeFilters = new ArrayList<NodeFilter>();

    public StandardNodeCrawlerImpl() {
    }

    public StandardNodeCrawlerImpl(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public Set<NodeRef> crawl(NodeRef ... nodes) {
        return this.crawl(new HashSet<NodeRef>(Arrays.asList(nodes)));
    }

    @Override
    public synchronized Set<NodeRef> crawl(Set<NodeRef> startingNodes) {
        this.init();
        LinkedList<NodeRef> nodesToProcess = new LinkedList<NodeRef>();
        nodesToProcess.addAll(startingNodes);
        HashSet<NodeRef> resultingNodeSet = new HashSet<NodeRef>(89);
        HashSet<NodeRef> processedNodes = new HashSet<NodeRef>(89);
        while (nodesToProcess.peek() != null) {
            NodeRef thisNode = (NodeRef)nodesToProcess.poll();
            if (processedNodes.contains(thisNode)) continue;
            processedNodes.add(thisNode);
            if (!startingNodes.contains(thisNode) && !this.includeNode(thisNode)) continue;
            resultingNodeSet.add(thisNode);
            Set<NodeRef> subsequentNodes = this.findSubsequentNodes(thisNode);
            for (NodeRef node : subsequentNodes) {
                nodesToProcess.add(node);
            }
        }
        return resultingNodeSet;
    }

    private void init() {
        for (NodeFinder nodeFinder : this.nodeFinders) {
            if (!(nodeFinder instanceof AbstractNodeFinder)) continue;
            ((AbstractNodeFinder)nodeFinder).setServiceRegistry(this.serviceRegistry);
            ((AbstractNodeFinder)nodeFinder).init();
        }
        for (NodeFilter nodeFilter : this.nodeFilters) {
            if (!(nodeFilter instanceof AbstractNodeFilter)) continue;
            ((AbstractNodeFilter)nodeFilter).setServiceRegistry(this.serviceRegistry);
            ((AbstractNodeFilter)nodeFilter).init();
        }
    }

    private Set<NodeRef> findSubsequentNodes(NodeRef thisNode) {
        HashSet<NodeRef> foundNodes = new HashSet<NodeRef>(89);
        for (NodeFinder finder : this.nodeFinders) {
            foundNodes.addAll(finder.findFrom(thisNode));
        }
        return foundNodes;
    }

    private boolean includeNode(NodeRef thisNode) {
        boolean include = true;
        for (int i = 0; include && i < this.nodeFilters.size(); include &= this.nodeFilters.get(i).accept(thisNode), ++i) {
        }
        return include;
    }

    @Override
    public synchronized void setNodeFinders(NodeFinder ... finders) {
        this.nodeFinders = Arrays.asList(finders);
    }

    @Override
    public synchronized void setNodeFilters(NodeFilter ... filters) {
        this.nodeFilters = Arrays.asList(filters);
    }
}

