/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferReceiver;

public class TransferCommitTransactionListener
extends TransactionListenerAdapter {
    private TransferReceiver receiver;
    private String transferId;

    public TransferCommitTransactionListener(String transferId, TransferReceiver receiver) {
        this.receiver = receiver;
        this.transferId = transferId;
    }

    @Override
    public void afterCommit() {
        this.updateTransferStatus(TransferProgress.Status.COMPLETE);
    }

    @Override
    public void afterRollback() {
        this.updateTransferStatus(TransferProgress.Status.ERROR);
    }

    private void updateTransferStatus(TransferProgress.Status status) {
        this.receiver.getProgressMonitor().updateStatus(this.transferId, status);
    }
}

