/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeFactory;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class UnitTestTransferManifestNodeFactory
implements TransferManifestNodeFactory {
    Map<NodeRef, NodeRef> refMap = new HashMap<NodeRef, NodeRef>();
    private List<Pair<Path, Path>> pathMap = new ArrayList<Pair<Path, Path>>();
    TransferManifestNodeFactory realFactory;

    public UnitTestTransferManifestNodeFactory(TransferManifestNodeFactory realFactory) {
        this.realFactory = realFactory;
    }

    @Override
    public TransferManifestNode createTransferManifestNode(NodeRef nodeRef, TransferDefinition definition) {
        return this.createTransferManifestNode(nodeRef, definition, false);
    }

    @Override
    public TransferManifestNode createTransferManifestNode(NodeRef nodeRef, TransferDefinition definition, boolean forceDelete) {
        Map<QName, Serializable> props;
        TransferManifestNormalNode normalNode;
        TransferManifestNode newNode = this.realFactory.createTransferManifestNode(nodeRef, definition);
        NodeRef origNodeRef = newNode.getNodeRef();
        NodeRef mappedNodeRef = this.mapNodeRef(origNodeRef);
        newNode.setNodeRef(mappedNodeRef);
        ChildAssociationRef primaryParentAssoc = newNode.getPrimaryParentAssoc();
        NodeRef mappedParentNodeRef = this.mapNodeRef(primaryParentAssoc.getParentRef());
        Path parentPath = newNode.getParentPath();
        newNode.setParentPath(this.getMappedPath(parentPath));
        newNode.setPrimaryParentAssoc(new ChildAssociationRef(primaryParentAssoc.getTypeQName(), mappedParentNodeRef, primaryParentAssoc.getQName(), mappedNodeRef, primaryParentAssoc.isPrimary(), primaryParentAssoc.getNthSibling()));
        if (newNode instanceof TransferManifestNormalNode) {
            normalNode = (TransferManifestNormalNode)newNode;
            ArrayList<ChildAssociationRef> mappedParentAssocs = new ArrayList<ChildAssociationRef>();
            List<ChildAssociationRef> assocs = normalNode.getParentAssocs();
            for (ChildAssociationRef assoc : assocs) {
                ChildAssociationRef replace = new ChildAssociationRef(assoc.getTypeQName(), mappedParentNodeRef, assoc.getQName(), mappedNodeRef, assoc.isPrimary(), assoc.getNthSibling());
                mappedParentAssocs.add(replace);
            }
            normalNode.setParentAssocs(mappedParentAssocs);
        }
        if (newNode instanceof TransferManifestNormalNode) {
            normalNode = (TransferManifestNormalNode)newNode;
            List<ChildAssociationRef> assocs = normalNode.getChildAssocs();
            ArrayList<ChildAssociationRef> mappedChildAssocs = new ArrayList<ChildAssociationRef>();
            for (ChildAssociationRef assoc : assocs) {
                NodeRef before = assoc.getChildRef();
                NodeRef mappedChildNodeRef = this.mapNodeRef(before);
                ChildAssociationRef replace = new ChildAssociationRef(assoc.getTypeQName(), mappedParentNodeRef, assoc.getQName(), mappedChildNodeRef, assoc.isPrimary(), assoc.getNthSibling());
                mappedChildAssocs.add(replace);
            }
            normalNode.setChildAssocs(mappedChildAssocs);
        }
        if (newNode instanceof TransferManifestNormalNode && (props = (normalNode = (TransferManifestNormalNode)newNode).getProperties()).containsKey(ContentModel.PROP_NODE_UUID)) {
            props.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)mappedNodeRef.getId()));
        }
        if (newNode instanceof TransferManifestNormalNode) {
            normalNode = (TransferManifestNormalNode)newNode;
            List<AssociationRef> source = normalNode.getSourceAssocs();
            List<AssociationRef> target = normalNode.getTargetAssocs();
            ArrayList<AssociationRef> mappedSourceAssocs = new ArrayList<AssociationRef>();
            ArrayList<AssociationRef> mappedTargetAssocs = new ArrayList<AssociationRef>();
            for (AssociationRef ref : source) {
                mappedSourceAssocs.add(new AssociationRef(Long.valueOf(6L), this.getMappedNodeRef(ref.getSourceRef()), ref.getTypeQName(), this.getMappedNodeRef(ref.getTargetRef())));
            }
            for (AssociationRef ref : target) {
                mappedTargetAssocs.add(new AssociationRef(Long.valueOf(6L), this.getMappedNodeRef(ref.getSourceRef()), ref.getTypeQName(), this.getMappedNodeRef(ref.getTargetRef())));
            }
            normalNode.setSourceAssocs(mappedSourceAssocs);
            normalNode.setTargetAssocs(mappedTargetAssocs);
        }
        return newNode;
    }

    public NodeRef getMappedNodeRef(NodeRef node) {
        return this.refMap.get(node);
    }

    public Path getMappedPath(Path from) {
        Path to = new Path();
        Path source = new Path();
        for (int i = 0; i < from.size(); ++i) {
            source.append(from.get(i));
            boolean replacePath = false;
            for (Pair<Path, Path> xx : this.getPathMap()) {
                if (!((Path)xx.getFirst()).toString().equals(source.toString())) continue;
                to = ((Path)xx.getSecond()).subPath(((Path)xx.getSecond()).size() - 1);
                replacePath = true;
                break;
            }
            if (replacePath) continue;
            to.append(from.get(i));
        }
        return to;
    }

    private NodeRef mapNodeRef(NodeRef in) {
        NodeRef mappedNodeRef = this.refMap.get(in);
        if (mappedNodeRef == null) {
            String nodeRef = in.getId();
            nodeRef = nodeRef.length() == 36 ? in.getId().substring(0, 35) + "Z" : in.getId() + "Z";
            mappedNodeRef = new NodeRef(in.getStoreRef(), nodeRef);
            this.refMap.put(in, mappedNodeRef);
        }
        return mappedNodeRef;
    }

    public void setPathMap(List<Pair<Path, Path>> pathMap) {
        this.pathMap = pathMap;
    }

    public List<Pair<Path, Path>> getPathMap() {
        return this.pathMap;
    }
}

