/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.transfer.script.ScriptTransferTarget;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferService;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.namespace.QName;

public class ScriptTransferService
extends BaseScopableProcessorExtension {
    private TransferService transferService;
    private ServiceRegistry serviceRegistry;
    ValueConverter valueConverter = new ValueConverter();
    private List<QName> excludedAspects = new ArrayList<QName>();

    public void setTransferService(TransferService transferService) {
        this.transferService = transferService;
    }

    public TransferService getTransferService() {
        return this.transferService;
    }

    public ScriptTransferTarget[] getTransferTargetsByGroup(String groupName) {
        Set<TransferTarget> values = this.transferService.getTransferTargets(groupName);
        ScriptTransferTarget[] retVal = new ScriptTransferTarget[values.size()];
        int i = 0;
        for (TransferTarget value : values) {
            retVal[i++] = new ScriptTransferTarget(value);
        }
        return retVal;
    }

    public ScriptTransferTarget[] getAllTransferTargets() {
        Set<TransferTarget> values = this.transferService.getTransferTargets();
        ScriptTransferTarget[] retVal = new ScriptTransferTarget[values.size()];
        int i = 0;
        for (TransferTarget value : values) {
            retVal[i++] = new ScriptTransferTarget(value);
        }
        return retVal;
    }

    public ScriptTransferTarget getTransferTarget(String name) {
        TransferTarget value = this.transferService.getTransferTarget(name);
        if (value != null) {
            return new ScriptTransferTarget(value);
        }
        return null;
    }

    public ScriptNode transferReadOnly(String targetName, Object nodesToTransfer) {
        Object nodesObject = this.valueConverter.convertValueForJava(nodesToTransfer);
        TransferDefinition toTransfer = new TransferDefinition();
        toTransfer.setReadOnly(true);
        toTransfer.setExcludedAspects(this.excludedAspects);
        ArrayList<NodeRef> nodeCollection = new ArrayList<NodeRef>();
        if (nodesObject instanceof Collection) {
            for (Object value : (Collection)nodesObject) {
                if (value instanceof NodeRef) {
                    nodeCollection.add((NodeRef)value);
                    continue;
                }
                if (value instanceof String) {
                    nodeCollection.add(new NodeRef((String)value));
                    continue;
                }
                throw new IllegalArgumentException("transfer: unknown type in collection: " + value.getClass().getName());
            }
        } else if (nodesObject instanceof NodeRef) {
            nodeCollection.add((NodeRef)nodesObject);
        } else if (nodesObject instanceof String) {
            nodeCollection.add(new NodeRef((String)nodesObject));
        } else {
            throw new IllegalArgumentException("transfer: unexpected type for nodes :" + nodesObject.getClass().getName());
        }
        toTransfer.setNodes(nodeCollection);
        NodeRef reportNode = this.transferService.transfer(targetName, toTransfer);
        return new ScriptNode(reportNode, this.serviceRegistry, this.getScope());
    }

    public ScriptNode transfer(String targetName, Object nodesToTransfer) {
        Object nodesObject = this.valueConverter.convertValueForJava(nodesToTransfer);
        TransferDefinition toTransfer = new TransferDefinition();
        toTransfer.setExcludedAspects(this.excludedAspects);
        ArrayList<NodeRef> nodeCollection = new ArrayList<NodeRef>();
        if (nodesObject instanceof Collection) {
            for (Object value : (Collection)nodesObject) {
                if (value instanceof NodeRef) {
                    nodeCollection.add((NodeRef)value);
                    continue;
                }
                if (value instanceof String) {
                    nodeCollection.add(new NodeRef((String)value));
                    continue;
                }
                throw new IllegalArgumentException("transfer: unknown type in collection: " + value.getClass().getName());
            }
        } else if (nodesObject instanceof NodeRef) {
            nodeCollection.add((NodeRef)nodesObject);
        } else if (nodesObject instanceof String) {
            nodeCollection.add(new NodeRef((String)nodesObject));
        } else {
            throw new IllegalArgumentException("transfer: unexpected type for nodes :" + nodesObject.getClass().getName());
        }
        toTransfer.setNodes(nodeCollection);
        NodeRef reportNode = this.transferService.transfer(targetName, toTransfer);
        return new ScriptNode(reportNode, this.serviceRegistry, this.getScope());
    }

    public ScriptNode remove(String targetName, Object nodesToRemove) {
        Object nodesObject = this.valueConverter.convertValueForJava(nodesToRemove);
        TransferDefinition toTransfer = new TransferDefinition();
        toTransfer.setExcludedAspects(this.excludedAspects);
        ArrayList<NodeRef> nodeCollection = new ArrayList<NodeRef>();
        if (nodesObject instanceof Collection) {
            for (Object value : (Collection)nodesObject) {
                if (value instanceof NodeRef) {
                    nodeCollection.add((NodeRef)value);
                    continue;
                }
                if (value instanceof String) {
                    nodeCollection.add(new NodeRef((String)value));
                    continue;
                }
                throw new IllegalArgumentException("transfer: unknown type in collection: " + value.getClass().getName());
            }
        } else if (nodesObject instanceof NodeRef) {
            nodeCollection.add((NodeRef)nodesObject);
        } else if (nodesObject instanceof String) {
            nodeCollection.add(new NodeRef((String)nodesObject));
        } else {
            throw new IllegalArgumentException("transfer: unexpected type for nodes :" + nodesObject.getClass().getName());
        }
        toTransfer.setNodesToRemove(nodeCollection);
        NodeRef reportNode = this.transferService.transfer(targetName, toTransfer);
        return new ScriptNode(reportNode, this.serviceRegistry, this.getScope());
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setExcludedAspects(String[] excludedAspects) {
        for (String aspect : excludedAspects) {
            this.excludedAspects.add(QName.createQName((String)aspect));
        }
    }
}

