/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.usage;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.usage.ContentQuotaException;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.alfresco.service.cmr.usage.UsageService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ContentUsageImpl
implements ContentUsageService,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnCreateNodePolicy {
    private static Log logger = LogFactory.getLog(ContentUsageImpl.class);
    private static final String KEY_DELETED_NODES = "contentUsage.deletedNodes";
    private static final String KEY_CREATED_NODES = "contentUsage.createdNodes";
    private NodeService nodeService;
    private PersonService personService;
    private PolicyComponent policyComponent;
    private UsageService usageService;
    private AuthenticationContext authenticationContext;
    private TenantService tenantService;
    private boolean enabled = true;
    private List<String> stores;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setUsageService(UsageService usageService) {
        this.usageService = usageService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setStores(List<String> stores) {
        this.stores = stores;
    }

    public List<String> getStores() {
        return this.stores;
    }

    public void init() {
        if (this.enabled) {
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        }
    }

    private void recordDelete(NodeRef nodeRef) {
        HashSet<NodeRef> deletedNodes = (HashSet<NodeRef>)AlfrescoTransactionSupport.getResource(KEY_DELETED_NODES);
        if (deletedNodes == null) {
            deletedNodes = new HashSet<NodeRef>();
            AlfrescoTransactionSupport.bindResource(KEY_DELETED_NODES, deletedNodes);
        }
        deletedNodes.add(this.tenantService.getName(nodeRef));
        Set updatedNodes = (Set)AlfrescoTransactionSupport.getResource(KEY_CREATED_NODES);
        if (updatedNodes != null) {
            updatedNodes.remove(this.tenantService.getName(nodeRef));
        }
    }

    private boolean alreadyDeleted(NodeRef nodeRef) {
        Set deletedNodes = (Set)AlfrescoTransactionSupport.getResource(KEY_DELETED_NODES);
        if (deletedNodes != null) {
            for (NodeRef deletedNodeRef : deletedNodes) {
                if (!deletedNodeRef.equals((Object)nodeRef)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("alreadyDeleted: nodeRef=" + nodeRef));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        ContentData contentData;
        NodeRef nodeRef = childAssocRef.getChildRef();
        if (this.stores.contains(this.tenantService.getBaseName(nodeRef.getStoreRef()).toString()) && !this.alreadyCreated(nodeRef) && (contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT)) != null) {
            long contentSize = contentData.getSize();
            String owner = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_OWNER));
            if (owner == null || owner.equals("")) {
                owner = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATOR));
            }
            if (contentSize != 0L && owner != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("onCreateNode: nodeRef=" + nodeRef + ", owner=" + owner + ", contentSize=" + contentSize));
                }
                this.incrementUserUsage(owner, contentSize, nodeRef);
                this.recordCreate(nodeRef);
            }
        }
    }

    private void recordCreate(NodeRef nodeRef) {
        HashSet<NodeRef> createdNodes = (HashSet<NodeRef>)AlfrescoTransactionSupport.getResource(KEY_CREATED_NODES);
        if (createdNodes == null) {
            createdNodes = new HashSet<NodeRef>();
            AlfrescoTransactionSupport.bindResource(KEY_CREATED_NODES, createdNodes);
        }
        createdNodes.add(this.tenantService.getName(nodeRef));
    }

    private boolean alreadyCreated(NodeRef nodeRef) {
        Set createdNodes = (Set)AlfrescoTransactionSupport.getResource(KEY_CREATED_NODES);
        if (createdNodes != null) {
            for (NodeRef createdNodeRef : createdNodes) {
                if (!createdNodeRef.equals((Object)nodeRef)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("alreadyCreated: nodeRef=" + nodeRef));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.stores.contains(this.tenantService.getBaseName(nodeRef.getStoreRef()).toString()) && !this.alreadyCreated(nodeRef)) {
            String ownerAfter;
            ContentData contentDataBefore = (ContentData)before.get(ContentModel.PROP_CONTENT);
            Long contentSizeBefore = contentDataBefore == null ? null : Long.valueOf(contentDataBefore.getSize());
            ContentData contentDataAfter = (ContentData)after.get(ContentModel.PROP_CONTENT);
            Long contentSizeAfter = contentDataAfter == null ? null : Long.valueOf(contentDataAfter.getSize());
            String ownerBefore = (String)((Object)before.get(ContentModel.PROP_OWNER));
            if (ownerBefore == null || ownerBefore.equals("")) {
                ownerBefore = (String)((Object)before.get(ContentModel.PROP_CREATOR));
            }
            if ((ownerAfter = (String)((Object)after.get(ContentModel.PROP_OWNER))) == null || ownerAfter.equals("")) {
                ownerAfter = (String)((Object)after.get(ContentModel.PROP_CREATOR));
            }
            if (contentSizeBefore == null && contentSizeAfter != null && contentSizeAfter != 0L && ownerAfter != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("onUpdateProperties: updateSize (null -> " + contentSizeAfter + "): nodeRef=" + nodeRef + ", ownerAfter=" + ownerAfter));
                }
                this.incrementUserUsage(ownerAfter, contentSizeAfter, nodeRef);
            } else if (contentSizeAfter == null && contentSizeBefore != null && contentSizeBefore != 0L && ownerBefore != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("onUpdateProperties: updateSize (" + contentSizeBefore + " -> null): nodeRef=" + nodeRef + ", ownerBefore=" + ownerBefore));
                }
                this.decrementUserUsage(ownerBefore, contentSizeBefore, nodeRef);
            } else if (contentSizeBefore != null && contentSizeAfter != null) {
                if (!contentSizeBefore.equals(contentSizeAfter)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("onUpdateProperties: updateSize (" + contentSizeBefore + " -> " + contentSizeAfter + "): nodeRef=" + nodeRef + ", ownerBefore=" + ownerBefore + ", ownerAfter=" + ownerAfter));
                    }
                    if (contentSizeBefore != 0L && ownerBefore != null) {
                        this.decrementUserUsage(ownerBefore, contentSizeBefore, nodeRef);
                    }
                    if (contentSizeAfter != 0L && ownerAfter != null) {
                        this.incrementUserUsage(ownerAfter, contentSizeAfter, nodeRef);
                    }
                } else if (ownerBefore == null && ownerAfter != null && contentSizeAfter != 0L && ownerAfter != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("onUpdateProperties: updateOwner (null -> " + ownerAfter + "): nodeRef=" + nodeRef + ", contentSize=" + contentSizeAfter));
                    }
                    this.incrementUserUsage(ownerAfter, contentSizeAfter, nodeRef);
                } else if (ownerAfter == null && ownerBefore != null && contentSizeBefore != 0L) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("onUpdateProperties: updateOwner (" + ownerBefore + " -> null): nodeRef=" + nodeRef + ", contentSize=" + contentSizeBefore));
                    }
                    this.decrementUserUsage(ownerBefore, contentSizeBefore, nodeRef);
                } else if (ownerBefore != null && ownerAfter != null && !ownerBefore.equals(ownerAfter)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("onUpdateProperties: updateOwner (" + ownerBefore + " -> " + ownerAfter + "): nodeRef=" + nodeRef + ", contentSize=" + contentSizeBefore));
                    }
                    if (contentSizeBefore != 0L) {
                        this.decrementUserUsage(ownerBefore, contentSizeBefore, nodeRef);
                    }
                    if (contentSizeAfter != 0L) {
                        this.incrementUserUsage(ownerAfter, contentSizeAfter, nodeRef);
                    }
                }
            }
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        ContentData contentData;
        if (this.stores.contains(this.tenantService.getBaseName(nodeRef.getStoreRef()).toString()) && !this.alreadyDeleted(nodeRef) && (contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT)) != null) {
            long contentSize = contentData.getSize();
            String owner = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER));
            if (owner == null && ((owner = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_OWNER))) == null || owner.equals(""))) {
                owner = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATOR));
            }
            if (contentSize != 0L && owner != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("beforeDeleteNode: nodeRef=" + nodeRef + ", owner=" + owner + ", contentSize=" + contentSize));
                }
                this.decrementUserUsage(owner, contentSize, nodeRef);
                this.recordDelete(nodeRef);
            }
        }
    }

    private void incrementUserUsage(String userName, long contentSize, NodeRef contentNodeRef) {
        if (!this.authenticationContext.isSystemUserName(userName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("incrementUserUsage: username=" + userName + ", contentSize=" + contentSize + ", contentNodeRef=" + contentNodeRef));
            }
            long currentSize = this.getUserUsage(userName);
            long quotaSize = this.getUserQuota(userName);
            long newSize = currentSize + contentSize;
            if (quotaSize != -1L && newSize > quotaSize) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("User (" + userName + ") quota exceeded: content=" + contentSize + ", usage=" + currentSize + ", quota=" + quotaSize));
                }
                throw new ContentQuotaException("User quota exceeded");
            }
            NodeRef personNodeRef = this.getPerson(userName);
            if (personNodeRef != null) {
                this.usageService.insertDelta(personNodeRef, contentSize);
            }
        }
    }

    private void decrementUserUsage(String userName, long contentSize, NodeRef contentNodeRef) {
        if (!this.authenticationContext.isSystemUserName(userName)) {
            NodeRef personNodeRef;
            long currentSize;
            long newSize;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("decrementUserUsage: username=" + userName + ", contentSize=" + contentSize + ", contentNodeRef=" + contentNodeRef));
            }
            if ((newSize = (currentSize = this.getUserUsage(userName)) + contentSize) < 0L && logger.isDebugEnabled()) {
                logger.debug((Object)("User (" + userName + ") has negative usage (" + newSize + ") - reset to 0"));
            }
            if ((personNodeRef = this.getPerson(userName)) != null) {
                this.usageService.insertDelta(personNodeRef, -contentSize);
            }
        }
    }

    public void setUserStoredUsage(NodeRef personNodeRef, long currentUsage) {
        if (personNodeRef != null) {
            this.nodeService.setProperty(personNodeRef, ContentModel.PROP_SIZE_CURRENT, (Serializable)new Long(currentUsage));
        }
    }

    public long getUserStoredUsage(NodeRef personNodeRef) {
        Long currentUsage = null;
        if (personNodeRef != null) {
            currentUsage = (Long)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_SIZE_CURRENT);
        }
        return currentUsage == null ? -1L : currentUsage;
    }

    @Override
    public long getUserUsage(String userName) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        long currentUsage = 0L;
        NodeRef personNodeRef = this.getPerson(userName);
        if (personNodeRef != null) {
            currentUsage = this.getUserUsage(personNodeRef, false);
        }
        return currentUsage;
    }

    public long getUserUsage(NodeRef personNodeRef, boolean removeDeltas) {
        long currentUsage = -1L;
        if (personNodeRef != null) {
            currentUsage = this.getUserStoredUsage(personNodeRef);
        }
        if (currentUsage != -1L) {
            long deltaSize;
            long l = deltaSize = removeDeltas ? this.usageService.getAndRemoveTotalDeltaSize(personNodeRef) : this.usageService.getTotalDeltaSize(personNodeRef);
            if ((currentUsage += deltaSize) < 0L) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("User usage (" + personNodeRef + ") is negative (" + currentUsage + ") overriding to 0"));
                }
                currentUsage = 0L;
            }
        }
        return currentUsage;
    }

    @Override
    public void setUserQuota(String userName, long currentQuota) {
        NodeRef personNodeRef = this.getPerson(userName);
        if (personNodeRef != null) {
            this.nodeService.setProperty(personNodeRef, ContentModel.PROP_SIZE_QUOTA, (Serializable)new Long(currentQuota));
        }
    }

    @Override
    public long getUserQuota(String userName) {
        Long currentQuota = null;
        NodeRef personNodeRef = this.getPerson(userName);
        if (personNodeRef != null) {
            currentQuota = (Long)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_SIZE_QUOTA);
        }
        return currentQuota == null ? -1L : currentQuota;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    private NodeRef getPerson(String userName) {
        NodeRef personNodeRef = null;
        try {
            personNodeRef = this.personService.getPerson(userName, false);
        }
        catch (NoSuchPersonException e) {
            personNodeRef = null;
        }
        catch (RuntimeException e) {
            if (this.tenantService.isEnabled()) {
                personNodeRef = null;
            }
            throw e;
        }
        return personNodeRef;
    }
}

