/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import org.activiti.engine.FormService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.form.FormData;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;
import org.alfresco.repo.workflow.WorkflowObjectFactory;
import org.alfresco.service.cmr.dictionary.TypeDefinition;

public class ActivitiTaskTypeManager {
    private final WorkflowObjectFactory factory;
    private final FormService formService;

    public ActivitiTaskTypeManager(WorkflowObjectFactory factory, FormService formService) {
        this.factory = factory;
        this.formService = formService;
    }

    public TypeDefinition getStartTaskDefinition(String taskTypeName) {
        return this.factory.getTaskFullTypeDefinition(taskTypeName, true);
    }

    public TypeDefinition getFullTaskDefinition(Task task) {
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        return this.getFullTaskDefinition(task.getId(), (FormData)taskFormData);
    }

    public TypeDefinition getFullTaskDefinition(DelegateTask delegateTask) {
        TaskFormData formData = null;
        TaskEntity taskEntity = (TaskEntity)delegateTask;
        TaskFormHandler taskFormHandler = taskEntity.getTaskDefinition().getTaskFormHandler();
        if (taskFormHandler != null) {
            formData = taskFormHandler.createTaskForm(taskEntity);
        }
        return this.getFullTaskDefinition(delegateTask.getId(), (FormData)formData);
    }

    public TypeDefinition getFullTaskDefinition(String typeName) {
        return this.getFullTaskDefinition(typeName, null);
    }

    private TypeDefinition getFullTaskDefinition(String taskDefinitionKey, FormData taskFormData) {
        String formKey = null;
        formKey = taskFormData != null ? taskFormData.getFormKey() : taskDefinitionKey;
        return this.factory.getTaskFullTypeDefinition(formKey, false);
    }
}

