/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ReceiveTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.deployer.BpmnDeployer;
import org.activiti.engine.impl.bpmn.diagram.ProcessDiagramGenerator;
import org.activiti.engine.impl.form.DefaultTaskFormHandler;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.Job;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.BPMEngine;
import org.alfresco.repo.workflow.WorkflowAuthorityManager;
import org.alfresco.repo.workflow.WorkflowEngine;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowNodeConverter;
import org.alfresco.repo.workflow.WorkflowObjectFactory;
import org.alfresco.repo.workflow.activiti.ActivitiTypeConverter;
import org.alfresco.repo.workflow.activiti.ActivitiUtil;
import org.alfresco.repo.workflow.activiti.properties.ActivitiPropertyConverter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowInstanceQuery;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.collections.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ActivitiWorkflowEngine
extends BPMEngine
implements WorkflowEngine {
    private static final String ERR_DEPLOY_WORKFLOW = "activiti.engine.deploy.workflow.error";
    private static final String ERR_IS_WORKFLOW_DEPLOYED = "activiti.engine.is.workflow.deployed.error";
    private static final String ERR_UNDEPLOY_WORKFLOW = "activiti.engine.undeploy.workflow.error";
    private static final String ERR_UNDEPLOY_WORKFLOW_UNEXISTING = "activiti.engine.undeploy.workflow.unexisting.error";
    private static final String ERR_GET_WORKFLOW_DEF = "activiti.engine.get.workflow.definition.error";
    private static final String ERR_GET_WORKFLOW_DEF_BY_ID = "activiti.engine.get.workflow.definition.by.id.error";
    private static final String ERR_GET_WORKFLOW_DEF_BY_NAME = "activiti.engine.get.workflow.definition.by.name.error";
    private static final String ERR_GET_ALL_DEFS_BY_NAME = "activiti.engine.get.all.workflow.definitions.by.name.error";
    private static final String ERR_GET_DEF_IMAGE = "activiti.engine.get.workflow.definition.image.error";
    private static final String ERR_GET_DEF_UNEXISTING_IMAGE = "activiti.engine.get.workflow.definition.unexisting.image.error";
    private static final String ERR_START_WORKFLOW = "activiti.engine.start.workflow.error";
    private static final String ERR_GET_WORKFLOW_INSTS = "activiti.engine.get.workflows.error";
    private static final String ERR_GET_ACTIVE_WORKFLOW_INSTS = "activiti.engine.get.active.workflows.error";
    private static final String ERR_GET_COMPLETED_WORKFLOW_INSTS = "activiti.engine.get.completed.workflows.error";
    private static final String ERR_GET_WORKFLOW_PATHS = "activiti.engine.get.workflow.paths.error";
    private static final String ERR_CANCEL_WORKFLOW = "activiti.engine.cancel.workflow.error";
    private static final String ERR_CANCEL_UNEXISTING_WORKFLOW = "activiti.engine.cancel.unexisting.workflow.error";
    private static final String ERR_DELETE_WORKFLOW = "activiti.engine.delete.workflow.error";
    private static final String ERR_DELETE_UNEXISTING_WORKFLOW = "activiti.engine.delete.unexisting.workflow.error";
    protected static final String ERR_FIRE_EVENT_NOT_SUPPORTED = "activiti.engine.event.unsupported";
    private static final String ERR_GET_TASKS_FOR_PATH = "activiti.engine.get.tasks.for.path.error";
    private static final String ERR_GET_TIMERS = "activiti.engine.get.timers.error";
    protected static final String ERR_FIND_COMPLETED_TASK_INSTS = "activiti.engine.find.completed.task.instances.error";
    private static final String ERR_GET_WORKFLOW_TOKEN_INVALID = "activiti.engine.get.workflow.token.invalid";
    private static final String ERR_GET_WORKFLOW_TOKEN_NULL = "activiti.engine.get.workflow.token.is.null";
    private static final String ERR_GET_COMPANY_HOME_INVALID = "activiti.engine.get.company.home.invalid";
    private static final String ERR_GET_COMPANY_HOME_MULTIPLE = "activiti.engine.get.company.home.multiple";
    private static final String ERR_GET_ASSIGNED_TASKS = "activiti.engine.get.assigned.tasks.error";
    private static final String ERR_GET_POOLED_TASKS = "activiti.engine.get.pooled.tasks.error";
    private static final String ERR_UPDATE_TASK = "activiti.engine.update.task.error";
    private static final String ERR_UPDATE_TASK_UNEXISTING = "activiti.engine.update.task.unexisting.error";
    private static final String ERR_UPDATE_START_TASK = "activiti.engine.update.starttask.illegal.error";
    private static final String ERR_END_UNEXISTING_TASK = "activiti.engine.end.task.unexisting.error";
    private static final String ERR_GET_TASK_BY_ID = "activiti.engine.get.task.by.id.error";
    private static final String ERR_END_TASK_INVALID_TRANSITION = "activiti.engine.end.task.invalid.transition";
    public static final QName QNAME_INITIATOR = QName.createQName((String)"", (String)"initiator");
    private static final String WORKFLOW_TOKEN_SEPERATOR = "\\$";
    private RepositoryService repoService;
    private RuntimeService runtimeService;
    private TaskService taskService;
    private HistoryService historyService;
    private ManagementService managementService;
    private FormService formService;
    private ActivitiUtil activitiUtil;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private SearchService unprotectedSearchService;
    private PersonService personService;
    private ActivitiTypeConverter typeConverter;
    private ActivitiPropertyConverter propertyConverter;
    private WorkflowAuthorityManager authorityManager;
    private WorkflowNodeConverter nodeConverter;
    private WorkflowObjectFactory factory;
    private MessageService messageService;
    private TenantService tenantService;
    private NamespaceService namespaceService;
    private String companyHomePath;
    private StoreRef companyHomeStore;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.repoService = this.activitiUtil.getRepositoryService();
        this.runtimeService = this.activitiUtil.getRuntimeService();
        this.taskService = this.activitiUtil.getTaskService();
        this.formService = this.activitiUtil.getFormService();
        this.historyService = this.activitiUtil.getHistoryService();
        this.managementService = this.activitiUtil.getManagementService();
    }

    @Override
    public List<WorkflowInstance> cancelWorkflows(List<String> workflowIds) {
        ArrayList<WorkflowInstance> result = new ArrayList<WorkflowInstance>(workflowIds.size());
        for (String workflowId : workflowIds) {
            result.add(this.cancelWorkflow(workflowId));
        }
        return result;
    }

    @Override
    public WorkflowInstance cancelWorkflow(String workflowId) {
        String localId = this.createLocalId(workflowId);
        try {
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(localId).singleResult();
            if (processInstance == null) {
                throw new WorkflowException(this.messageService.getMessage(ERR_CANCEL_UNEXISTING_WORKFLOW));
            }
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "cancelled");
            HistoricProcessInstance deletedInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
            WorkflowInstance result = this.typeConverter.convert(deletedInstance);
            this.historyService.deleteHistoricProcessInstance(deletedInstance.getId());
            return result;
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_CANCEL_WORKFLOW);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public WorkflowInstance deleteWorkflow(String workflowId) {
        String localId = this.createLocalId(workflowId);
        try {
            HistoricProcessInstance deletedInstance;
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(localId).singleResult();
            if (processInstance != null) {
                this.runtimeService.deleteProcessInstance(processInstance.getId(), "deleted");
            }
            if ((deletedInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(localId).singleResult()) == null) {
                throw new WorkflowException(this.messageService.getMessage(ERR_DELETE_UNEXISTING_WORKFLOW, localId));
            }
            WorkflowInstance result = this.typeConverter.convert(deletedInstance);
            this.historyService.deleteHistoricProcessInstance(deletedInstance.getId());
            return result;
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_DELETE_WORKFLOW);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public WorkflowDeployment deployDefinition(InputStream workflowDefinition, String mimetype) {
        return this.deployDefinition(workflowDefinition, mimetype, null);
    }

    @Override
    public WorkflowDeployment deployDefinition(InputStream workflowDefinition, String mimetype, String name) {
        try {
            String resourceName = GUID.generate() + BpmnDeployer.BPMN_RESOURCE_SUFFIXES[0];
            if (this.tenantService.isEnabled()) {
                name = this.tenantService.getName(name);
            }
            Deployment deployment = this.repoService.createDeployment().addInputStream(resourceName, workflowDefinition).name(name).deploy();
            return this.typeConverter.convert(deployment);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_DEPLOY_WORKFLOW);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public WorkflowPath fireEvent(String pathId, String event) {
        String message = this.messageService.getMessage(ERR_FIRE_EVENT_NOT_SUPPORTED);
        throw new WorkflowException(message);
    }

    @Override
    public List<WorkflowInstance> getActiveWorkflows() {
        try {
            return this.getWorkflows(new WorkflowInstanceQuery(true));
        }
        catch (ActivitiException ae) {
            String message = this.messageService.getMessage(ERR_GET_ACTIVE_WORKFLOW_INSTS, "");
            throw new WorkflowException(message, ae);
        }
    }

    @Override
    public List<WorkflowInstance> getCompletedWorkflows() {
        try {
            return this.getWorkflows(new WorkflowInstanceQuery(false));
        }
        catch (ActivitiException ae) {
            String message = this.messageService.getMessage(ERR_GET_COMPLETED_WORKFLOW_INSTS, "");
            throw new WorkflowException(message, ae);
        }
    }

    @Override
    public List<WorkflowInstance> getWorkflows() {
        try {
            return this.getWorkflows(new WorkflowInstanceQuery());
        }
        catch (ActivitiException ae) {
            String message = this.messageService.getMessage(ERR_GET_WORKFLOW_INSTS, "");
            throw new WorkflowException(message, ae);
        }
    }

    @Override
    public List<WorkflowInstance> getActiveWorkflows(String workflowDefinitionId) {
        try {
            return this.getWorkflows(new WorkflowInstanceQuery(workflowDefinitionId, true));
        }
        catch (ActivitiException ae) {
            String message = this.messageService.getMessage(ERR_GET_ACTIVE_WORKFLOW_INSTS, workflowDefinitionId);
            throw new WorkflowException(message, ae);
        }
    }

    @Override
    public List<WorkflowDefinition> getAllDefinitions() {
        try {
            List definitions = this.repoService.createProcessDefinitionQuery().list();
            return this.getValidWorkflowDefinitions(definitions);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public List<WorkflowDefinition> getAllDefinitionsByName(String workflowName) {
        try {
            String key = this.factory.getProcessKey(workflowName);
            List definitions = this.repoService.createProcessDefinitionQuery().processDefinitionKey(key).list();
            return this.typeConverter.convert(definitions);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_ALL_DEFS_BY_NAME, workflowName);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public List<WorkflowInstance> getCompletedWorkflows(String workflowDefinitionId) {
        try {
            return this.getWorkflows(new WorkflowInstanceQuery(workflowDefinitionId, false));
        }
        catch (ActivitiException ae) {
            String message = this.messageService.getMessage(ERR_GET_COMPLETED_WORKFLOW_INSTS, workflowDefinitionId);
            throw new WorkflowException(message, ae);
        }
    }

    @Override
    public WorkflowDefinition getDefinitionById(String workflowDefinitionId) {
        try {
            String localId = this.createLocalId(workflowDefinitionId);
            ProcessDefinition procDef = (ProcessDefinition)this.repoService.createProcessDefinitionQuery().processDefinitionId(localId).singleResult();
            return this.typeConverter.convert(procDef);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF_BY_ID, workflowDefinitionId);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public WorkflowDefinition getDefinitionByName(String workflowName) {
        try {
            String key = this.factory.getDomainProcessKey(workflowName);
            ProcessDefinition definition = (ProcessDefinition)this.repoService.createProcessDefinitionQuery().processDefinitionKey(key).latestVersion().singleResult();
            return this.typeConverter.convert(definition);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF_BY_NAME, workflowName);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public byte[] getDefinitionImage(String workflowDefinitionId) {
        try {
            String processDefinitionId = this.createLocalId(workflowDefinitionId);
            ProcessDefinition processDefinition = (ProcessDefinition)this.repoService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
            if (processDefinition == null) {
                throw new WorkflowException(this.messageService.getMessage(ERR_GET_DEF_UNEXISTING_IMAGE, workflowDefinitionId));
            }
            String diagramResourceName = ((ReadOnlyProcessDefinition)processDefinition).getDiagramResourceName();
            if (diagramResourceName != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                InputStream resourceInputStream = this.repoService.getResourceAsStream(processDefinitionId, diagramResourceName);
                IOUtils.copy((InputStream)resourceInputStream, (OutputStream)out);
                return out.toByteArray();
            }
            return null;
        }
        catch (IOException ioe) {
            String msg = this.messageService.getMessage(ERR_GET_DEF_IMAGE, workflowDefinitionId);
            throw new WorkflowException(msg, ioe);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_DEF_IMAGE, workflowDefinitionId);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public List<WorkflowDefinition> getDefinitions() {
        try {
            List definitions = this.repoService.createProcessDefinitionQuery().latestVersion().list();
            return this.getValidWorkflowDefinitions(definitions);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public Map<QName, Serializable> getPathProperties(String pathId) {
        String executionId = this.createLocalId(pathId);
        return this.propertyConverter.getPathProperties(executionId);
    }

    @Override
    public List<WorkflowTaskDefinition> getTaskDefinitions(String workflowDefinitionId) {
        ArrayList<WorkflowTaskDefinition> defs = new ArrayList<WorkflowTaskDefinition>();
        String processDefinitionId = this.createLocalId(workflowDefinitionId);
        ReadOnlyProcessDefinition processDefinition = ((RepositoryServiceImpl)this.repoService).getDeployedProcessDefinition(processDefinitionId);
        String processName = ((ProcessDefinition)processDefinition).getKey();
        this.factory.checkDomain(processName);
        PvmActivity startEvent = processDefinition.getInitial();
        String startTaskName = null;
        StartFormData startFormData = this.formService.getStartFormData(processDefinition.getId());
        if (startFormData != null) {
            startTaskName = startFormData.getFormKey();
        }
        defs.add(this.typeConverter.getTaskDefinition(startEvent, startTaskName, processDefinition.getId(), true));
        Collection<PvmActivity> taskActivities = this.findUserTasks(startEvent);
        for (PvmActivity act : taskActivities) {
            String formKey = this.getFormKey(act, processDefinition);
            defs.add(this.typeConverter.getTaskDefinition(act, formKey, processDefinition.getId(), false));
        }
        return defs;
    }

    private String getFormKey(PvmActivity act, ReadOnlyProcessDefinition processDefinition) {
        if (act instanceof ActivityImpl) {
            TaskDefinition taskDef;
            ActivityImpl actImpl = (ActivityImpl)act;
            if (actImpl.getActivityBehavior() instanceof UserTaskActivityBehavior) {
                UserTaskActivityBehavior uta = (UserTaskActivityBehavior)actImpl.getActivityBehavior();
                return this.getFormKey(uta.getTaskDefinition());
            }
            if (actImpl.getActivityBehavior() instanceof MultiInstanceActivityBehavior && processDefinition instanceof ProcessDefinitionEntity && (taskDef = (TaskDefinition)((ProcessDefinitionEntity)processDefinition).getTaskDefinitions().get(act.getId())) != null) {
                return this.getFormKey(taskDef);
            }
        }
        return null;
    }

    private String getFormKey(TaskDefinition taskDefinition) {
        TaskFormHandler handler = taskDefinition.getTaskFormHandler();
        if (handler != null && handler instanceof DefaultTaskFormHandler) {
            return ((DefaultTaskFormHandler)handler).getFormKey();
        }
        return null;
    }

    private boolean isReceiveTask(PvmActivity act) {
        if (act instanceof ActivityImpl) {
            ActivityImpl actImpl = (ActivityImpl)act;
            return actImpl.getActivityBehavior() instanceof ReceiveTaskActivityBehavior;
        }
        return false;
    }

    private Collection<PvmActivity> findUserTasks(PvmActivity startEvent) {
        LinkedHashMap<String, PvmActivity> userTasks = new LinkedHashMap<String, PvmActivity>();
        HashSet<String> processedActivities = new HashSet<String>();
        this.findUserTasks(startEvent, userTasks, processedActivities);
        return userTasks.values();
    }

    private boolean isFirstActivity(PvmActivity activity, ReadOnlyProcessDefinition procDef) {
        return procDef.getInitial().getOutgoingTransitions().size() == 1 && ((PvmTransition)procDef.getInitial().getOutgoingTransitions().get(0)).getDestination().equals(activity);
    }

    private void findUserTasks(PvmActivity currentActivity, Map<String, PvmActivity> userTasks, Set<String> processedActivities) {
        if (!processedActivities.contains(currentActivity.getId())) {
            processedActivities.add(currentActivity.getId());
            if (this.isUserTask(currentActivity)) {
                userTasks.put(currentActivity.getId(), currentActivity);
            }
            if (currentActivity.getOutgoingTransitions() != null) {
                for (PvmTransition transition : currentActivity.getOutgoingTransitions()) {
                    if (transition.getDestination() == null) continue;
                    this.findUserTasks(transition.getDestination(), userTasks, processedActivities);
                }
            }
        }
    }

    private boolean isUserTask(PvmActivity currentActivity) {
        String type = (String)currentActivity.getProperty("type");
        return type != null && type.equals("userTask");
    }

    @Override
    public List<WorkflowTask> getTasksForWorkflowPath(String pathId) {
        try {
            String executionId = this.getExecutionIdFromPath(pathId);
            if (executionId == null) {
                throw new WorkflowException(this.messageService.getMessage(ERR_GET_WORKFLOW_TOKEN_INVALID, pathId));
            }
            Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(executionId).singleResult();
            if (execution == null) {
                throw new WorkflowException(this.messageService.getMessage(ERR_GET_WORKFLOW_TOKEN_NULL, pathId));
            }
            String processInstanceId = execution.getProcessInstanceId();
            ArrayList<WorkflowTask> resultList = new ArrayList<WorkflowTask>();
            if (this.typeConverter.isStartTaskActive(processInstanceId)) {
                resultList.add(this.typeConverter.getVirtualStartTask(processInstanceId, (Boolean)true));
            } else {
                List tasks = this.taskService.createTaskQuery().executionId(executionId).list();
                for (Task task : tasks) {
                    resultList.add(this.typeConverter.convert(task));
                }
            }
            return resultList;
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_TASKS_FOR_PATH, pathId);
            throw new WorkflowException(msg, ae);
        }
    }

    protected String getExecutionIdFromPath(String workflowPath) {
        if (workflowPath != null) {
            String[] parts = workflowPath.split(WORKFLOW_TOKEN_SEPERATOR);
            if (parts.length != 2) {
                throw new WorkflowException(this.messageService.getMessage(ERR_GET_WORKFLOW_TOKEN_INVALID, workflowPath));
            }
            return parts[1];
        }
        return null;
    }

    @Override
    public List<WorkflowTimer> getTimers(String workflowId) {
        try {
            ArrayList<WorkflowTimer> timers = new ArrayList<WorkflowTimer>();
            String processInstanceId = this.createLocalId(workflowId);
            List timerJobs = this.managementService.createJobQuery().processInstanceId(processInstanceId).timers().list();
            ProcessInstance jobsProcessInstance = null;
            if (timerJobs.size() > 0) {
                jobsProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            }
            for (Job job : timerJobs) {
                Execution jobExecution = (Execution)this.runtimeService.createExecutionQuery().executionId(job.getExecutionId()).singleResult();
                WorkflowPath path = this.typeConverter.convert(jobExecution, jobsProcessInstance);
                WorkflowTask workflowTask = this.getTaskForTimer(job, jobsProcessInstance, jobExecution);
                WorkflowTimer workflowTimer = this.factory.createWorkflowTimer(job.getId(), job.getId(), job.getExceptionMessage(), job.getDuedate(), path, workflowTask);
                timers.add(workflowTimer);
            }
            return timers;
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_TIMERS, workflowId);
            throw new WorkflowException(msg, ae);
        }
    }

    private WorkflowTask getTaskForTimer(Job job, ProcessInstance processInstance, Execution jobExecution) {
        if (job instanceof TimerEntity) {
            String activityType;
            PvmActivity targetActivity;
            ReadOnlyProcessDefinition def = this.activitiUtil.getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
            List activeActivityIds = this.runtimeService.getActiveActivityIds(jobExecution.getId());
            if (activeActivityIds.size() == 1 && (targetActivity = def.findActivity((String)activeActivityIds.get(0))) != null && "userTask".equals(activityType = (String)targetActivity.getProperty("type"))) {
                Task task = (Task)this.taskService.createTaskQuery().executionId(job.getExecutionId()).singleResult();
                return this.typeConverter.convert(task);
            }
        }
        return null;
    }

    @Override
    public WorkflowInstance getWorkflowById(String workflowId) {
        try {
            WorkflowInstance instance = null;
            String processInstanceId = this.createLocalId(workflowId);
            ProcessInstance processIntance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (processIntance != null) {
                instance = this.typeConverter.convert(processIntance);
            } else {
                HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                if (historicInstance != null) {
                    instance = this.typeConverter.convert(historicInstance);
                }
            }
            return instance;
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public List<WorkflowPath> getWorkflowPaths(String workflowId) {
        try {
            String processInstanceId = this.createLocalId(workflowId);
            List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
            return this.typeConverter.convertExecution(executions);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_PATHS);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public List<WorkflowInstance> getWorkflows(String workflowDefinitionId) {
        try {
            return this.getWorkflows(new WorkflowInstanceQuery(workflowDefinitionId));
        }
        catch (ActivitiException ae) {
            String message = this.messageService.getMessage(ERR_GET_WORKFLOW_INSTS, workflowDefinitionId);
            throw new WorkflowException(message, ae);
        }
    }

    @Override
    public boolean isDefinitionDeployed(InputStream workflowDefinition, String mimetype) {
        String key = null;
        try {
            key = this.getProcessKey(workflowDefinition);
        }
        catch (Exception e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        try {
            long count = this.repoService.createProcessDefinitionQuery().processDefinitionKey(key).count();
            return count > 0L;
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_IS_WORKFLOW_DEPLOYED);
            throw new WorkflowException(msg, ae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProcessKey(InputStream workflowDefinition) throws Exception {
        try {
            InputSource inputSource = new InputSource(workflowDefinition);
            DOMParser parser = new DOMParser();
            parser.parse(inputSource);
            Document document = parser.getDocument();
            NodeList elemnts = document.getElementsByTagName("process");
            if (elemnts.getLength() < 1) {
                throw new IllegalArgumentException("The input stream does not contain a process definition!");
            }
            NamedNodeMap attributes = elemnts.item(0).getAttributes();
            Node idAttrib = attributes.getNamedItem("id");
            if (idAttrib == null) {
                throw new IllegalAccessError("The process definition does not have an id!");
            }
            String key = idAttrib.getNodeValue();
            String string = this.factory.getDomainProcessKey(key);
            return string;
        }
        finally {
            workflowDefinition.close();
        }
    }

    @Override
    public WorkflowPath signal(String pathId, String transitionId) {
        String execId = this.createLocalId(pathId);
        Execution oldExecution = this.activitiUtil.getExecution(execId);
        this.runtimeService.signal(execId);
        Execution execution = this.activitiUtil.getExecution(execId);
        if (execution != null) {
            return this.typeConverter.convert(execution);
        }
        return this.typeConverter.buildCompletedPath(execId, oldExecution.getProcessInstanceId());
    }

    @Override
    public WorkflowPath startWorkflow(String workflowDefinitionId, Map<QName, Serializable> parameters) {
        try {
            ProcessInstance instance;
            String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
            Authentication.setAuthenticatedUserId((String)currentUserName);
            String processDefId = this.createLocalId(workflowDefinitionId);
            Map<String, Object> variables = this.propertyConverter.getStartVariables(processDefId, parameters);
            variables.put("cancelled", Boolean.FALSE);
            Object companyHome = this.nodeConverter.convertNode(this.getCompanyHome());
            variables.put("companyhome", companyHome);
            NodeRef initiator = this.getPersonNodeRef(currentUserName);
            if (initiator != null) {
                variables.put("initiator", this.nodeConverter.convertNode(initiator));
                NodeRef initiatorHome = (NodeRef)this.nodeService.getProperty(initiator, ContentModel.PROP_HOMEFOLDER);
                if (initiatorHome != null) {
                    variables.put("initiatorhome", this.nodeConverter.convertNode(initiatorHome));
                }
            }
            if ((instance = this.runtimeService.startProcessInstanceById(processDefId, variables)).isEnded()) {
                return this.typeConverter.buildCompletedPath(instance.getId(), instance.getId());
            }
            WorkflowPath path = this.typeConverter.convert((Execution)instance);
            this.endStartTaskAutomatically(path, instance);
            return path;
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_START_WORKFLOW, workflowDefinitionId);
            throw new WorkflowException(msg, ae);
        }
    }

    private void endStartTaskAutomatically(WorkflowPath path, ProcessInstance instance) {
        WorkflowDefinition definition = path.getInstance().getDefinition();
        TypeDefinition metadata = definition.getStartTaskDefinition().getMetadata();
        Set aspects = metadata.getDefaultAspectNames();
        if (aspects.contains(WorkflowModel.ASPECT_END_AUTOMATICALLY)) {
            String taskId = "start" + instance.getId();
            this.endStartTask(taskId);
        }
    }

    @Override
    public void undeployDefinition(String workflowDefinitionId) {
        try {
            String procDefId = this.createLocalId(workflowDefinitionId);
            ProcessDefinition procDef = (ProcessDefinition)this.repoService.createProcessDefinitionQuery().processDefinitionId(procDefId).singleResult();
            if (procDef == null) {
                String msg = this.messageService.getMessage(ERR_UNDEPLOY_WORKFLOW_UNEXISTING, workflowDefinitionId);
                throw new WorkflowException(msg);
            }
            String deploymentId = procDef.getDeploymentId();
            this.repoService.deleteDeployment(deploymentId);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_UNDEPLOY_WORKFLOW, workflowDefinitionId);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public boolean hasWorkflowImage(String workflowInstanceId) {
        boolean hasImage = false;
        String processInstanceId = this.createLocalId(workflowInstanceId);
        ExecutionEntity pi = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (pi != null) {
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repoService).getDeployedProcessDefinition(pi.getProcessDefinitionId());
            hasImage = processDefinition != null && processDefinition.isGraphicalNotationDefined();
        }
        return hasImage;
    }

    @Override
    public InputStream getWorkflowImage(String workflowInstanceId) {
        ProcessDefinitionEntity processDefinition;
        String processInstanceId = this.createLocalId(workflowInstanceId);
        ExecutionEntity pi = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (pi != null && (processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repoService).getDeployedProcessDefinition(pi.getProcessDefinitionId())) != null && processDefinition.isGraphicalNotationDefined()) {
            return ProcessDiagramGenerator.generateDiagram((ProcessDefinitionEntity)processDefinition, (String)"png", (List)this.runtimeService.getActiveActivityIds(processInstanceId));
        }
        return null;
    }

    private List<WorkflowDefinition> getValidWorkflowDefinitions(List<ProcessDefinition> definitions) {
        return this.typeConverter.filterByDomainAndConvert(definitions, new Function<ProcessDefinition, String>(){

            public String apply(ProcessDefinition value) {
                return value.getKey();
            }
        });
    }

    private List<WorkflowTask> getValidWorkflowTasks(List<Task> tasks) {
        return this.typeConverter.filterByDomainAndConvert(tasks, new Function<Task, String>(){

            public String apply(Task task) {
                String defId = task.getProcessDefinitionId();
                ProcessDefinition definition = (ProcessDefinition)ActivitiWorkflowEngine.this.repoService.createProcessDefinitionQuery().processDefinitionId(defId).singleResult();
                return definition.getKey();
            }
        });
    }

    private List<WorkflowTask> getValidHistoricTasks(List<HistoricTaskInstance> tasks) {
        return this.typeConverter.filterByDomainAndConvert(tasks, new Function<HistoricTaskInstance, String>(){

            public String apply(HistoricTaskInstance task) {
                String defId = task.getProcessDefinitionId();
                ProcessDefinition definition = (ProcessDefinition)ActivitiWorkflowEngine.this.repoService.createProcessDefinitionQuery().processDefinitionId(defId).singleResult();
                return definition.getKey();
            }
        });
    }

    private NodeRef getCompanyHome() {
        if (this.tenantService.isEnabled()) {
            try {
                return this.tenantService.getRootNode(this.nodeService, this.unprotectedSearchService, this.namespaceService, this.companyHomePath, this.nodeService.getRootNode(this.companyHomeStore));
            }
            catch (RuntimeException re) {
                String msg = this.messageService.getMessage(ERR_GET_COMPANY_HOME_INVALID, this.companyHomePath);
                throw new IllegalStateException(msg, re);
            }
        }
        List refs = this.unprotectedSearchService.selectNodes(this.nodeService.getRootNode(this.companyHomeStore), this.companyHomePath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (refs.size() != 1) {
            String msg = this.messageService.getMessage(ERR_GET_COMPANY_HOME_MULTIPLE, this.companyHomePath, refs.size());
            throw new IllegalStateException(msg);
        }
        return (NodeRef)refs.get(0);
    }

    private NodeRef getPersonNodeRef(String name) {
        NodeRef authority = null;
        if (name != null && this.personService.personExists(name)) {
            authority = this.personService.getPerson(name);
        }
        return authority;
    }

    public void setPropertyConverter(ActivitiPropertyConverter propertyConverter) {
        this.propertyConverter = propertyConverter;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCompanyHomePath(String companyHomePath) {
        this.companyHomePath = companyHomePath;
    }

    public void setCompanyHomeStore(String companyHomeStore) {
        this.companyHomeStore = new StoreRef(companyHomeStore);
    }

    public void setUnprotectedSearchService(SearchService unprotectedSearchService) {
        this.unprotectedSearchService = unprotectedSearchService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthorityManager(WorkflowAuthorityManager authorityManager) {
        this.authorityManager = authorityManager;
    }

    @Override
    public WorkflowTask endTask(String taskId, String transition) {
        String localTaskId = this.createLocalId(taskId);
        if (localTaskId.startsWith("start")) {
            return this.endStartTask(localTaskId);
        }
        return this.endNormalTask(taskId, localTaskId, transition);
    }

    private WorkflowTask endNormalTask(String taskId, String localTaskId, String transition) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(localTaskId).singleResult();
        if (task == null) {
            String msg = this.messageService.getMessage(ERR_END_UNEXISTING_TASK, taskId);
            throw new WorkflowException(msg);
        }
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        if (task.getAssignee() == null || !task.getAssignee().equals(currentUserName)) {
            this.taskService.setAssignee(localTaskId, currentUserName);
            task.setAssignee(currentUserName);
        }
        this.setOutcome(task, transition);
        this.taskService.complete(localTaskId);
        HistoricTaskInstance historicTask = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
        return this.typeConverter.convert(historicTask);
    }

    private void setOutcome(Task task, String transition) {
        String outcomeValue = "Next";
        HashMap<QName, Serializable> updates = new HashMap<QName, Serializable>();
        boolean isDefaultTransition = transition == null || "Next".equals(transition);
        Map<QName, Serializable> properties = this.propertyConverter.getTaskProperties(task);
        QName outcomePropName = (QName)properties.get(WorkflowModel.PROP_OUTCOME_PROPERTY_NAME);
        if (outcomePropName != null) {
            if (!isDefaultTransition) {
                outcomeValue = transition;
                Serializable transitionValue = this.propertyConverter.convertValueToPropertyType(task, (Serializable)((Object)transition), outcomePropName);
                updates.put(outcomePropName, transitionValue);
            } else {
                Serializable rawOutcome = properties.get(outcomePropName);
                if (rawOutcome != null) {
                    outcomeValue = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)rawOutcome);
                }
            }
        } else if (!isDefaultTransition) {
            String taskId = this.createGlobalId(task.getId());
            String msg = this.messageService.getMessage(ERR_END_TASK_INVALID_TRANSITION, transition, taskId, "Next");
            throw new WorkflowException(msg);
        }
        updates.put(WorkflowModel.PROP_OUTCOME, (Serializable)((Object)outcomeValue));
        this.propertyConverter.updateTask(task, updates, null, null);
    }

    private WorkflowTask endStartTask(String localTaskId) {
        String processInstanceId = localTaskId.replace("start", "");
        if (!this.typeConverter.isStartTaskActive(processInstanceId)) {
            return this.typeConverter.getVirtualStartTask(processInstanceId, (Boolean)false);
        }
        this.runtimeService.setVariable(processInstanceId, "_startTaskCompleted", (Object)new Date());
        ProcessInstance processInstance = this.activitiUtil.getProcessInstance(processInstanceId);
        String currentActivity = ((ExecutionEntity)processInstance).getActivityId();
        ReadOnlyProcessDefinition procDef = this.activitiUtil.getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        PvmActivity activity = procDef.findActivity(currentActivity);
        if (this.isReceiveTask(activity) && this.isFirstActivity(activity, procDef)) {
            this.runtimeService.signal(processInstanceId);
        }
        return this.typeConverter.getVirtualStartTask(processInstanceId, (Boolean)false);
    }

    @Override
    public List<WorkflowTask> getAssignedTasks(String authority, WorkflowTaskState state) {
        try {
            if (state == WorkflowTaskState.IN_PROGRESS) {
                List tasks = this.taskService.createTaskQuery().taskAssignee(authority).list();
                return this.typeConverter.convert(tasks);
            }
            List historicTasks = this.historyService.createHistoricTaskInstanceQuery().taskAssignee(authority).finished().list();
            return this.typeConverter.convert(historicTasks);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_ASSIGNED_TASKS);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public List<WorkflowTask> getPooledTasks(List<String> authorities) {
        try {
            if (authorities != null && authorities.size() > 0) {
                String firstAuthority = authorities.get(0);
                HashMap<String, Task> resultingTasks = new HashMap<String, Task>();
                if (this.authorityManager.isUser(firstAuthority)) {
                    this.addTasksForCandidateUser(firstAuthority, resultingTasks);
                    if (authorities.size() > 1) {
                        List<String> remainingAuthorities = authorities.subList(1, authorities.size());
                        this.addTasksForCandidateGroups(remainingAuthorities, resultingTasks);
                    }
                } else {
                    this.addTasksForCandidateGroups(authorities, resultingTasks);
                }
                ArrayList<Task> tasks = new ArrayList<Task>();
                for (Task task : resultingTasks.values()) {
                    if (task.getAssignee() != null) continue;
                    tasks.add(task);
                }
                return this.typeConverter.convert(tasks);
            }
            return Collections.emptyList();
        }
        catch (ActivitiException ae) {
            String authorityString = null;
            if (authorities != null) {
                authorityString = StringUtils.join(authorities.iterator(), (String)", ");
            }
            String msg = this.messageService.getMessage(ERR_GET_POOLED_TASKS, authorityString);
            throw new WorkflowException(msg, ae);
        }
    }

    private void addTasksForCandidateGroups(List<String> groupNames, Map<String, Task> resultingTasks) {
        if (groupNames != null && groupNames.size() > 0) {
            List tasks = this.taskService.createTaskQuery().taskCandidateGroupIn(groupNames).list();
            for (Task task : tasks) {
                resultingTasks.put(task.getId(), task);
            }
        }
    }

    private void addTasksForCandidateUser(String userName, Map<String, Task> resultingTasks) {
        List tasks = this.taskService.createTaskQuery().taskCandidateUser(userName).list();
        for (Task task : tasks) {
            resultingTasks.put(task.getId(), task);
        }
    }

    @Override
    public WorkflowTask getTaskById(String taskId) {
        try {
            String localId = this.createLocalId(taskId);
            if (localId.startsWith("start")) {
                String processInstanceId = localId.replace("start", "");
                return this.typeConverter.getVirtualStartTask(processInstanceId, null);
            }
            Task task = this.activitiUtil.getTaskInstance(localId);
            if (task != null) {
                return this.typeConverter.convert(task);
            }
            HistoricTaskInstance historicTask = this.activitiUtil.getHistoricTaskInstance(localId);
            return this.typeConverter.convert(historicTask);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_GET_TASK_BY_ID);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public List<WorkflowTask> queryTasks(WorkflowTaskQuery query, boolean sameSession) {
        return this.queryTasks(query);
    }

    @Override
    public List<WorkflowTask> queryTasks(WorkflowTaskQuery query) {
        ArrayList<WorkflowTask> result = new ArrayList<WorkflowTask>();
        WorkflowTaskState taskState = query.getTaskState();
        if (!WorkflowTaskState.COMPLETED.equals((Object)taskState)) {
            result.addAll(this.queryRuntimeTasks(query));
        }
        if (!WorkflowTaskState.IN_PROGRESS.equals((Object)taskState)) {
            result.addAll(this.queryHistoricTasks(query));
            result.addAll(this.queryStartTasks(query));
        }
        return result;
    }

    private List<WorkflowTask> queryRuntimeTasks(WorkflowTaskQuery query) {
        if (!Boolean.FALSE.equals(query.isActive())) {
            int limit;
            String processName;
            TaskQuery taskQuery = this.taskService.createTaskQuery();
            if (query.getTaskName() != null) {
                String formKey = query.getTaskName().toPrefixString((NamespacePrefixResolver)this.namespaceService);
                taskQuery.taskVariableValueEquals("taskFormKey", (Object)formKey);
            }
            if (query.getProcessId() != null) {
                String processInstanceId = this.createLocalId(query.getProcessId());
                taskQuery.processInstanceId(processInstanceId);
            }
            if (query.getProcessName() != null) {
                processName = this.getProcessNameMTSafe(query.getProcessName());
                taskQuery.processDefinitionKey(processName);
            }
            if (query.getWorkflowDefinitionName() != null) {
                processName = this.factory.getProcessKey(query.getWorkflowDefinitionName());
                taskQuery.processDefinitionKey(processName);
            }
            if (query.getActorId() != null) {
                taskQuery.taskAssignee(query.getActorId());
            }
            if (query.getTaskId() != null) {
                String taskId = this.createLocalId(query.getTaskId());
                taskQuery.taskId(taskId);
            }
            if (query.getTaskCustomProps() != null) {
                this.addTaskPropertiesToQuery(query.getTaskCustomProps(), taskQuery);
            }
            if (query.getProcessCustomProps() != null) {
                this.addProcessPropertiesToQuery(query.getProcessCustomProps(), taskQuery);
            }
            if (query.getOrderBy() != null) {
                WorkflowTaskQuery.OrderBy[] orderBy = query.getOrderBy();
                this.orderQuery(taskQuery, orderBy);
            }
            List results = (limit = query.getLimit()) > 0 ? taskQuery.listPage(0, limit) : taskQuery.list();
            return this.getValidWorkflowTasks(results);
        }
        return new ArrayList<WorkflowTask>();
    }

    private void addProcessPropertiesToQuery(Map<QName, Object> processCustomProps, TaskQuery taskQuery) {
        for (Map.Entry<QName, Object> customProperty : processCustomProps.entrySet()) {
            String name = this.factory.mapQNameToName(customProperty.getKey());
            Object converted = this.propertyConverter.convertPropertyToValue(customProperty.getValue());
            taskQuery.processVariableValueEquals(name, converted);
        }
    }

    private String getProcessNameMTSafe(QName processNameQName) {
        String key = processNameQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        return this.factory.getProcessKey(key);
    }

    private void orderQuery(TaskQuery taskQuery, WorkflowTaskQuery.OrderBy[] orderBy) {
        for (WorkflowTaskQuery.OrderBy orderByPart : orderBy) {
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskActor_Asc) {
                taskQuery.orderByTaskAssignee().asc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskActor_Desc) {
                taskQuery.orderByTaskAssignee().desc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskCreated_Asc) {
                taskQuery.orderByTaskCreateTime().asc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskCreated_Desc) {
                taskQuery.orderByTaskCreateTime().desc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskDue_Asc || orderByPart == WorkflowTaskQuery.OrderBy.TaskDue_Desc) continue;
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskId_Asc) {
                taskQuery.orderByTaskId().asc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskId_Desc) {
                taskQuery.orderByTaskId().desc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskName_Asc) {
                taskQuery.orderByTaskName().asc();
                continue;
            }
            if (orderByPart != WorkflowTaskQuery.OrderBy.TaskName_Desc) continue;
            taskQuery.orderByTaskName().desc();
        }
    }

    private void orderQuery(HistoricTaskInstanceQuery taskQuery, WorkflowTaskQuery.OrderBy[] orderBy) {
        for (WorkflowTaskQuery.OrderBy orderByPart : orderBy) {
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskActor_Asc) {
                taskQuery.orderByTaskAssignee().asc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskActor_Desc) {
                taskQuery.orderByTaskAssignee().desc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskCreated_Asc) {
                taskQuery.orderByHistoricActivityInstanceStartTime().asc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskCreated_Desc) {
                taskQuery.orderByHistoricActivityInstanceStartTime().desc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskDue_Asc || orderByPart == WorkflowTaskQuery.OrderBy.TaskDue_Desc) continue;
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskId_Asc) {
                taskQuery.orderByTaskId().asc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskId_Desc) {
                taskQuery.orderByTaskId().desc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskName_Asc) {
                taskQuery.orderByTaskName().asc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskName_Desc) {
                taskQuery.orderByTaskName().desc();
                continue;
            }
            if (orderByPart == WorkflowTaskQuery.OrderBy.TaskState_Asc) {
                taskQuery.orderByHistoricTaskInstanceEndTime().asc();
                continue;
            }
            if (orderByPart != WorkflowTaskQuery.OrderBy.TaskState_Desc) continue;
            taskQuery.orderByHistoricTaskInstanceEndTime().asc();
        }
    }

    private void addTaskPropertiesToQuery(Map<QName, Object> taskCustomProps, TaskQuery taskQuery) {
        for (Map.Entry<QName, Object> customProperty : taskCustomProps.entrySet()) {
            String name = this.factory.mapQNameToName(customProperty.getKey());
            Object converted = this.propertyConverter.convertPropertyToValue(customProperty.getValue());
            taskQuery.taskVariableValueEquals(name, converted);
        }
    }

    private List<WorkflowTask> queryHistoricTasks(WorkflowTaskQuery query) {
        int limit;
        String processName;
        HistoricTaskInstanceQuery historicQuery = this.historyService.createHistoricTaskInstanceQuery().finished();
        if (query.getTaskId() != null) {
            String taskId = this.createLocalId(query.getTaskId());
            historicQuery.taskId(taskId);
        }
        if (query.getProcessId() != null) {
            String processInstanceId = this.createLocalId(query.getProcessId());
            historicQuery.processInstanceId(processInstanceId);
        }
        if (query.getTaskName() != null) {
            historicQuery.taskDefinitionKey(query.getTaskName().toPrefixString());
        }
        if (query.getActorId() != null) {
            historicQuery.taskAssignee(query.getActorId());
        }
        if (query.getProcessName() != null) {
            processName = this.getProcessNameMTSafe(query.getProcessName());
            historicQuery.processDefinitionKey(processName);
        }
        if (query.getWorkflowDefinitionName() != null) {
            processName = this.factory.getProcessKey(query.getWorkflowDefinitionName());
            historicQuery.processDefinitionKey(processName);
        }
        if (query.getTaskCustomProps() != null) {
            this.addTaskPropertiesToQuery(query.getTaskCustomProps(), historicQuery);
        }
        if (query.getProcessCustomProps() != null) {
            this.addProcessPropertiesToQuery(query.getProcessCustomProps(), historicQuery);
        }
        if (query.isActive() != null) {
            if (query.isActive().booleanValue()) {
                historicQuery.processUnfinished();
            } else {
                historicQuery.processFinished();
            }
        }
        if (query.getOrderBy() != null) {
            this.orderQuery(historicQuery, query.getOrderBy());
        }
        List results = (limit = query.getLimit()) > 0 ? historicQuery.listPage(0, limit) : historicQuery.list();
        return this.getValidHistoricTasks(results);
    }

    private void addTaskPropertiesToQuery(Map<QName, Object> taskCustomProps, HistoricTaskInstanceQuery taskQuery) {
        for (Map.Entry<QName, Object> customProperty : taskCustomProps.entrySet()) {
            String name = this.factory.mapQNameToName(customProperty.getKey());
            Object converted = this.propertyConverter.convertPropertyToValue(customProperty.getValue());
            taskQuery.taskVariableValueEquals(name, converted);
        }
    }

    private void addProcessPropertiesToQuery(Map<QName, Object> processCustomProps, HistoricTaskInstanceQuery taskQuery) {
        for (Map.Entry<QName, Object> customProperty : processCustomProps.entrySet()) {
            String name = this.factory.mapQNameToName(customProperty.getKey());
            Object converted = this.propertyConverter.convertPropertyToValue(customProperty.getValue());
            taskQuery.processVariableValueEquals(name, converted);
        }
    }

    private List<WorkflowTask> queryStartTasks(WorkflowTaskQuery query) {
        boolean startTaskMatches;
        WorkflowTask workflowTask;
        ArrayList<WorkflowTask> startTasks = new ArrayList<WorkflowTask>();
        String processInstanceId = null;
        String taskId = query.getTaskId();
        if (taskId != null) {
            String localTaskId = this.createLocalId(taskId);
            if (localTaskId.startsWith("start")) {
                processInstanceId = localTaskId.substring("start".length());
            }
        } else {
            String processId = query.getProcessId();
            if (processId != null) {
                processInstanceId = this.createLocalId(processId);
            }
        }
        if (processInstanceId != null && (workflowTask = this.typeConverter.getVirtualStartTask(processInstanceId, null)) != null && (startTaskMatches = this.isStartTaskMatching(workflowTask, query))) {
            startTasks.add(workflowTask);
        }
        return startTasks;
    }

    private boolean isStartTaskMatching(WorkflowTask workflowTask, WorkflowTaskQuery query) {
        String processName;
        if (query.isActive() != null) {
            if (query.isActive().booleanValue() && !workflowTask.getPath().isActive()) {
                return false;
            }
            if (!query.isActive().booleanValue() && workflowTask.getPath().isActive()) {
                return false;
            }
        }
        if (query.getActorId() != null && !query.getActorId().equals(workflowTask.getProperties().get(ContentModel.PROP_OWNER))) {
            return false;
        }
        if (query.getProcessCustomProps() != null) {
            Map<QName, Serializable> props = this.getPathProperties(workflowTask.getPath().getId());
            if (!this.checkPropertiesPresent(query.getProcessCustomProps(), props)) {
                return false;
            }
        }
        if (query.getProcessId() != null && !query.getProcessId().equals(workflowTask.getPath().getInstance().getId())) {
            return false;
        }
        if (query.getProcessName() != null && !(processName = this.factory.mapQNameToName(query.getProcessName())).equals(workflowTask.getPath().getInstance().getDefinition().getName())) {
            return false;
        }
        if (query.getWorkflowDefinitionName() != null && !query.getWorkflowDefinitionName().equals(workflowTask.getPath().getInstance().getDefinition().getName())) {
            return false;
        }
        if (query.getTaskCustomProps() != null && !this.checkPropertiesPresent(query.getTaskCustomProps(), workflowTask.getProperties())) {
            return false;
        }
        if (query.getTaskId() != null && !query.getTaskId().equals(workflowTask.getId())) {
            return false;
        }
        if (query.getTaskName() != null && !query.getTaskName().equals((Object)workflowTask.getDefinition().getMetadata().getName())) {
            return false;
        }
        return query.getTaskState() == null || query.getTaskState().equals((Object)workflowTask.getState());
    }

    private boolean checkPropertiesPresent(Map<QName, Object> expectedProperties, Map<QName, Serializable> props) {
        for (Map.Entry<QName, Object> entry : expectedProperties.entrySet()) {
            if (props.containsKey(entry.getKey())) {
                Object requiredValue = entry.getValue();
                Serializable actualValue = props.get(entry.getKey());
                if (!(requiredValue != null ? !requiredValue.equals(actualValue) : actualValue != null)) break;
                return false;
            }
            if (entry.getValue() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<WorkflowTask> getStartTasks(List<String> workflowInstanceIds, boolean sameSession) {
        ArrayList<WorkflowTask> result = new ArrayList<WorkflowTask>(workflowInstanceIds.size());
        for (String workflowInstanceId : workflowInstanceIds) {
            WorkflowTask startTask = this.getStartTask(workflowInstanceId);
            if (startTask == null) continue;
            result.add(startTask);
        }
        return result;
    }

    @Override
    public WorkflowTask getStartTask(String workflowInstanceId) {
        String instanceId = this.createLocalId(workflowInstanceId);
        return this.typeConverter.getVirtualStartTask(instanceId, null);
    }

    @Override
    public WorkflowTask startTask(String taskId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WorkflowTask suspendTask(String taskId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WorkflowTask updateTask(String taskId, Map<QName, Serializable> properties, Map<QName, List<NodeRef>> add, Map<QName, List<NodeRef>> remove) {
        try {
            if (taskId.startsWith("start")) {
                String msg = this.messageService.getMessage(ERR_UPDATE_START_TASK, taskId);
                throw new WorkflowException(msg);
            }
            Task task = (Task)this.taskService.createTaskQuery().taskId(this.createLocalId(taskId)).singleResult();
            if (task != null) {
                Task updatedTask = this.propertyConverter.updateTask(task, properties, add, remove);
                return this.typeConverter.convert(updatedTask);
            }
            String msg = this.messageService.getMessage(ERR_UPDATE_TASK_UNEXISTING, taskId);
            throw new WorkflowException(msg);
        }
        catch (ActivitiException ae) {
            String msg = this.messageService.getMessage(ERR_UPDATE_TASK, taskId);
            throw new WorkflowException(msg, ae);
        }
    }

    @Override
    public List<WorkflowInstance> getWorkflows(WorkflowInstanceQuery workflowInstanceQuery) {
        LinkedList<WorkflowInstance> results = new LinkedList<WorkflowInstance>();
        if (!Boolean.FALSE.equals(workflowInstanceQuery.getActive())) {
            results.addAll(this.getWorkflowsInternal(workflowInstanceQuery, true));
        }
        if (!Boolean.TRUE.equals(workflowInstanceQuery.getActive())) {
            results.addAll(this.getWorkflowsInternal(workflowInstanceQuery, false));
        }
        return results;
    }

    private List<WorkflowInstance> getWorkflowsInternal(WorkflowInstanceQuery workflowInstanceQuery, boolean isActive) {
        String processDefId = workflowInstanceQuery.getWorkflowDefinitionId() == null ? null : this.createLocalId(workflowInstanceQuery.getWorkflowDefinitionId());
        LinkedList<WorkflowInstance> results = new LinkedList<WorkflowInstance>();
        HistoricProcessInstanceQuery query = isActive ? this.historyService.createHistoricProcessInstanceQuery().unfinished() : this.historyService.createHistoricProcessInstanceQuery().finished();
        if (processDefId != null) {
            query = query.processDefinitionId(processDefId);
        }
        if (workflowInstanceQuery.getExcludedDefinitions() != null) {
            ArrayList<String> exDefIds = new ArrayList<String>();
            for (String excludedDef : workflowInstanceQuery.getExcludedDefinitions()) {
                String exDef = this.createLocalId(excludedDef);
                exDef = exDef.replaceAll("\\*", "%");
                exDefIds.add(exDef);
            }
            if (exDefIds.size() > 0) {
                query.processDefinitionKeyNotIn(exDefIds);
            }
        }
        if (workflowInstanceQuery.getStartBefore() != null) {
            query.startedBefore(workflowInstanceQuery.getStartBefore());
        }
        if (workflowInstanceQuery.getStartAfter() != null) {
            query.startedAfter(workflowInstanceQuery.getStartAfter());
        }
        if (workflowInstanceQuery.getEndBefore() != null) {
            query.finishedBefore(workflowInstanceQuery.getEndBefore());
        }
        if (workflowInstanceQuery.getEndAfter() != null) {
            query.finishedAfter(workflowInstanceQuery.getEndAfter());
        }
        if (workflowInstanceQuery.getCustomProps() != null) {
            NodeRef initiator;
            Map<QName, Object> customProps = workflowInstanceQuery.getCustomProps();
            Object initiatorObject = customProps.get(QNAME_INITIATOR);
            if (initiatorObject != null && initiatorObject instanceof NodeRef && this.nodeService.exists(initiator = (NodeRef)initiatorObject)) {
                String initiatorUserName = (String)((Object)this.nodeService.getProperty(initiator, ContentModel.PROP_USERNAME));
                query.startedBy(initiatorUserName);
                customProps = new HashMap<QName, Object>();
                customProps.putAll(workflowInstanceQuery.getCustomProps());
                customProps.remove(QNAME_INITIATOR);
            }
            for (Map.Entry<QName, Object> prop : customProps.entrySet()) {
                String propertyName = this.factory.mapQNameToName(prop.getKey());
                if (prop.getValue() == null) {
                    query.variableValueEquals(propertyName, null);
                    continue;
                }
                PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(prop.getKey());
                if (propertyDefinition == null) {
                    Object converted = this.propertyConverter.convertPropertyToValue(prop.getValue());
                    query.variableValueEquals(propertyName, converted);
                    continue;
                }
                String propertyType = propertyDefinition.getDataType().getJavaClassName();
                if (propertyType.equals("java.util.Date")) {
                    Map dateProps = (Map)prop.getValue();
                    for (Map.Entry dateProp : dateProps.entrySet()) {
                        if (dateProp.getValue() == null) continue;
                        if (dateProp.getKey() == WorkflowInstanceQuery.DatePosition.BEFORE) {
                            query.variableValueLessThanOrEqual(propertyName, dateProp.getValue());
                        }
                        if (dateProp.getKey() != WorkflowInstanceQuery.DatePosition.AFTER) continue;
                        query.variableValueGreaterThanOrEqual(propertyName, dateProp.getValue());
                    }
                    continue;
                }
                Object convertedValue = DefaultTypeConverter.INSTANCE.convert(propertyDefinition.getDataType(), prop.getValue());
                query.variableValueEquals(propertyName, convertedValue);
            }
        }
        List completedInstances = query.list();
        List completedResults = this.typeConverter.convert(completedInstances);
        results.addAll(completedResults);
        return results;
    }

    public void setNodeConverter(WorkflowNodeConverter nodeConverter) {
        this.nodeConverter = nodeConverter;
    }

    public void setFactory(WorkflowObjectFactory factory) {
        this.factory = factory;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setTypeConverter(ActivitiTypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    public void setActivitiUtil(ActivitiUtil activitiUtil) {
        this.activitiUtil = activitiUtil;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }
}

