/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.script;

import java.util.Map;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.Expression;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowException;

public class ActivitiScriptBase {
    protected static final String PERSON_BINDING_NAME = "person";
    protected static final String USERHOME_BINDING_NAME = "userhome";
    protected static final String EXECUTION_BINDING_NAME = "execution";
    protected Expression script;
    protected Expression runAs;
    protected Expression scriptProcessor;

    protected Object executeScript(String theScript, Map<String, Object> model, String scriptProcessorName, String runAsUser) {
        String user = AuthenticationUtil.getFullyAuthenticatedUser();
        Object scriptResult = null;
        if (runAsUser == null && user != null) {
            scriptResult = this.executeScript(theScript, model, scriptProcessorName);
        } else {
            if (runAsUser != null) {
                this.validateRunAsUser(runAsUser);
            } else {
                runAsUser = AuthenticationUtil.getSystemUserName();
            }
            this.executeScriptAsUser(theScript, model, scriptProcessorName, runAsUser);
        }
        return scriptResult;
    }

    protected Object executeScriptAsUser(final String theScript, final Map<String, Object> model, final String scriptProcessorName, String runAsUser) {
        return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                return ActivitiScriptBase.this.executeScript(theScript, model, scriptProcessorName);
            }
        }, (String)runAsUser);
    }

    protected Object executeScript(String theScript, Map<String, Object> model, String scriptProcessorName) {
        Object scriptResult = null;
        scriptResult = scriptProcessorName != null ? this.getServiceRegistry().getScriptService().executeScriptString(scriptProcessorName, theScript, model) : this.getServiceRegistry().getScriptService().executeScriptString(theScript, model);
        return scriptResult;
    }

    protected String getStringValue(Expression expression, VariableScope scope) {
        if (expression != null) {
            return (String)expression.getValue(scope);
        }
        return null;
    }

    protected ServiceRegistry getServiceRegistry() {
        ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
        if (config != null) {
            ServiceRegistry registry = (ServiceRegistry)config.getBeans().get("services");
            if (registry == null) {
                throw new RuntimeException("Service-registry not present in ProcessEngineConfiguration beans, expected ServiceRegistry with keyservices");
            }
            return registry;
        }
        throw new IllegalStateException("No ProcessEngineCOnfiguration found in active context");
    }

    private void validateRunAsUser(final String runAsUser) {
        Boolean runAsExists = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                return ActivitiScriptBase.this.getServiceRegistry().getPersonService().personExists(runAsUser);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (!runAsExists.booleanValue()) {
            throw new WorkflowException("runas user '" + runAsUser + "' does not exist.");
        }
    }

    protected ActivitiScriptNode getPersonNode(String runAsUser) {
        ServiceRegistry services;
        PersonService personService;
        String userName = null;
        userName = runAsUser != null ? runAsUser : AuthenticationUtil.getFullyAuthenticatedUser();
        if (userName != null && !"System".equals(userName) && (personService = (services = this.getServiceRegistry()).getPersonService()).personExists(userName)) {
            NodeRef person = personService.getPerson(userName);
            return new ActivitiScriptNode(person, services);
        }
        return null;
    }

    public void setScript(Expression script) {
        this.script = script;
    }

    public void setRunAs(Expression runAs) {
        this.runAs = runAs;
    }

    public void setScriptProcessor(Expression scriptProcessor) {
        this.scriptProcessor = scriptProcessor;
    }
}

