/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.util.Calendar;
import java.util.Date;
import org.alfresco.repo.workflow.jbpm.AlfrescoTimer;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.job.Timer;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.scheduler.def.CreateTimerAction;

public class AlfrescoCreateTimerAction
extends CreateTimerAction {
    private static final long serialVersionUID = -7427571820130058416L;
    protected static BusinessCalendar businessCalendar = new BusinessCalendar();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Timer createTimer(ExecutionContext executionContext) {
        Date dueDate = null;
        String dueDateExpression = this.getDueDate();
        if (dueDateExpression.startsWith("#{")) {
            Object result = JbpmExpressionEvaluator.evaluate((String)dueDateExpression, (ExecutionContext)executionContext);
            if (result instanceof Date) {
                dueDate = (Date)result;
            } else {
                if (!(result instanceof Calendar)) throw new WorkflowException("duedate expression must evaluate to a date");
                dueDate = ((Calendar)result).getTime();
            }
        } else {
            Duration duration = new Duration(this.getDueDate());
            dueDate = businessCalendar.add(new Date(), duration);
        }
        AlfrescoTimer timer = new AlfrescoTimer(executionContext.getToken());
        timer.setName(this.getTimerName());
        timer.setRepeat(this.getRepeat());
        timer.setDueDate(dueDate);
        timer.setAction(this.getTimerAction());
        timer.setTransitionName(this.getTransitionName());
        timer.setGraphElement(executionContext.getEventSource());
        timer.setTaskInstance(executionContext.getTaskInstance());
        if (this.getEvent() == null || this.getEvent().getGraphElement() == null) return timer;
        GraphElement graphElement = this.getEvent().getGraphElement();
        try {
            executionContext.setTimer((Timer)timer);
            graphElement.fireEvent("timer-create", executionContext);
            return timer;
        }
        finally {
            executionContext.setTimer(null);
        }
    }
}

