/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.repo.workflow.jbpm.AlfrescoCreateTimerAction;
import org.dom4j.Element;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.jpdl.xml.ProblemListener;
import org.jbpm.scheduler.def.CancelTimerAction;
import org.jbpm.taskmgmt.def.Task;
import org.xml.sax.InputSource;

public class JBPMJpdlXmlReader
extends JpdlXmlReader {
    private static final long serialVersionUID = -753730152120696221L;

    public JBPMJpdlXmlReader(InputStream inputStream) {
        super(new InputSource(inputStream));
    }

    public JBPMJpdlXmlReader(InputSource inputSource, ProblemListener problemListener) {
        super(inputSource, problemListener);
    }

    public JBPMJpdlXmlReader(InputSource inputSource) {
        super(inputSource);
    }

    public JBPMJpdlXmlReader(Reader reader) {
        super(reader);
    }

    protected void readNodeTimer(Element timerElement, Node node) {
        String name = timerElement.attributeValue("name", node.getName());
        AlfrescoCreateTimerAction createTimerAction = new AlfrescoCreateTimerAction();
        createTimerAction.read(timerElement, this);
        createTimerAction.setTimerName(name);
        createTimerAction.setTimerAction(this.readSingleAction(timerElement));
        this.addAction((GraphElement)node, "node-enter", (Action)createTimerAction);
        CancelTimerAction cancelTimerAction = new CancelTimerAction();
        cancelTimerAction.setTimerName(name);
        this.addAction((GraphElement)node, "node-leave", (Action)cancelTimerAction);
    }

    protected void readTaskTimer(Element timerElement, Task task) {
        String name = timerElement.attributeValue("name", task.getName());
        if (name == null) {
            name = "timer-for-task-" + task.getId();
        }
        AlfrescoCreateTimerAction createTimerAction = new AlfrescoCreateTimerAction();
        createTimerAction.read(timerElement, this);
        createTimerAction.setTimerName(name);
        Action action = null;
        if ("timer".equals(timerElement.getName())) {
            action = this.readSingleAction(timerElement);
        } else {
            Delegation delegation = this.createMailDelegation("task-reminder", null, null, null, null);
            action = new Action(delegation);
        }
        createTimerAction.setTimerAction(action);
        this.addAction((GraphElement)task, "task-create", (Action)createTimerAction);
        ArrayList<String> cancelEventTypes = new ArrayList<String>();
        String cancelEventTypeText = timerElement.attributeValue("cancel-event");
        if (cancelEventTypeText != null) {
            StringTokenizer tokenizer = new StringTokenizer(cancelEventTypeText, ",");
            while (tokenizer.hasMoreTokens()) {
                cancelEventTypes.add(tokenizer.nextToken().trim());
            }
        } else {
            cancelEventTypes.add("task-end");
        }
        for (String cancelEventType : cancelEventTypes) {
            CancelTimerAction cancelTimerAction = new CancelTimerAction();
            cancelTimerAction.setTimerName(name);
            this.addAction((GraphElement)task, cancelEventType, (Action)cancelTimerAction);
        }
    }

    public List<Problem> getProblems() {
        return this.problems;
    }
}

