/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.springmodules.workflow.jbpm31.JbpmTemplate;

public class JBPMTransactionTemplate
extends JbpmTemplate
implements TransactionListener {
    private static Log logger = LogFactory.getLog((String)"org.alfresco.repo.workflow");
    private String id = GUID.generate();
    private static final String JBPM_CONTEXT_KEY = JBPMTransactionTemplate.class.getName() + ".context";
    private boolean localContext = true;

    public JBPMTransactionTemplate() {
    }

    public JBPMTransactionTemplate(JbpmConfiguration jbpmConfiguration, ProcessDefinition processDefinition) {
        super(jbpmConfiguration, processDefinition);
    }

    public JBPMTransactionTemplate(JbpmConfiguration jbpmConfiguration) {
        super(jbpmConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        try {
            JBPMTransactionTemplate.super.afterPropertiesSet();
        }
        finally {
            this.localContext = false;
        }
    }

    protected JbpmContext getContext() {
        if (this.localContext) {
            return super.getContext();
        }
        JbpmContext context = (JbpmContext)AlfrescoTransactionSupport.getResource(JBPM_CONTEXT_KEY);
        if (context == null) {
            context = super.getContext();
            AlfrescoTransactionSupport.bindResource(JBPM_CONTEXT_KEY, context);
            AlfrescoTransactionSupport.bindListener(this);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attached JBPM Context to transaction " + AlfrescoTransactionSupport.getTransactionId()));
            }
        }
        return context;
    }

    protected void releaseContext(JbpmContext jbpmContext) {
        if (this.localContext) {
            jbpmContext.close();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterCommit() {
        JbpmContext context = (JbpmContext)AlfrescoTransactionSupport.getResource(JBPM_CONTEXT_KEY);
        if (context != null) {
            super.releaseContext(context);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Detached (commit) JBPM Context from transaction " + AlfrescoTransactionSupport.getTransactionId()));
            }
        }
    }

    @Override
    public void afterRollback() {
        JbpmContext context = (JbpmContext)AlfrescoTransactionSupport.getResource(JBPM_CONTEXT_KEY);
        if (context != null) {
            super.releaseContext(context);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Detached (rollback) JBPM Context from transaction " + AlfrescoTransactionSupport.getTransactionId()));
            }
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JBPMTransactionTemplate) {
            JBPMTransactionTemplate that = (JBPMTransactionTemplate)obj;
            return this.id.equals(that.id);
        }
        return false;
    }
}

