/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.publishing.channels;

import java.util.Map;
import java.util.Set;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.springframework.core.io.Resource;

public interface ChannelType {
    public String getId();

    public String getTitle();

    public QName getChannelNodeType();

    public boolean canPublish();

    public boolean canUnpublish();

    public boolean canPublishStatusUpdates();

    public void sendStatusUpdate(Channel var1, String var2);

    public Set<String> getSupportedMimeTypes();

    public Set<QName> getSupportedContentTypes();

    public String getNodeUrl(NodeRef var1);

    public int getMaximumStatusLength();

    public AuthUrlPair getAuthorisationUrls(Channel var1, String var2);

    public AuthStatus acceptAuthorisationCallback(Channel var1, Map<String, String[]> var2, Map<String, String[]> var3);

    public Resource getIcon(String var1);

    public static enum AuthStatus {
        AUTHORISED,
        RETRY,
        UNAUTHORISED;

    }

    public static final class AuthUrlPair {
        public final String authorisationRequestUrl;
        public final String authorisationRedirectUrl;

        public AuthUrlPair(String authorisationRequestUrl, String authorisationRedirectUrl) {
            this.authorisationRequestUrl = authorisationRequestUrl;
            this.authorisationRedirectUrl = authorisationRedirectUrl;
        }
    }
}

