/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.util.List;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.permissions.PermissionCheckValue;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public interface CopyService {
    @Auditable(parameters={"sourceNodeRef", "targetParentNodeRef", "assocTypeQName", "assocQName", "copyChildren"})
    public NodeRef copy(NodeRef var1, NodeRef var2, QName var3, QName var4, boolean var5);

    @Auditable(parameters={"sourceNodeRef", "targetParentNodeRef", "assocTypeQName", "assocQName", "copyChildren"})
    public NodeRef copyAndRename(NodeRef var1, NodeRef var2, QName var3, QName var4, boolean var5);

    @Auditable(parameters={"sourceNodeRef", "targetParentNodeRef", "assocTypeQName", "assocQName"})
    public NodeRef copy(NodeRef var1, NodeRef var2, QName var3, QName var4);

    @Auditable(parameters={"sourceNodeRef", "destinationNodeRef"})
    public void copy(NodeRef var1, NodeRef var2);

    @Auditable(parameters={"nodeRef"})
    public NodeRef getOriginal(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public List<NodeRef> getCopies(NodeRef var1);

    @Auditable(parameters={"originalNodeRef"})
    public PagingResults<CopyInfo> getCopies(NodeRef var1, PagingRequest var2);

    @Auditable(parameters={"originalNodeRef", "copyParentNodeRef"})
    public PagingResults<CopyInfo> getCopies(NodeRef var1, NodeRef var2, PagingRequest var3);

    public static class CopyInfo
    implements PermissionCheckValue {
        private final NodeRef nodeRef;
        private final String name;

        public CopyInfo(NodeRef nodeRef, String name) {
            this.nodeRef = nodeRef;
            this.name = name;
        }

        @Override
        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public String getName() {
            return this.name;
        }
    }
}

