/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.rule;

import java.util.List;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleType;

public interface RuleService {
    @Auditable
    public List<RuleType> getRuleTypes();

    @Auditable(parameters={"name"})
    public RuleType getRuleType(String var1);

    @Auditable
    public void enableRules();

    @Auditable
    public void disableRules();

    @Auditable
    public boolean isEnabled();

    @Auditable(parameters={"nodeRef"})
    public boolean rulesEnabled(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public void disableRules(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public void enableRules(NodeRef var1);

    @Auditable(parameters={"rule"})
    public void disableRule(Rule var1);

    @Auditable(parameters={"rule"})
    public void enableRule(Rule var1);

    @Auditable(parameters={"ruleType"})
    public void disableRuleType(String var1);

    @Auditable(parameters={"ruleType"})
    public void enableRuleType(String var1);

    @Auditable(parameters={"ruleType"})
    public boolean isRuleTypeEnabled(String var1);

    @Auditable(parameters={"nodeRef"})
    public boolean hasRules(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public List<Rule> getRules(NodeRef var1);

    @Auditable(parameters={"nodeRef", "includeInhertied"})
    public List<Rule> getRules(NodeRef var1, boolean var2);

    @Auditable(parameters={"nodeRef", "includeInhertiedRuleType", "ruleTypeName"})
    public List<Rule> getRules(NodeRef var1, boolean var2, String var3);

    @Auditable(parameters={"nodeRef"})
    public int countRules(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public Rule getRule(NodeRef var1);

    @Auditable(parameters={"nodeRef", "rule"})
    public void saveRule(NodeRef var1, Rule var2);

    @Auditable(parameters={"nodeRef", "rule", "index"})
    public void saveRule(NodeRef var1, Rule var2, int var3);

    @Auditable(parameters={"nodeRef", "ruleNodeRef", "index"})
    public void setRulePosition(NodeRef var1, NodeRef var2, int var3);

    @Auditable(parameters={"nodeRef", "rule", "index"})
    public void setRulePosition(NodeRef var1, Rule var2, int var3);

    @Auditable(parameters={"nodeRef", "rule"})
    public void removeRule(NodeRef var1, Rule var2);

    @Auditable(parameters={"nodeRef"})
    public void removeAllRules(NodeRef var1);

    @Auditable(parameters={"rule"})
    public NodeRef getOwningNodeRef(Rule var1);

    @Auditable(parameters={"action"})
    public NodeRef getOwningNodeRef(Action var1);

    @Auditable(parameters={"nodeRef"})
    public boolean isLinkedToRuleNode(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public NodeRef getLinkedToRuleNode(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public List<NodeRef> getLinkedFromRuleNodes(NodeRef var1);
}

