/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.security;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.permissions.PermissionCheckValue;
import org.alfresco.service.Auditable;
import org.alfresco.service.NotAuditable;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public interface PersonService {
    @Auditable(parameters={"userName"})
    public NodeRef getPerson(String var1);

    @Auditable(parameters={"userName", "autoCreate"})
    public NodeRef getPerson(String var1, boolean var2);

    @Auditable(parameters={"userName"})
    public boolean personExists(String var1);

    @Auditable
    public boolean createMissingPeople();

    @Auditable(parameters={"createMissing"})
    public void setCreateMissingPeople(boolean var1);

    @Auditable
    public Set<QName> getMutableProperties();

    @Auditable(parameters={"userName", "properties"})
    public void setPersonProperties(String var1, Map<QName, Serializable> var2);

    @Auditable(parameters={"userName", "properties", "autoCreate"})
    public void setPersonProperties(String var1, Map<QName, Serializable> var2, boolean var3);

    @Auditable
    public boolean isMutable();

    @Auditable(parameters={"properties"})
    public NodeRef createPerson(Map<QName, Serializable> var1);

    @Auditable(parameters={"properties", "zones"})
    public NodeRef createPerson(Map<QName, Serializable> var1, Set<String> var2);

    @Auditable(parameters={"userName"})
    public void notifyPerson(String var1, String var2);

    @Auditable(parameters={"userName"})
    public void deletePerson(String var1);

    @Auditable(parameters={"personRef"})
    public void deletePerson(NodeRef var1);

    @Auditable
    public Set<NodeRef> getAllPeople();

    @Auditable(parameters={"pattern", "filterProps", "sortProps", "pagingRequest"})
    public PagingResults<PersonInfo> getPeople(String var1, List<QName> var2, List<Pair<QName, Boolean>> var3, PagingRequest var4);

    @Auditable(parameters={"stringPropFilters", "filterIgnoreCase", "sortProps", "pagingRequest"})
    public PagingResults<PersonInfo> getPeople(List<Pair<QName, String>> var1, boolean var2, List<Pair<QName, Boolean>> var3, PagingRequest var4);

    @Auditable
    public Set<NodeRef> getPeopleFilteredByProperty(QName var1, Serializable var2, int var3);

    @Auditable
    public NodeRef getPeopleContainer();

    @Auditable
    public boolean getUserNamesAreCaseSensitive();

    @NotAuditable
    public String getUserIdentifier(String var1);

    @NotAuditable
    public int countPeople();

    @NotAuditable
    public boolean isEnabled(String var1);

    public static class PersonInfo
    implements PermissionCheckValue {
        private final NodeRef nodeRef;
        private final String userName;
        private final String firstName;
        private final String lastName;

        public PersonInfo(NodeRef nodeRef, String userName, String firstName, String lastName) {
            this.nodeRef = nodeRef;
            this.userName = userName;
            this.firstName = firstName;
            this.lastName = lastName;
        }

        @Override
        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }
    }
}

