/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;

public abstract class BaseAlfrescoSpringTest
extends BaseSpringTest {
    protected NodeService nodeService;
    protected ContentService contentService;
    protected MutableAuthenticationService authenticationService;
    protected StoreRef storeRef;
    protected NodeRef rootNodeRef;
    protected ActionService actionService;
    protected TransactionService transactionService;
    protected AuthenticationComponent authenticationComponent;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
    }

    protected void onTearDownInTransaction() throws Exception {
        this.authenticationService.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    protected NodeRef createNode(NodeRef parentNode, String name, QName type) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        String fullName = name + System.currentTimeMillis();
        props.put(ContentModel.PROP_NAME, fullName);
        QName childName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)fullName);
        ChildAssociationRef childAssoc = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, childName, type, props);
        return childAssoc.getChildRef();
    }
}

