/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.json;

import java.util.Arrays;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.util.json.ExceptionJsonSerializer;
import org.json.JSONObject;

public class ExceptionJsonSerializerTest
extends TestCase {
    private ExceptionJsonSerializer serializer;

    protected void setUp() throws Exception {
        super.setUp();
        this.serializer = new ExceptionJsonSerializer();
    }

    public void testIllegalArgumentException() {
        IllegalArgumentException expectedException = new IllegalArgumentException("This is the message");
        JSONObject obj = this.serializer.serialize(expectedException);
        Throwable actualException = this.serializer.deserialize(obj);
        ExceptionJsonSerializerTest.assertEquals(expectedException.getClass(), actualException.getClass());
        ExceptionJsonSerializerTest.assertEquals((String)expectedException.getMessage(), (String)actualException.getMessage());
    }

    public void testAlfrescoRuntimeExceptionWithNoParams() {
        AlfrescoRuntimeException expectedException = new AlfrescoRuntimeException("message id");
        JSONObject obj = this.serializer.serialize(expectedException);
        Throwable actualException = this.serializer.deserialize(obj);
        ExceptionJsonSerializerTest.assertEquals(((Object)((Object)expectedException)).getClass(), actualException.getClass());
        ExceptionJsonSerializerTest.assertEquals((String)expectedException.getMsgId(), (String)((AlfrescoRuntimeException)actualException).getMsgId());
        ExceptionJsonSerializerTest.assertTrue((((AlfrescoRuntimeException)actualException).getMsgParams().length == 0 ? 1 : 0) != 0);
    }

    public void testAlfrescoRuntimeExceptionWithParams() {
        AlfrescoRuntimeException expectedException = new AlfrescoRuntimeException("message id", new Object[]{"one", "two", "three"});
        JSONObject obj = this.serializer.serialize(expectedException);
        Throwable actualException = this.serializer.deserialize(obj);
        ExceptionJsonSerializerTest.assertEquals(((Object)((Object)expectedException)).getClass(), actualException.getClass());
        ExceptionJsonSerializerTest.assertEquals((String)expectedException.getMsgId(), (String)((AlfrescoRuntimeException)actualException).getMsgId());
        ExceptionJsonSerializerTest.assertTrue((boolean)Arrays.deepEquals(expectedException.getMsgParams(), ((AlfrescoRuntimeException)actualException).getMsgParams()));
    }

    public void testAccessDeniedException() {
        AccessDeniedException expectedException = new AccessDeniedException("message id");
        JSONObject obj = this.serializer.serialize((Throwable)((Object)expectedException));
        Throwable actualException = this.serializer.deserialize(obj);
        ExceptionJsonSerializerTest.assertEquals(((Object)((Object)expectedException)).getClass(), actualException.getClass());
        ExceptionJsonSerializerTest.assertEquals((String)expectedException.getMsgId(), (String)((AlfrescoRuntimeException)actualException).getMsgId());
        ExceptionJsonSerializerTest.assertTrue((expectedException.getMsgParams() == null ? 1 : 0) != 0);
    }
}

