/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.Result;
import org.springframework.extensions.surf.util.I18NUtil;

public final class Difference
extends Result {
    private final Where where;
    private final DbProperty left;
    private final DbProperty right;

    public Difference(Where where, DbProperty left, DbProperty right) {
        if (left == null && right == null) {
            throw new IllegalArgumentException("DbProperty parameters cannot BOTH be null.");
        }
        this.where = where;
        this.left = left;
        this.right = right;
    }

    public Where getWhere() {
        return this.where;
    }

    public DbProperty getLeft() {
        return this.left;
    }

    public DbProperty getRight() {
        return this.right;
    }

    @Override
    public String describe() {
        if (this.getLeft() == null) {
            return I18NUtil.getMessage((String)"system.schema_comp.diff.target_only", (Object[])new Object[]{this.getRight().getDbObject().getTypeName(), this.getRight().getPath(), this.getRight().getPropertyValue()});
        }
        if (this.getRight() == null) {
            return I18NUtil.getMessage((String)"system.schema_comp.diff.ref_only", (Object[])new Object[]{this.getLeft().getDbObject().getTypeName(), this.getLeft().getPath(), this.getLeft().getPropertyValue()});
        }
        return I18NUtil.getMessage((String)"system.schema_comp.diff", (Object[])new Object[]{this.getLeft().getDbObject().getTypeName(), this.getLeft().getPath(), this.getLeft().getPropertyValue(), this.getRight().getPath(), this.getRight().getPropertyValue()});
    }

    public String toString() {
        return "Difference [where=" + (Object)((Object)this.where) + ", left=" + this.left + ", right=" + this.right + "]";
    }

    public static enum Where {
        ONLY_IN_REFERENCE,
        ONLY_IN_TARGET,
        IN_BOTH_NO_DIFFERENCE,
        IN_BOTH_BUT_DIFFERENCE;

    }
}

