/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.ValidatingVisitor;
import org.alfresco.util.schemacomp.model.Schema;
import org.hibernate.dialect.Dialect;

public class SchemaComparator {
    public static final String CHAR_SET = "UTF-8";
    public static final String LINE_SEPARATOR = "\r\n";
    private final Schema referenceSchema;
    private final Schema targetSchema;
    private final DiffContext ctx;

    public SchemaComparator(Schema referenceSchema, Schema targetSchema, Dialect dialect) {
        this.referenceSchema = referenceSchema;
        this.targetSchema = targetSchema;
        this.ctx = new DiffContext(dialect, referenceSchema, targetSchema);
    }

    public void validateAndCompare() {
        this.validateTargetSchema();
        this.compare();
    }

    private void compare() {
        this.referenceSchema.diff(this.targetSchema, this.ctx);
    }

    private void validateTargetSchema() {
        ValidatingVisitor validatingVisitor = new ValidatingVisitor(this.ctx);
        this.referenceSchema.accept(validatingVisitor);
    }

    public Results getComparisonResults() {
        return this.ctx.getComparisonResults();
    }
}

