/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ExternalResource;
import org.springframework.context.ApplicationContext;

public abstract class AbstractPersonRule
extends ExternalResource {
    private static final Log log = LogFactory.getLog(AbstractPersonRule.class);
    protected static final String PASSWORD = "PWD";
    protected static final String FIRST_NAME = "firstName";
    protected static final String LAST_NAME = "lastName";
    protected static final String EMAIL = "email@email.com";
    protected static final String JOB_TITLE = "jobTitle";
    protected final ApplicationContext appContext;
    protected final ApplicationContextInit appContextRule;

    public AbstractPersonRule(ApplicationContext appContext) {
        ParameterCheck.mandatory((String)"appContext", (Object)appContext);
        this.appContext = appContext;
        this.appContextRule = null;
    }

    public AbstractPersonRule(ApplicationContextInit appContextRule) {
        ParameterCheck.mandatory((String)"appContextRule", (Object)((Object)appContextRule));
        this.appContext = null;
        this.appContextRule = appContextRule;
    }

    protected ApplicationContext getApplicationContext() {
        ApplicationContext result = null;
        if (this.appContext != null) {
            result = this.appContext;
        } else {
            ApplicationContext contextFromRule = this.appContextRule.getApplicationContext();
            if (contextFromRule != null) {
                result = contextFromRule;
            } else {
                throw new NullPointerException("Cannot retrieve application context from provided rule.");
            }
        }
        return result;
    }

    protected NodeRef createPerson(String userName) {
        NodeRef person;
        ApplicationContext ctxt = this.getApplicationContext();
        MutableAuthenticationService authService = (MutableAuthenticationService)ctxt.getBean("authenticationService");
        PersonService personService = (PersonService)ctxt.getBean("personService");
        if (!authService.authenticationExists(userName)) {
            log.debug((Object)("Creating authentication " + userName + "..."));
            authService.createAuthentication(userName, PASSWORD.toCharArray());
        }
        if (personService.personExists(userName)) {
            person = personService.getPerson(userName, false);
        } else {
            log.debug((Object)("Creating personNode " + userName + "..."));
            PropertyMap ppOne = new PropertyMap();
            ppOne.put(ContentModel.PROP_USERNAME, userName);
            ppOne.put(ContentModel.PROP_FIRSTNAME, FIRST_NAME);
            ppOne.put(ContentModel.PROP_LASTNAME, LAST_NAME);
            ppOne.put(ContentModel.PROP_EMAIL, EMAIL);
            ppOne.put(ContentModel.PROP_JOBTITLE, JOB_TITLE);
            person = personService.createPerson(ppOne);
        }
        return person;
    }

    protected void deletePerson(final String userName) {
        ApplicationContext ctxt = this.getApplicationContext();
        final PersonService personService = (PersonService)ctxt.getBean("personService");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (personService.personExists(userName)) {
                    log.debug((Object)("Deleting person " + userName + "..."));
                    personService.deletePerson(userName);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }
}

