/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ExternalResource;
import org.springframework.context.ApplicationContext;

public class ApplicationContextInit
extends ExternalResource {
    private final String[] configLocations;
    private ApplicationContext appContext;
    private static final Log log = LogFactory.getLog(ApplicationContextInit.class);

    public ApplicationContextInit() {
        this(new String[0]);
    }

    public ApplicationContextInit(String ... configLocations) {
        this.configLocations = configLocations;
    }

    public static ApplicationContextInit createStandardContextWithOverrides(String ... additionalConfigLocations) {
        ArrayList<String> contexts = new ArrayList<String>();
        for (String defaultConfigLocation : ApplicationContextHelper.CONFIG_LOCATIONS) {
            contexts.add(defaultConfigLocation);
        }
        for (String additionalContext : additionalConfigLocations) {
            contexts.add(additionalContext);
        }
        String[] contextsAsArray = contexts.toArray(new String[0]);
        return new ApplicationContextInit(contextsAsArray);
    }

    protected void before() {
        if (this.configLocations.length > 0) {
            log.debug((Object)("Initialising custom Spring Configuration: " + Arrays.asList(this.configLocations).toString()));
            this.appContext = ApplicationContextHelper.getApplicationContext((String[])this.configLocations);
        } else {
            log.debug((Object)"Initialising default Alfresco Spring Configuration");
            this.appContext = ApplicationContextHelper.getApplicationContext();
        }
    }

    protected void after() {
    }

    public List<String> getConfigLocations() {
        return Arrays.asList(this.configLocations);
    }

    public ApplicationContext getApplicationContext() {
        if (this.appContext == null) {
            this.before();
        }
        return this.appContext;
    }
}

