/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ExternalResource;
import org.springframework.context.ApplicationContext;

public class TemporaryNodes
extends ExternalResource {
    private static final Log log = LogFactory.getLog(TemporaryNodes.class);
    private final ApplicationContextInit appContextRule;
    private List<NodeRef> temporaryNodeRefs = new ArrayList<NodeRef>();

    public TemporaryNodes(ApplicationContextInit appContextRule) {
        this.appContextRule = appContextRule;
    }

    protected void before() throws Throwable {
    }

    protected void after() {
        ApplicationContext springContext = this.appContextRule.getApplicationContext();
        final RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)springContext.getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        final CheckOutCheckInService cociService = (CheckOutCheckInService)springContext.getBean("CheckOutCheckInService", CheckOutCheckInService.class);
        final DictionaryService dictionaryService = (DictionaryService)springContext.getBean("DictionaryService", DictionaryService.class);
        final NodeService nodeService = (NodeService)springContext.getBean("NodeService", NodeService.class);
        final SiteService siteService = (SiteService)springContext.getBean("SiteService", SiteService.class);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() throws Throwable {
                        for (NodeRef node : TemporaryNodes.this.temporaryNodeRefs) {
                            if (!nodeService.exists(node)) continue;
                            if (cociService.isCheckedOut(node)) {
                                log.debug((Object)("Cancelling checkout of temporary node " + nodeService.getProperty(node, ContentModel.PROP_NAME)));
                                NodeRef workingCopy = cociService.getWorkingCopy(node);
                                cociService.cancelCheckout(workingCopy);
                            }
                            log.debug((Object)("Deleting temporary node " + nodeService.getProperty(node, ContentModel.PROP_NAME)));
                            QName nodeType = nodeService.getType(node);
                            if (nodeType.equals((Object)SiteModel.TYPE_SITE) || dictionaryService.isSubClass(nodeType, SiteModel.TYPE_SITE)) {
                                SiteInfo siteInfo = siteService.getSite(node);
                                siteService.deleteSite(siteInfo.getShortName());
                                continue;
                            }
                            nodeService.deleteNode(node);
                        }
                        return null;
                    }
                });
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void addNodeRef(NodeRef temporaryNodeRef) {
        this.temporaryNodeRefs.add(temporaryNodeRef);
    }

    public NodeRef createNode(NodeRef parentNode, String nodeCmName, QName nodeType, String nodeCreator) {
        return this.createNodeWithTextContent(parentNode, nodeCmName, nodeType, nodeCreator, null);
    }

    public NodeRef createNodeWithTextContent(NodeRef parentNode, String nodeCmName, QName nodeType, String nodeCreator, String textContent) {
        QName childName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)nodeCmName);
        return this.createNodeWithTextContent(parentNode, childName, nodeCmName, nodeType, nodeCreator, textContent);
    }

    public NodeRef createNodeWithTextContent(final NodeRef parentNode, final QName childName, final String nodeCmName, final QName nodeType, String nodeCreator, final String textContent) {
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)this.appContextRule.getApplicationContext().getBean("retryingTransactionHelper");
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)nodeCreator);
        NodeRef newNodeRef = transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeService nodeService = (NodeService)TemporaryNodes.this.appContextRule.getApplicationContext().getBean("nodeService");
                HashMap<QName, String> props = new HashMap<QName, String>();
                props.put(ContentModel.PROP_NAME, nodeCmName);
                ChildAssociationRef childAssoc = nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, childName, nodeType, props);
                if (textContent != null) {
                    ContentService contentService = (ContentService)TemporaryNodes.this.appContextRule.getApplicationContext().getBean("contentService", ContentService.class);
                    ContentWriter writer = contentService.getWriter(childAssoc.getChildRef(), ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/plain");
                    writer.setEncoding("UTF-8");
                    writer.putContent(textContent);
                }
                return childAssoc.getChildRef();
            }
        });
        AuthenticationUtil.popAuthentication();
        this.temporaryNodeRefs.add(newNodeRef);
        return newNodeRef;
    }

    public NodeRef createFolder(final NodeRef parentNode, final String nodeCmName, String nodeCreator) {
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)this.appContextRule.getApplicationContext().getBean("retryingTransactionHelper");
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)nodeCreator);
        NodeRef newNodeRef = transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef result = TemporaryNodes.this.createNode(nodeCmName, parentNode, ContentModel.TYPE_FOLDER);
                return result;
            }
        });
        AuthenticationUtil.popAuthentication();
        this.temporaryNodeRefs.add(newNodeRef);
        return newNodeRef;
    }

    public NodeRef createQuickFile(final String mimetype, final NodeRef parentNode, final String nodeCmName, String nodeCreator) {
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)this.appContextRule.getApplicationContext().getBean("retryingTransactionHelper");
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)nodeCreator);
        NodeRef newNodeRef = transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef result = TemporaryNodes.this.createNode(nodeCmName, parentNode, ContentModel.TYPE_CONTENT);
                File quickFile = TemporaryNodes.this.loadQuickFile(mimetype);
                ContentService contentService = (ContentService)TemporaryNodes.this.appContextRule.getApplicationContext().getBean("contentService", ContentService.class);
                ContentWriter writer = contentService.getWriter(result, ContentModel.PROP_CONTENT, true);
                writer.setMimetype(mimetype);
                writer.setEncoding("UTF-8");
                writer.putContent(quickFile);
                return result;
            }
        });
        AuthenticationUtil.popAuthentication();
        this.temporaryNodeRefs.add(newNodeRef);
        return newNodeRef;
    }

    private NodeRef createNode(String cmName, NodeRef parentNode, QName nodeType) {
        NodeService nodeService = (NodeService)this.appContextRule.getApplicationContext().getBean("nodeService");
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, cmName);
        ChildAssociationRef childAssoc = nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, nodeType, props);
        return childAssoc.getChildRef();
    }

    private File loadQuickFile(String mimetype) {
        MimetypeMap mimetypeService = (MimetypeMap)this.appContextRule.getApplicationContext().getBean("mimetypeService");
        String extension = mimetypeService.getExtension(mimetype);
        if (extension == null) {
            throw new UnsupportedOperationException("No 'quick' file for unrecognised mimetype: " + mimetype);
        }
        URL url = AbstractContentTransformerTest.class.getClassLoader().getResource("quick/quick." + extension);
        if (url == null) {
            throw new UnsupportedOperationException("No 'quick' file for extension: " + extension);
        }
        File file = new File(url.getFile());
        if (!file.exists()) {
            throw new UnsupportedOperationException("No 'quick' file for extension: " + extension);
        }
        return file;
    }
}

