/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.test.junitrules.AbstractPersonRule;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.GUID;

public class TemporarySites
extends AbstractPersonRule {
    private static final Log log = LogFactory.getLog(TemporarySites.class);
    private List<SiteInfo> temporarySites = new ArrayList<SiteInfo>();
    private List<String> temporarySiteUsers = new ArrayList<String>();

    public TemporarySites(ApplicationContextInit appContextRule) {
        super(appContextRule);
    }

    protected void before() throws Throwable {
    }

    protected void after() {
        final RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)this.appContextRule.getApplicationContext().getBean("retryingTransactionHelper");
        final SiteService siteService = (SiteService)this.appContextRule.getApplicationContext().getBean("siteService", SiteService.class);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() throws Throwable {
                        for (SiteInfo site : TemporarySites.this.temporarySites) {
                            String shortName = site.getShortName();
                            if (siteService.getSite(shortName) == null) continue;
                            log.debug((Object)("Deleting temporary site " + shortName));
                            siteService.deleteSite(shortName);
                        }
                        for (String username : TemporarySites.this.temporarySiteUsers) {
                            log.debug((Object)("Deleting temporary site user " + username));
                            TemporarySites.this.deletePerson(username);
                        }
                        return null;
                    }
                });
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    public void addSite(SiteInfo temporarySite) {
        this.temporarySites.add(temporarySite);
    }

    public SiteInfo createSite(String sitePreset, String siteShortName, String siteTitle, String siteDescription, SiteVisibility visibility, String siteCreator) {
        return this.createSite(sitePreset, siteShortName, siteTitle, siteDescription, visibility, SiteModel.TYPE_SITE, siteCreator);
    }

    public SiteInfo createSite(final String sitePreset, final String siteShortName, final String siteTitle, final String siteDescription, final SiteVisibility visibility, final QName siteType, String siteCreator) {
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)this.appContextRule.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)siteCreator);
        SiteInfo newSite = transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            @Override
            public SiteInfo execute() throws Throwable {
                SiteService siteService = (SiteService)TemporarySites.this.appContextRule.getApplicationContext().getBean("siteService", SiteService.class);
                SiteInfo newSite = siteService.createSite(sitePreset, siteShortName, siteTitle, siteDescription, visibility, siteType);
                NodeRef docLibFolder = siteService.getContainer(siteShortName, "documentLibrary");
                if (docLibFolder == null) {
                    docLibFolder = siteService.createContainer(siteShortName, "documentLibrary", ContentModel.TYPE_FOLDER, null);
                }
                return newSite;
            }
        });
        AuthenticationUtil.popAuthentication();
        this.temporarySites.add(newSite);
        return newSite;
    }

    public TestSiteAndMemberInfo createTestSiteWithUserPerRole(final String siteShortName, String sitePreset, SiteVisibility visibility, String siteCreator) {
        SiteInfo result = this.createSite(sitePreset, siteShortName, null, null, visibility, siteCreator);
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)this.appContextRule.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        final SiteService siteService = (SiteService)this.appContextRule.getApplicationContext().getBean("siteService", SiteService.class);
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)siteCreator);
        List<String> userNames = transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<String>>(){

            @Override
            public List<String> execute() throws Throwable {
                ArrayList<String> users = new ArrayList<String>(4);
                for (String shareRole : SiteModel.STANDARD_PERMISSIONS) {
                    String userName = siteShortName + "_" + shareRole + "_" + GUID.generate();
                    log.debug((Object)("Creating temporary site user " + userName));
                    TemporarySites.this.createPerson(userName);
                    siteService.setMembership(siteShortName, userName, shareRole);
                    users.add(userName);
                    TemporarySites.this.temporarySiteUsers.add(userName);
                }
                return users;
            }
        });
        NodeRef doclibFolder = transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                return siteService.getContainer(siteShortName, "documentLibrary");
            }
        });
        AuthenticationUtil.popAuthentication();
        return new TestSiteAndMemberInfo(result, doclibFolder, userNames.get(0), userNames.get(1), userNames.get(2), userNames.get(3));
    }

    public static class TestSiteAndMemberInfo {
        public final SiteInfo siteInfo;
        public final NodeRef doclib;
        public final String siteManager;
        public final String siteCollaborator;
        public final String siteContributor;
        public final String siteConsumer;

        public TestSiteAndMemberInfo(SiteInfo siteInfo, NodeRef siteDocLib, String siteManager, String siteCollaborator, String siteContributor, String siteConsumer) {
            this.siteInfo = siteInfo;
            this.doclib = siteDocLib;
            this.siteManager = siteManager;
            this.siteCollaborator = siteCollaborator;
            this.siteContributor = siteContributor;
            this.siteConsumer = siteConsumer;
        }
    }
}

