/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.preview;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.wcm.preview.PreviewContext;
import org.alfresco.wcm.preview.PreviewURIService;
import org.alfresco.wcm.preview.PreviewURIServiceProvider;
import org.alfresco.wcm.preview.PreviewURIServiceRegistry;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.wcm.webproject.WebProjectService;
import org.springframework.extensions.surf.util.ParameterCheck;

public class PreviewURIServiceImpl
implements PreviewURIService {
    private PreviewURIServiceRegistry previewURIProviderRegistry;
    private WebProjectService wpService;

    public void setPreviewURIServiceRegistry(PreviewURIServiceRegistry previewURIProviderRegistry) {
        this.previewURIProviderRegistry = previewURIProviderRegistry;
    }

    public void setWebProjectService(WebProjectService wpService) {
        this.wpService = wpService;
    }

    @Override
    public String getPreviewURI(String sbStoreId, String pathToAsset) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        String wpStoreId = WCMUtil.getWebProjectStoreId(sbStoreId);
        String authenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
        String webApp = null;
        if (pathToAsset != null) {
            webApp = WCMUtil.getWebapp(AVMUtil.buildAVMPath(sbStoreId, pathToAsset));
        }
        PreviewContext prevCtx = new PreviewContext(wpStoreId, webApp, authenticatedUser);
        return this.getProvider(wpStoreId).getPreviewURI(sbStoreId, pathToAsset, prevCtx);
    }

    @Override
    public List<String> getPreviewURIs(String sbStoreId, List<String> pathsToAssets) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatory((String)"pathsToAssets", pathsToAssets);
        String wpStoreId = WCMUtil.getWebProjectStoreId(sbStoreId);
        String authenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
        String webApp = WCMUtil.getCommonWebApp(sbStoreId, pathsToAssets);
        PreviewContext prevCtx = new PreviewContext(wpStoreId, webApp, authenticatedUser);
        return this.getProvider(wpStoreId).getPreviewURIs(sbStoreId, pathsToAssets, prevCtx);
    }

    @Override
    public Set<String> getProviderNames() {
        Map<String, PreviewURIServiceProvider> previewProviders = this.previewURIProviderRegistry.getPreviewURIServiceProviders();
        return previewProviders.keySet();
    }

    @Override
    public String getDefaultProviderName() {
        return this.previewURIProviderRegistry.getDefaultProviderName();
    }

    @Override
    public String getProviderName(String wpStoreId) {
        return this.wpService.getPreviewProvider(wpStoreId);
    }

    private PreviewURIServiceProvider getProvider(String wpStoreId) {
        PreviewURIServiceProvider previewProvider = this.previewURIProviderRegistry.getPreviewURIServiceProviders().get(this.getProviderName(wpStoreId));
        if (previewProvider == null) {
            previewProvider = this.previewURIProviderRegistry.getPreviewURIServiceProviders().get(this.previewURIProviderRegistry.getDefaultProviderName());
        }
        return previewProvider;
    }
}

