/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.VirtServerUtils;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class WCMUtil
extends AVMUtil {
    private static Log logger = LogFactory.getLog(WCMUtil.class);
    protected static final String STORE_SEPARATOR = "--";
    protected static final Pattern PATTERN_ILLEGAL_SEQUENCE = Pattern.compile("[\\\"\\*\\\\\\>\\<\\?\\/\\:\\|]|[^\\p{ASCII}]|-x|--");
    protected static final String STORE_WORKFLOW = "workflow";
    protected static final String STORE_PREVIEW = "preview";
    public static final String DIR_ROOT = "ROOT";
    protected static final String SPACE_ICON_WEBSITE = "space-icon-website";
    public static final String LOCK_KEY_STORE_NAME = "avm-store-name";
    public static final String ROLE_CONTENT_MANAGER = "ContentManager";
    public static final String ROLE_CONTENT_PUBLISHER = "ContentPublisher";
    public static final String ROLE_CONTENT_CONTRIBUTOR = "ContentContributor";
    public static final String ROLE_CONTENT_REVIEWER = "ContentReviewer";
    private static final Pattern WEBAPP_RELATIVE_PATH_PATTERN = Pattern.compile("([^:]+:/www/avm_webapps/([^/]+))(.*)");
    private static final Pattern SANDBOX_RELATIVE_PATH_PATTERN = Pattern.compile("([^:]+:/www/avm_webapps)(.*)");
    public static final String WORKFLOW_SUBMITDIRECT_NAME = "wcmwf:submitdirect";

    public static String getSandboxStoreId(String avmPath) {
        return WCMUtil.getStoreName(avmPath);
    }

    public static String getWebProjectStoreId(String storeName) {
        int index = storeName.indexOf(STORE_SEPARATOR);
        return index == -1 ? storeName : storeName.substring(0, index);
    }

    public static String getWebProjectStoreIdFromPath(String avmPath) {
        return WCMUtil.getWebProjectStoreId(WCMUtil.getStoreName(avmPath));
    }

    protected static boolean isPreviewStore(String storeName) {
        return storeName != null && storeName.endsWith("--preview");
    }

    protected static boolean isLocalhostDeployedStore(String wpStoreId, String storeName) {
        return storeName.startsWith(wpStoreId) && storeName.endsWith("live") && !wpStoreId.endsWith("live");
    }

    protected static boolean isWorkflowStore(String storeName) {
        if (WCMUtil.isPreviewStore(storeName)) {
            storeName = WCMUtil.getCorrespondingMainStoreName(storeName);
        }
        return storeName != null && storeName.indexOf("--workflow") != -1;
    }

    public static boolean isUserStore(String storeName) {
        if (WCMUtil.isPreviewStore(storeName)) {
            storeName = WCMUtil.getCorrespondingMainStoreName(storeName);
        }
        return storeName != null && storeName.indexOf(STORE_SEPARATOR) != -1;
    }

    public static boolean isStagingStore(String storeName) {
        return storeName != null && storeName.indexOf(STORE_SEPARATOR) == -1;
    }

    public static String getUserName(String storeName) {
        int index;
        if (WCMUtil.isPreviewStore(storeName)) {
            storeName = WCMUtil.getCorrespondingMainStoreName(storeName);
        }
        return (index = storeName.indexOf(STORE_SEPARATOR)) == -1 ? null : WCMUtil.unescapeStoreNameComponent(storeName.substring(index + STORE_SEPARATOR.length()));
    }

    public static String getWorkflowId(String storeName) {
        int index;
        if (WCMUtil.isPreviewStore(storeName)) {
            storeName = WCMUtil.getCorrespondingMainStoreName(storeName);
        }
        return (index = storeName.indexOf("--workflow")) == -1 ? null : storeName.substring(index + STORE_SEPARATOR.length());
    }

    protected static String getCorrespondingMainStoreName(String storeName) {
        if (!WCMUtil.isPreviewStore(storeName)) {
            throw new IllegalArgumentException("store " + storeName + " is not a preview store");
        }
        return storeName.substring(0, storeName.length() - "--preview".length());
    }

    protected static String getCorrespondingPreviewStoreName(String storeName) {
        if (WCMUtil.isPreviewStore(storeName)) {
            throw new IllegalArgumentException("store " + storeName + " is already a preview store");
        }
        return storeName + STORE_SEPARATOR + STORE_PREVIEW;
    }

    protected static String getCorrespondingPathInMainStore(String avmPath) {
        String storeName = WCMUtil.getStoreName(avmPath);
        storeName = WCMUtil.getCorrespondingMainStoreName(storeName);
        return WCMUtil.getCorrespondingPath(avmPath, storeName);
    }

    protected static String getCorrespondingPathInPreviewStore(String avmPath) {
        String storeName = WCMUtil.getStoreName(avmPath);
        storeName = WCMUtil.getCorrespondingPreviewStoreName(storeName);
        return WCMUtil.getCorrespondingPath(avmPath, storeName);
    }

    public static String getCorrespondingPath(String avmPath, String otherStoreName) {
        return WCMUtil.buildAVMPath(otherStoreName, WCMUtil.getStoreRelativePath(avmPath));
    }

    public static final String escapeStoreNameComponent(String component) {
        StringBuilder builder = null;
        int length = component.length();
        if (component.equals(STORE_PREVIEW) || component.equals(STORE_WORKFLOW)) {
            builder = new StringBuilder(length + 5);
            WCMUtil.appendEncoded(builder, component);
            return builder.toString();
        }
        Matcher matcher = PATTERN_ILLEGAL_SEQUENCE.matcher(component);
        int lastAppendPosition = 0;
        while (matcher.find()) {
            if (builder == null) {
                builder = new StringBuilder(length + 5);
            }
            if (matcher.start() != lastAppendPosition) {
                builder.append(component, lastAppendPosition, matcher.start());
            }
            lastAppendPosition = matcher.end();
            WCMUtil.appendEncoded(builder, matcher.group());
        }
        if (builder == null) {
            return component;
        }
        if (lastAppendPosition < length) {
            builder.append(component, lastAppendPosition, length);
        }
        return builder.toString();
    }

    private static String unescapeStoreNameComponent(String component) {
        int escapeIndex;
        StringBuilder builder = null;
        int length = component.length();
        int lastAppendPosition = 0;
        while ((escapeIndex = component.indexOf("-x", lastAppendPosition)) != -1) {
            if (builder == null) {
                builder = new StringBuilder(length + 5);
            }
            if (escapeIndex != lastAppendPosition) {
                builder.append(component, lastAppendPosition, escapeIndex);
            }
            lastAppendPosition = component.indexOf(45, escapeIndex + 2);
            builder.appendCodePoint(Integer.parseInt(component.substring(escapeIndex + 2, lastAppendPosition), 16));
            ++lastAppendPosition;
        }
        if (builder == null) {
            return component;
        }
        if (lastAppendPosition < length) {
            builder.append(component, lastAppendPosition, length);
        }
        return builder.toString();
    }

    private static final void appendEncoded(StringBuilder builder, String sequence) {
        builder.append("-x").append(Integer.toString(sequence.codePointAt(0), 16).toUpperCase()).append("-");
        int length = sequence.length();
        int next = sequence.offsetByCodePoints(0, 1);
        if (next < length) {
            builder.append(sequence, next, length);
        }
    }

    public static String buildStagingStoreName(String wpStoreId) {
        ParameterCheck.mandatoryString((String)"wpStoreId", (String)wpStoreId);
        return wpStoreId;
    }

    protected static String buildStagingPreviewStoreName(String storeId) {
        return WCMUtil.buildStagingStoreName(storeId) + STORE_SEPARATOR + STORE_PREVIEW;
    }

    public static String buildUserMainStoreName(String storeId, String userName) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        String fixedUserName = WCMUtil.escapeStoreNameComponent(userName);
        return WCMUtil.buildStagingStoreName(storeId) + STORE_SEPARATOR + fixedUserName;
    }

    protected static String buildUserPreviewStoreName(String storeId, String username) {
        return WCMUtil.buildUserMainStoreName(storeId, username) + STORE_SEPARATOR + STORE_PREVIEW;
    }

    protected static String buildWorkflowMainStoreName(String storeId, String workflowId) {
        ParameterCheck.mandatoryString((String)"workflowId", (String)workflowId);
        return WCMUtil.buildStagingStoreName(storeId) + STORE_SEPARATOR + workflowId;
    }

    protected static String buildWorkflowPreviewStoreName(String storeId, String workflowId) {
        return WCMUtil.buildWorkflowMainStoreName(storeId, workflowId) + STORE_SEPARATOR + STORE_PREVIEW;
    }

    public static String buildStoreRootPath(String storeName) {
        ParameterCheck.mandatoryString((String)"storeName", (String)storeName);
        return WCMUtil.buildAVMPath(storeName, "/www");
    }

    public static String buildSandboxRootPath(String storeName) {
        ParameterCheck.mandatoryString((String)"storeName", (String)storeName);
        return WCMUtil.buildAVMPath(storeName, "/www/avm_webapps");
    }

    public static String buildStoreWebappPath(String storeName, String webApp) {
        ParameterCheck.mandatoryString((String)"webApp", (String)webApp);
        return WCMUtil.buildSandboxRootPath(storeName) + '/' + webApp;
    }

    public static String lookupStoreDNS(AVMService avmService, String store) {
        ParameterCheck.mandatoryString((String)"store", (String)store);
        Map<QName, PropertyValue> props = avmService.queryStorePropertyKey(store, QName.createQName(null, (String)".dns.%"));
        return props.size() == 1 ? props.keySet().iterator().next().getLocalName().substring(".dns.".length()) : null;
    }

    public static NodeRef getWebProjectNodeFromWebProjectStore(AVMService avmService, String wpStoreId) {
        NodeRef wpNodeRef = null;
        String stagingStoreId = wpStoreId;
        try {
            PropertyValue pValue = avmService.getStoreProperty(stagingStoreId, SandboxConstants.PROP_WEB_PROJECT_NODE_REF);
            if (pValue != null) {
                wpNodeRef = (NodeRef)pValue.getValue(DataTypeDefinition.NODE_REF);
            }
        }
        catch (AVMNotFoundException nfe) {
            logger.warn((Object)(wpStoreId + " is not a web project: " + (Object)((Object)nfe)));
        }
        return wpNodeRef;
    }

    public static String getWebProject(AVMService avmService, String avmStoreName) {
        String wpStoreId = WCMUtil.getWebProjectStoreId(avmStoreName);
        if (WCMUtil.getWebProjectNodeFromWebProjectStore(avmService, wpStoreId) != null) {
            return wpStoreId;
        }
        return null;
    }

    public static String getStoreRelativePath(String absoluteAVMPath) {
        ParameterCheck.mandatoryString((String)"absoluteAVMPath", (String)absoluteAVMPath);
        return AVMUtil.splitPath(absoluteAVMPath)[1];
    }

    protected static String getWebappRelativePath(String absoluteAVMPath) {
        Matcher m = WEBAPP_RELATIVE_PATH_PATTERN.matcher(absoluteAVMPath);
        return m.matches() && m.group(3).length() != 0 ? m.group(3) : "/";
    }

    public static String getWebapp(String absoluteAVMPath) {
        Matcher m = WEBAPP_RELATIVE_PATH_PATTERN.matcher(absoluteAVMPath);
        return m.matches() && m.group(2).length() != 0 ? m.group(2) : null;
    }

    protected static String getWebappPath(String absoluteAVMPath) {
        Matcher m = WEBAPP_RELATIVE_PATH_PATTERN.matcher(absoluteAVMPath);
        return m.matches() && m.group(1).length() != 0 ? m.group(1) : null;
    }

    protected static String getSandboxRelativePath(String absoluteAVMPath) {
        Matcher m = SANDBOX_RELATIVE_PATH_PATTERN.matcher(absoluteAVMPath);
        return m.matches() && m.group(2).length() != 0 ? m.group(2) : "/";
    }

    protected static String getSandboxPath(String absoluteAVMPath) {
        Matcher m = SANDBOX_RELATIVE_PATH_PATTERN.matcher(absoluteAVMPath);
        return m.matches() && m.group(1).length() != 0 ? m.group(1) : null;
    }

    protected static Map<String, String> listWebUsers(NodeService nodeService, NodeRef wpNodeRef) {
        List<ChildAssociationRef> userInfoRefs = WCMUtil.listWebUserRefs(nodeService, wpNodeRef, true);
        HashMap<String, String> webUsers = new HashMap<String, String>(23);
        for (ChildAssociationRef ref : userInfoRefs) {
            NodeRef userInfoRef = ref.getChildRef();
            String userName = (String)((Object)nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERNAME));
            String userRole = (String)((Object)nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERROLE));
            webUsers.put(userName, userRole);
        }
        return webUsers;
    }

    protected static List<ChildAssociationRef> listWebUserRefs(NodeService nodeService, NodeRef wpNodeRef, boolean preLoad) {
        return nodeService.getChildAssocs(wpNodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBUSER, RegexQNamePattern.MATCH_ALL, preLoad);
    }

    public static void updateVServerWebapp(VirtServerRegistry vServerRegistry, String path, boolean force) {
        if (force || VirtServerUtils.requiresUpdateNotification((String)path)) {
            int webappIndex = path.indexOf(47, path.indexOf("avm_webapps") + "avm_webapps".length() + 1);
            if (webappIndex != -1) {
                path = path.substring(0, webappIndex);
            }
            vServerRegistry.updateWebapp(-1, path, true);
        }
    }

    protected static void removeAllVServerWebapps(VirtServerRegistry vServerRegistry, String path, boolean force) {
        if (force || VirtServerUtils.requiresUpdateNotification((String)path)) {
            int webappIndex = path.indexOf(47, path.indexOf("avm_webapps") + "avm_webapps".length() + 1);
            if (webappIndex != -1) {
                path = path.substring(0, webappIndex);
            }
            vServerRegistry.removeAllWebapps(-1, path, true);
        }
    }

    protected static void removeVServerWebapp(VirtServerRegistry vServerRegistry, String path, boolean force) {
        if (force || VirtServerUtils.requiresUpdateNotification((String)path)) {
            int webappIndex = path.indexOf(47, path.indexOf("avm_webapps") + "avm_webapps".length() + 1);
            if (webappIndex != -1) {
                path = path.substring(0, webappIndex);
            }
            vServerRegistry.removeWebapp(-1, path, true);
        }
    }

    public static String getCommonWebApp(String sbStoreId, List<String> storeRelativePaths) {
        String derivedWebApp = null;
        boolean multiWebAppsFound = false;
        for (String storeRelativePath : storeRelativePaths) {
            String srcPath = WCMUtil.buildAVMPath(sbStoreId, storeRelativePath);
            String srcWebApp = WCMUtil.getWebapp(srcPath);
            if (srcWebApp == null) continue;
            if (derivedWebApp == null) {
                derivedWebApp = srcWebApp;
                continue;
            }
            if (derivedWebApp.equals(srcWebApp)) continue;
            multiWebAppsFound = true;
        }
        return !multiWebAppsFound ? derivedWebApp : null;
    }
}

