/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DecryptingInputStream
extends InputStream {
    private final DataInputStream wrapped;
    private final Cipher inputCipher;
    private final Mac mac;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
    private final DataOutputStream dataStr = new DataOutputStream(this.buffer);
    private byte[] currentDataBlock;
    private byte[] nextDataBlock;
    private boolean isAtEnd;
    private int currentDataPos;

    public DecryptingInputStream(InputStream wrapped, PrivateKey privKey) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        this(wrapped, privKey, "AES", "CBC", "PKCS5PADDING");
    }

    public DecryptingInputStream(InputStream wrapped, PrivateKey privKey, String algorithm, String mode, String padding) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        this.wrapped = new DataInputStream(wrapped);
        SecureRandom secRand = SecureRandom.getInstance("SHA1PRNG");
        Cipher rsa = Cipher.getInstance("RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING");
        rsa.init(2, (Key)privKey, secRand);
        SecretKeySpec symKey = new SecretKeySpec(rsa.doFinal(this.readBlock()), algorithm);
        byte[] keyIV = rsa.doFinal(this.readBlock());
        this.inputCipher = Cipher.getInstance(algorithm + "/" + mode + "/" + padding);
        this.inputCipher.init(2, (Key)symKey, new IvParameterSpec(keyIV));
        SecretKeySpec macKey = new SecretKeySpec(this.inputCipher.doFinal(this.readBlock()), "HMACSHA1");
        this.mac = Mac.getInstance("HMACSHA1");
        this.mac.init(macKey);
        this.nextDataBlock = this.readBlock(false);
    }

    private byte[] readBlock() throws IOException {
        return this.readBlock(true);
    }

    private byte[] readBlock(boolean updateMac) throws IOException {
        int len;
        try {
            len = this.wrapped.readInt();
        }
        catch (EOFException e) {
            return null;
        }
        byte[] in = new byte[len];
        this.wrapped.readFully(in);
        if (updateMac) {
            this.macBlock(in);
        }
        return in;
    }

    private void macBlock(byte[] block) throws IOException {
        this.dataStr.writeInt(block.length);
        this.dataStr.write(block);
        if (this.mac != null) {
            this.dataStr.flush();
            byte[] bytes = this.buffer.toByteArray();
            this.buffer.reset();
            this.mac.update(bytes);
        }
    }

    @Override
    public int read() throws IOException {
        int bytesRead;
        byte[] buf = new byte[1];
        while ((bytesRead = this.read(buf)) == 0) {
        }
        return bytesRead == -1 ? -1 : buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int bytesToRead = len;
        block2: while (bytesToRead > 0) {
            while (this.currentDataBlock == null || this.currentDataPos >= this.currentDataBlock.length) {
                if (this.isAtEnd) {
                    this.nextDataBlock = null;
                    this.currentDataBlock = null;
                    break block2;
                }
                byte[] newDataBlock = this.readBlock(false);
                if (newDataBlock == null) {
                    if (!MessageDigest.isEqual(this.mac.doFinal(), this.nextDataBlock)) {
                        throw new IOException("Invalid HMAC");
                    }
                    try {
                        this.currentDataBlock = this.inputCipher.doFinal();
                    }
                    catch (GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                    this.isAtEnd = true;
                } else {
                    this.macBlock(this.nextDataBlock);
                    this.currentDataBlock = this.inputCipher.update(this.nextDataBlock);
                    this.nextDataBlock = newDataBlock;
                }
                this.currentDataPos = 0;
            }
            int bytesRead = Math.min(bytesToRead, this.currentDataBlock.length - this.currentDataPos);
            System.arraycopy(this.currentDataBlock, this.currentDataPos, b, off, bytesRead);
            bytesToRead -= bytesRead;
            off += bytesRead;
            this.currentDataPos += bytesRead;
        }
        return bytesToRead == len ? -1 : len - bytesToRead;
    }

    @Override
    public int available() throws IOException {
        return this.currentDataBlock == null ? 0 : this.currentDataBlock.length - this.currentDataPos;
    }

    @Override
    public void close() throws IOException {
        if (this.nextDataBlock != null) {
            byte[] skipBuff = new byte[1024];
            while (this.read(skipBuff) != -1) {
            }
        }
        this.wrapped.close();
        this.dataStr.close();
    }
}

