/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class EncryptingOutputStream
extends OutputStream {
    private final OutputStream wrapped;
    private final Cipher outputCipher;
    private final Mac mac;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
    private final DataOutputStream dataStr = new DataOutputStream(this.buffer);

    public EncryptingOutputStream(OutputStream wrapped, PublicKey receiverKey, SecureRandom rand) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this(wrapped, receiverKey, "AES", rand, 128, "CBC", "PKCS5PADDING");
    }

    public EncryptingOutputStream(OutputStream wrapped, PublicKey receiverKey, String algorithm, SecureRandom rand, int strength, String mode, String padding) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this.wrapped = wrapped;
        KeyGenerator keyGen = KeyGenerator.getInstance(algorithm);
        keyGen.init(strength, rand);
        SecretKey symKey = keyGen.generateKey();
        this.outputCipher = Cipher.getInstance(algorithm + "/" + mode + "/" + padding);
        this.outputCipher.init(1, (Key)symKey, rand);
        this.mac = Mac.getInstance("HMACSHA1");
        byte[] macKeyBytes = new byte[20];
        rand.nextBytes(macKeyBytes);
        SecretKeySpec macKey = new SecretKeySpec(macKeyBytes, "HMACSHA1");
        this.mac.init(macKey);
        Cipher rsa = Cipher.getInstance("RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING");
        rsa.init(1, (Key)receiverKey, rand);
        this.writeBlock(rsa.doFinal(symKey.getEncoded()));
        this.writeBlock(rsa.doFinal(this.outputCipher.getIV()));
        this.writeBlock(this.outputCipher.doFinal(macKey.getEncoded()));
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] out = this.outputCipher.update(b, off, len);
        if (out != null && out.length > 0) {
            this.writeBlock(out);
        }
    }

    private void writeBlock(byte[] out) throws IOException {
        this.dataStr.writeInt(out.length);
        this.dataStr.write(out);
        this.dataStr.flush();
        byte[] block = this.buffer.toByteArray();
        this.buffer.reset();
        this.mac.update(block);
        this.wrapped.write(block);
    }

    @Override
    public void flush() throws IOException {
        this.wrapped.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.writeBlock(this.outputCipher.doFinal());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        this.writeBlock(this.mac.doFinal());
        this.wrapped.close();
        this.dataStr.close();
    }
}

