/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.encryption.CachedKey;

public class KeyMap {
    private Map<String, CachedKey> keys;

    public KeyMap() {
        this.keys = new HashMap<String, CachedKey>(5);
    }

    public KeyMap(Map<String, CachedKey> keys) {
        this.keys = keys;
    }

    public int numKeys() {
        return this.keys.size();
    }

    public Set<String> getKeyAliases() {
        return this.keys.keySet();
    }

    public CachedKey getCachedKey(String keyAlias) {
        CachedKey cachedKey = this.keys.get(keyAlias);
        return cachedKey != null ? cachedKey : CachedKey.NULL;
    }

    public Key getKey(String keyAlias) {
        return this.getCachedKey(keyAlias).getKey();
    }

    public void setKey(String keyAlias, Key key) {
        this.keys.put(keyAlias, new CachedKey(key));
    }
}

